/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera;

import android.app.Activity;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import androidx.annotation.NonNull;
import io.flutter.embedding.engine.systemchannels.PlatformChannel;
import io.flutter.plugins.camera.Messages;
import io.flutter.plugins.camera.features.autofocus.FocusMode;
import io.flutter.plugins.camera.features.exposurelock.ExposureMode;
import io.flutter.plugins.camera.features.flash.FlashMode;
import io.flutter.plugins.camera.features.resolution.ResolutionPreset;
import java.util.ArrayList;
import java.util.List;

public final class CameraUtils {
    private CameraUtils() {
    }

    static CameraManager getCameraManager(Context context) {
        return (CameraManager)context.getSystemService("camera");
    }

    static Messages.PlatformCameraLensDirection lensDirectionFromInteger(int lensDirection) {
        switch (lensDirection) {
            case 0: {
                return Messages.PlatformCameraLensDirection.FRONT;
            }
            case 1: {
                return Messages.PlatformCameraLensDirection.BACK;
            }
            case 2: {
                return Messages.PlatformCameraLensDirection.EXTERNAL;
            }
        }
        return Messages.PlatformCameraLensDirection.FRONT;
    }

    @NonNull
    public static List<Messages.PlatformCameraDescription> getAvailableCameras(@NonNull Activity activity) throws CameraAccessException {
        CameraManager cameraManager = (CameraManager)activity.getSystemService("camera");
        String[] cameraNames = cameraManager.getCameraIdList();
        ArrayList<Messages.PlatformCameraDescription> cameras = new ArrayList<Messages.PlatformCameraDescription>();
        for (String cameraName : cameraNames) {
            int cameraId;
            try {
                cameraId = Integer.parseInt(cameraName, 10);
            }
            catch (NumberFormatException e) {
                cameraId = -1;
            }
            if (cameraId < 0) continue;
            CameraCharacteristics characteristics = cameraManager.getCameraCharacteristics(cameraName);
            int sensorOrientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
            int lensFacing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
            Messages.PlatformCameraLensDirection lensDirection = CameraUtils.lensDirectionFromInteger(lensFacing);
            Messages.PlatformCameraDescription details = new Messages.PlatformCameraDescription.Builder().setName(cameraName).setSensorOrientation(Long.valueOf(sensorOrientation)).setLensDirection(lensDirection).build();
            cameras.add(details);
        }
        return cameras;
    }

    @NonNull
    public static Messages.PlatformDeviceOrientation orientationToPigeon(@NonNull PlatformChannel.DeviceOrientation orientation) {
        switch (orientation) {
            case PORTRAIT_UP: {
                return Messages.PlatformDeviceOrientation.PORTRAIT_UP;
            }
            case PORTRAIT_DOWN: {
                return Messages.PlatformDeviceOrientation.PORTRAIT_DOWN;
            }
            case LANDSCAPE_LEFT: {
                return Messages.PlatformDeviceOrientation.LANDSCAPE_LEFT;
            }
            case LANDSCAPE_RIGHT: {
                return Messages.PlatformDeviceOrientation.LANDSCAPE_RIGHT;
            }
        }
        return Messages.PlatformDeviceOrientation.PORTRAIT_UP;
    }

    @NonNull
    public static PlatformChannel.DeviceOrientation orientationFromPigeon(@NonNull Messages.PlatformDeviceOrientation orientation) {
        switch (orientation) {
            case PORTRAIT_UP: {
                return PlatformChannel.DeviceOrientation.PORTRAIT_UP;
            }
            case PORTRAIT_DOWN: {
                return PlatformChannel.DeviceOrientation.PORTRAIT_DOWN;
            }
            case LANDSCAPE_LEFT: {
                return PlatformChannel.DeviceOrientation.LANDSCAPE_LEFT;
            }
            case LANDSCAPE_RIGHT: {
                return PlatformChannel.DeviceOrientation.LANDSCAPE_RIGHT;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    @NonNull
    public static Messages.PlatformFocusMode focusModeToPigeon(@NonNull FocusMode focusMode) {
        switch (focusMode) {
            case auto: {
                return Messages.PlatformFocusMode.AUTO;
            }
            case locked: {
                return Messages.PlatformFocusMode.LOCKED;
            }
        }
        return Messages.PlatformFocusMode.AUTO;
    }

    @NonNull
    public static FocusMode focusModeFromPigeon(@NonNull Messages.PlatformFocusMode focusMode) {
        switch (focusMode) {
            case AUTO: {
                return FocusMode.auto;
            }
            case LOCKED: {
                return FocusMode.locked;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    @NonNull
    public static Messages.PlatformExposureMode exposureModeToPigeon(@NonNull ExposureMode exposureMode) {
        switch (exposureMode) {
            case auto: {
                return Messages.PlatformExposureMode.AUTO;
            }
            case locked: {
                return Messages.PlatformExposureMode.LOCKED;
            }
        }
        return Messages.PlatformExposureMode.AUTO;
    }

    @NonNull
    public static ExposureMode exposureModeFromPigeon(@NonNull Messages.PlatformExposureMode mode) {
        switch (mode) {
            case AUTO: {
                return ExposureMode.auto;
            }
            case LOCKED: {
                return ExposureMode.locked;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    @NonNull
    public static ResolutionPreset resolutionPresetFromPigeon(@NonNull Messages.PlatformResolutionPreset preset) {
        switch (preset) {
            case LOW: {
                return ResolutionPreset.low;
            }
            case MEDIUM: {
                return ResolutionPreset.medium;
            }
            case HIGH: {
                return ResolutionPreset.high;
            }
            case VERY_HIGH: {
                return ResolutionPreset.veryHigh;
            }
            case ULTRA_HIGH: {
                return ResolutionPreset.ultraHigh;
            }
            case MAX: {
                return ResolutionPreset.max;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    @NonNull
    public static Integer imageFormatGroupFromPigeon(@NonNull Messages.PlatformImageFormatGroup format) {
        switch (format) {
            case YUV420: {
                return 35;
            }
            case JPEG: {
                return 256;
            }
            case NV21: {
                return 17;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    @NonNull
    public static FlashMode flashModeFromPigeon(@NonNull Messages.PlatformFlashMode mode) {
        switch (mode) {
            case AUTO: {
                return FlashMode.auto;
            }
            case OFF: {
                return FlashMode.off;
            }
            case ALWAYS: {
                return FlashMode.always;
            }
            case TORCH: {
                return FlashMode.torch;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }
}

