/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera.features.exposureoffset;

import android.annotation.SuppressLint;
import android.hardware.camera2.CaptureRequest;
import android.util.Range;
import androidx.annotation.NonNull;
import io.flutter.plugins.camera.CameraProperties;
import io.flutter.plugins.camera.features.CameraFeature;

public class ExposureOffsetFeature
extends CameraFeature<Double> {
    private double currentSetting = 0.0;

    public ExposureOffsetFeature(@NonNull CameraProperties cameraProperties) {
        super(cameraProperties);
    }

    @Override
    @NonNull
    public String getDebugName() {
        return "ExposureOffsetFeature";
    }

    @Override
    @SuppressLint(value={"KotlinPropertyAccess"})
    @NonNull
    public Double getValue() {
        return this.currentSetting;
    }

    @Override
    public void setValue(@NonNull Double value) {
        double stepSize = this.getExposureOffsetStepSize();
        this.currentSetting = value / stepSize;
    }

    @Override
    public boolean checkIsSupported() {
        return true;
    }

    @Override
    public void updateBuilder(@NonNull CaptureRequest.Builder requestBuilder) {
        if (!this.checkIsSupported()) {
            return;
        }
        requestBuilder.set(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, (Object)((int)this.currentSetting));
    }

    public double getMinExposureOffset() {
        Range<Integer> range = this.cameraProperties.getControlAutoExposureCompensationRange();
        double minStepped = range == null ? 0.0 : (double)((Integer)range.getLower()).intValue();
        double stepSize = this.getExposureOffsetStepSize();
        return minStepped * stepSize;
    }

    public double getMaxExposureOffset() {
        Range<Integer> range = this.cameraProperties.getControlAutoExposureCompensationRange();
        double maxStepped = range == null ? 0.0 : (double)((Integer)range.getUpper()).intValue();
        double stepSize = this.getExposureOffsetStepSize();
        return maxStepped * stepSize;
    }

    public double getExposureOffsetStepSize() {
        return this.cameraProperties.getControlAutoExposureCompensationStep();
    }
}

