/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera.features.zoomlevel;

import android.annotation.SuppressLint;
import android.graphics.Rect;
import android.hardware.camera2.CaptureRequest;
import androidx.annotation.NonNull;
import io.flutter.plugins.camera.CameraProperties;
import io.flutter.plugins.camera.SdkCapabilityChecker;
import io.flutter.plugins.camera.features.CameraFeature;
import io.flutter.plugins.camera.features.zoomlevel.ZoomUtils;

public class ZoomLevelFeature
extends CameraFeature<Float> {
    private static final Float DEFAULT_ZOOM_LEVEL = Float.valueOf(1.0f);
    private final boolean hasSupport;
    private final Rect sensorArraySize;
    @NonNull
    private Float currentSetting;
    private Float minimumZoomLevel;
    private final Float maximumZoomLevel;

    public ZoomLevelFeature(@NonNull CameraProperties cameraProperties) {
        super(cameraProperties);
        this.minimumZoomLevel = this.currentSetting = DEFAULT_ZOOM_LEVEL;
        this.sensorArraySize = cameraProperties.getSensorInfoActiveArraySize();
        if (this.sensorArraySize == null) {
            this.maximumZoomLevel = this.minimumZoomLevel;
            this.hasSupport = false;
            return;
        }
        if (SdkCapabilityChecker.supportsZoomRatio()) {
            this.minimumZoomLevel = cameraProperties.getScalerMinZoomRatio();
            this.maximumZoomLevel = cameraProperties.getScalerMaxZoomRatio();
        } else {
            this.minimumZoomLevel = DEFAULT_ZOOM_LEVEL;
            Float maxDigitalZoom = cameraProperties.getScalerAvailableMaxDigitalZoom();
            this.maximumZoomLevel = maxDigitalZoom == null || maxDigitalZoom.floatValue() < this.minimumZoomLevel.floatValue() ? this.minimumZoomLevel : maxDigitalZoom;
        }
        this.hasSupport = Float.compare(this.maximumZoomLevel.floatValue(), this.minimumZoomLevel.floatValue()) > 0;
    }

    @Override
    @NonNull
    public String getDebugName() {
        return "ZoomLevelFeature";
    }

    @Override
    @SuppressLint(value={"KotlinPropertyAccess"})
    @NonNull
    public Float getValue() {
        return this.currentSetting;
    }

    @Override
    public void setValue(@NonNull Float value) {
        this.currentSetting = value;
    }

    @Override
    public boolean checkIsSupported() {
        return this.hasSupport;
    }

    @Override
    public void updateBuilder(@NonNull CaptureRequest.Builder requestBuilder) {
        if (!this.checkIsSupported()) {
            return;
        }
        if (SdkCapabilityChecker.supportsZoomRatio()) {
            requestBuilder.set(CaptureRequest.CONTROL_ZOOM_RATIO, (Object)ZoomUtils.computeZoomRatio(this.currentSetting.floatValue(), this.minimumZoomLevel.floatValue(), this.maximumZoomLevel.floatValue()));
        } else {
            Rect computedZoom = ZoomUtils.computeZoomRect(this.currentSetting.floatValue(), this.sensorArraySize, this.minimumZoomLevel.floatValue(), this.maximumZoomLevel.floatValue());
            requestBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)computedZoom);
        }
    }

    public float getMinimumZoomLevel() {
        return this.minimumZoomLevel.floatValue();
    }

    public float getMaximumZoomLevel() {
        return this.maximumZoomLevel.floatValue();
    }
}

