/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera.media;

import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugins.camera.media.ImageStreamReaderUtils;
import io.flutter.plugins.camera.types.CameraCaptureProperties;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageStreamReader {
    private static final String TAG = "ImageStreamReader";
    private final int dartImageFormat;
    private final ImageReader imageReader;
    private final ImageStreamReaderUtils imageStreamReaderUtils;
    @VisibleForTesting(otherwise=5)
    @Nullable
    public Handler handler;
    private Map<String, Object> latestImageBufferHardReference = null;

    @VisibleForTesting
    public ImageStreamReader(@NonNull ImageReader imageReader, int dartImageFormat, @NonNull ImageStreamReaderUtils imageStreamReaderUtils) {
        this.imageReader = imageReader;
        this.dartImageFormat = dartImageFormat;
        this.imageStreamReaderUtils = imageStreamReaderUtils;
    }

    public ImageStreamReader(int width, int height, int imageFormat, int maxImages) {
        this.dartImageFormat = imageFormat;
        this.imageReader = ImageReader.newInstance((int)width, (int)height, (int)ImageStreamReader.computeStreamImageFormat(imageFormat), (int)maxImages);
        this.imageStreamReaderUtils = new ImageStreamReaderUtils();
    }

    @VisibleForTesting
    public static int computeStreamImageFormat(int dartImageFormat) {
        if (dartImageFormat == 17) {
            return 35;
        }
        return dartImageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void onImageAvailable(@NonNull Image image, @NonNull CameraCaptureProperties captureProps, final @NonNull EventChannel.EventSink imageStreamSink) {
        Handler handler;
        HashMap<String, Object> imageBuffer = new HashMap<String, Object>();
        imageBuffer.put("width", image.getWidth());
        imageBuffer.put("height", image.getHeight());
        try {
            if (this.dartImageFormat == 17) {
                imageBuffer.put("planes", this.parsePlanesForNv21(image));
            } else {
                imageBuffer.put("planes", this.parsePlanesForYuvOrJpeg(image));
            }
        }
        catch (IllegalStateException e) {
            handler = this.handler != null ? this.handler : new Handler(Looper.getMainLooper());
            handler.post(() -> imageStreamSink.error("IllegalStateException", "Caught IllegalStateException: " + e.getMessage(), null));
        }
        finally {
            image.close();
        }
        imageBuffer.put("format", this.dartImageFormat);
        imageBuffer.put("lensAperture", captureProps.getLastLensAperture());
        imageBuffer.put("sensorExposureTime", captureProps.getLastSensorExposureTime());
        Integer sensorSensitivity = captureProps.getLastSensorSensitivity();
        imageBuffer.put("sensorSensitivity", sensorSensitivity == null ? null : Double.valueOf(sensorSensitivity.intValue()));
        handler = this.handler != null ? this.handler : new Handler(Looper.getMainLooper());
        this.latestImageBufferHardReference = imageBuffer;
        boolean postResult = handler.post(new Runnable(){
            @VisibleForTesting
            public WeakReference<Map<String, Object>> weakImageBuffer;

            public Runnable withImageBuffer(Map<String, Object> imageBuffer) {
                this.weakImageBuffer = new WeakReference<Map<String, Object>>(imageBuffer);
                return this;
            }

            @Override
            public void run() {
                Map imageBuffer = (Map)this.weakImageBuffer.get();
                if (imageBuffer == null) {
                    Log.d((String)ImageStreamReader.TAG, (String)"Image buffer was dropped by garbage collector.");
                    return;
                }
                imageStreamSink.success((Object)imageBuffer);
            }
        }.withImageBuffer(imageBuffer));
    }

    @NonNull
    public List<Map<String, Object>> parsePlanesForYuvOrJpeg(@NonNull Image image) {
        ArrayList<Map<String, Object>> planes = new ArrayList<Map<String, Object>>();
        for (Image.Plane plane : image.getPlanes()) {
            ByteBuffer buffer = plane.getBuffer();
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes, 0, bytes.length);
            HashMap<String, Object> planeBuffer = new HashMap<String, Object>();
            planeBuffer.put("bytesPerRow", plane.getRowStride());
            planeBuffer.put("bytesPerPixel", plane.getPixelStride());
            planeBuffer.put("bytes", bytes);
            planes.add(planeBuffer);
        }
        return planes;
    }

    @NonNull
    public List<Map<String, Object>> parsePlanesForNv21(@NonNull Image image) {
        ArrayList<Map<String, Object>> planes = new ArrayList<Map<String, Object>>();
        ByteBuffer bytes = this.imageStreamReaderUtils.yuv420ThreePlanesToNV21(image.getPlanes(), image.getWidth(), image.getHeight());
        HashMap<String, Object> planeBuffer = new HashMap<String, Object>();
        planeBuffer.put("bytesPerRow", image.getWidth());
        planeBuffer.put("bytesPerPixel", 1);
        planeBuffer.put("bytes", bytes.array());
        planes.add(planeBuffer);
        return planes;
    }

    @NonNull
    public Surface getSurface() {
        return this.imageReader.getSurface();
    }

    public void subscribeListener(@NonNull CameraCaptureProperties captureProps, @NonNull EventChannel.EventSink imageStreamSink, @NonNull Handler handler) {
        this.imageReader.setOnImageAvailableListener(reader -> {
            Image image = reader.acquireNextImage();
            if (image == null) {
                return;
            }
            this.onImageAvailable(image, captureProps, imageStreamSink);
        }, handler);
    }

    public void removeListener(@NonNull Handler handler) {
        this.imageReader.setOnImageAvailableListener(null, handler);
    }

    public void close() {
        this.imageReader.close();
    }
}

