/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera;

import android.app.Activity;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugins.camera.Camera;
import io.flutter.plugins.camera.CameraPermissions;
import io.flutter.plugins.camera.CameraPropertiesImpl;
import io.flutter.plugins.camera.CameraUtils;
import io.flutter.plugins.camera.DartMessenger;
import io.flutter.plugins.camera.Messages;
import io.flutter.plugins.camera.features.CameraFeatureFactoryImpl;
import io.flutter.plugins.camera.features.Point;
import io.flutter.plugins.camera.features.exposurelock.ExposureMode;
import io.flutter.plugins.camera.features.flash.FlashMode;
import io.flutter.plugins.camera.features.resolution.ResolutionPreset;
import io.flutter.view.TextureRegistry;
import java.util.Collections;
import java.util.List;

final class CameraApiImpl
implements Messages.CameraApi {
    private final Activity activity;
    private final BinaryMessenger messenger;
    private final CameraPermissions cameraPermissions;
    private final CameraPermissions.PermissionsRegistry permissionsRegistry;
    private final TextureRegistry textureRegistry;
    private final EventChannel imageStreamChannel;
    @VisibleForTesting
    @Nullable
    Camera camera;

    CameraApiImpl(Activity activity, BinaryMessenger messenger, CameraPermissions cameraPermissions, CameraPermissions.PermissionsRegistry permissionsAdder, TextureRegistry textureRegistry) {
        this.activity = activity;
        this.messenger = messenger;
        this.cameraPermissions = cameraPermissions;
        this.permissionsRegistry = permissionsAdder;
        this.textureRegistry = textureRegistry;
        this.imageStreamChannel = new EventChannel(messenger, "plugins.flutter.io/camera_android/imageStream");
        Messages.CameraApi.setUp(messenger, this);
    }

    void tearDownMessageHandler() {
        Messages.CameraApi.setUp(this.messenger, null);
    }

    private Long instantiateCamera(String cameraName, Messages.PlatformMediaSettings settings) throws CameraAccessException {
        TextureRegistry.SurfaceTextureEntry flutterSurfaceTexture = this.textureRegistry.createSurfaceTexture();
        long cameraId = flutterSurfaceTexture.id();
        DartMessenger dartMessenger = new DartMessenger(new Handler(Looper.getMainLooper()), new Messages.CameraGlobalEventApi(this.messenger), new Messages.CameraEventApi(this.messenger, String.valueOf(cameraId)));
        CameraPropertiesImpl cameraProperties = new CameraPropertiesImpl(cameraName, CameraUtils.getCameraManager((Context)this.activity));
        Integer fps = settings.getFps() == null ? null : Integer.valueOf(settings.getFps().intValue());
        Integer videoBitrate = settings.getVideoBitrate() == null ? null : Integer.valueOf(settings.getVideoBitrate().intValue());
        Integer audioBitrate = settings.getAudioBitrate() == null ? null : Integer.valueOf(settings.getAudioBitrate().intValue());
        ResolutionPreset resolutionPreset = CameraUtils.resolutionPresetFromPigeon(settings.getResolutionPreset());
        this.camera = new Camera(this.activity, flutterSurfaceTexture, new CameraFeatureFactoryImpl(), dartMessenger, cameraProperties, new Camera.VideoCaptureSettings(resolutionPreset, settings.getEnableAudio(), fps, videoBitrate, audioBitrate));
        return flutterSurfaceTexture.id();
    }

    private <T> void handleException(Exception exception, Messages.Result<T> result) {
        if (exception instanceof CameraAccessException) {
            result.error(new Messages.FlutterError("CameraAccess", exception.getMessage(), null));
            return;
        }
        result.error(new Messages.FlutterError("error", exception.getMessage(), null));
    }

    private void handleException(Exception exception, Messages.VoidResult result) {
        if (exception instanceof CameraAccessException) {
            result.error(new Messages.FlutterError("CameraAccess", exception.getMessage(), null));
            return;
        }
        result.error(new Messages.FlutterError("error", exception.getMessage(), null));
    }

    @Override
    @NonNull
    public List<Messages.PlatformCameraDescription> getAvailableCameras() {
        if (this.activity == null) {
            return Collections.emptyList();
        }
        try {
            return CameraUtils.getAvailableCameras(this.activity);
        }
        catch (CameraAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void create(@NonNull String cameraName, @NonNull Messages.PlatformMediaSettings settings, @NonNull Messages.Result<Long> result) {
        if (this.camera != null) {
            this.camera.close();
        }
        this.cameraPermissions.requestPermissions(this.activity, this.permissionsRegistry, settings.getEnableAudio(), (errCode, errDesc) -> {
            if (errCode == null) {
                try {
                    result.success(this.instantiateCamera(cameraName, settings));
                }
                catch (Exception e) {
                    this.handleException(e, result);
                }
            } else {
                result.error(new Messages.FlutterError(errCode, errDesc, null));
            }
        });
    }

    @Override
    public void initialize(@NonNull Messages.PlatformImageFormatGroup imageFormat) {
        if (this.camera == null) {
            throw new Messages.FlutterError("cameraNotFound", "Camera not found. Please call the 'create' method before calling 'initialize'.", null);
        }
        try {
            this.camera.open(CameraUtils.imageFormatGroupFromPigeon(imageFormat));
        }
        catch (CameraAccessException e) {
            throw new Messages.FlutterError("CameraAccessException", e.getMessage(), null);
        }
    }

    @Override
    public void takePicture(@NonNull Messages.Result<String> result) {
        this.camera.takePicture(result);
    }

    @Override
    public void startVideoRecording(@NonNull Boolean enableStream) {
        this.camera.startVideoRecording(enableStream != false ? this.imageStreamChannel : null);
    }

    @Override
    @NonNull
    public String stopVideoRecording() {
        return this.camera.stopVideoRecording();
    }

    @Override
    public void pauseVideoRecording() {
        this.camera.pauseVideoRecording();
    }

    @Override
    public void resumeVideoRecording() {
        this.camera.resumeVideoRecording();
    }

    @Override
    public void setFlashMode(@NonNull Messages.PlatformFlashMode flashMode, @NonNull Messages.VoidResult result) {
        FlashMode mode = CameraUtils.flashModeFromPigeon(flashMode);
        try {
            this.camera.setFlashMode(result, mode);
        }
        catch (Exception e) {
            this.handleException(e, result);
        }
    }

    @Override
    public void setExposureMode(@NonNull Messages.PlatformExposureMode exposureMode, @NonNull Messages.VoidResult result) {
        ExposureMode mode = CameraUtils.exposureModeFromPigeon(exposureMode);
        try {
            this.camera.setExposureMode(result, mode);
        }
        catch (Exception e) {
            this.handleException(e, result);
        }
    }

    @Override
    public void setExposurePoint(@Nullable Messages.PlatformPoint point, @NonNull Messages.VoidResult result) {
        try {
            this.camera.setExposurePoint(result, point == null ? null : new Point(point.getX(), point.getY()));
        }
        catch (Exception e) {
            this.handleException(e, result);
        }
    }

    @Override
    @NonNull
    public Double getMinExposureOffset() {
        return this.camera.getMinExposureOffset();
    }

    @Override
    @NonNull
    public Double getMaxExposureOffset() {
        return this.camera.getMaxExposureOffset();
    }

    @Override
    @NonNull
    public Double getExposureOffsetStepSize() {
        return this.camera.getExposureOffsetStepSize();
    }

    @Override
    public void setExposureOffset(@NonNull Double offset, @NonNull Messages.Result<Double> result) {
        try {
            this.camera.setExposureOffset(result, offset);
        }
        catch (Exception e) {
            this.handleException(e, result);
        }
    }

    @Override
    public void setFocusMode(@NonNull Messages.PlatformFocusMode focusMode) {
        this.camera.setFocusMode(CameraUtils.focusModeFromPigeon(focusMode));
    }

    @Override
    public void setFocusPoint(@Nullable Messages.PlatformPoint point, @NonNull Messages.VoidResult result) {
        try {
            this.camera.setFocusPoint(result, point == null ? null : new Point(point.getX(), point.getY()));
        }
        catch (Exception e) {
            this.handleException(e, result);
        }
    }

    @Override
    public void startImageStream() {
        try {
            this.camera.startPreviewWithImageStream(this.imageStreamChannel);
        }
        catch (CameraAccessException e) {
            throw new Messages.FlutterError("CameraAccessException", e.getMessage(), null);
        }
    }

    @Override
    public void stopImageStream() {
        try {
            this.camera.startPreview(null);
        }
        catch (Exception e) {
            throw new Messages.FlutterError(e.getClass().getName(), e.getMessage(), null);
        }
    }

    @Override
    @NonNull
    public Double getMaxZoomLevel() {
        assert (this.camera != null);
        return this.camera.getMaxZoomLevel();
    }

    @Override
    @NonNull
    public Double getMinZoomLevel() {
        assert (this.camera != null);
        return this.camera.getMinZoomLevel();
    }

    @Override
    public void setZoomLevel(@NonNull Double zoom, @NonNull Messages.VoidResult result) {
        assert (this.camera != null);
        this.camera.setZoomLevel(result, zoom.floatValue());
    }

    @Override
    public void lockCaptureOrientation(@NonNull Messages.PlatformDeviceOrientation platformOrientation) {
        this.camera.lockCaptureOrientation(CameraUtils.orientationFromPigeon(platformOrientation));
    }

    @Override
    public void unlockCaptureOrientation() {
        this.camera.unlockCaptureOrientation();
    }

    @Override
    public void pausePreview() {
        try {
            this.camera.pausePreview();
        }
        catch (CameraAccessException e) {
            throw new Messages.FlutterError("CameraAccessException", e.getMessage(), null);
        }
    }

    @Override
    public void resumePreview() {
        this.camera.resumePreview();
    }

    @Override
    public void setDescriptionWhileRecording(@NonNull String cameraName) {
        try {
            this.camera.setDescriptionWhileRecording(new CameraPropertiesImpl(cameraName, CameraUtils.getCameraManager((Context)this.activity)));
        }
        catch (CameraAccessException e) {
            throw new Messages.FlutterError("CameraAccessException", e.getMessage(), null);
        }
    }

    @Override
    public void dispose() {
        if (this.camera != null) {
            this.camera.dispose();
        }
    }
}

