/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import io.flutter.plugin.common.PluginRegistry;

final class CameraPermissions {
    private static final String CAMERA_PERMISSIONS_REQUEST_ONGOING = "CameraPermissionsRequestOngoing";
    private static final String CAMERA_PERMISSIONS_REQUEST_ONGOING_MESSAGE = "Another request is ongoing and multiple requests cannot be handled at once.";
    private static final String CAMERA_ACCESS_DENIED = "CameraAccessDenied";
    private static final String CAMERA_ACCESS_DENIED_MESSAGE = "Camera access permission was denied.";
    private static final String AUDIO_ACCESS_DENIED = "AudioAccessDenied";
    private static final String AUDIO_ACCESS_DENIED_MESSAGE = "Audio access permission was denied.";
    private static final int CAMERA_REQUEST_ID = 9796;
    @VisibleForTesting
    boolean ongoing = false;

    CameraPermissions() {
    }

    void requestPermissions(Activity activity, PermissionsRegistry permissionsRegistry, boolean enableAudio, ResultCallback callback) {
        if (this.ongoing) {
            callback.onResult(CAMERA_PERMISSIONS_REQUEST_ONGOING, CAMERA_PERMISSIONS_REQUEST_ONGOING_MESSAGE);
            return;
        }
        if (!this.hasCameraPermission(activity) || enableAudio && !this.hasAudioPermission(activity)) {
            String[] stringArray;
            permissionsRegistry.addListener(new CameraRequestPermissionsListener((errorCode, errorDescription) -> {
                this.ongoing = false;
                callback.onResult(errorCode, errorDescription);
            }));
            this.ongoing = true;
            if (enableAudio) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "android.permission.CAMERA";
                stringArray = stringArray2;
                stringArray2[1] = "android.permission.RECORD_AUDIO";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "android.permission.CAMERA";
            }
            ActivityCompat.requestPermissions((Activity)activity, (String[])stringArray, (int)9796);
        } else {
            callback.onResult(null, null);
        }
    }

    private boolean hasCameraPermission(Activity activity) {
        return ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.CAMERA") == 0;
    }

    private boolean hasAudioPermission(Activity activity) {
        return ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.RECORD_AUDIO") == 0;
    }

    static interface ResultCallback {
        public void onResult(String var1, String var2);
    }

    @VisibleForTesting
    static final class CameraRequestPermissionsListener
    implements PluginRegistry.RequestPermissionsResultListener {
        boolean alreadyCalled = false;
        final ResultCallback callback;

        @VisibleForTesting
        CameraRequestPermissionsListener(ResultCallback callback) {
            this.callback = callback;
        }

        public boolean onRequestPermissionsResult(int id, String[] permissions, int[] grantResults) {
            if (this.alreadyCalled || id != 9796) {
                return false;
            }
            this.alreadyCalled = true;
            if (grantResults.length == 0 || grantResults[0] != 0) {
                this.callback.onResult(CameraPermissions.CAMERA_ACCESS_DENIED, CameraPermissions.CAMERA_ACCESS_DENIED_MESSAGE);
            } else if (grantResults.length > 1 && grantResults[1] != 0) {
                this.callback.onResult(CameraPermissions.AUDIO_ACCESS_DENIED, CameraPermissions.AUDIO_ACCESS_DENIED_MESSAGE);
            } else {
                this.callback.onResult(null, null);
            }
            return true;
        }
    }

    static interface PermissionsRegistry {
        public void addListener(PluginRegistry.RequestPermissionsResultListener var1);
    }
}

