/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugins.camera.CameraApiImpl;
import io.flutter.plugins.camera.CameraPermissions;
import io.flutter.view.TextureRegistry;

public final class CameraPlugin
implements FlutterPlugin,
ActivityAware {
    private static final String TAG = "CameraPlugin";
    @Nullable
    private FlutterPlugin.FlutterPluginBinding flutterPluginBinding;
    @Nullable
    private CameraApiImpl cameraApi;

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.flutterPluginBinding = binding;
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.flutterPluginBinding = null;
    }

    public void onAttachedToActivity(@NonNull ActivityPluginBinding binding) {
        this.maybeStartListening(binding.getActivity(), this.flutterPluginBinding.getBinaryMessenger(), arg_0 -> ((ActivityPluginBinding)binding).addRequestPermissionsResultListener(arg_0), this.flutterPluginBinding.getTextureRegistry());
    }

    public void onDetachedFromActivity() {
        if (this.cameraApi != null) {
            this.cameraApi.tearDownMessageHandler();
            this.cameraApi = null;
        }
    }

    public void onReattachedToActivityForConfigChanges(@NonNull ActivityPluginBinding binding) {
        this.onAttachedToActivity(binding);
    }

    public void onDetachedFromActivityForConfigChanges() {
        this.onDetachedFromActivity();
    }

    private void maybeStartListening(Activity activity, BinaryMessenger messenger, CameraPermissions.PermissionsRegistry permissionsRegistry, TextureRegistry textureRegistry) {
        this.cameraApi = new CameraApiImpl(activity, messenger, new CameraPermissions(), permissionsRegistry, textureRegistry);
    }
}

