/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera;

import android.graphics.Rect;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import io.flutter.plugins.camera.CameraProperties;

public class CameraPropertiesImpl
implements CameraProperties {
    private final CameraCharacteristics cameraCharacteristics;
    private final String cameraName;

    public CameraPropertiesImpl(@NonNull String cameraName, @NonNull CameraManager cameraManager) throws CameraAccessException {
        this.cameraName = cameraName;
        this.cameraCharacteristics = cameraManager.getCameraCharacteristics(cameraName);
    }

    @Override
    @NonNull
    public String getCameraName() {
        return this.cameraName;
    }

    @Override
    @NonNull
    public Range<Integer>[] getControlAutoExposureAvailableTargetFpsRanges() {
        return (Range[])this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
    }

    @Override
    @NonNull
    public Range<Integer> getControlAutoExposureCompensationRange() {
        return (Range)this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
    }

    @Override
    public double getControlAutoExposureCompensationStep() {
        Rational rational = (Rational)this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP);
        return rational == null ? 0.0 : rational.doubleValue();
    }

    @Override
    @NonNull
    public int[] getControlAutoFocusAvailableModes() {
        return (int[])this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
    }

    @Override
    @NonNull
    public Integer getControlMaxRegionsAutoExposure() {
        return (Integer)this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AE);
    }

    @Override
    @NonNull
    public Integer getControlMaxRegionsAutoFocus() {
        return (Integer)this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF);
    }

    @Override
    @RequiresApi(api=28)
    @Nullable
    public int[] getDistortionCorrectionAvailableModes() {
        return (int[])this.cameraCharacteristics.get(CameraCharacteristics.DISTORTION_CORRECTION_AVAILABLE_MODES);
    }

    @Override
    @NonNull
    public Boolean getFlashInfoAvailable() {
        return (Boolean)this.cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
    }

    @Override
    public int getLensFacing() {
        return (Integer)this.cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
    }

    @Override
    @Nullable
    public Float getLensInfoMinimumFocusDistance() {
        return (Float)this.cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE);
    }

    @Override
    @NonNull
    public Float getScalerAvailableMaxDigitalZoom() {
        return (Float)this.cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
    }

    @Override
    @RequiresApi(api=30)
    @Nullable
    public Float getScalerMaxZoomRatio() {
        Range range = (Range)this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_ZOOM_RATIO_RANGE);
        if (range != null) {
            return (Float)range.getUpper();
        }
        return null;
    }

    @Override
    @RequiresApi(api=30)
    @Nullable
    public Float getScalerMinZoomRatio() {
        Range range = (Range)this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_ZOOM_RATIO_RANGE);
        if (range != null) {
            return (Float)range.getLower();
        }
        return null;
    }

    @Override
    @NonNull
    public Rect getSensorInfoActiveArraySize() {
        return (Rect)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
    }

    @Override
    @NonNull
    public Size getSensorInfoPixelArraySize() {
        return (Size)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_PIXEL_ARRAY_SIZE);
    }

    @Override
    @NonNull
    public Rect getSensorInfoPreCorrectionActiveArraySize() {
        return (Rect)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_PRE_CORRECTION_ACTIVE_ARRAY_SIZE);
    }

    @Override
    public int getSensorOrientation() {
        return (Integer)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
    }

    @Override
    public int getHardwareLevel() {
        return (Integer)this.cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
    }

    @Override
    @NonNull
    public int[] getAvailableNoiseReductionModes() {
        return (int[])this.cameraCharacteristics.get(CameraCharacteristics.NOISE_REDUCTION_AVAILABLE_NOISE_REDUCTION_MODES);
    }
}

