/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera.features.noisereduction;

import android.annotation.SuppressLint;
import android.hardware.camera2.CaptureRequest;
import android.util.Log;
import androidx.annotation.NonNull;
import io.flutter.plugins.camera.CameraProperties;
import io.flutter.plugins.camera.features.CameraFeature;
import io.flutter.plugins.camera.features.noisereduction.NoiseReductionMode;
import java.util.HashMap;

public class NoiseReductionFeature
extends CameraFeature<NoiseReductionMode> {
    @NonNull
    private NoiseReductionMode currentSetting = NoiseReductionMode.fast;
    private final HashMap<NoiseReductionMode, Integer> NOISE_REDUCTION_MODES = new HashMap();

    public NoiseReductionFeature(@NonNull CameraProperties cameraProperties) {
        super(cameraProperties);
        this.NOISE_REDUCTION_MODES.put(NoiseReductionMode.off, 0);
        this.NOISE_REDUCTION_MODES.put(NoiseReductionMode.fast, 1);
        this.NOISE_REDUCTION_MODES.put(NoiseReductionMode.highQuality, 2);
        this.NOISE_REDUCTION_MODES.put(NoiseReductionMode.minimal, 3);
        this.NOISE_REDUCTION_MODES.put(NoiseReductionMode.zeroShutterLag, 4);
    }

    @Override
    @NonNull
    public String getDebugName() {
        return "NoiseReductionFeature";
    }

    @Override
    @SuppressLint(value={"KotlinPropertyAccess"})
    @NonNull
    public NoiseReductionMode getValue() {
        return this.currentSetting;
    }

    @Override
    public void setValue(@NonNull NoiseReductionMode value) {
        this.currentSetting = value;
    }

    @Override
    public boolean checkIsSupported() {
        int[] modes = this.cameraProperties.getAvailableNoiseReductionModes();
        return modes != null && modes.length > 0;
    }

    @Override
    public void updateBuilder(@NonNull CaptureRequest.Builder requestBuilder) {
        if (!this.checkIsSupported()) {
            return;
        }
        Log.i((String)"Camera", (String)("updateNoiseReduction | currentSetting: " + (Object)((Object)this.currentSetting)));
        requestBuilder.set(CaptureRequest.NOISE_REDUCTION_MODE, (Object)this.NOISE_REDUCTION_MODES.get((Object)this.currentSetting));
    }
}

