/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera.features.sensororientation;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.hardware.camera2.CaptureRequest;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.embedding.engine.systemchannels.PlatformChannel;
import io.flutter.plugins.camera.CameraProperties;
import io.flutter.plugins.camera.DartMessenger;
import io.flutter.plugins.camera.features.CameraFeature;
import io.flutter.plugins.camera.features.sensororientation.DeviceOrientationManager;

public class SensorOrientationFeature
extends CameraFeature<Integer> {
    @NonNull
    private Integer currentSetting = 0;
    @NonNull
    private final DeviceOrientationManager deviceOrientationListener;
    @Nullable
    private PlatformChannel.DeviceOrientation lockedCaptureOrientation;

    public SensorOrientationFeature(@NonNull CameraProperties cameraProperties, @NonNull Activity activity, @NonNull DartMessenger dartMessenger) {
        super(cameraProperties);
        this.setValue(cameraProperties.getSensorOrientation());
        boolean isFrontFacing = cameraProperties.getLensFacing() == 0;
        this.deviceOrientationListener = DeviceOrientationManager.create(activity, dartMessenger, isFrontFacing, this.currentSetting);
        this.deviceOrientationListener.start();
    }

    @Override
    @NonNull
    public String getDebugName() {
        return "SensorOrientationFeature";
    }

    @Override
    @SuppressLint(value={"KotlinPropertyAccess"})
    @NonNull
    public Integer getValue() {
        return this.currentSetting;
    }

    @Override
    public final void setValue(@NonNull Integer value) {
        this.currentSetting = value;
    }

    @Override
    public boolean checkIsSupported() {
        return true;
    }

    @Override
    public void updateBuilder(@NonNull CaptureRequest.Builder requestBuilder) {
    }

    @NonNull
    public DeviceOrientationManager getDeviceOrientationManager() {
        return this.deviceOrientationListener;
    }

    public void lockCaptureOrientation(@NonNull PlatformChannel.DeviceOrientation orientation) {
        this.lockedCaptureOrientation = orientation;
    }

    public void unlockCaptureOrientation() {
        this.lockedCaptureOrientation = null;
    }

    @Nullable
    public PlatformChannel.DeviceOrientation getLockedCaptureOrientation() {
        return this.lockedCaptureOrientation;
    }
}

