/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera;

import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.embedding.engine.systemchannels.PlatformChannel;
import io.flutter.plugins.camera.CameraUtils;
import io.flutter.plugins.camera.Messages;
import io.flutter.plugins.camera.NoOpVoidResult;
import io.flutter.plugins.camera.features.autofocus.FocusMode;
import io.flutter.plugins.camera.features.exposurelock.ExposureMode;

public class DartMessenger {
    @NonNull
    private final Handler handler;
    Messages.CameraGlobalEventApi globalEventApi;
    Messages.CameraEventApi eventApi;

    DartMessenger(@NonNull Handler handler, Messages.CameraGlobalEventApi globalEventApi, Messages.CameraEventApi eventApi) {
        this.handler = handler;
        this.globalEventApi = globalEventApi;
        this.eventApi = eventApi;
    }

    public void sendDeviceOrientationChangeEvent(@NonNull PlatformChannel.DeviceOrientation orientation) {
        this.handler.post(() -> this.globalEventApi.deviceOrientationChanged(CameraUtils.orientationToPigeon(orientation), new NoOpVoidResult()));
    }

    void sendCameraInitializedEvent(Integer previewWidth, Integer previewHeight, ExposureMode exposureMode, FocusMode focusMode, Boolean exposurePointSupported, Boolean focusPointSupported) {
        assert (previewWidth != null);
        assert (previewHeight != null);
        assert (exposureMode != null);
        assert (focusMode != null);
        assert (exposurePointSupported != null);
        assert (focusPointSupported != null);
        this.handler.post(() -> this.eventApi.initialized(new Messages.PlatformCameraState.Builder().setPreviewSize(new Messages.PlatformSize.Builder().setWidth(previewWidth.doubleValue()).setHeight(previewHeight.doubleValue()).build()).setExposurePointSupported(exposurePointSupported).setFocusPointSupported(focusPointSupported).setExposureMode(CameraUtils.exposureModeToPigeon(exposureMode)).setFocusMode(CameraUtils.focusModeToPigeon(focusMode)).build(), new NoOpVoidResult()));
    }

    void sendCameraClosingEvent() {
        this.handler.post(() -> this.eventApi.closed(new NoOpVoidResult()));
    }

    void sendCameraErrorEvent(@NonNull String description) {
        this.handler.post(() -> this.eventApi.error(description, new NoOpVoidResult()));
    }

    public <T> void finish(@NonNull Messages.Result<T> result, @NonNull T payload) {
        this.handler.post(() -> result.success(payload));
    }

    public <T> void error(@NonNull Messages.Result<T> result, @NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
        this.handler.post(() -> result.error(new Messages.FlutterError(errorCode, errorMessage, errorDetails)));
    }
}

