/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera.features.fpsrange;

import android.annotation.SuppressLint;
import android.hardware.camera2.CaptureRequest;
import android.util.Range;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugins.camera.CameraProperties;
import io.flutter.plugins.camera.DeviceInfo;
import io.flutter.plugins.camera.features.CameraFeature;

public class FpsRangeFeature
extends CameraFeature<Range<Integer>> {
    private static final Range<Integer> MAX_PIXEL4A_RANGE = new Range((Comparable)Integer.valueOf(30), (Comparable)Integer.valueOf(30));
    @Nullable
    private Range<Integer> currentSetting;

    public FpsRangeFeature(@NonNull CameraProperties cameraProperties) {
        super(cameraProperties);
        if (this.isPixel4A()) {
            this.currentSetting = MAX_PIXEL4A_RANGE;
        } else {
            Range<Integer>[] ranges = cameraProperties.getControlAutoExposureAvailableTargetFpsRanges();
            if (ranges != null) {
                for (Range<Integer> range : ranges) {
                    int upper = (Integer)range.getUpper();
                    if (upper < 10 || this.currentSetting != null && upper <= (Integer)this.currentSetting.getUpper()) continue;
                    this.currentSetting = range;
                }
            }
        }
    }

    private boolean isPixel4A() {
        String brand = DeviceInfo.getBrand();
        String model = DeviceInfo.getModel();
        return brand != null && brand.equals("google") && model != null && model.equals("Pixel 4a");
    }

    @Override
    @NonNull
    public String getDebugName() {
        return "FpsRangeFeature";
    }

    @Override
    @SuppressLint(value={"KotlinPropertyAccess"})
    @Nullable
    public Range<Integer> getValue() {
        return this.currentSetting;
    }

    @Override
    public void setValue(@NonNull Range<Integer> value) {
        this.currentSetting = value;
    }

    @Override
    public boolean checkIsSupported() {
        return true;
    }

    @Override
    public void updateBuilder(@NonNull CaptureRequest.Builder requestBuilder) {
        if (!this.checkIsSupported()) {
            return;
        }
        requestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, this.currentSetting);
    }
}

