/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera.features.sensororientation;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.systemchannels.PlatformChannel;
import io.flutter.plugins.camera.DartMessenger;

public class DeviceOrientationManager {
    private static final IntentFilter orientationIntentFilter = new IntentFilter("android.intent.action.CONFIGURATION_CHANGED");
    private final Activity activity;
    private final DartMessenger messenger;
    private final boolean isFrontFacing;
    private final int sensorOrientation;
    private PlatformChannel.DeviceOrientation lastOrientation;
    private BroadcastReceiver broadcastReceiver;

    @NonNull
    public static DeviceOrientationManager create(@NonNull Activity activity, @NonNull DartMessenger messenger, boolean isFrontFacing, int sensorOrientation) {
        return new DeviceOrientationManager(activity, messenger, isFrontFacing, sensorOrientation);
    }

    private DeviceOrientationManager(@NonNull Activity activity, @NonNull DartMessenger messenger, boolean isFrontFacing, int sensorOrientation) {
        this.activity = activity;
        this.messenger = messenger;
        this.isFrontFacing = isFrontFacing;
        this.sensorOrientation = sensorOrientation;
    }

    public void start() {
        if (this.broadcastReceiver != null) {
            return;
        }
        this.broadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                DeviceOrientationManager.this.handleUIOrientationChange();
            }
        };
        this.activity.registerReceiver(this.broadcastReceiver, orientationIntentFilter);
        this.broadcastReceiver.onReceive((Context)this.activity, null);
    }

    public void stop() {
        if (this.broadcastReceiver == null) {
            return;
        }
        this.activity.unregisterReceiver(this.broadcastReceiver);
        this.broadcastReceiver = null;
    }

    public int getPhotoOrientation() {
        return this.getPhotoOrientation(this.lastOrientation);
    }

    public int getPhotoOrientation(@Nullable PlatformChannel.DeviceOrientation orientation) {
        int angle = 0;
        if (orientation == null) {
            orientation = this.getUIOrientation();
        }
        switch (orientation) {
            case PORTRAIT_UP: {
                angle = 90;
                break;
            }
            case PORTRAIT_DOWN: {
                angle = 270;
                break;
            }
            case LANDSCAPE_LEFT: {
                angle = this.isFrontFacing ? 180 : 0;
                break;
            }
            case LANDSCAPE_RIGHT: {
                angle = this.isFrontFacing ? 0 : 180;
            }
        }
        return (angle + this.sensorOrientation + 270) % 360;
    }

    public int getVideoOrientation() {
        return this.getVideoOrientation(this.lastOrientation);
    }

    public int getVideoOrientation(@Nullable PlatformChannel.DeviceOrientation orientation) {
        int angle = 0;
        if (orientation == null) {
            orientation = this.getUIOrientation();
        }
        switch (orientation) {
            case PORTRAIT_UP: {
                angle = 0;
                break;
            }
            case PORTRAIT_DOWN: {
                angle = 180;
                break;
            }
            case LANDSCAPE_LEFT: {
                angle = 270;
                break;
            }
            case LANDSCAPE_RIGHT: {
                angle = 90;
            }
        }
        if (this.isFrontFacing) {
            angle *= -1;
        }
        return (angle + this.sensorOrientation + 360) % 360;
    }

    @Nullable
    public PlatformChannel.DeviceOrientation getLastUIOrientation() {
        return this.lastOrientation;
    }

    @VisibleForTesting
    void handleUIOrientationChange() {
        PlatformChannel.DeviceOrientation orientation = this.getUIOrientation();
        DeviceOrientationManager.handleOrientationChange(orientation, this.lastOrientation, this.messenger);
        this.lastOrientation = orientation;
    }

    @VisibleForTesting
    static void handleOrientationChange(PlatformChannel.DeviceOrientation newOrientation, PlatformChannel.DeviceOrientation previousOrientation, DartMessenger messenger) {
        if (!newOrientation.equals((Object)previousOrientation)) {
            messenger.sendDeviceOrientationChangeEvent(newOrientation);
        }
    }

    @VisibleForTesting
    PlatformChannel.DeviceOrientation getUIOrientation() {
        int rotation = this.getDisplay().getRotation();
        int orientation = this.activity.getResources().getConfiguration().orientation;
        switch (orientation) {
            case 1: {
                if (rotation == 0 || rotation == 1) {
                    return PlatformChannel.DeviceOrientation.PORTRAIT_UP;
                }
                return PlatformChannel.DeviceOrientation.PORTRAIT_DOWN;
            }
            case 2: {
                if (rotation == 0 || rotation == 1) {
                    return PlatformChannel.DeviceOrientation.LANDSCAPE_LEFT;
                }
                return PlatformChannel.DeviceOrientation.LANDSCAPE_RIGHT;
            }
        }
        return PlatformChannel.DeviceOrientation.PORTRAIT_UP;
    }

    @VisibleForTesting
    PlatformChannel.DeviceOrientation calculateSensorOrientation(int angle) {
        int tolerance = 45;
        angle += 45;
        int defaultDeviceOrientation = this.getDeviceDefaultOrientation();
        if (defaultDeviceOrientation == 2) {
            angle += 90;
        }
        return (new PlatformChannel.DeviceOrientation[]{PlatformChannel.DeviceOrientation.PORTRAIT_UP, PlatformChannel.DeviceOrientation.LANDSCAPE_LEFT, PlatformChannel.DeviceOrientation.PORTRAIT_DOWN, PlatformChannel.DeviceOrientation.LANDSCAPE_RIGHT})[(angle %= 360) / 90];
    }

    @VisibleForTesting
    int getDeviceDefaultOrientation() {
        Configuration config = this.activity.getResources().getConfiguration();
        int rotation = this.getDisplay().getRotation();
        if ((rotation == 0 || rotation == 2) && config.orientation == 2 || (rotation == 1 || rotation == 3) && config.orientation == 1) {
            return 2;
        }
        return 1;
    }

    @VisibleForTesting
    Display getDisplay() {
        return ((WindowManager)this.activity.getSystemService("window")).getDefaultDisplay();
    }
}

