/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.firestore;

import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.DocumentChange;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FieldValue;
import com.google.firebase.firestore.Filter;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.GeoPoint;
import com.google.firebase.firestore.LoadBundleTaskProgress;
import com.google.firebase.firestore.LocalCacheSettings;
import com.google.firebase.firestore.MemoryCacheSettings;
import com.google.firebase.firestore.PersistentCacheSettings;
import com.google.firebase.firestore.Query;
import com.google.firebase.firestore.QuerySnapshot;
import com.google.firebase.firestore.SnapshotMetadata;
import com.google.firebase.firestore.VectorValue;
import io.flutter.plugin.common.StandardMessageCodec;
import io.flutter.plugins.firebase.firestore.FlutterFirebaseFirestoreExtension;
import io.flutter.plugins.firebase.firestore.FlutterFirebaseFirestorePlugin;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class FlutterFirebaseFirestoreMessageCodec
extends StandardMessageCodec {
    public static final FlutterFirebaseFirestoreMessageCodec INSTANCE = new FlutterFirebaseFirestoreMessageCodec();
    private static final byte DATA_TYPE_DATE_TIME = -76;
    private static final byte DATA_TYPE_GEO_POINT = -75;
    private static final byte DATA_TYPE_DOCUMENT_REFERENCE = -74;
    private static final byte DATA_TYPE_BLOB = -73;
    private static final byte DATA_TYPE_ARRAY_UNION = -72;
    private static final byte DATA_TYPE_ARRAY_REMOVE = -71;
    private static final byte DATA_TYPE_DELETE = -70;
    private static final byte DATA_TYPE_SERVER_TIMESTAMP = -69;
    private static final byte DATA_TYPE_TIMESTAMP = -68;
    private static final byte DATA_TYPE_INCREMENT_DOUBLE = -67;
    private static final byte DATA_TYPE_INCREMENT_INTEGER = -66;
    private static final byte DATA_TYPE_DOCUMENT_ID = -65;
    private static final byte DATA_TYPE_FIELD_PATH = -64;
    private static final byte DATA_TYPE_NAN = -63;
    private static final byte DATA_TYPE_INFINITY = -62;
    private static final byte DATA_TYPE_NEGATIVE_INFINITY = -61;
    private static final byte DATA_TYPE_FIRESTORE_INSTANCE = -60;
    private static final byte DATA_TYPE_FIRESTORE_QUERY = -59;
    private static final byte DATA_TYPE_FIRESTORE_SETTINGS = -58;
    private static final byte DATA_TYPE_VECTOR_VALUE = -57;

    FlutterFirebaseFirestoreMessageCodec() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeValue(ByteArrayOutputStream stream, Object value) {
        if (value instanceof Date) {
            stream.write(-76);
            FlutterFirebaseFirestoreMessageCodec.writeLong((ByteArrayOutputStream)stream, (long)((Date)value).getTime());
        } else if (value instanceof Timestamp) {
            stream.write(-68);
            FlutterFirebaseFirestoreMessageCodec.writeLong((ByteArrayOutputStream)stream, (long)((Timestamp)value).getSeconds());
            FlutterFirebaseFirestoreMessageCodec.writeInt((ByteArrayOutputStream)stream, (int)((Timestamp)value).getNanoseconds());
        } else if (value instanceof GeoPoint) {
            stream.write(-75);
            FlutterFirebaseFirestoreMessageCodec.writeAlignment((ByteArrayOutputStream)stream, (int)8);
            FlutterFirebaseFirestoreMessageCodec.writeDouble((ByteArrayOutputStream)stream, (double)((GeoPoint)value).getLatitude());
            FlutterFirebaseFirestoreMessageCodec.writeDouble((ByteArrayOutputStream)stream, (double)((GeoPoint)value).getLongitude());
        } else if (value instanceof VectorValue) {
            stream.write(-57);
            this.writeValue(stream, ((VectorValue)value).toArray());
        } else if (value instanceof DocumentReference) {
            String databaseURL;
            stream.write(-74);
            FirebaseFirestore firestore = ((DocumentReference)value).getFirestore();
            String appName = firestore.getApp().getName();
            this.writeValue(stream, appName);
            this.writeValue(stream, ((DocumentReference)value).getPath());
            HashMap<FirebaseFirestore, FlutterFirebaseFirestoreExtension> hashMap = FlutterFirebaseFirestorePlugin.firestoreInstanceCache;
            synchronized (hashMap) {
                databaseURL = FlutterFirebaseFirestorePlugin.getCachedFirebaseFirestoreInstanceForKey(firestore).getDatabaseURL();
            }
            this.writeValue(stream, databaseURL);
        } else if (value instanceof DocumentSnapshot) {
            this.writeDocumentSnapshot(stream, (DocumentSnapshot)value);
        } else if (value instanceof QuerySnapshot) {
            this.writeQuerySnapshot(stream, (QuerySnapshot)value);
        } else if (value instanceof DocumentChange) {
            this.writeDocumentChange(stream, (DocumentChange)value);
        } else if (value instanceof LoadBundleTaskProgress) {
            this.writeLoadBundleTaskProgress(stream, (LoadBundleTaskProgress)value);
        } else if (value instanceof SnapshotMetadata) {
            this.writeSnapshotMetadata(stream, (SnapshotMetadata)value);
        } else if (value instanceof Blob) {
            stream.write(-73);
            FlutterFirebaseFirestoreMessageCodec.writeBytes((ByteArrayOutputStream)stream, (byte[])((Blob)value).toBytes());
        } else if (value instanceof Double) {
            Double doubleValue = (Double)value;
            if (Double.isNaN(doubleValue)) {
                stream.write(-63);
            } else if (doubleValue.equals(Double.NEGATIVE_INFINITY)) {
                stream.write(-61);
            } else if (doubleValue.equals(Double.POSITIVE_INFINITY)) {
                stream.write(-62);
            } else {
                super.writeValue(stream, value);
            }
        } else {
            super.writeValue(stream, value);
        }
    }

    private void writeSnapshotMetadata(ByteArrayOutputStream stream, SnapshotMetadata value) {
        HashMap<String, Boolean> metadataMap = new HashMap<String, Boolean>();
        metadataMap.put("hasPendingWrites", value.hasPendingWrites());
        metadataMap.put("isFromCache", value.isFromCache());
        this.writeValue(stream, metadataMap);
    }

    private void writeDocumentChange(ByteArrayOutputStream stream, DocumentChange value) {
        HashMap<String, Object> changeMap = new HashMap<String, Object>();
        String type = null;
        switch (value.getType()) {
            case ADDED: {
                type = "DocumentChangeType.added";
                break;
            }
            case MODIFIED: {
                type = "DocumentChangeType.modified";
                break;
            }
            case REMOVED: {
                type = "DocumentChangeType.removed";
            }
        }
        changeMap.put("type", type);
        changeMap.put("data", value.getDocument().getData());
        changeMap.put("path", value.getDocument().getReference().getPath());
        changeMap.put("oldIndex", value.getOldIndex());
        changeMap.put("newIndex", value.getNewIndex());
        changeMap.put("metadata", value.getDocument().getMetadata());
        this.writeValue(stream, changeMap);
    }

    private void writeQuerySnapshot(ByteArrayOutputStream stream, QuerySnapshot value) {
        ArrayList<String> paths = new ArrayList<String>();
        HashMap querySnapshotMap = new HashMap();
        ArrayList<Map> documents = new ArrayList<Map>();
        ArrayList<SnapshotMetadata> metadatas = new ArrayList<SnapshotMetadata>();
        DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior = FlutterFirebaseFirestorePlugin.serverTimestampBehaviorHashMap.get(value.hashCode());
        for (DocumentSnapshot document : value.getDocuments()) {
            paths.add(document.getReference().getPath());
            if (serverTimestampBehavior != null) {
                documents.add(document.getData(serverTimestampBehavior));
            } else {
                documents.add(document.getData());
            }
            metadatas.add(document.getMetadata());
        }
        querySnapshotMap.put("paths", paths);
        querySnapshotMap.put("documents", documents);
        querySnapshotMap.put("metadatas", metadatas);
        querySnapshotMap.put("documentChanges", value.getDocumentChanges());
        querySnapshotMap.put("metadata", value.getMetadata());
        FlutterFirebaseFirestorePlugin.serverTimestampBehaviorHashMap.remove(value.hashCode());
        this.writeValue(stream, querySnapshotMap);
    }

    private void writeLoadBundleTaskProgress(ByteArrayOutputStream stream, LoadBundleTaskProgress snapshot) {
        HashMap<String, Object> snapshotMap = new HashMap<String, Object>();
        snapshotMap.put("bytesLoaded", snapshot.getBytesLoaded());
        snapshotMap.put("documentsLoaded", snapshot.getDocumentsLoaded());
        snapshotMap.put("totalBytes", snapshot.getTotalBytes());
        snapshotMap.put("totalDocuments", snapshot.getTotalDocuments());
        LoadBundleTaskProgress.TaskState taskState = snapshot.getTaskState();
        String convertedState = "running";
        switch (taskState) {
            case RUNNING: {
                convertedState = "running";
                break;
            }
            case SUCCESS: {
                convertedState = "success";
                break;
            }
            case ERROR: {
                convertedState = "error";
            }
        }
        snapshotMap.put("taskState", convertedState);
        this.writeValue(stream, snapshotMap);
    }

    private void writeDocumentSnapshot(ByteArrayOutputStream stream, DocumentSnapshot value) {
        HashMap<String, Object> snapshotMap = new HashMap<String, Object>();
        snapshotMap.put("path", value.getReference().getPath());
        if (value.exists()) {
            DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior = FlutterFirebaseFirestorePlugin.serverTimestampBehaviorHashMap.get(value.hashCode());
            if (serverTimestampBehavior != null) {
                snapshotMap.put("data", value.getData(serverTimestampBehavior));
            } else {
                snapshotMap.put("data", value.getData());
            }
        } else {
            snapshotMap.put("data", null);
        }
        snapshotMap.put("metadata", value.getMetadata());
        FlutterFirebaseFirestorePlugin.serverTimestampBehaviorHashMap.remove(value.hashCode());
        this.writeValue(stream, snapshotMap);
    }

    protected Object readValueOfType(byte type, ByteBuffer buffer) {
        switch (type) {
            case -76: {
                return new Date(buffer.getLong());
            }
            case -68: {
                return new Timestamp(buffer.getLong(), buffer.getInt());
            }
            case -75: {
                FlutterFirebaseFirestoreMessageCodec.readAlignment((ByteBuffer)buffer, (int)8);
                return new GeoPoint(buffer.getDouble(), buffer.getDouble());
            }
            case -57: {
                ArrayList arrayList = (ArrayList)this.readValue(buffer);
                double[] doubleArray = new double[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    doubleArray[i] = Objects.requireNonNull((Double)arrayList.get(i), "Null value at index " + i);
                }
                return FieldValue.vector((double[])doubleArray);
            }
            case -74: {
                FirebaseFirestore firestore = (FirebaseFirestore)this.readValue(buffer);
                String path = (String)this.readValue(buffer);
                return firestore.document(path);
            }
            case -73: {
                byte[] bytes = FlutterFirebaseFirestoreMessageCodec.readBytes((ByteBuffer)buffer);
                return Blob.fromBytes((byte[])bytes);
            }
            case -72: {
                return FieldValue.arrayUnion((Object[])this.toArray(this.readValue(buffer)));
            }
            case -71: {
                return FieldValue.arrayRemove((Object[])this.toArray(this.readValue(buffer)));
            }
            case -70: {
                return FieldValue.delete();
            }
            case -69: {
                return FieldValue.serverTimestamp();
            }
            case -66: {
                Number integerIncrementValue = (Number)this.readValue(buffer);
                return FieldValue.increment((long)integerIncrementValue.intValue());
            }
            case -67: {
                Number doubleIncrementValue = (Number)this.readValue(buffer);
                return FieldValue.increment((double)doubleIncrementValue.doubleValue());
            }
            case -65: {
                return FieldPath.documentId();
            }
            case -60: {
                return this.readFirestoreInstance(buffer);
            }
            case -59: {
                return this.readFirestoreQuery(buffer);
            }
            case -58: {
                return this.readFirestoreSettings(buffer);
            }
            case -63: {
                return Double.NaN;
            }
            case -62: {
                return Double.POSITIVE_INFINITY;
            }
            case -61: {
                return Double.NEGATIVE_INFINITY;
            }
            case -64: {
                int size = FlutterFirebaseFirestoreMessageCodec.readSize((ByteBuffer)buffer);
                ArrayList<Object> list = new ArrayList<Object>(size);
                for (int i = 0; i < size; ++i) {
                    list.add(this.readValue(buffer));
                }
                return FieldPath.of((String[])list.toArray(new String[0]));
            }
        }
        return super.readValueOfType(type, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FirebaseFirestore readFirestoreInstance(ByteBuffer buffer) {
        String appName = (String)this.readValue(buffer);
        String databaseURL = (String)this.readValue(buffer);
        FirebaseFirestoreSettings settings = (FirebaseFirestoreSettings)this.readValue(buffer);
        HashMap<FirebaseFirestore, FlutterFirebaseFirestoreExtension> hashMap = FlutterFirebaseFirestorePlugin.firestoreInstanceCache;
        synchronized (hashMap) {
            FirebaseFirestore cachedFirestoreInstance = FlutterFirebaseFirestorePlugin.getFirestoreInstanceByNameAndDatabaseUrl(appName, databaseURL);
            if (cachedFirestoreInstance != null) {
                return cachedFirestoreInstance;
            }
            FirebaseApp app = FirebaseApp.getInstance((String)appName);
            FirebaseFirestore firestore = FirebaseFirestore.getInstance((FirebaseApp)app, (String)databaseURL);
            firestore.setFirestoreSettings(settings);
            FlutterFirebaseFirestorePlugin.setCachedFirebaseFirestoreInstanceForKey(firestore, databaseURL);
            return firestore;
        }
    }

    private FirebaseFirestoreSettings readFirestoreSettings(ByteBuffer buffer) {
        Map settingsMap = (Map)this.readValue(buffer);
        FirebaseFirestoreSettings.Builder settingsBuilder = new FirebaseFirestoreSettings.Builder();
        if (settingsMap.get("persistenceEnabled") != null) {
            Boolean persistenceEnabled = (Boolean)settingsMap.get("persistenceEnabled");
            if (Boolean.TRUE.equals(persistenceEnabled)) {
                PersistentCacheSettings.Builder persistenceSettings = PersistentCacheSettings.newBuilder();
                if (settingsMap.get("cacheSizeBytes") != null) {
                    Long cacheSizeBytes = 0x6400000L;
                    Object value = settingsMap.get("cacheSizeBytes");
                    if (value instanceof Long) {
                        cacheSizeBytes = (Long)value;
                    } else if (value instanceof Integer) {
                        cacheSizeBytes = (long)((Integer)value);
                    }
                    if (cacheSizeBytes == -1L) {
                        persistenceSettings.setSizeBytes(-1L);
                    } else {
                        persistenceSettings.setSizeBytes(cacheSizeBytes.longValue());
                    }
                }
                settingsBuilder.setLocalCacheSettings((LocalCacheSettings)persistenceSettings.build());
            } else {
                settingsBuilder.setLocalCacheSettings((LocalCacheSettings)MemoryCacheSettings.newBuilder().build());
            }
        }
        if (settingsMap.get("host") != null) {
            settingsBuilder.setHost((String)Objects.requireNonNull(settingsMap.get("host")));
            if (settingsMap.get("sslEnabled") != null) {
                settingsBuilder.setSslEnabled(((Boolean)Objects.requireNonNull(settingsMap.get("sslEnabled"))).booleanValue());
            }
        }
        return settingsBuilder.build();
    }

    private Filter filterFromJson(Map<String, Object> map) {
        if (map.containsKey("fieldPath")) {
            String op = (String)map.get("op");
            FieldPath fieldPath = (FieldPath)map.get("fieldPath");
            Object value = map.get("value");
            switch (op) {
                case "==": {
                    return Filter.equalTo((FieldPath)fieldPath, (Object)value);
                }
                case "!=": {
                    return Filter.notEqualTo((FieldPath)fieldPath, (Object)value);
                }
                case "<": {
                    return Filter.lessThan((FieldPath)fieldPath, (Object)value);
                }
                case "<=": {
                    return Filter.lessThanOrEqualTo((FieldPath)fieldPath, (Object)value);
                }
                case ">": {
                    return Filter.greaterThan((FieldPath)fieldPath, (Object)value);
                }
                case ">=": {
                    return Filter.greaterThanOrEqualTo((FieldPath)fieldPath, (Object)value);
                }
                case "array-contains": {
                    return Filter.arrayContains((FieldPath)fieldPath, (Object)value);
                }
                case "array-contains-any": {
                    return Filter.arrayContainsAny((FieldPath)fieldPath, (List)((List)value));
                }
                case "in": {
                    return Filter.inArray((FieldPath)fieldPath, (List)((List)value));
                }
                case "not-in": {
                    return Filter.notInArray((FieldPath)fieldPath, (List)((List)value));
                }
            }
            throw new Error("Invalid operator");
        }
        String op = (String)map.get("op");
        List queries = (List)map.get("queries");
        ArrayList<Filter> parsedFilters = new ArrayList<Filter>();
        for (Map query : queries) {
            parsedFilters.add(this.filterFromJson(query));
        }
        if (op.equals("OR")) {
            return Filter.or((Filter[])parsedFilters.toArray(new Filter[0]));
        }
        if (op.equals("AND")) {
            return Filter.and((Filter[])parsedFilters.toArray(new Filter[0]));
        }
        throw new Error("Invalid operator");
    }

    private Query readFirestoreQuery(ByteBuffer buffer) {
        try {
            List endBefore;
            List endAt;
            List startAfter;
            List orderBy;
            Number limitToLast;
            Map values = (Map)this.readValue(buffer);
            FirebaseFirestore firestore = (FirebaseFirestore)Objects.requireNonNull(values.get("firestore"));
            String path = (String)Objects.requireNonNull(values.get("path"));
            boolean isCollectionGroup = (Boolean)values.get("isCollectionGroup");
            Map parameters = (Map)values.get("parameters");
            Object query = isCollectionGroup ? firestore.collectionGroup(path) : firestore.collection(path);
            if (parameters == null) {
                return query;
            }
            boolean isFilterQuery = parameters.containsKey("filters");
            if (isFilterQuery) {
                Filter filter = this.filterFromJson((Map)Objects.requireNonNull(parameters.get("filters")));
                query = query.where(filter);
            }
            List filters = (List)Objects.requireNonNull(parameters.get("where"));
            for (List condition : filters) {
                List listValues;
                FieldPath fieldPath = (FieldPath)condition.get(0);
                String operator = (String)condition.get(1);
                Object value = condition.get(2);
                if ("==".equals(operator)) {
                    query = query.whereEqualTo(fieldPath, value);
                    continue;
                }
                if ("!=".equals(operator)) {
                    query = query.whereNotEqualTo(fieldPath, value);
                    continue;
                }
                if ("<".equals(operator)) {
                    query = query.whereLessThan(fieldPath, value);
                    continue;
                }
                if ("<=".equals(operator)) {
                    query = query.whereLessThanOrEqualTo(fieldPath, value);
                    continue;
                }
                if (">".equals(operator)) {
                    query = query.whereGreaterThan(fieldPath, value);
                    continue;
                }
                if (">=".equals(operator)) {
                    query = query.whereGreaterThanOrEqualTo(fieldPath, value);
                    continue;
                }
                if ("array-contains".equals(operator)) {
                    query = query.whereArrayContains(fieldPath, value);
                    continue;
                }
                if ("array-contains-any".equals(operator)) {
                    listValues = (List)value;
                    query = query.whereArrayContainsAny(fieldPath, listValues);
                    continue;
                }
                if ("in".equals(operator)) {
                    listValues = (List)value;
                    query = query.whereIn(fieldPath, listValues);
                    continue;
                }
                if ("not-in".equals(operator)) {
                    listValues = (List)value;
                    query = query.whereNotIn(fieldPath, listValues);
                    continue;
                }
                Log.w((String)"FLTFirestoreMsgCodec", (String)("An invalid query operator " + (String)operator + " was received but not handled."));
            }
            Number limit = (Number)parameters.get("limit");
            if (limit != null) {
                query = query.limit(limit.longValue());
            }
            if ((limitToLast = (Number)parameters.get("limitToLast")) != null) {
                query = query.limitToLast(limitToLast.longValue());
            }
            if ((orderBy = (List)parameters.get("orderBy")) == null) {
                return query;
            }
            for (List order : orderBy) {
                FieldPath fieldPath = (FieldPath)order.get(0);
                boolean descending = (Boolean)order.get(1);
                Query.Direction direction = descending ? Query.Direction.DESCENDING : Query.Direction.ASCENDING;
                query = query.orderBy(fieldPath, direction);
            }
            List startAt = (List)parameters.get("startAt");
            if (startAt != null) {
                query = query.startAt(Objects.requireNonNull(startAt.toArray()));
            }
            if ((startAfter = (List)parameters.get("startAfter")) != null) {
                query = query.startAfter(Objects.requireNonNull(startAfter.toArray()));
            }
            if ((endAt = (List)parameters.get("endAt")) != null) {
                query = query.endAt(Objects.requireNonNull(endAt.toArray()));
            }
            if ((endBefore = (List)parameters.get("endBefore")) != null) {
                query = query.endBefore(Objects.requireNonNull(endBefore.toArray()));
            }
            return query;
        }
        catch (Exception exception) {
            Log.e((String)"FLTFirestoreMsgCodec", (String)"An error occurred while parsing query arguments, this is most likely an error with this SDK.", (Throwable)exception);
            return null;
        }
    }

    private Object[] toArray(Object source) {
        if (source instanceof List) {
            return ((List)source).toArray();
        }
        if (source == null) {
            return new ArrayList().toArray();
        }
        String sourceType = source.getClass().getCanonicalName();
        String message = "java.util.List was expected, unable to convert '%s' to an object array";
        throw new IllegalArgumentException(String.format(message, sourceType));
    }
}

