/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.firestore.streamhandler;

import androidx.annotation.NonNull;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.LoadBundleTask;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugins.firebase.firestore.utils.ExceptionConverter;
import java.util.Map;

public class LoadBundleStreamHandler
implements EventChannel.StreamHandler {
    private EventChannel.EventSink eventSink;
    private final FirebaseFirestore firestore;
    @NonNull
    private final byte[] bundle;

    public LoadBundleStreamHandler(FirebaseFirestore firestore, @NonNull byte[] bundle) {
        this.firestore = firestore;
        this.bundle = bundle;
    }

    public void onListen(Object arguments, EventChannel.EventSink events) {
        this.eventSink = events;
        LoadBundleTask task = this.firestore.loadBundle(this.bundle);
        task.addOnProgressListener(arg_0 -> ((EventChannel.EventSink)events).success(arg_0));
        task.addOnFailureListener(exception -> {
            Map<String, String> exceptionDetails = ExceptionConverter.createDetails(exception);
            events.error("firebase_firestore", exception.getMessage(), exceptionDetails);
            this.onCancel(null);
        });
    }

    public void onCancel(Object arguments) {
        this.eventSink.endOfStream();
    }
}

