/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.firestore;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugins.firebase.firestore.FlutterFirebaseFirestoreMessageCodec;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GeneratedAndroidFirebaseFirestore {
    @NonNull
    protected static ArrayList<Object> wrapError(@NonNull Throwable exception) {
        ArrayList<Object> errorList = new ArrayList<Object>(3);
        if (exception instanceof FlutterError) {
            FlutterError error = (FlutterError)exception;
            errorList.add(error.code);
            errorList.add(error.getMessage());
            errorList.add(error.details);
        } else {
            errorList.add(exception.toString());
            errorList.add(exception.getClass().getSimpleName());
            errorList.add("Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString((Throwable)exception));
        }
        return errorList;
    }

    public static class FlutterError
    extends RuntimeException {
        public final String code;
        public final Object details;

        public FlutterError(@NonNull String code, @Nullable String message, @Nullable Object details) {
            super(message);
            this.code = code;
            this.details = details;
        }
    }

    public static interface FirebaseFirestoreHostApi {
        public void loadBundle(@NonNull FirestorePigeonFirebaseApp var1, @NonNull byte[] var2, @NonNull Result<String> var3);

        public void namedQueryGet(@NonNull FirestorePigeonFirebaseApp var1, @NonNull String var2, @NonNull PigeonGetOptions var3, @NonNull Result<PigeonQuerySnapshot> var4);

        public void clearPersistence(@NonNull FirestorePigeonFirebaseApp var1, @NonNull Result<Void> var2);

        public void disableNetwork(@NonNull FirestorePigeonFirebaseApp var1, @NonNull Result<Void> var2);

        public void enableNetwork(@NonNull FirestorePigeonFirebaseApp var1, @NonNull Result<Void> var2);

        public void terminate(@NonNull FirestorePigeonFirebaseApp var1, @NonNull Result<Void> var2);

        public void waitForPendingWrites(@NonNull FirestorePigeonFirebaseApp var1, @NonNull Result<Void> var2);

        public void setIndexConfiguration(@NonNull FirestorePigeonFirebaseApp var1, @NonNull String var2, @NonNull Result<Void> var3);

        public void setLoggingEnabled(@NonNull Boolean var1, @NonNull Result<Void> var2);

        public void snapshotsInSyncSetup(@NonNull FirestorePigeonFirebaseApp var1, @NonNull Result<String> var2);

        public void transactionCreate(@NonNull FirestorePigeonFirebaseApp var1, @NonNull Long var2, @NonNull Long var3, @NonNull Result<String> var4);

        public void transactionStoreResult(@NonNull String var1, @NonNull PigeonTransactionResult var2, @Nullable List<PigeonTransactionCommand> var3, @NonNull Result<Void> var4);

        public void transactionGet(@NonNull FirestorePigeonFirebaseApp var1, @NonNull String var2, @NonNull String var3, @NonNull Result<PigeonDocumentSnapshot> var4);

        public void documentReferenceSet(@NonNull FirestorePigeonFirebaseApp var1, @NonNull DocumentReferenceRequest var2, @NonNull Result<Void> var3);

        public void documentReferenceUpdate(@NonNull FirestorePigeonFirebaseApp var1, @NonNull DocumentReferenceRequest var2, @NonNull Result<Void> var3);

        public void documentReferenceGet(@NonNull FirestorePigeonFirebaseApp var1, @NonNull DocumentReferenceRequest var2, @NonNull Result<PigeonDocumentSnapshot> var3);

        public void documentReferenceDelete(@NonNull FirestorePigeonFirebaseApp var1, @NonNull DocumentReferenceRequest var2, @NonNull Result<Void> var3);

        public void queryGet(@NonNull FirestorePigeonFirebaseApp var1, @NonNull String var2, @NonNull Boolean var3, @NonNull PigeonQueryParameters var4, @NonNull PigeonGetOptions var5, @NonNull Result<PigeonQuerySnapshot> var6);

        public void aggregateQuery(@NonNull FirestorePigeonFirebaseApp var1, @NonNull String var2, @NonNull PigeonQueryParameters var3, @NonNull AggregateSource var4, @NonNull List<AggregateQuery> var5, @NonNull Boolean var6, @NonNull Result<List<AggregateQueryResponse>> var7);

        public void writeBatchCommit(@NonNull FirestorePigeonFirebaseApp var1, @NonNull List<PigeonTransactionCommand> var2, @NonNull Result<Void> var3);

        public void querySnapshot(@NonNull FirestorePigeonFirebaseApp var1, @NonNull String var2, @NonNull Boolean var3, @NonNull PigeonQueryParameters var4, @NonNull PigeonGetOptions var5, @NonNull Boolean var6, @NonNull ListenSource var7, @NonNull Result<String> var8);

        public void documentReferenceSnapshot(@NonNull FirestorePigeonFirebaseApp var1, @NonNull DocumentReferenceRequest var2, @NonNull Boolean var3, @NonNull ListenSource var4, @NonNull Result<String> var5);

        public void persistenceCacheIndexManagerRequest(@NonNull FirestorePigeonFirebaseApp var1, @NonNull PersistenceCacheIndexManagerRequest var2, @NonNull Result<Void> var3);

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return FirebaseFirestoreHostApiCodec.INSTANCE;
        }

        public static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable FirebaseFirestoreHostApi api) {
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.loadBundle", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    byte[] bundleArg = (byte[])args.get(1);
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.loadBundle(appArg, bundleArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.namedQueryGet", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    String nameArg = (String)args.get(1);
                    PigeonGetOptions optionsArg = (PigeonGetOptions)args.get(2);
                    Result<PigeonQuerySnapshot> resultCallback = new Result<PigeonQuerySnapshot>(){

                        @Override
                        public void success(PigeonQuerySnapshot result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.namedQueryGet(appArg, nameArg, optionsArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.clearPersistence", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.clearPersistence(appArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.disableNetwork", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.disableNetwork(appArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.enableNetwork", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.enableNetwork(appArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.terminate", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.terminate(appArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.waitForPendingWrites", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.waitForPendingWrites(appArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.setIndexConfiguration", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    String indexConfigurationArg = (String)args.get(1);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.setIndexConfiguration(appArg, indexConfigurationArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.setLoggingEnabled", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    Boolean loggingEnabledArg = (Boolean)args.get(0);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.setLoggingEnabled(loggingEnabledArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.snapshotsInSyncSetup", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.snapshotsInSyncSetup(appArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.transactionCreate", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    Number timeoutArg = (Number)args.get(1);
                    Number maxAttemptsArg = (Number)args.get(2);
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.transactionCreate(appArg, timeoutArg == null ? null : Long.valueOf(timeoutArg.longValue()), maxAttemptsArg == null ? null : Long.valueOf(maxAttemptsArg.longValue()), resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.transactionStoreResult", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String transactionIdArg = (String)args.get(0);
                    PigeonTransactionResult resultTypeArg = PigeonTransactionResult.values()[(Integer)args.get(1)];
                    List commandsArg = (List)args.get(2);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.transactionStoreResult(transactionIdArg, resultTypeArg, commandsArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.transactionGet", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    String transactionIdArg = (String)args.get(1);
                    String pathArg = (String)args.get(2);
                    Result<PigeonDocumentSnapshot> resultCallback = new Result<PigeonDocumentSnapshot>(){

                        @Override
                        public void success(PigeonDocumentSnapshot result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.transactionGet(appArg, transactionIdArg, pathArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.documentReferenceSet", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    DocumentReferenceRequest requestArg = (DocumentReferenceRequest)args.get(1);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.documentReferenceSet(appArg, requestArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.documentReferenceUpdate", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    DocumentReferenceRequest requestArg = (DocumentReferenceRequest)args.get(1);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.documentReferenceUpdate(appArg, requestArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.documentReferenceGet", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    DocumentReferenceRequest requestArg = (DocumentReferenceRequest)args.get(1);
                    Result<PigeonDocumentSnapshot> resultCallback = new Result<PigeonDocumentSnapshot>(){

                        @Override
                        public void success(PigeonDocumentSnapshot result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.documentReferenceGet(appArg, requestArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.documentReferenceDelete", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    DocumentReferenceRequest requestArg = (DocumentReferenceRequest)args.get(1);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.documentReferenceDelete(appArg, requestArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.queryGet", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    String pathArg = (String)args.get(1);
                    Boolean isCollectionGroupArg = (Boolean)args.get(2);
                    PigeonQueryParameters parametersArg = (PigeonQueryParameters)args.get(3);
                    PigeonGetOptions optionsArg = (PigeonGetOptions)args.get(4);
                    Result<PigeonQuerySnapshot> resultCallback = new Result<PigeonQuerySnapshot>(){

                        @Override
                        public void success(PigeonQuerySnapshot result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.queryGet(appArg, pathArg, isCollectionGroupArg, parametersArg, optionsArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.aggregateQuery", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    String pathArg = (String)args.get(1);
                    PigeonQueryParameters parametersArg = (PigeonQueryParameters)args.get(2);
                    AggregateSource sourceArg = AggregateSource.values()[(Integer)args.get(3)];
                    List queriesArg = (List)args.get(4);
                    Boolean isCollectionGroupArg = (Boolean)args.get(5);
                    Result<List<AggregateQueryResponse>> resultCallback = new Result<List<AggregateQueryResponse>>(){

                        @Override
                        public void success(List<AggregateQueryResponse> result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.aggregateQuery(appArg, pathArg, parametersArg, sourceArg, queriesArg, isCollectionGroupArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.writeBatchCommit", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    List writesArg = (List)args.get(1);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.writeBatchCommit(appArg, writesArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.querySnapshot", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    String pathArg = (String)args.get(1);
                    Boolean isCollectionGroupArg = (Boolean)args.get(2);
                    PigeonQueryParameters parametersArg = (PigeonQueryParameters)args.get(3);
                    PigeonGetOptions optionsArg = (PigeonGetOptions)args.get(4);
                    Boolean includeMetadataChangesArg = (Boolean)args.get(5);
                    ListenSource sourceArg = ListenSource.values()[(Integer)args.get(6)];
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.querySnapshot(appArg, pathArg, isCollectionGroupArg, parametersArg, optionsArg, includeMetadataChangesArg, sourceArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.documentReferenceSnapshot", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    DocumentReferenceRequest parametersArg = (DocumentReferenceRequest)args.get(1);
                    Boolean includeMetadataChangesArg = (Boolean)args.get(2);
                    ListenSource sourceArg = ListenSource.values()[(Integer)args.get(3)];
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.documentReferenceSnapshot(appArg, parametersArg, includeMetadataChangesArg, sourceArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.cloud_firestore_platform_interface.FirebaseFirestoreHostApi.persistenceCacheIndexManagerRequest", FirebaseFirestoreHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    FirestorePigeonFirebaseApp appArg = (FirestorePigeonFirebaseApp)args.get(0);
                    PersistenceCacheIndexManagerRequest requestArg = PersistenceCacheIndexManagerRequest.values()[(Integer)args.get(1)];
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseFirestore.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.persistenceCacheIndexManagerRequest(appArg, requestArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    private static class FirebaseFirestoreHostApiCodec
    extends FlutterFirebaseFirestoreMessageCodec {
        public static final FirebaseFirestoreHostApiCodec INSTANCE = new FirebaseFirestoreHostApiCodec();

        private FirebaseFirestoreHostApiCodec() {
        }

        @Override
        protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
            switch (type) {
                case -128: {
                    return AggregateQuery.fromList((ArrayList)this.readValue(buffer));
                }
                case -127: {
                    return AggregateQueryResponse.fromList((ArrayList)this.readValue(buffer));
                }
                case -126: {
                    return DocumentReferenceRequest.fromList((ArrayList)this.readValue(buffer));
                }
                case -125: {
                    return FirestorePigeonFirebaseApp.fromList((ArrayList)this.readValue(buffer));
                }
                case -124: {
                    return PigeonDocumentChange.fromList((ArrayList)this.readValue(buffer));
                }
                case -123: {
                    return PigeonDocumentOption.fromList((ArrayList)this.readValue(buffer));
                }
                case -122: {
                    return PigeonDocumentSnapshot.fromList((ArrayList)this.readValue(buffer));
                }
                case -121: {
                    return PigeonFirebaseSettings.fromList((ArrayList)this.readValue(buffer));
                }
                case -120: {
                    return PigeonGetOptions.fromList((ArrayList)this.readValue(buffer));
                }
                case -119: {
                    return PigeonQueryParameters.fromList((ArrayList)this.readValue(buffer));
                }
                case -118: {
                    return PigeonQuerySnapshot.fromList((ArrayList)this.readValue(buffer));
                }
                case -117: {
                    return PigeonSnapshotMetadata.fromList((ArrayList)this.readValue(buffer));
                }
                case -116: {
                    return PigeonTransactionCommand.fromList((ArrayList)this.readValue(buffer));
                }
            }
            return super.readValueOfType(type, buffer);
        }

        @Override
        protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
            if (value instanceof AggregateQuery) {
                stream.write(128);
                this.writeValue(stream, ((AggregateQuery)value).toList());
            } else if (value instanceof AggregateQueryResponse) {
                stream.write(129);
                this.writeValue(stream, ((AggregateQueryResponse)value).toList());
            } else if (value instanceof DocumentReferenceRequest) {
                stream.write(130);
                this.writeValue(stream, ((DocumentReferenceRequest)value).toList());
            } else if (value instanceof FirestorePigeonFirebaseApp) {
                stream.write(131);
                this.writeValue(stream, ((FirestorePigeonFirebaseApp)value).toList());
            } else if (value instanceof PigeonDocumentChange) {
                stream.write(132);
                this.writeValue(stream, ((PigeonDocumentChange)value).toList());
            } else if (value instanceof PigeonDocumentOption) {
                stream.write(133);
                this.writeValue(stream, ((PigeonDocumentOption)value).toList());
            } else if (value instanceof PigeonDocumentSnapshot) {
                stream.write(134);
                this.writeValue(stream, ((PigeonDocumentSnapshot)value).toList());
            } else if (value instanceof PigeonFirebaseSettings) {
                stream.write(135);
                this.writeValue(stream, ((PigeonFirebaseSettings)value).toList());
            } else if (value instanceof PigeonGetOptions) {
                stream.write(136);
                this.writeValue(stream, ((PigeonGetOptions)value).toList());
            } else if (value instanceof PigeonQueryParameters) {
                stream.write(137);
                this.writeValue(stream, ((PigeonQueryParameters)value).toList());
            } else if (value instanceof PigeonQuerySnapshot) {
                stream.write(138);
                this.writeValue(stream, ((PigeonQuerySnapshot)value).toList());
            } else if (value instanceof PigeonSnapshotMetadata) {
                stream.write(139);
                this.writeValue(stream, ((PigeonSnapshotMetadata)value).toList());
            } else if (value instanceof PigeonTransactionCommand) {
                stream.write(140);
                this.writeValue(stream, ((PigeonTransactionCommand)value).toList());
            } else {
                super.writeValue(stream, value);
            }
        }
    }

    public static interface Result<T> {
        public void success(T var1);

        public void error(@NonNull Throwable var1);
    }

    public static final class AggregateQueryResponse {
        @NonNull
        private AggregateType type;
        @Nullable
        private String field;
        @Nullable
        private Double value;

        @NonNull
        public AggregateType getType() {
            return this.type;
        }

        public void setType(@NonNull AggregateType setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"type\" is null.");
            }
            this.type = setterArg;
        }

        @Nullable
        public String getField() {
            return this.field;
        }

        public void setField(@Nullable String setterArg) {
            this.field = setterArg;
        }

        @Nullable
        public Double getValue() {
            return this.value;
        }

        public void setValue(@Nullable Double setterArg) {
            this.value = setterArg;
        }

        AggregateQueryResponse() {
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add(this.type == null ? null : Integer.valueOf(this.type.index));
            toListResult.add(this.field);
            toListResult.add(this.value);
            return toListResult;
        }

        @NonNull
        static AggregateQueryResponse fromList(@NonNull ArrayList<Object> list) {
            AggregateQueryResponse pigeonResult = new AggregateQueryResponse();
            Object type = list.get(0);
            pigeonResult.setType(AggregateType.values()[(Integer)type]);
            Object field = list.get(1);
            pigeonResult.setField((String)field);
            Object value = list.get(2);
            pigeonResult.setValue((Double)value);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private AggregateType type;
            @Nullable
            private String field;
            @Nullable
            private Double value;

            @NonNull
            public Builder setType(@NonNull AggregateType setterArg) {
                this.type = setterArg;
                return this;
            }

            @NonNull
            public Builder setField(@Nullable String setterArg) {
                this.field = setterArg;
                return this;
            }

            @NonNull
            public Builder setValue(@Nullable Double setterArg) {
                this.value = setterArg;
                return this;
            }

            @NonNull
            public AggregateQueryResponse build() {
                AggregateQueryResponse pigeonReturn = new AggregateQueryResponse();
                pigeonReturn.setType(this.type);
                pigeonReturn.setField(this.field);
                pigeonReturn.setValue(this.value);
                return pigeonReturn;
            }
        }
    }

    public static final class AggregateQuery {
        @NonNull
        private AggregateType type;
        @Nullable
        private String field;

        @NonNull
        public AggregateType getType() {
            return this.type;
        }

        public void setType(@NonNull AggregateType setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"type\" is null.");
            }
            this.type = setterArg;
        }

        @Nullable
        public String getField() {
            return this.field;
        }

        public void setField(@Nullable String setterArg) {
            this.field = setterArg;
        }

        AggregateQuery() {
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.type == null ? null : Integer.valueOf(this.type.index));
            toListResult.add(this.field);
            return toListResult;
        }

        @NonNull
        static AggregateQuery fromList(@NonNull ArrayList<Object> list) {
            AggregateQuery pigeonResult = new AggregateQuery();
            Object type = list.get(0);
            pigeonResult.setType(AggregateType.values()[(Integer)type]);
            Object field = list.get(1);
            pigeonResult.setField((String)field);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private AggregateType type;
            @Nullable
            private String field;

            @NonNull
            public Builder setType(@NonNull AggregateType setterArg) {
                this.type = setterArg;
                return this;
            }

            @NonNull
            public Builder setField(@Nullable String setterArg) {
                this.field = setterArg;
                return this;
            }

            @NonNull
            public AggregateQuery build() {
                AggregateQuery pigeonReturn = new AggregateQuery();
                pigeonReturn.setType(this.type);
                pigeonReturn.setField(this.field);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonQueryParameters {
        @Nullable
        private List<List<Object>> where;
        @Nullable
        private List<List<Object>> orderBy;
        @Nullable
        private Long limit;
        @Nullable
        private Long limitToLast;
        @Nullable
        private List<Object> startAt;
        @Nullable
        private List<Object> startAfter;
        @Nullable
        private List<Object> endAt;
        @Nullable
        private List<Object> endBefore;
        @Nullable
        private Map<String, Object> filters;

        @Nullable
        public List<List<Object>> getWhere() {
            return this.where;
        }

        public void setWhere(@Nullable List<List<Object>> setterArg) {
            this.where = setterArg;
        }

        @Nullable
        public List<List<Object>> getOrderBy() {
            return this.orderBy;
        }

        public void setOrderBy(@Nullable List<List<Object>> setterArg) {
            this.orderBy = setterArg;
        }

        @Nullable
        public Long getLimit() {
            return this.limit;
        }

        public void setLimit(@Nullable Long setterArg) {
            this.limit = setterArg;
        }

        @Nullable
        public Long getLimitToLast() {
            return this.limitToLast;
        }

        public void setLimitToLast(@Nullable Long setterArg) {
            this.limitToLast = setterArg;
        }

        @Nullable
        public List<Object> getStartAt() {
            return this.startAt;
        }

        public void setStartAt(@Nullable List<Object> setterArg) {
            this.startAt = setterArg;
        }

        @Nullable
        public List<Object> getStartAfter() {
            return this.startAfter;
        }

        public void setStartAfter(@Nullable List<Object> setterArg) {
            this.startAfter = setterArg;
        }

        @Nullable
        public List<Object> getEndAt() {
            return this.endAt;
        }

        public void setEndAt(@Nullable List<Object> setterArg) {
            this.endAt = setterArg;
        }

        @Nullable
        public List<Object> getEndBefore() {
            return this.endBefore;
        }

        public void setEndBefore(@Nullable List<Object> setterArg) {
            this.endBefore = setterArg;
        }

        @Nullable
        public Map<String, Object> getFilters() {
            return this.filters;
        }

        public void setFilters(@Nullable Map<String, Object> setterArg) {
            this.filters = setterArg;
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(9);
            toListResult.add(this.where);
            toListResult.add(this.orderBy);
            toListResult.add(this.limit);
            toListResult.add(this.limitToLast);
            toListResult.add(this.startAt);
            toListResult.add(this.startAfter);
            toListResult.add(this.endAt);
            toListResult.add(this.endBefore);
            toListResult.add(this.filters);
            return toListResult;
        }

        @NonNull
        static PigeonQueryParameters fromList(@NonNull ArrayList<Object> list) {
            PigeonQueryParameters pigeonResult = new PigeonQueryParameters();
            Object where = list.get(0);
            pigeonResult.setWhere((List)where);
            Object orderBy = list.get(1);
            pigeonResult.setOrderBy((List)orderBy);
            Object limit = list.get(2);
            pigeonResult.setLimit(limit == null ? null : Long.valueOf(limit instanceof Integer ? (long)((Integer)limit).intValue() : (Long)limit));
            Object limitToLast = list.get(3);
            pigeonResult.setLimitToLast(limitToLast == null ? null : Long.valueOf(limitToLast instanceof Integer ? (long)((Integer)limitToLast).intValue() : (Long)limitToLast));
            Object startAt = list.get(4);
            pigeonResult.setStartAt((List)startAt);
            Object startAfter = list.get(5);
            pigeonResult.setStartAfter((List)startAfter);
            Object endAt = list.get(6);
            pigeonResult.setEndAt((List)endAt);
            Object endBefore = list.get(7);
            pigeonResult.setEndBefore((List)endBefore);
            Object filters = list.get(8);
            pigeonResult.setFilters((Map)filters);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private List<List<Object>> where;
            @Nullable
            private List<List<Object>> orderBy;
            @Nullable
            private Long limit;
            @Nullable
            private Long limitToLast;
            @Nullable
            private List<Object> startAt;
            @Nullable
            private List<Object> startAfter;
            @Nullable
            private List<Object> endAt;
            @Nullable
            private List<Object> endBefore;
            @Nullable
            private Map<String, Object> filters;

            @NonNull
            public Builder setWhere(@Nullable List<List<Object>> setterArg) {
                this.where = setterArg;
                return this;
            }

            @NonNull
            public Builder setOrderBy(@Nullable List<List<Object>> setterArg) {
                this.orderBy = setterArg;
                return this;
            }

            @NonNull
            public Builder setLimit(@Nullable Long setterArg) {
                this.limit = setterArg;
                return this;
            }

            @NonNull
            public Builder setLimitToLast(@Nullable Long setterArg) {
                this.limitToLast = setterArg;
                return this;
            }

            @NonNull
            public Builder setStartAt(@Nullable List<Object> setterArg) {
                this.startAt = setterArg;
                return this;
            }

            @NonNull
            public Builder setStartAfter(@Nullable List<Object> setterArg) {
                this.startAfter = setterArg;
                return this;
            }

            @NonNull
            public Builder setEndAt(@Nullable List<Object> setterArg) {
                this.endAt = setterArg;
                return this;
            }

            @NonNull
            public Builder setEndBefore(@Nullable List<Object> setterArg) {
                this.endBefore = setterArg;
                return this;
            }

            @NonNull
            public Builder setFilters(@Nullable Map<String, Object> setterArg) {
                this.filters = setterArg;
                return this;
            }

            @NonNull
            public PigeonQueryParameters build() {
                PigeonQueryParameters pigeonReturn = new PigeonQueryParameters();
                pigeonReturn.setWhere(this.where);
                pigeonReturn.setOrderBy(this.orderBy);
                pigeonReturn.setLimit(this.limit);
                pigeonReturn.setLimitToLast(this.limitToLast);
                pigeonReturn.setStartAt(this.startAt);
                pigeonReturn.setStartAfter(this.startAfter);
                pigeonReturn.setEndAt(this.endAt);
                pigeonReturn.setEndBefore(this.endBefore);
                pigeonReturn.setFilters(this.filters);
                return pigeonReturn;
            }
        }
    }

    public static final class DocumentReferenceRequest {
        @NonNull
        private String path;
        @Nullable
        private Map<Object, Object> data;
        @Nullable
        private PigeonDocumentOption option;
        @Nullable
        private Source source;
        @Nullable
        private ServerTimestampBehavior serverTimestampBehavior;

        @NonNull
        public String getPath() {
            return this.path;
        }

        public void setPath(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"path\" is null.");
            }
            this.path = setterArg;
        }

        @Nullable
        public Map<Object, Object> getData() {
            return this.data;
        }

        public void setData(@Nullable Map<Object, Object> setterArg) {
            this.data = setterArg;
        }

        @Nullable
        public PigeonDocumentOption getOption() {
            return this.option;
        }

        public void setOption(@Nullable PigeonDocumentOption setterArg) {
            this.option = setterArg;
        }

        @Nullable
        public Source getSource() {
            return this.source;
        }

        public void setSource(@Nullable Source setterArg) {
            this.source = setterArg;
        }

        @Nullable
        public ServerTimestampBehavior getServerTimestampBehavior() {
            return this.serverTimestampBehavior;
        }

        public void setServerTimestampBehavior(@Nullable ServerTimestampBehavior setterArg) {
            this.serverTimestampBehavior = setterArg;
        }

        DocumentReferenceRequest() {
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(5);
            toListResult.add(this.path);
            toListResult.add(this.data);
            toListResult.add(this.option == null ? null : this.option.toList());
            toListResult.add(this.source == null ? null : Integer.valueOf(this.source.index));
            toListResult.add(this.serverTimestampBehavior == null ? null : Integer.valueOf(this.serverTimestampBehavior.index));
            return toListResult;
        }

        @NonNull
        static DocumentReferenceRequest fromList(@NonNull ArrayList<Object> list) {
            DocumentReferenceRequest pigeonResult = new DocumentReferenceRequest();
            Object path = list.get(0);
            pigeonResult.setPath((String)path);
            Object data = list.get(1);
            pigeonResult.setData((Map)data);
            Object option = list.get(2);
            pigeonResult.setOption(option == null ? null : PigeonDocumentOption.fromList((ArrayList)option));
            Object source = list.get(3);
            pigeonResult.setSource(source == null ? null : Source.values()[(Integer)source]);
            Object serverTimestampBehavior = list.get(4);
            pigeonResult.setServerTimestampBehavior(serverTimestampBehavior == null ? null : ServerTimestampBehavior.values()[(Integer)serverTimestampBehavior]);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String path;
            @Nullable
            private Map<Object, Object> data;
            @Nullable
            private PigeonDocumentOption option;
            @Nullable
            private Source source;
            @Nullable
            private ServerTimestampBehavior serverTimestampBehavior;

            @NonNull
            public Builder setPath(@NonNull String setterArg) {
                this.path = setterArg;
                return this;
            }

            @NonNull
            public Builder setData(@Nullable Map<Object, Object> setterArg) {
                this.data = setterArg;
                return this;
            }

            @NonNull
            public Builder setOption(@Nullable PigeonDocumentOption setterArg) {
                this.option = setterArg;
                return this;
            }

            @NonNull
            public Builder setSource(@Nullable Source setterArg) {
                this.source = setterArg;
                return this;
            }

            @NonNull
            public Builder setServerTimestampBehavior(@Nullable ServerTimestampBehavior setterArg) {
                this.serverTimestampBehavior = setterArg;
                return this;
            }

            @NonNull
            public DocumentReferenceRequest build() {
                DocumentReferenceRequest pigeonReturn = new DocumentReferenceRequest();
                pigeonReturn.setPath(this.path);
                pigeonReturn.setData(this.data);
                pigeonReturn.setOption(this.option);
                pigeonReturn.setSource(this.source);
                pigeonReturn.setServerTimestampBehavior(this.serverTimestampBehavior);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonTransactionCommand {
        @NonNull
        private PigeonTransactionType type;
        @NonNull
        private String path;
        @Nullable
        private Map<String, Object> data;
        @Nullable
        private PigeonDocumentOption option;

        @NonNull
        public PigeonTransactionType getType() {
            return this.type;
        }

        public void setType(@NonNull PigeonTransactionType setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"type\" is null.");
            }
            this.type = setterArg;
        }

        @NonNull
        public String getPath() {
            return this.path;
        }

        public void setPath(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"path\" is null.");
            }
            this.path = setterArg;
        }

        @Nullable
        public Map<String, Object> getData() {
            return this.data;
        }

        public void setData(@Nullable Map<String, Object> setterArg) {
            this.data = setterArg;
        }

        @Nullable
        public PigeonDocumentOption getOption() {
            return this.option;
        }

        public void setOption(@Nullable PigeonDocumentOption setterArg) {
            this.option = setterArg;
        }

        PigeonTransactionCommand() {
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(4);
            toListResult.add(this.type == null ? null : Integer.valueOf(this.type.index));
            toListResult.add(this.path);
            toListResult.add(this.data);
            toListResult.add(this.option == null ? null : this.option.toList());
            return toListResult;
        }

        @NonNull
        static PigeonTransactionCommand fromList(@NonNull ArrayList<Object> list) {
            PigeonTransactionCommand pigeonResult = new PigeonTransactionCommand();
            Object type = list.get(0);
            pigeonResult.setType(PigeonTransactionType.values()[(Integer)type]);
            Object path = list.get(1);
            pigeonResult.setPath((String)path);
            Object data = list.get(2);
            pigeonResult.setData((Map)data);
            Object option = list.get(3);
            pigeonResult.setOption(option == null ? null : PigeonDocumentOption.fromList((ArrayList)option));
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private PigeonTransactionType type;
            @Nullable
            private String path;
            @Nullable
            private Map<String, Object> data;
            @Nullable
            private PigeonDocumentOption option;

            @NonNull
            public Builder setType(@NonNull PigeonTransactionType setterArg) {
                this.type = setterArg;
                return this;
            }

            @NonNull
            public Builder setPath(@NonNull String setterArg) {
                this.path = setterArg;
                return this;
            }

            @NonNull
            public Builder setData(@Nullable Map<String, Object> setterArg) {
                this.data = setterArg;
                return this;
            }

            @NonNull
            public Builder setOption(@Nullable PigeonDocumentOption setterArg) {
                this.option = setterArg;
                return this;
            }

            @NonNull
            public PigeonTransactionCommand build() {
                PigeonTransactionCommand pigeonReturn = new PigeonTransactionCommand();
                pigeonReturn.setType(this.type);
                pigeonReturn.setPath(this.path);
                pigeonReturn.setData(this.data);
                pigeonReturn.setOption(this.option);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonDocumentOption {
        @Nullable
        private Boolean merge;
        @Nullable
        private List<List<String>> mergeFields;

        @Nullable
        public Boolean getMerge() {
            return this.merge;
        }

        public void setMerge(@Nullable Boolean setterArg) {
            this.merge = setterArg;
        }

        @Nullable
        public List<List<String>> getMergeFields() {
            return this.mergeFields;
        }

        public void setMergeFields(@Nullable List<List<String>> setterArg) {
            this.mergeFields = setterArg;
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.merge);
            toListResult.add(this.mergeFields);
            return toListResult;
        }

        @NonNull
        static PigeonDocumentOption fromList(@NonNull ArrayList<Object> list) {
            PigeonDocumentOption pigeonResult = new PigeonDocumentOption();
            Object merge = list.get(0);
            pigeonResult.setMerge((Boolean)merge);
            Object mergeFields = list.get(1);
            pigeonResult.setMergeFields((List)mergeFields);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Boolean merge;
            @Nullable
            private List<List<String>> mergeFields;

            @NonNull
            public Builder setMerge(@Nullable Boolean setterArg) {
                this.merge = setterArg;
                return this;
            }

            @NonNull
            public Builder setMergeFields(@Nullable List<List<String>> setterArg) {
                this.mergeFields = setterArg;
                return this;
            }

            @NonNull
            public PigeonDocumentOption build() {
                PigeonDocumentOption pigeonReturn = new PigeonDocumentOption();
                pigeonReturn.setMerge(this.merge);
                pigeonReturn.setMergeFields(this.mergeFields);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonGetOptions {
        @NonNull
        private Source source;
        @NonNull
        private ServerTimestampBehavior serverTimestampBehavior;

        @NonNull
        public Source getSource() {
            return this.source;
        }

        public void setSource(@NonNull Source setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"source\" is null.");
            }
            this.source = setterArg;
        }

        @NonNull
        public ServerTimestampBehavior getServerTimestampBehavior() {
            return this.serverTimestampBehavior;
        }

        public void setServerTimestampBehavior(@NonNull ServerTimestampBehavior setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"serverTimestampBehavior\" is null.");
            }
            this.serverTimestampBehavior = setterArg;
        }

        PigeonGetOptions() {
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.source == null ? null : Integer.valueOf(this.source.index));
            toListResult.add(this.serverTimestampBehavior == null ? null : Integer.valueOf(this.serverTimestampBehavior.index));
            return toListResult;
        }

        @NonNull
        static PigeonGetOptions fromList(@NonNull ArrayList<Object> list) {
            PigeonGetOptions pigeonResult = new PigeonGetOptions();
            Object source = list.get(0);
            pigeonResult.setSource(Source.values()[(Integer)source]);
            Object serverTimestampBehavior = list.get(1);
            pigeonResult.setServerTimestampBehavior(ServerTimestampBehavior.values()[(Integer)serverTimestampBehavior]);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Source source;
            @Nullable
            private ServerTimestampBehavior serverTimestampBehavior;

            @NonNull
            public Builder setSource(@NonNull Source setterArg) {
                this.source = setterArg;
                return this;
            }

            @NonNull
            public Builder setServerTimestampBehavior(@NonNull ServerTimestampBehavior setterArg) {
                this.serverTimestampBehavior = setterArg;
                return this;
            }

            @NonNull
            public PigeonGetOptions build() {
                PigeonGetOptions pigeonReturn = new PigeonGetOptions();
                pigeonReturn.setSource(this.source);
                pigeonReturn.setServerTimestampBehavior(this.serverTimestampBehavior);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonQuerySnapshot {
        @NonNull
        private List<PigeonDocumentSnapshot> documents;
        @NonNull
        private List<PigeonDocumentChange> documentChanges;
        @NonNull
        private PigeonSnapshotMetadata metadata;

        @NonNull
        public List<PigeonDocumentSnapshot> getDocuments() {
            return this.documents;
        }

        public void setDocuments(@NonNull List<PigeonDocumentSnapshot> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"documents\" is null.");
            }
            this.documents = setterArg;
        }

        @NonNull
        public List<PigeonDocumentChange> getDocumentChanges() {
            return this.documentChanges;
        }

        public void setDocumentChanges(@NonNull List<PigeonDocumentChange> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"documentChanges\" is null.");
            }
            this.documentChanges = setterArg;
        }

        @NonNull
        public PigeonSnapshotMetadata getMetadata() {
            return this.metadata;
        }

        public void setMetadata(@NonNull PigeonSnapshotMetadata setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"metadata\" is null.");
            }
            this.metadata = setterArg;
        }

        PigeonQuerySnapshot() {
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add(this.documents);
            toListResult.add(this.documentChanges);
            toListResult.add(this.metadata == null ? null : this.metadata.toList());
            return toListResult;
        }

        @NonNull
        static PigeonQuerySnapshot fromList(@NonNull ArrayList<Object> list) {
            PigeonQuerySnapshot pigeonResult = new PigeonQuerySnapshot();
            Object documents = list.get(0);
            pigeonResult.setDocuments((List)documents);
            Object documentChanges = list.get(1);
            pigeonResult.setDocumentChanges((List)documentChanges);
            Object metadata = list.get(2);
            pigeonResult.setMetadata(metadata == null ? null : PigeonSnapshotMetadata.fromList((ArrayList)metadata));
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private List<PigeonDocumentSnapshot> documents;
            @Nullable
            private List<PigeonDocumentChange> documentChanges;
            @Nullable
            private PigeonSnapshotMetadata metadata;

            @NonNull
            public Builder setDocuments(@NonNull List<PigeonDocumentSnapshot> setterArg) {
                this.documents = setterArg;
                return this;
            }

            @NonNull
            public Builder setDocumentChanges(@NonNull List<PigeonDocumentChange> setterArg) {
                this.documentChanges = setterArg;
                return this;
            }

            @NonNull
            public Builder setMetadata(@NonNull PigeonSnapshotMetadata setterArg) {
                this.metadata = setterArg;
                return this;
            }

            @NonNull
            public PigeonQuerySnapshot build() {
                PigeonQuerySnapshot pigeonReturn = new PigeonQuerySnapshot();
                pigeonReturn.setDocuments(this.documents);
                pigeonReturn.setDocumentChanges(this.documentChanges);
                pigeonReturn.setMetadata(this.metadata);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonDocumentChange {
        @NonNull
        private DocumentChangeType type;
        @NonNull
        private PigeonDocumentSnapshot document;
        @NonNull
        private Long oldIndex;
        @NonNull
        private Long newIndex;

        @NonNull
        public DocumentChangeType getType() {
            return this.type;
        }

        public void setType(@NonNull DocumentChangeType setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"type\" is null.");
            }
            this.type = setterArg;
        }

        @NonNull
        public PigeonDocumentSnapshot getDocument() {
            return this.document;
        }

        public void setDocument(@NonNull PigeonDocumentSnapshot setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"document\" is null.");
            }
            this.document = setterArg;
        }

        @NonNull
        public Long getOldIndex() {
            return this.oldIndex;
        }

        public void setOldIndex(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"oldIndex\" is null.");
            }
            this.oldIndex = setterArg;
        }

        @NonNull
        public Long getNewIndex() {
            return this.newIndex;
        }

        public void setNewIndex(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"newIndex\" is null.");
            }
            this.newIndex = setterArg;
        }

        PigeonDocumentChange() {
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(4);
            toListResult.add(this.type == null ? null : Integer.valueOf(this.type.index));
            toListResult.add(this.document == null ? null : this.document.toList());
            toListResult.add(this.oldIndex);
            toListResult.add(this.newIndex);
            return toListResult;
        }

        @NonNull
        static PigeonDocumentChange fromList(@NonNull ArrayList<Object> list) {
            PigeonDocumentChange pigeonResult = new PigeonDocumentChange();
            Object type = list.get(0);
            pigeonResult.setType(DocumentChangeType.values()[(Integer)type]);
            Object document = list.get(1);
            pigeonResult.setDocument(document == null ? null : PigeonDocumentSnapshot.fromList((ArrayList)document));
            Object oldIndex = list.get(2);
            pigeonResult.setOldIndex(oldIndex == null ? null : Long.valueOf(oldIndex instanceof Integer ? (long)((Integer)oldIndex).intValue() : (Long)oldIndex));
            Object newIndex = list.get(3);
            pigeonResult.setNewIndex(newIndex == null ? null : Long.valueOf(newIndex instanceof Integer ? (long)((Integer)newIndex).intValue() : (Long)newIndex));
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private DocumentChangeType type;
            @Nullable
            private PigeonDocumentSnapshot document;
            @Nullable
            private Long oldIndex;
            @Nullable
            private Long newIndex;

            @NonNull
            public Builder setType(@NonNull DocumentChangeType setterArg) {
                this.type = setterArg;
                return this;
            }

            @NonNull
            public Builder setDocument(@NonNull PigeonDocumentSnapshot setterArg) {
                this.document = setterArg;
                return this;
            }

            @NonNull
            public Builder setOldIndex(@NonNull Long setterArg) {
                this.oldIndex = setterArg;
                return this;
            }

            @NonNull
            public Builder setNewIndex(@NonNull Long setterArg) {
                this.newIndex = setterArg;
                return this;
            }

            @NonNull
            public PigeonDocumentChange build() {
                PigeonDocumentChange pigeonReturn = new PigeonDocumentChange();
                pigeonReturn.setType(this.type);
                pigeonReturn.setDocument(this.document);
                pigeonReturn.setOldIndex(this.oldIndex);
                pigeonReturn.setNewIndex(this.newIndex);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonDocumentSnapshot {
        @NonNull
        private String path;
        @Nullable
        private Map<String, Object> data;
        @NonNull
        private PigeonSnapshotMetadata metadata;

        @NonNull
        public String getPath() {
            return this.path;
        }

        public void setPath(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"path\" is null.");
            }
            this.path = setterArg;
        }

        @Nullable
        public Map<String, Object> getData() {
            return this.data;
        }

        public void setData(@Nullable Map<String, Object> setterArg) {
            this.data = setterArg;
        }

        @NonNull
        public PigeonSnapshotMetadata getMetadata() {
            return this.metadata;
        }

        public void setMetadata(@NonNull PigeonSnapshotMetadata setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"metadata\" is null.");
            }
            this.metadata = setterArg;
        }

        PigeonDocumentSnapshot() {
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add(this.path);
            toListResult.add(this.data);
            toListResult.add(this.metadata == null ? null : this.metadata.toList());
            return toListResult;
        }

        @NonNull
        static PigeonDocumentSnapshot fromList(@NonNull ArrayList<Object> list) {
            PigeonDocumentSnapshot pigeonResult = new PigeonDocumentSnapshot();
            Object path = list.get(0);
            pigeonResult.setPath((String)path);
            Object data = list.get(1);
            pigeonResult.setData((Map)data);
            Object metadata = list.get(2);
            pigeonResult.setMetadata(metadata == null ? null : PigeonSnapshotMetadata.fromList((ArrayList)metadata));
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String path;
            @Nullable
            private Map<String, Object> data;
            @Nullable
            private PigeonSnapshotMetadata metadata;

            @NonNull
            public Builder setPath(@NonNull String setterArg) {
                this.path = setterArg;
                return this;
            }

            @NonNull
            public Builder setData(@Nullable Map<String, Object> setterArg) {
                this.data = setterArg;
                return this;
            }

            @NonNull
            public Builder setMetadata(@NonNull PigeonSnapshotMetadata setterArg) {
                this.metadata = setterArg;
                return this;
            }

            @NonNull
            public PigeonDocumentSnapshot build() {
                PigeonDocumentSnapshot pigeonReturn = new PigeonDocumentSnapshot();
                pigeonReturn.setPath(this.path);
                pigeonReturn.setData(this.data);
                pigeonReturn.setMetadata(this.metadata);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonSnapshotMetadata {
        @NonNull
        private Boolean hasPendingWrites;
        @NonNull
        private Boolean isFromCache;

        @NonNull
        public Boolean getHasPendingWrites() {
            return this.hasPendingWrites;
        }

        public void setHasPendingWrites(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"hasPendingWrites\" is null.");
            }
            this.hasPendingWrites = setterArg;
        }

        @NonNull
        public Boolean getIsFromCache() {
            return this.isFromCache;
        }

        public void setIsFromCache(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"isFromCache\" is null.");
            }
            this.isFromCache = setterArg;
        }

        PigeonSnapshotMetadata() {
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.hasPendingWrites);
            toListResult.add(this.isFromCache);
            return toListResult;
        }

        @NonNull
        static PigeonSnapshotMetadata fromList(@NonNull ArrayList<Object> list) {
            PigeonSnapshotMetadata pigeonResult = new PigeonSnapshotMetadata();
            Object hasPendingWrites = list.get(0);
            pigeonResult.setHasPendingWrites((Boolean)hasPendingWrites);
            Object isFromCache = list.get(1);
            pigeonResult.setIsFromCache((Boolean)isFromCache);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Boolean hasPendingWrites;
            @Nullable
            private Boolean isFromCache;

            @NonNull
            public Builder setHasPendingWrites(@NonNull Boolean setterArg) {
                this.hasPendingWrites = setterArg;
                return this;
            }

            @NonNull
            public Builder setIsFromCache(@NonNull Boolean setterArg) {
                this.isFromCache = setterArg;
                return this;
            }

            @NonNull
            public PigeonSnapshotMetadata build() {
                PigeonSnapshotMetadata pigeonReturn = new PigeonSnapshotMetadata();
                pigeonReturn.setHasPendingWrites(this.hasPendingWrites);
                pigeonReturn.setIsFromCache(this.isFromCache);
                return pigeonReturn;
            }
        }
    }

    public static final class FirestorePigeonFirebaseApp {
        @NonNull
        private String appName;
        @NonNull
        private PigeonFirebaseSettings settings;
        @NonNull
        private String databaseURL;

        @NonNull
        public String getAppName() {
            return this.appName;
        }

        public void setAppName(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"appName\" is null.");
            }
            this.appName = setterArg;
        }

        @NonNull
        public PigeonFirebaseSettings getSettings() {
            return this.settings;
        }

        public void setSettings(@NonNull PigeonFirebaseSettings setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"settings\" is null.");
            }
            this.settings = setterArg;
        }

        @NonNull
        public String getDatabaseURL() {
            return this.databaseURL;
        }

        public void setDatabaseURL(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"databaseURL\" is null.");
            }
            this.databaseURL = setterArg;
        }

        FirestorePigeonFirebaseApp() {
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add(this.appName);
            toListResult.add(this.settings == null ? null : this.settings.toList());
            toListResult.add(this.databaseURL);
            return toListResult;
        }

        @NonNull
        static FirestorePigeonFirebaseApp fromList(@NonNull ArrayList<Object> list) {
            FirestorePigeonFirebaseApp pigeonResult = new FirestorePigeonFirebaseApp();
            Object appName = list.get(0);
            pigeonResult.setAppName((String)appName);
            Object settings = list.get(1);
            pigeonResult.setSettings(settings == null ? null : PigeonFirebaseSettings.fromList((ArrayList)settings));
            Object databaseURL = list.get(2);
            pigeonResult.setDatabaseURL((String)databaseURL);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String appName;
            @Nullable
            private PigeonFirebaseSettings settings;
            @Nullable
            private String databaseURL;

            @NonNull
            public Builder setAppName(@NonNull String setterArg) {
                this.appName = setterArg;
                return this;
            }

            @NonNull
            public Builder setSettings(@NonNull PigeonFirebaseSettings setterArg) {
                this.settings = setterArg;
                return this;
            }

            @NonNull
            public Builder setDatabaseURL(@NonNull String setterArg) {
                this.databaseURL = setterArg;
                return this;
            }

            @NonNull
            public FirestorePigeonFirebaseApp build() {
                FirestorePigeonFirebaseApp pigeonReturn = new FirestorePigeonFirebaseApp();
                pigeonReturn.setAppName(this.appName);
                pigeonReturn.setSettings(this.settings);
                pigeonReturn.setDatabaseURL(this.databaseURL);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonFirebaseSettings {
        @Nullable
        private Boolean persistenceEnabled;
        @Nullable
        private String host;
        @Nullable
        private Boolean sslEnabled;
        @Nullable
        private Long cacheSizeBytes;
        @NonNull
        private Boolean ignoreUndefinedProperties;

        @Nullable
        public Boolean getPersistenceEnabled() {
            return this.persistenceEnabled;
        }

        public void setPersistenceEnabled(@Nullable Boolean setterArg) {
            this.persistenceEnabled = setterArg;
        }

        @Nullable
        public String getHost() {
            return this.host;
        }

        public void setHost(@Nullable String setterArg) {
            this.host = setterArg;
        }

        @Nullable
        public Boolean getSslEnabled() {
            return this.sslEnabled;
        }

        public void setSslEnabled(@Nullable Boolean setterArg) {
            this.sslEnabled = setterArg;
        }

        @Nullable
        public Long getCacheSizeBytes() {
            return this.cacheSizeBytes;
        }

        public void setCacheSizeBytes(@Nullable Long setterArg) {
            this.cacheSizeBytes = setterArg;
        }

        @NonNull
        public Boolean getIgnoreUndefinedProperties() {
            return this.ignoreUndefinedProperties;
        }

        public void setIgnoreUndefinedProperties(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"ignoreUndefinedProperties\" is null.");
            }
            this.ignoreUndefinedProperties = setterArg;
        }

        PigeonFirebaseSettings() {
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(5);
            toListResult.add(this.persistenceEnabled);
            toListResult.add(this.host);
            toListResult.add(this.sslEnabled);
            toListResult.add(this.cacheSizeBytes);
            toListResult.add(this.ignoreUndefinedProperties);
            return toListResult;
        }

        @NonNull
        static PigeonFirebaseSettings fromList(@NonNull ArrayList<Object> list) {
            PigeonFirebaseSettings pigeonResult = new PigeonFirebaseSettings();
            Object persistenceEnabled = list.get(0);
            pigeonResult.setPersistenceEnabled((Boolean)persistenceEnabled);
            Object host = list.get(1);
            pigeonResult.setHost((String)host);
            Object sslEnabled = list.get(2);
            pigeonResult.setSslEnabled((Boolean)sslEnabled);
            Object cacheSizeBytes = list.get(3);
            pigeonResult.setCacheSizeBytes(cacheSizeBytes == null ? null : Long.valueOf(cacheSizeBytes instanceof Integer ? (long)((Integer)cacheSizeBytes).intValue() : (Long)cacheSizeBytes));
            Object ignoreUndefinedProperties = list.get(4);
            pigeonResult.setIgnoreUndefinedProperties((Boolean)ignoreUndefinedProperties);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Boolean persistenceEnabled;
            @Nullable
            private String host;
            @Nullable
            private Boolean sslEnabled;
            @Nullable
            private Long cacheSizeBytes;
            @Nullable
            private Boolean ignoreUndefinedProperties;

            @NonNull
            public Builder setPersistenceEnabled(@Nullable Boolean setterArg) {
                this.persistenceEnabled = setterArg;
                return this;
            }

            @NonNull
            public Builder setHost(@Nullable String setterArg) {
                this.host = setterArg;
                return this;
            }

            @NonNull
            public Builder setSslEnabled(@Nullable Boolean setterArg) {
                this.sslEnabled = setterArg;
                return this;
            }

            @NonNull
            public Builder setCacheSizeBytes(@Nullable Long setterArg) {
                this.cacheSizeBytes = setterArg;
                return this;
            }

            @NonNull
            public Builder setIgnoreUndefinedProperties(@NonNull Boolean setterArg) {
                this.ignoreUndefinedProperties = setterArg;
                return this;
            }

            @NonNull
            public PigeonFirebaseSettings build() {
                PigeonFirebaseSettings pigeonReturn = new PigeonFirebaseSettings();
                pigeonReturn.setPersistenceEnabled(this.persistenceEnabled);
                pigeonReturn.setHost(this.host);
                pigeonReturn.setSslEnabled(this.sslEnabled);
                pigeonReturn.setCacheSizeBytes(this.cacheSizeBytes);
                pigeonReturn.setIgnoreUndefinedProperties(this.ignoreUndefinedProperties);
                return pigeonReturn;
            }
        }
    }

    public static enum AggregateType {
        COUNT(0),
        SUM(1),
        AVERAGE(2);

        final int index;

        private AggregateType(int index) {
            this.index = index;
        }
    }

    public static enum PigeonTransactionType {
        GET(0),
        UPDATE(1),
        SET(2),
        DELETE_TYPE(3);

        final int index;

        private PigeonTransactionType(int index) {
            this.index = index;
        }
    }

    public static enum PigeonTransactionResult {
        SUCCESS(0),
        FAILURE(1);

        final int index;

        private PigeonTransactionResult(int index) {
            this.index = index;
        }
    }

    public static enum PersistenceCacheIndexManagerRequest {
        ENABLE_INDEX_AUTO_CREATION(0),
        DISABLE_INDEX_AUTO_CREATION(1),
        DELETE_ALL_INDEXES(2);

        final int index;

        private PersistenceCacheIndexManagerRequest(int index) {
            this.index = index;
        }
    }

    public static enum AggregateSource {
        SERVER(0);

        final int index;

        private AggregateSource(int index) {
            this.index = index;
        }
    }

    public static enum ServerTimestampBehavior {
        NONE(0),
        ESTIMATE(1),
        PREVIOUS(2);

        final int index;

        private ServerTimestampBehavior(int index) {
            this.index = index;
        }
    }

    public static enum ListenSource {
        DEFAULT_SOURCE(0),
        CACHE(1);

        final int index;

        private ListenSource(int index) {
            this.index = index;
        }
    }

    public static enum Source {
        SERVER_AND_CACHE(0),
        SERVER(1),
        CACHE(2);

        final int index;

        private Source(int index) {
            this.index = index;
        }
    }

    public static enum DocumentChangeType {
        ADDED(0),
        MODIFIED(1),
        REMOVED(2);

        final int index;

        private DocumentChangeType(int index) {
            this.index = index;
        }
    }
}

