/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.firestore;

import android.app.Activity;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.firestore.AggregateField;
import com.google.firebase.firestore.AggregateQuery;
import com.google.firebase.firestore.AggregateQuerySnapshot;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.LocalCacheSettings;
import com.google.firebase.firestore.MemoryCacheSettings;
import com.google.firebase.firestore.PersistentCacheIndexManager;
import com.google.firebase.firestore.PersistentCacheSettings;
import com.google.firebase.firestore.Query;
import com.google.firebase.firestore.QuerySnapshot;
import com.google.firebase.firestore.SetOptions;
import com.google.firebase.firestore.Source;
import com.google.firebase.firestore.Transaction;
import com.google.firebase.firestore.WriteBatch;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugin.common.MethodCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import io.flutter.plugin.common.StandardMethodCodec;
import io.flutter.plugins.firebase.core.FlutterFirebasePlugin;
import io.flutter.plugins.firebase.core.FlutterFirebasePluginRegistry;
import io.flutter.plugins.firebase.firestore.FlutterFirebaseFirestoreExtension;
import io.flutter.plugins.firebase.firestore.FlutterFirebaseFirestoreMessageCodec;
import io.flutter.plugins.firebase.firestore.GeneratedAndroidFirebaseFirestore;
import io.flutter.plugins.firebase.firestore.streamhandler.DocumentSnapshotsStreamHandler;
import io.flutter.plugins.firebase.firestore.streamhandler.LoadBundleStreamHandler;
import io.flutter.plugins.firebase.firestore.streamhandler.OnTransactionResultListener;
import io.flutter.plugins.firebase.firestore.streamhandler.QuerySnapshotsStreamHandler;
import io.flutter.plugins.firebase.firestore.streamhandler.SnapshotsInSyncStreamHandler;
import io.flutter.plugins.firebase.firestore.streamhandler.TransactionStreamHandler;
import io.flutter.plugins.firebase.firestore.utils.ExceptionConverter;
import io.flutter.plugins.firebase.firestore.utils.PigeonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

public class FlutterFirebaseFirestorePlugin
implements FlutterFirebasePlugin,
FlutterPlugin,
ActivityAware,
GeneratedAndroidFirebaseFirestore.FirebaseFirestoreHostApi {
    protected static final HashMap<FirebaseFirestore, FlutterFirebaseFirestoreExtension> firestoreInstanceCache = new HashMap();
    public static final String TAG = "FlutterFirestorePlugin";
    public static final String DEFAULT_ERROR_CODE = "firebase_firestore";
    private static final String METHOD_CHANNEL_NAME = "plugins.flutter.io/firebase_firestore";
    final StandardMethodCodec MESSAGE_CODEC = new StandardMethodCodec((StandardMessageCodec)FlutterFirebaseFirestoreMessageCodec.INSTANCE);
    private BinaryMessenger binaryMessenger;
    private final AtomicReference<Activity> activity = new AtomicReference<Object>(null);
    private final Map<String, Transaction> transactions = new HashMap<String, Transaction>();
    private final Map<String, EventChannel> eventChannels = new HashMap<String, EventChannel>();
    private final Map<String, EventChannel.StreamHandler> streamHandlers = new HashMap<String, EventChannel.StreamHandler>();
    private final Map<String, OnTransactionResultListener> transactionHandlers = new HashMap<String, OnTransactionResultListener>();
    public static final Map<Integer, DocumentSnapshot.ServerTimestampBehavior> serverTimestampBehaviorHashMap = new HashMap<Integer, DocumentSnapshot.ServerTimestampBehavior>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static FlutterFirebaseFirestoreExtension getCachedFirebaseFirestoreInstanceForKey(FirebaseFirestore firestore) {
        HashMap<FirebaseFirestore, FlutterFirebaseFirestoreExtension> hashMap = firestoreInstanceCache;
        synchronized (hashMap) {
            return firestoreInstanceCache.get(firestore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setCachedFirebaseFirestoreInstanceForKey(FirebaseFirestore firestore, String databaseURL) {
        HashMap<FirebaseFirestore, FlutterFirebaseFirestoreExtension> hashMap = firestoreInstanceCache;
        synchronized (hashMap) {
            FlutterFirebaseFirestoreExtension existingInstance = firestoreInstanceCache.get(firestore);
            if (existingInstance == null) {
                firestoreInstanceCache.put(firestore, new FlutterFirebaseFirestoreExtension(firestore, databaseURL));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static FirebaseFirestore getFirestoreInstanceByNameAndDatabaseUrl(String appName, String databaseURL) {
        HashMap<FirebaseFirestore, FlutterFirebaseFirestoreExtension> hashMap = firestoreInstanceCache;
        synchronized (hashMap) {
            for (Map.Entry<FirebaseFirestore, FlutterFirebaseFirestoreExtension> entry : firestoreInstanceCache.entrySet()) {
                if (!entry.getValue().getInstance().getApp().getName().equals(appName) || !entry.getValue().getDatabaseURL().equals(databaseURL)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroyCachedFirebaseFirestoreInstanceForKey(FirebaseFirestore firestore) {
        HashMap<FirebaseFirestore, FlutterFirebaseFirestoreExtension> hashMap = firestoreInstanceCache;
        synchronized (hashMap) {
            FlutterFirebaseFirestoreExtension existingInstance = firestoreInstanceCache.get(firestore);
            if (existingInstance != null) {
                firestoreInstanceCache.remove(firestore);
            }
        }
    }

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.initInstance(binding.getBinaryMessenger());
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.removeEventListeners();
        this.binaryMessenger = null;
    }

    public void onAttachedToActivity(@NonNull ActivityPluginBinding activityPluginBinding) {
        this.attachToActivity(activityPluginBinding);
    }

    public void onDetachedFromActivityForConfigChanges() {
        this.detachToActivity();
    }

    public void onReattachedToActivityForConfigChanges(@NonNull ActivityPluginBinding activityPluginBinding) {
        this.attachToActivity(activityPluginBinding);
    }

    public void onDetachedFromActivity() {
        this.detachToActivity();
    }

    private void attachToActivity(ActivityPluginBinding activityPluginBinding) {
        this.activity.set(activityPluginBinding.getActivity());
    }

    private void detachToActivity() {
        this.activity.set(null);
    }

    private void initInstance(BinaryMessenger messenger) {
        this.binaryMessenger = messenger;
        FlutterFirebasePluginRegistry.registerPlugin((String)METHOD_CHANNEL_NAME, (FlutterFirebasePlugin)this);
        GeneratedAndroidFirebaseFirestore.FirebaseFirestoreHostApi.setup(this.binaryMessenger, this);
    }

    public Task<Map<String, Object>> getPluginConstantsForFirebaseApp(FirebaseApp firebaseApp) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                taskCompletionSource.setResult(null);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    public Task<Void> didReinitializeFirebaseCore() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                HashMap<FirebaseFirestore, FlutterFirebaseFirestoreExtension> hashMap = firestoreInstanceCache;
                synchronized (hashMap) {
                    for (Map.Entry<FirebaseFirestore, FlutterFirebaseFirestoreExtension> entry : firestoreInstanceCache.entrySet()) {
                        FirebaseFirestore firestore = entry.getKey();
                        Tasks.await((Task)firestore.terminate());
                        FlutterFirebaseFirestorePlugin.destroyCachedFirebaseFirestoreInstanceForKey(firestore);
                    }
                }
                this.removeEventListeners();
                taskCompletionSource.setResult(null);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    private String registerEventChannel(String prefix, EventChannel.StreamHandler handler) {
        String identifier = UUID.randomUUID().toString().toLowerCase(Locale.US);
        return this.registerEventChannel(prefix, identifier, handler);
    }

    private String registerEventChannel(String prefix, String identifier, EventChannel.StreamHandler handler) {
        String channelName = prefix + "/" + identifier;
        EventChannel channel = new EventChannel(this.binaryMessenger, channelName, (MethodCodec)this.MESSAGE_CODEC);
        channel.setStreamHandler(handler);
        this.eventChannels.put(identifier, channel);
        this.streamHandlers.put(identifier, handler);
        return identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEventListeners() {
        Map<String, EventChannel> map = this.eventChannels;
        synchronized (map) {
            for (String identifier : this.eventChannels.keySet()) {
                Objects.requireNonNull(this.eventChannels.get(identifier)).setStreamHandler(null);
            }
            this.eventChannels.clear();
        }
        map = this.streamHandlers;
        synchronized (map) {
            for (String identifier : this.streamHandlers.keySet()) {
                Objects.requireNonNull(this.streamHandlers.get(identifier)).onCancel(null);
            }
            this.streamHandlers.clear();
        }
        this.transactionHandlers.clear();
    }

    static FirebaseFirestoreSettings getSettingsFromPigeon(GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp pigeonApp) {
        FirebaseFirestoreSettings.Builder builder = new FirebaseFirestoreSettings.Builder();
        if (pigeonApp.getSettings().getHost() != null) {
            builder.setHost(pigeonApp.getSettings().getHost());
        }
        if (pigeonApp.getSettings().getSslEnabled() != null) {
            builder.setSslEnabled(pigeonApp.getSettings().getSslEnabled().booleanValue());
        }
        if (pigeonApp.getSettings().getPersistenceEnabled() != null) {
            if (pigeonApp.getSettings().getPersistenceEnabled().booleanValue()) {
                Long receivedCacheSizeBytes = pigeonApp.getSettings().getCacheSizeBytes();
                long cacheSizeBytes = 0x6400000L;
                if (receivedCacheSizeBytes != null && receivedCacheSizeBytes != -1L) {
                    cacheSizeBytes = receivedCacheSizeBytes;
                }
                builder.setLocalCacheSettings((LocalCacheSettings)PersistentCacheSettings.newBuilder().setSizeBytes(cacheSizeBytes).build());
            } else {
                builder.setLocalCacheSettings((LocalCacheSettings)MemoryCacheSettings.newBuilder().build());
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseFirestore getFirestoreFromPigeon(GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp pigeonApp) {
        HashMap<FirebaseFirestore, FlutterFirebaseFirestoreExtension> hashMap = firestoreInstanceCache;
        synchronized (hashMap) {
            FirebaseFirestore cachedFirestoreInstance = FlutterFirebaseFirestorePlugin.getFirestoreInstanceByNameAndDatabaseUrl(pigeonApp.getAppName(), pigeonApp.getDatabaseURL());
            if (cachedFirestoreInstance != null) {
                return cachedFirestoreInstance;
            }
            FirebaseApp app = FirebaseApp.getInstance((String)pigeonApp.getAppName());
            FirebaseFirestore firestore = FirebaseFirestore.getInstance((FirebaseApp)app, (String)pigeonApp.getDatabaseURL());
            firestore.setFirestoreSettings(FlutterFirebaseFirestorePlugin.getSettingsFromPigeon(pigeonApp));
            FlutterFirebaseFirestorePlugin.setCachedFirebaseFirestoreInstanceForKey(firestore, pigeonApp.getDatabaseURL());
            return firestore;
        }
    }

    @Override
    public void loadBundle(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull byte[] bundle, @NonNull GeneratedAndroidFirebaseFirestore.Result<String> result) {
        result.success(this.registerEventChannel("plugins.flutter.io/firebase_firestore/loadBundle", new LoadBundleStreamHandler(FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app), bundle)));
    }

    @Override
    public void namedQueryGet(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull String name, @NonNull GeneratedAndroidFirebaseFirestore.PigeonGetOptions options, @NonNull GeneratedAndroidFirebaseFirestore.Result<GeneratedAndroidFirebaseFirestore.PigeonQuerySnapshot> result) {
        cachedThreadPool.execute(() -> {
            try {
                FirebaseFirestore firestore = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app);
                Query query = (Query)Tasks.await((Task)firestore.getNamedQuery(name));
                if (query == null) {
                    result.error(new NullPointerException("Named query has not been found. Please check it has been loaded properly via loadBundle()."));
                    return;
                }
                QuerySnapshot querySnapshot = (QuerySnapshot)Tasks.await((Task)query.get(PigeonParser.parsePigeonSource(options.getSource())));
                result.success(PigeonParser.toPigeonQuerySnapshot(querySnapshot, PigeonParser.parsePigeonServerTimestampBehavior(options.getServerTimestampBehavior())));
            }
            catch (Exception e) {
                ExceptionConverter.sendErrorToFlutter(result, e);
            }
        });
    }

    @Override
    public void clearPersistence(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseFirestore.Result<Void> result) {
        cachedThreadPool.execute(() -> {
            try {
                FirebaseFirestore firestore = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app);
                Tasks.await((Task)firestore.clearPersistence());
                result.success(null);
            }
            catch (Exception e) {
                ExceptionConverter.sendErrorToFlutter(result, e);
            }
        });
    }

    @Override
    public void disableNetwork(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseFirestore.Result<Void> result) {
        cachedThreadPool.execute(() -> {
            try {
                FirebaseFirestore firestore = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app);
                Tasks.await((Task)firestore.disableNetwork());
                result.success(null);
            }
            catch (Exception e) {
                ExceptionConverter.sendErrorToFlutter(result, e);
            }
        });
    }

    @Override
    public void enableNetwork(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseFirestore.Result<Void> result) {
        cachedThreadPool.execute(() -> {
            try {
                FirebaseFirestore firestore = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app);
                Tasks.await((Task)firestore.enableNetwork());
                result.success(null);
            }
            catch (Exception e) {
                ExceptionConverter.sendErrorToFlutter(result, e);
            }
        });
    }

    @Override
    public void terminate(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseFirestore.Result<Void> result) {
        cachedThreadPool.execute(() -> {
            try {
                FirebaseFirestore firestore = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app);
                Tasks.await((Task)firestore.terminate());
                FlutterFirebaseFirestorePlugin.destroyCachedFirebaseFirestoreInstanceForKey(firestore);
                result.success(null);
            }
            catch (Exception e) {
                ExceptionConverter.sendErrorToFlutter(result, e);
            }
        });
    }

    @Override
    public void waitForPendingWrites(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseFirestore.Result<Void> result) {
        cachedThreadPool.execute(() -> {
            try {
                FirebaseFirestore firestore = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app);
                Tasks.await((Task)firestore.waitForPendingWrites());
                result.success(null);
            }
            catch (Exception e) {
                ExceptionConverter.sendErrorToFlutter(result, e);
            }
        });
    }

    @Override
    public void setIndexConfiguration(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull String indexConfiguration, @NonNull GeneratedAndroidFirebaseFirestore.Result<Void> result) {
        cachedThreadPool.execute(() -> {
            try {
                FirebaseFirestore firestore = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app);
                Tasks.await((Task)firestore.setIndexConfiguration(indexConfiguration));
                result.success(null);
            }
            catch (Exception e) {
                ExceptionConverter.sendErrorToFlutter(result, e);
            }
        });
    }

    @Override
    public void persistenceCacheIndexManagerRequest(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseFirestore.PersistenceCacheIndexManagerRequest request, @NonNull GeneratedAndroidFirebaseFirestore.Result<Void> result) {
        cachedThreadPool.execute(() -> {
            PersistentCacheIndexManager indexManager = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app).getPersistentCacheIndexManager();
            if (indexManager != null) {
                switch (request) {
                    case ENABLE_INDEX_AUTO_CREATION: {
                        indexManager.enableIndexAutoCreation();
                        break;
                    }
                    case DISABLE_INDEX_AUTO_CREATION: {
                        indexManager.disableIndexAutoCreation();
                        break;
                    }
                    case DELETE_ALL_INDEXES: {
                        indexManager.deleteAllIndexes();
                    }
                }
            } else {
                Log.d((String)TAG, (String)"`PersistentCacheIndexManager` is not available.");
            }
            result.success(null);
        });
    }

    @Override
    public void setLoggingEnabled(@NonNull Boolean loggingEnabled, @NonNull GeneratedAndroidFirebaseFirestore.Result<Void> result) {
        cachedThreadPool.execute(() -> {
            try {
                FirebaseFirestore.setLoggingEnabled((boolean)loggingEnabled);
                result.success(null);
            }
            catch (Exception e) {
                ExceptionConverter.sendErrorToFlutter(result, e);
            }
        });
    }

    @Override
    public void snapshotsInSyncSetup(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseFirestore.Result<String> result) {
        FirebaseFirestore firestore = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app);
        result.success(this.registerEventChannel("plugins.flutter.io/firebase_firestore/snapshotsInSync", new SnapshotsInSyncStreamHandler(firestore)));
    }

    @Override
    public void transactionCreate(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull Long timeout, @NonNull Long maxAttempts, @NonNull GeneratedAndroidFirebaseFirestore.Result<String> result) {
        FirebaseFirestore firestore = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app);
        String transactionId = UUID.randomUUID().toString().toLowerCase(Locale.US);
        TransactionStreamHandler handler = new TransactionStreamHandler(transaction -> this.transactions.put(transactionId, transaction), firestore, transactionId, timeout, maxAttempts);
        this.registerEventChannel("plugins.flutter.io/firebase_firestore/transaction", transactionId, handler);
        this.transactionHandlers.put(transactionId, handler);
        result.success(transactionId);
    }

    @Override
    public void transactionStoreResult(@NonNull String transactionId, @NonNull GeneratedAndroidFirebaseFirestore.PigeonTransactionResult resultType, @Nullable List<GeneratedAndroidFirebaseFirestore.PigeonTransactionCommand> commands, @NonNull GeneratedAndroidFirebaseFirestore.Result<Void> result) {
        Objects.requireNonNull(this.transactionHandlers.get(transactionId)).receiveTransactionResponse(resultType, commands);
        result.success(null);
    }

    @Override
    public void transactionGet(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull String transactionId, @NonNull String path, @NonNull GeneratedAndroidFirebaseFirestore.Result<GeneratedAndroidFirebaseFirestore.PigeonDocumentSnapshot> result) {
        cachedThreadPool.execute(() -> {
            try {
                DocumentReference documentReference = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app).document(path);
                Transaction transaction = this.transactions.get(transactionId);
                if (transaction == null) {
                    result.error(new Exception("Transaction.getDocument(): No transaction handler exists for ID: " + transactionId));
                    return;
                }
                result.success(PigeonParser.toPigeonDocumentSnapshot(transaction.get(documentReference), DocumentSnapshot.ServerTimestampBehavior.NONE));
            }
            catch (Exception e) {
                ExceptionConverter.sendErrorToFlutter(result, e);
            }
        });
    }

    @Override
    public void documentReferenceSet(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseFirestore.DocumentReferenceRequest request, @NonNull GeneratedAndroidFirebaseFirestore.Result<Void> result) {
        cachedThreadPool.execute(() -> {
            try {
                Task setTask;
                DocumentReference documentReference = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app).document(request.getPath());
                Map<Object, Object> data = Objects.requireNonNull(request.getData());
                assert (request.getOption() != null);
                if (request.getOption().getMerge() != null && request.getOption().getMerge().booleanValue()) {
                    setTask = documentReference.set(data, SetOptions.merge());
                } else if (request.getOption().getMergeFields() != null) {
                    List<List<String>> fieldList = Objects.requireNonNull(request.getOption().getMergeFields());
                    List<FieldPath> fieldPathList = PigeonParser.parseFieldPath(fieldList);
                    setTask = documentReference.set(data, SetOptions.mergeFieldPaths(fieldPathList));
                } else {
                    setTask = documentReference.set(data);
                }
                result.success((Void)Tasks.await((Task)setTask));
            }
            catch (Exception e) {
                ExceptionConverter.sendErrorToFlutter(result, e);
            }
        });
    }

    @Override
    public void documentReferenceUpdate(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseFirestore.DocumentReferenceRequest request, @NonNull GeneratedAndroidFirebaseFirestore.Result<Void> result) {
        cachedThreadPool.execute(() -> {
            try {
                DocumentReference documentReference = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app).document(request.getPath());
                Map<Object, Object> dataWithString = Objects.requireNonNull(request.getData());
                HashMap<FieldPath, Object> data = new HashMap<FieldPath, Object>();
                for (Object key : dataWithString.keySet()) {
                    if (key instanceof String) {
                        data.put(FieldPath.of((String[])new String[]{(String)key}), dataWithString.get(key));
                        continue;
                    }
                    if (key instanceof FieldPath) {
                        data.put((FieldPath)key, dataWithString.get(key));
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid key type in update data. Supported types are String and FieldPath.");
                }
                FieldPath firstFieldPath = (FieldPath)data.keySet().iterator().next();
                Object firstObject = data.get(firstFieldPath);
                ArrayList<Object> flattenData = new ArrayList<Object>();
                for (FieldPath fieldPath : data.keySet()) {
                    if (fieldPath.equals((Object)firstFieldPath)) continue;
                    flattenData.add(fieldPath);
                    flattenData.add(data.get(fieldPath));
                }
                result.success((Void)Tasks.await((Task)documentReference.update(firstFieldPath, firstObject, flattenData.toArray())));
            }
            catch (Exception e) {
                ExceptionConverter.sendErrorToFlutter(result, e);
            }
        });
    }

    @Override
    public void documentReferenceGet(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseFirestore.DocumentReferenceRequest request, @NonNull GeneratedAndroidFirebaseFirestore.Result<GeneratedAndroidFirebaseFirestore.PigeonDocumentSnapshot> result) {
        cachedThreadPool.execute(() -> {
            try {
                assert (request.getSource() != null);
                Source source = PigeonParser.parsePigeonSource(request.getSource());
                DocumentReference documentReference = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app).document(request.getPath());
                DocumentSnapshot documentSnapshot = (DocumentSnapshot)Tasks.await((Task)documentReference.get(source));
                assert (request.getServerTimestampBehavior() != null);
                result.success(PigeonParser.toPigeonDocumentSnapshot(documentSnapshot, PigeonParser.parsePigeonServerTimestampBehavior(request.getServerTimestampBehavior())));
            }
            catch (Exception e) {
                ExceptionConverter.sendErrorToFlutter(result, e);
            }
        });
    }

    @Override
    public void documentReferenceDelete(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseFirestore.DocumentReferenceRequest request, @NonNull GeneratedAndroidFirebaseFirestore.Result<Void> result) {
        cachedThreadPool.execute(() -> {
            try {
                DocumentReference documentReference = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app).document(request.getPath());
                result.success((Void)Tasks.await((Task)documentReference.delete()));
            }
            catch (Exception e) {
                ExceptionConverter.sendErrorToFlutter(result, e);
            }
        });
    }

    @Override
    public void queryGet(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull String path, @NonNull Boolean isCollectionGroup, @NonNull GeneratedAndroidFirebaseFirestore.PigeonQueryParameters parameters, @NonNull GeneratedAndroidFirebaseFirestore.PigeonGetOptions options, @NonNull GeneratedAndroidFirebaseFirestore.Result<GeneratedAndroidFirebaseFirestore.PigeonQuerySnapshot> result) {
        cachedThreadPool.execute(() -> {
            try {
                Source source = PigeonParser.parsePigeonSource(options.getSource());
                Query query = PigeonParser.parseQuery(FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app), path, isCollectionGroup, parameters);
                if (query == null) {
                    result.error(new GeneratedAndroidFirebaseFirestore.FlutterError("invalid_query", "An error occurred while parsing query arguments, see native logs for more information. Please report this issue.", null));
                    return;
                }
                QuerySnapshot querySnapshot = (QuerySnapshot)Tasks.await((Task)query.get(source));
                result.success(PigeonParser.toPigeonQuerySnapshot(querySnapshot, PigeonParser.parsePigeonServerTimestampBehavior(options.getServerTimestampBehavior())));
            }
            catch (Exception e) {
                ExceptionConverter.sendErrorToFlutter(result, e);
            }
        });
    }

    @Override
    public void aggregateQuery(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull String path, @NonNull GeneratedAndroidFirebaseFirestore.PigeonQueryParameters parameters, @NonNull GeneratedAndroidFirebaseFirestore.AggregateSource source, @NonNull List<GeneratedAndroidFirebaseFirestore.AggregateQuery> queries, @NonNull Boolean isCollectionGroup, @NonNull GeneratedAndroidFirebaseFirestore.Result<List<GeneratedAndroidFirebaseFirestore.AggregateQueryResponse>> result) {
        Query query = PigeonParser.parseQuery(FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app), path, isCollectionGroup, parameters);
        ArrayList<Object> aggregateFields = new ArrayList<Object>();
        for (GeneratedAndroidFirebaseFirestore.AggregateQuery queryRequest : queries) {
            switch (queryRequest.getType()) {
                case COUNT: {
                    aggregateFields.add(AggregateField.count());
                    break;
                }
                case SUM: {
                    assert (queryRequest.getField() != null);
                    aggregateFields.add(AggregateField.sum((String)queryRequest.getField()));
                    break;
                }
                case AVERAGE: {
                    assert (queryRequest.getField() != null);
                    aggregateFields.add(AggregateField.average((String)queryRequest.getField()));
                }
            }
        }
        assert (query != null);
        AggregateQuery aggregateQuery = query.aggregate((AggregateField)aggregateFields.get(0), aggregateFields.subList(1, aggregateFields.size()).toArray(new AggregateField[0]));
        cachedThreadPool.execute(() -> {
            try {
                AggregateQuerySnapshot aggregateQuerySnapshot = (AggregateQuerySnapshot)Tasks.await((Task)aggregateQuery.get(PigeonParser.parseAggregateSource(source)));
                ArrayList<GeneratedAndroidFirebaseFirestore.AggregateQueryResponse> aggregateResponse = new ArrayList<GeneratedAndroidFirebaseFirestore.AggregateQueryResponse>();
                for (GeneratedAndroidFirebaseFirestore.AggregateQuery queryRequest : queries) {
                    switch (queryRequest.getType()) {
                        case COUNT: {
                            GeneratedAndroidFirebaseFirestore.AggregateQueryResponse.Builder builder = new GeneratedAndroidFirebaseFirestore.AggregateQueryResponse.Builder();
                            builder.setType(GeneratedAndroidFirebaseFirestore.AggregateType.COUNT);
                            builder.setValue(Double.valueOf(aggregateQuerySnapshot.getCount()));
                            aggregateResponse.add(builder.build());
                            break;
                        }
                        case SUM: {
                            assert (queryRequest.getField() != null);
                            GeneratedAndroidFirebaseFirestore.AggregateQueryResponse.Builder builderSum = new GeneratedAndroidFirebaseFirestore.AggregateQueryResponse.Builder();
                            builderSum.setType(GeneratedAndroidFirebaseFirestore.AggregateType.SUM);
                            builderSum.setValue(((Number)Objects.requireNonNull(aggregateQuerySnapshot.get((AggregateField)AggregateField.sum((String)queryRequest.getField())))).doubleValue());
                            builderSum.setField(queryRequest.getField());
                            aggregateResponse.add(builderSum.build());
                            break;
                        }
                        case AVERAGE: {
                            assert (queryRequest.getField() != null);
                            GeneratedAndroidFirebaseFirestore.AggregateQueryResponse.Builder builderAverage = new GeneratedAndroidFirebaseFirestore.AggregateQueryResponse.Builder();
                            builderAverage.setType(GeneratedAndroidFirebaseFirestore.AggregateType.AVERAGE);
                            builderAverage.setValue(aggregateQuerySnapshot.get(AggregateField.average((String)queryRequest.getField())));
                            builderAverage.setField(queryRequest.getField());
                            aggregateResponse.add(builderAverage.build());
                        }
                    }
                }
                result.success(aggregateResponse);
            }
            catch (Exception e) {
                ExceptionConverter.sendErrorToFlutter(result, e);
            }
        });
    }

    @Override
    public void writeBatchCommit(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull List<GeneratedAndroidFirebaseFirestore.PigeonTransactionCommand> writes, @NonNull GeneratedAndroidFirebaseFirestore.Result<Void> result) {
        cachedThreadPool.execute(() -> {
            try {
                FirebaseFirestore firestore = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app);
                WriteBatch batch = firestore.batch();
                for (GeneratedAndroidFirebaseFirestore.PigeonTransactionCommand write : writes) {
                    GeneratedAndroidFirebaseFirestore.PigeonTransactionType type = Objects.requireNonNull(write.getType());
                    String path = Objects.requireNonNull(write.getPath());
                    Map<String, Object> data = write.getData();
                    DocumentReference documentReference = firestore.document(path);
                    switch (type) {
                        case DELETE_TYPE: {
                            batch = batch.delete(documentReference);
                            break;
                        }
                        case UPDATE: {
                            batch = batch.update(documentReference, Objects.requireNonNull(data));
                            break;
                        }
                        case SET: {
                            GeneratedAndroidFirebaseFirestore.PigeonDocumentOption options = Objects.requireNonNull(write.getOption());
                            if (options.getMerge() != null && options.getMerge().booleanValue()) {
                                batch = batch.set(documentReference, Objects.requireNonNull(data), SetOptions.merge());
                                break;
                            }
                            if (options.getMergeFields() != null) {
                                List<FieldPath> fieldPathList = PigeonParser.parseFieldPath(Objects.requireNonNull(options.getMergeFields()));
                                batch = batch.set(documentReference, Objects.requireNonNull(data), SetOptions.mergeFieldPaths(fieldPathList));
                                break;
                            }
                            batch = batch.set(documentReference, Objects.requireNonNull(data));
                        }
                    }
                }
                Tasks.await((Task)batch.commit());
                result.success(null);
            }
            catch (Exception e) {
                ExceptionConverter.sendErrorToFlutter(result, e);
            }
        });
    }

    @Override
    public void querySnapshot(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull String path, @NonNull Boolean isCollectionGroup, @NonNull GeneratedAndroidFirebaseFirestore.PigeonQueryParameters parameters, @NonNull GeneratedAndroidFirebaseFirestore.PigeonGetOptions options, @NonNull Boolean includeMetadataChanges, @NonNull GeneratedAndroidFirebaseFirestore.ListenSource source, @NonNull GeneratedAndroidFirebaseFirestore.Result<String> result) {
        Query query = PigeonParser.parseQuery(FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app), path, isCollectionGroup, parameters);
        if (query == null) {
            result.error(new GeneratedAndroidFirebaseFirestore.FlutterError("invalid_query", "An error occurred while parsing query arguments, see native logs for more information. Please report this issue.", null));
            return;
        }
        result.success(this.registerEventChannel("plugins.flutter.io/firebase_firestore/query", new QuerySnapshotsStreamHandler(query, includeMetadataChanges, PigeonParser.parsePigeonServerTimestampBehavior(options.getServerTimestampBehavior()), PigeonParser.parseListenSource(source))));
    }

    @Override
    public void documentReferenceSnapshot(@NonNull GeneratedAndroidFirebaseFirestore.FirestorePigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseFirestore.DocumentReferenceRequest parameters, @NonNull Boolean includeMetadataChanges, @NonNull GeneratedAndroidFirebaseFirestore.ListenSource source, @NonNull GeneratedAndroidFirebaseFirestore.Result<String> result) {
        FirebaseFirestore firestore = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app);
        DocumentReference documentReference = FlutterFirebaseFirestorePlugin.getFirestoreFromPigeon(app).document(parameters.getPath());
        result.success(this.registerEventChannel("plugins.flutter.io/firebase_firestore/document", new DocumentSnapshotsStreamHandler(firestore, documentReference, includeMetadataChanges, PigeonParser.parsePigeonServerTimestampBehavior(parameters.getServerTimestampBehavior()), PigeonParser.parseListenSource(source))));
    }
}

