/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.firestore.streamhandler;

import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.ListenSource;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.MetadataChanges;
import com.google.firebase.firestore.SnapshotListenOptions;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugins.firebase.firestore.utils.ExceptionConverter;
import io.flutter.plugins.firebase.firestore.utils.PigeonParser;
import java.util.Map;

public class DocumentSnapshotsStreamHandler
implements EventChannel.StreamHandler {
    ListenerRegistration listenerRegistration;
    FirebaseFirestore firestore;
    DocumentReference documentReference;
    MetadataChanges metadataChanges;
    DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior;
    ListenSource source;

    public DocumentSnapshotsStreamHandler(FirebaseFirestore firestore, DocumentReference documentReference, Boolean includeMetadataChanges, DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior, ListenSource source) {
        this.firestore = firestore;
        this.documentReference = documentReference;
        this.metadataChanges = includeMetadataChanges != false ? MetadataChanges.INCLUDE : MetadataChanges.EXCLUDE;
        this.serverTimestampBehavior = serverTimestampBehavior;
        this.source = source;
    }

    public void onListen(Object arguments, EventChannel.EventSink events) {
        SnapshotListenOptions.Builder optionsBuilder = new SnapshotListenOptions.Builder();
        optionsBuilder.setMetadataChanges(this.metadataChanges);
        optionsBuilder.setSource(this.source);
        this.listenerRegistration = this.documentReference.addSnapshotListener(optionsBuilder.build(), (documentSnapshot, exception) -> {
            if (exception != null) {
                Map<String, String> exceptionDetails = ExceptionConverter.createDetails((Exception)exception);
                events.error("firebase_firestore", exception.getMessage(), exceptionDetails);
                events.endOfStream();
                this.onCancel(null);
            } else {
                events.success(PigeonParser.toPigeonDocumentSnapshot(documentSnapshot, this.serverTimestampBehavior).toList());
            }
        });
    }

    public void onCancel(Object arguments) {
        if (this.listenerRegistration != null) {
            this.listenerRegistration.remove();
            this.listenerRegistration = null;
        }
    }
}

