/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.firestore.utils;

import android.util.Log;
import com.google.firebase.firestore.FirebaseFirestoreException;
import io.flutter.plugins.firebase.firestore.FlutterFirebaseFirestoreException;
import io.flutter.plugins.firebase.firestore.GeneratedAndroidFirebaseFirestore;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ExceptionConverter {
    public static Map<String, String> createDetails(Exception exception) {
        HashMap<String, String> details = new HashMap<String, String>();
        if (exception == null) {
            return details;
        }
        FlutterFirebaseFirestoreException firestoreException = null;
        if (exception instanceof FirebaseFirestoreException) {
            firestoreException = new FlutterFirebaseFirestoreException((FirebaseFirestoreException)exception, exception.getCause());
        } else if (exception.getCause() != null && exception.getCause() instanceof FirebaseFirestoreException) {
            firestoreException = new FlutterFirebaseFirestoreException((FirebaseFirestoreException)exception.getCause(), exception.getCause().getCause() != null ? exception.getCause().getCause() : exception.getCause());
        }
        if (firestoreException != null) {
            details.put("code", firestoreException.getCode());
            details.put("message", firestoreException.getMessage());
        }
        if (details.containsKey("code") && Objects.requireNonNull((String)details.get("code")).equals("unknown")) {
            Log.e((String)"FLTFirebaseFirestore", (String)"An unknown error occurred", (Throwable)exception);
        }
        return details;
    }

    public static void sendErrorToFlutter(GeneratedAndroidFirebaseFirestore.Result result, Exception exception) {
        Map<String, String> exceptionDetails = ExceptionConverter.createDetails(exception);
        result.error(new GeneratedAndroidFirebaseFirestore.FlutterError("firebase_firestore", exception != null ? exception.getMessage() : null, exceptionDetails));
    }
}

