/*
 * Decompiled with CFR 0.152.
 */
package com.mr.flutter.plugin.filepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.mr.flutter.plugin.filepicker.FileInfo;
import com.mr.flutter.plugin.filepicker.FilePickerPlugin;
import com.mr.flutter.plugin.filepicker.FileUtils;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;

public class FilePickerDelegate
implements PluginRegistry.ActivityResultListener {
    private static final String TAG = "FilePickerDelegate";
    private static final int REQUEST_CODE = FilePickerPlugin.class.hashCode() + 43 & 0xFFFF;
    private static final int SAVE_FILE_CODE = FilePickerPlugin.class.hashCode() + 83 & 0xFFFF;
    private final Activity activity;
    private MethodChannel.Result pendingResult;
    private boolean isMultipleSelection = false;
    private boolean loadDataToMemory = false;
    private String type;
    private boolean allowCompression = true;
    private int compressionQuality = 20;
    private String[] allowedExtensions;
    private EventChannel.EventSink eventSink;
    private byte[] bytes;

    public FilePickerDelegate(Activity activity) {
        this(activity, null);
    }

    public void setEventHandler(EventChannel.EventSink eventSink) {
        this.eventSink = eventSink;
    }

    @VisibleForTesting
    FilePickerDelegate(Activity activity, MethodChannel.Result result) {
        this.activity = activity;
        this.pendingResult = result;
    }

    public boolean onActivityResult(int requestCode, int resultCode, final Intent data) {
        if (requestCode == SAVE_FILE_CODE) {
            if (resultCode == -1) {
                if (data == null) {
                    return false;
                }
                this.dispatchEventStatus(true);
                Uri uri = data.getData();
                if (uri != null) {
                    String path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath() + File.separator + FileUtils.getFileName(uri, (Context)this.activity);
                    try {
                        OutputStream outputStream = this.activity.getContentResolver().openOutputStream(uri);
                        if (outputStream != null) {
                            outputStream.write(this.bytes);
                            outputStream.flush();
                            outputStream.close();
                        }
                        this.finishWithSuccess(path);
                        return true;
                    }
                    catch (IOException e) {
                        Log.i((String)TAG, (String)"Error while saving file", (Throwable)e);
                        this.finishWithError("Error while saving file", e.getMessage());
                    }
                }
            }
            if (resultCode == 0) {
                Log.i((String)TAG, (String)"User cancelled the save request");
                this.finishWithSuccess(null);
            }
            return false;
        }
        if (this.type == null) {
            return false;
        }
        if (requestCode == REQUEST_CODE && resultCode == -1) {
            this.dispatchEventStatus(true);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (data != null) {
                        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
                        if (data.getClipData() != null) {
                            int count = data.getClipData().getItemCount();
                            for (int currentItem = 0; currentItem < count; ++currentItem) {
                                FileInfo file;
                                Uri currentUri = data.getClipData().getItemAt(currentItem).getUri();
                                if (Objects.equals(FilePickerDelegate.this.type, "image/*") && FilePickerDelegate.this.allowCompression && FilePickerDelegate.this.compressionQuality > 0) {
                                    currentUri = FileUtils.compressImage(currentUri, FilePickerDelegate.this.compressionQuality, FilePickerDelegate.this.activity.getApplicationContext());
                                }
                                if ((file = FileUtils.openFileStream((Context)FilePickerDelegate.this.activity, currentUri, FilePickerDelegate.this.loadDataToMemory)) == null) continue;
                                files.add(file);
                                Log.d((String)FilePickerDelegate.TAG, (String)("[MultiFilePick] File #" + currentItem + " - URI: " + currentUri.getPath()));
                            }
                            FilePickerDelegate.this.finishWithSuccess(files);
                        } else if (data.getData() != null) {
                            Uri uri = data.getData();
                            if (Objects.equals(FilePickerDelegate.this.type, "image/*") && FilePickerDelegate.this.allowCompression && FilePickerDelegate.this.compressionQuality > 0) {
                                uri = FileUtils.compressImage(uri, FilePickerDelegate.this.compressionQuality, FilePickerDelegate.this.activity.getApplicationContext());
                            }
                            if (FilePickerDelegate.this.type.equals("dir") && Build.VERSION.SDK_INT >= 21) {
                                uri = DocumentsContract.buildDocumentUriUsingTree((Uri)uri, (String)DocumentsContract.getTreeDocumentId((Uri)uri));
                                Log.d((String)FilePickerDelegate.TAG, (String)("[SingleFilePick] File URI:" + uri.toString()));
                                String dirPath = FileUtils.getFullPathFromTreeUri(uri, (Context)FilePickerDelegate.this.activity);
                                if (dirPath != null) {
                                    FilePickerDelegate.this.finishWithSuccess(dirPath);
                                } else {
                                    FilePickerDelegate.this.finishWithError("unknown_path", "Failed to retrieve directory path.");
                                }
                                return;
                            }
                            FileInfo file = FileUtils.openFileStream((Context)FilePickerDelegate.this.activity, uri, FilePickerDelegate.this.loadDataToMemory);
                            if (file != null) {
                                files.add(file);
                            }
                            if (!files.isEmpty()) {
                                Log.d((String)FilePickerDelegate.TAG, (String)("File path:" + files.toString()));
                                FilePickerDelegate.this.finishWithSuccess(files);
                            } else {
                                FilePickerDelegate.this.finishWithError("unknown_path", "Failed to retrieve path.");
                            }
                        } else if (data.getExtras() != null) {
                            Bundle bundle = data.getExtras();
                            if (bundle.keySet().contains("selectedItems")) {
                                ArrayList fileUris = FilePickerDelegate.this.getSelectedItems(bundle);
                                int currentItem = 0;
                                if (fileUris != null) {
                                    for (Parcelable fileUri : fileUris) {
                                        if (fileUri instanceof Uri) {
                                            Uri currentUri = (Uri)fileUri;
                                            FileInfo file = FileUtils.openFileStream((Context)FilePickerDelegate.this.activity, currentUri, FilePickerDelegate.this.loadDataToMemory);
                                            if (file != null) {
                                                files.add(file);
                                                Log.d((String)FilePickerDelegate.TAG, (String)("[MultiFilePick] File #" + currentItem + " - URI: " + currentUri.getPath()));
                                            }
                                        }
                                        ++currentItem;
                                    }
                                }
                                FilePickerDelegate.this.finishWithSuccess(files);
                            } else {
                                FilePickerDelegate.this.finishWithError("unknown_path", "Failed to retrieve path from bundle.");
                            }
                        } else {
                            FilePickerDelegate.this.finishWithError("unknown_activity", "Unknown activity error, please fill an issue.");
                        }
                    } else {
                        FilePickerDelegate.this.finishWithError("unknown_activity", "Unknown activity error, please fill an issue.");
                    }
                }
            }).start();
            return true;
        }
        if (requestCode == REQUEST_CODE && resultCode == 0) {
            Log.i((String)TAG, (String)"User cancelled the picker request");
            this.finishWithSuccess(null);
            return true;
        }
        if (requestCode == REQUEST_CODE) {
            this.finishWithError("unknown_activity", "Unknown activity error, please fill an issue.");
        }
        return false;
    }

    private boolean setPendingMethodCallAndResult(MethodChannel.Result result) {
        if (this.pendingResult != null) {
            return false;
        }
        this.pendingResult = result;
        return true;
    }

    private static void finishWithAlreadyActiveError(MethodChannel.Result result) {
        result.error("already_active", "File picker is already active", null);
    }

    private ArrayList<Parcelable> getSelectedItems(Bundle bundle) {
        if (Build.VERSION.SDK_INT >= 33) {
            return bundle.getParcelableArrayList("selectedItems", Parcelable.class);
        }
        return bundle.getParcelableArrayList("selectedItems");
    }

    private void startFileExplorer() {
        Intent intent;
        if (this.type == null) {
            return;
        }
        if (this.type.equals("dir")) {
            intent = new Intent("android.intent.action.OPEN_DOCUMENT_TREE");
        } else {
            if (this.type.equals("image/*")) {
                intent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            } else {
                intent = Build.VERSION.SDK_INT >= 19 ? new Intent("android.intent.action.OPEN_DOCUMENT") : new Intent("android.intent.action.GET_CONTENT");
                intent.addCategory("android.intent.category.OPENABLE");
            }
            Uri uri = Uri.parse((String)(Environment.getExternalStorageDirectory().getPath() + File.separator));
            Log.d((String)TAG, (String)("Selected type " + this.type));
            intent.setDataAndType(uri, this.type);
            intent.setType(this.type);
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", this.isMultipleSelection);
            intent.putExtra("multi-pick", this.isMultipleSelection);
            if (this.type.contains(",")) {
                this.allowedExtensions = this.type.split(",");
            }
            if (this.allowedExtensions != null) {
                intent.putExtra("android.intent.extra.MIME_TYPES", this.allowedExtensions);
            }
        }
        if (intent.resolveActivity(this.activity.getPackageManager()) != null) {
            this.activity.startActivityForResult(intent, REQUEST_CODE);
        } else {
            Log.e((String)TAG, (String)"Can't find a valid activity to handle the request. Make sure you've a file explorer installed.");
            this.finishWithError("invalid_format_type", "Can't handle the provided file type.");
        }
    }

    public void startFileExplorer(String type, boolean isMultipleSelection, boolean withData, String[] allowedExtensions, boolean allowCompression, int compressionQuality, MethodChannel.Result result) {
        if (!this.setPendingMethodCallAndResult(result)) {
            FilePickerDelegate.finishWithAlreadyActiveError(result);
            return;
        }
        this.type = type;
        this.isMultipleSelection = isMultipleSelection;
        this.loadDataToMemory = withData;
        this.allowedExtensions = allowedExtensions;
        this.compressionQuality = compressionQuality;
        this.allowCompression = allowCompression;
        this.startFileExplorer();
    }

    @RequiresApi(api=19)
    public void saveFile(String fileName, String type, String initialDirectory, String[] allowedExtensions, byte[] bytes, MethodChannel.Result result) {
        if (!this.setPendingMethodCallAndResult(result)) {
            FilePickerDelegate.finishWithAlreadyActiveError(result);
            return;
        }
        Intent intent = new Intent("android.intent.action.CREATE_DOCUMENT");
        intent.addCategory("android.intent.category.OPENABLE");
        if (fileName != null && !fileName.isEmpty()) {
            intent.putExtra("android.intent.extra.TITLE", fileName);
        }
        this.bytes = bytes;
        if (type != null && !"dir".equals(type) && type.split(",").length == 1) {
            intent.setType(type);
        } else {
            intent.setType("*/*");
        }
        if (initialDirectory != null && !initialDirectory.isEmpty() && Build.VERSION.SDK_INT >= 26) {
            intent.putExtra("android.provider.extra.INITIAL_URI", (Parcelable)Uri.parse((String)initialDirectory));
        }
        if (allowedExtensions != null && allowedExtensions.length > 0) {
            intent.putExtra("android.intent.extra.MIME_TYPES", allowedExtensions);
        }
        if (intent.resolveActivity(this.activity.getPackageManager()) != null) {
            this.activity.startActivityForResult(intent, SAVE_FILE_CODE);
        } else {
            Log.e((String)TAG, (String)"Can't find a valid activity to handle the request. Make sure you've a file explorer installed.");
            this.finishWithError("invalid_format_type", "Can't handle the provided file type.");
        }
    }

    private void finishWithSuccess(Object data) {
        this.dispatchEventStatus(false);
        if (this.pendingResult != null) {
            if (data != null && !(data instanceof String)) {
                ArrayList<HashMap<String, Object>> files = new ArrayList<HashMap<String, Object>>();
                for (FileInfo file : (ArrayList)data) {
                    files.add(file.toMap());
                }
                data = files;
            }
            this.pendingResult.success((Object)data);
            this.clearPendingResult();
        }
    }

    private void finishWithError(String errorCode, String errorMessage) {
        if (this.pendingResult == null) {
            return;
        }
        this.dispatchEventStatus(false);
        this.pendingResult.error(errorCode, errorMessage, null);
        this.clearPendingResult();
    }

    private void dispatchEventStatus(final boolean status) {
        if (this.eventSink == null || this.type.equals("dir")) {
            return;
        }
        new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                FilePickerDelegate.this.eventSink.success((Object)status);
            }
        }.obtainMessage().sendToTarget();
    }

    private void clearPendingResult() {
        this.pendingResult = null;
    }
}

