/*
 * Decompiled with CFR 0.152.
 */
package com.mr.flutter.plugin.filepicker;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.mr.flutter.plugin.filepicker.FilePickerDelegate;
import com.mr.flutter.plugin.filepicker.FileUtils;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.embedding.engine.plugins.lifecycle.FlutterLifecycleAdapter;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import java.util.ArrayList;
import java.util.HashMap;

public class FilePickerPlugin
implements MethodChannel.MethodCallHandler,
FlutterPlugin,
ActivityAware {
    private static final String TAG = "FilePicker";
    private static final String CHANNEL = "miguelruivo.flutter.plugins.filepicker";
    private static final String EVENT_CHANNEL = "miguelruivo.flutter.plugins.filepickerevent";
    private ActivityPluginBinding activityBinding;
    private FilePickerDelegate delegate;
    private Application application;
    private FlutterPlugin.FlutterPluginBinding pluginBinding;
    private Lifecycle lifecycle;
    private LifeCycleObserver observer;
    private Activity activity;
    private MethodChannel channel;
    private static String fileType;
    private static boolean isMultipleSelection;
    private static boolean withData;
    private static int compressionQuality;
    private static boolean allowCompression;

    public void onMethodCall(MethodCall call, MethodChannel.Result rawResult) {
        if (this.activity == null) {
            rawResult.error("no_activity", "file picker plugin requires a foreground activity", null);
            return;
        }
        MethodResultWrapper result = new MethodResultWrapper(rawResult);
        HashMap arguments = (HashMap)call.arguments;
        if (call.method != null && call.method.equals("clear")) {
            result.success(FileUtils.clearCache(this.activity.getApplicationContext()));
            return;
        }
        if (call.method != null && call.method.equals("save")) {
            String fileName = (String)arguments.get("fileName");
            String type = FilePickerPlugin.resolveType((String)arguments.get("fileType"));
            String initialDirectory = (String)arguments.get("initialDirectory");
            String[] allowedExtensions = FileUtils.getMimeTypes((ArrayList)arguments.get("allowedExtensions"));
            byte[] bytes = (byte[])arguments.get("bytes");
            this.delegate.saveFile(fileName, type, initialDirectory, allowedExtensions, bytes, result);
            return;
        }
        fileType = FilePickerPlugin.resolveType(call.method);
        String[] allowedExtensions = null;
        if (fileType == null) {
            result.notImplemented();
        } else if (fileType != "dir") {
            isMultipleSelection = (Boolean)arguments.get("allowMultipleSelection");
            withData = (Boolean)arguments.get("withData");
            allowCompression = (Boolean)arguments.get("allowCompression");
            compressionQuality = (Integer)arguments.get("compressionQuality");
            allowedExtensions = FileUtils.getMimeTypes((ArrayList)arguments.get("allowedExtensions"));
        }
        if (call.method != null && call.method.equals("custom") && (allowedExtensions == null || allowedExtensions.length == 0)) {
            result.error(TAG, "Unsupported filter. Make sure that you are only using the extension without the dot, (ie., jpg instead of .jpg). This could also have happened because you are using an unsupported file extension.  If the problem persists, you may want to consider using FileType.any instead.", null);
        } else {
            this.delegate.startFileExplorer(fileType, isMultipleSelection, withData, allowedExtensions, allowCompression, compressionQuality, result);
        }
    }

    private static String resolveType(String type) {
        switch (type) {
            case "audio": {
                return "audio/*";
            }
            case "image": {
                return "image/*";
            }
            case "video": {
                return "video/*";
            }
            case "media": {
                return "image/*,video/*";
            }
            case "any": 
            case "custom": {
                return "*/*";
            }
            case "dir": {
                return "dir";
            }
        }
        return null;
    }

    private void setup(BinaryMessenger messenger, Application application, Activity activity, ActivityPluginBinding activityBinding) {
        this.activity = activity;
        this.application = application;
        this.delegate = new FilePickerDelegate(activity);
        this.channel = new MethodChannel(messenger, CHANNEL);
        this.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
        new EventChannel(messenger, EVENT_CHANNEL).setStreamHandler(new EventChannel.StreamHandler(){

            public void onListen(Object arguments, EventChannel.EventSink events) {
                FilePickerPlugin.this.delegate.setEventHandler(events);
            }

            public void onCancel(Object arguments) {
                FilePickerPlugin.this.delegate.setEventHandler(null);
            }
        });
        this.observer = new LifeCycleObserver(activity);
        activityBinding.addActivityResultListener((PluginRegistry.ActivityResultListener)this.delegate);
        this.lifecycle = FlutterLifecycleAdapter.getActivityLifecycle((ActivityPluginBinding)activityBinding);
        this.lifecycle.addObserver((LifecycleObserver)this.observer);
    }

    private void tearDown() {
        this.activityBinding.removeActivityResultListener((PluginRegistry.ActivityResultListener)this.delegate);
        this.activityBinding = null;
        if (this.observer != null) {
            this.lifecycle.removeObserver((LifecycleObserver)this.observer);
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.observer);
        }
        this.lifecycle = null;
        this.delegate.setEventHandler(null);
        this.delegate = null;
        this.channel.setMethodCallHandler(null);
        this.channel = null;
        this.application = null;
    }

    public void onAttachedToEngine(FlutterPlugin.FlutterPluginBinding binding) {
        this.pluginBinding = binding;
    }

    public void onDetachedFromEngine(FlutterPlugin.FlutterPluginBinding binding) {
        this.pluginBinding = null;
    }

    public void onAttachedToActivity(ActivityPluginBinding binding) {
        this.activityBinding = binding;
        this.setup(this.pluginBinding.getBinaryMessenger(), (Application)this.pluginBinding.getApplicationContext(), this.activityBinding.getActivity(), this.activityBinding);
    }

    public void onDetachedFromActivityForConfigChanges() {
        this.onDetachedFromActivity();
    }

    public void onReattachedToActivityForConfigChanges(ActivityPluginBinding binding) {
        this.onAttachedToActivity(binding);
    }

    public void onDetachedFromActivity() {
        this.tearDown();
    }

    static {
        isMultipleSelection = false;
        withData = false;
    }

    private static class MethodResultWrapper
    implements MethodChannel.Result {
        private final MethodChannel.Result methodResult;
        private final Handler handler;

        MethodResultWrapper(MethodChannel.Result result) {
            this.methodResult = result;
            this.handler = new Handler(Looper.getMainLooper());
        }

        public void success(final Object result) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    methodResult.success(result);
                }
            });
        }

        public void error(final String errorCode, final String errorMessage, final Object errorDetails) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    methodResult.error(errorCode, errorMessage, errorDetails);
                }
            });
        }

        public void notImplemented() {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    methodResult.notImplemented();
                }
            });
        }
    }

    private class LifeCycleObserver
    implements Application.ActivityLifecycleCallbacks,
    DefaultLifecycleObserver {
        private final Activity thisActivity;

        LifeCycleObserver(Activity activity) {
            this.thisActivity = activity;
        }

        public void onCreate(@NonNull LifecycleOwner owner) {
        }

        public void onStart(@NonNull LifecycleOwner owner) {
        }

        public void onResume(@NonNull LifecycleOwner owner) {
        }

        public void onPause(@NonNull LifecycleOwner owner) {
        }

        public void onStop(@NonNull LifecycleOwner owner) {
            this.onActivityStopped(this.thisActivity);
        }

        public void onDestroy(@NonNull LifecycleOwner owner) {
            this.onActivityDestroyed(this.thisActivity);
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
            if (this.thisActivity == activity && activity.getApplicationContext() != null) {
                ((Application)activity.getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            }
        }

        public void onActivityStopped(Activity activity) {
        }
    }
}

