/*
 * Decompiled with CFR 0.152.
 */
package com.mr.flutter.plugin.filepicker;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.storage.StorageManager;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.util.Log;
import android.webkit.MimeTypeMap;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.mr.flutter.plugin.filepicker.FileInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class FileUtils {
    private static final String TAG = "FilePickerUtils";
    private static final String PRIMARY_VOLUME_NAME = "primary";

    public static String[] getMimeTypes(ArrayList<String> allowedExtensions) {
        if (allowedExtensions == null || allowedExtensions.isEmpty()) {
            return null;
        }
        ArrayList<String> mimes = new ArrayList<String>();
        for (int i = 0; i < allowedExtensions.size(); ++i) {
            String mime = MimeTypeMap.getSingleton().getMimeTypeFromExtension(allowedExtensions.get(i));
            if (mime == null) {
                Log.w((String)TAG, (String)("Custom file type " + allowedExtensions.get(i) + " is unsupported and will be ignored."));
                continue;
            }
            mimes.add(mime);
        }
        Log.d((String)TAG, (String)("Allowed file extensions mimes: " + mimes));
        return mimes.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileName(Uri uri, Context context) {
        String result = null;
        try {
            int cut;
            if (uri.getScheme().equals("content")) {
                try (Cursor cursor = context.getContentResolver().query(uri, new String[]{"_display_name"}, null, null, null);){
                    if (cursor != null && cursor.moveToFirst()) {
                        result = cursor.getString(cursor.getColumnIndexOrThrow("_display_name"));
                    }
                }
            }
            if (result == null && (cut = (result = uri.getPath()).lastIndexOf(47)) != -1) {
                result = result.substring(cut + 1);
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("Failed to handle file name: " + ex.toString()));
        }
        return result;
    }

    public static Uri compressImage(Uri originalImageUri, int compressionQuality, Context context) {
        Uri compressedUri;
        try (InputStream imageStream = context.getContentResolver().openInputStream(originalImageUri);){
            File compressedFile = FileUtils.createImageFile();
            Bitmap originalBitmap = BitmapFactory.decodeStream((InputStream)imageStream);
            FileOutputStream fos = new FileOutputStream(compressedFile);
            originalBitmap.compress(Bitmap.CompressFormat.JPEG, compressionQuality, (OutputStream)fos);
            fos.flush();
            fos.close();
            compressedUri = Uri.fromFile((File)compressedFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return compressedUri;
    }

    private static File createImageFile() throws IOException {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        return File.createTempFile(imageFileName, ".jpg", storageDir);
    }

    public static String getRealPathFromURI(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if (PRIMARY_VOLUME_NAME.equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (FileUtils.isDownloadsDocument(uri)) {
                    String id = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id));
                    return FileUtils.getDataColumn(context, contentUri, null, null);
                }
                if (FileUtils.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return FileUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (FileUtils.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                return FileUtils.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int index = cursor.getColumnIndexOrThrow("_data");
                String string = cursor.getString(index);
                return string;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    public static HashMap<String, Object> createFileInfoMap(File compressedImageFile) {
        HashMap<String, Object> fileInfoMap = new HashMap<String, Object>();
        fileInfoMap.put("filePath", compressedImageFile.getAbsolutePath());
        fileInfoMap.put("fileName", compressedImageFile.getName());
        return fileInfoMap;
    }

    public static boolean clearCache(Context context) {
        try {
            File cacheDir = new File(context.getCacheDir() + "/file_picker/");
            FileUtils.recursiveDeleteFile(cacheDir);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("There was an error while clearing cached files: " + ex.toString()));
            return false;
        }
        return true;
    }

    public static void loadData(File file, FileInfo.Builder fileInfo) {
        try {
            int size = (int)file.length();
            byte[] bytes = new byte[size];
            try {
                BufferedInputStream buf = new BufferedInputStream(new FileInputStream(file));
                buf.read(bytes, 0, bytes.length);
                buf.close();
            }
            catch (FileNotFoundException e) {
                Log.e((String)TAG, (String)("File not found: " + e.getMessage()), null);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Failed to close file streams: " + e.getMessage()), null);
            }
            fileInfo.withData(bytes);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Failed to load bytes into memory with error " + e.toString() + ". Probably the file is too big to fit device memory. Bytes won't be added to the file this time."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileInfo openFileStream(Context context, Uri uri, boolean withData) {
        Log.i((String)TAG, (String)("Caching from URI: " + uri.toString()));
        FileOutputStream fos = null;
        FileInfo.Builder fileInfo = new FileInfo.Builder();
        String fileName = FileUtils.getFileName(uri, context);
        String path = context.getCacheDir().getAbsolutePath() + "/file_picker/" + System.currentTimeMillis() + "/" + (fileName != null ? fileName : "unamed");
        File file = new File(path);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                fos = new FileOutputStream(path);
                try {
                    BufferedOutputStream out = new BufferedOutputStream(fos);
                    InputStream in = context.getContentResolver().openInputStream(uri);
                    byte[] buffer = new byte[8192];
                    int len = 0;
                    while ((len = in.read(buffer)) >= 0) {
                        out.write(buffer, 0, len);
                    }
                    out.flush();
                }
                finally {
                    fos.getFD().sync();
                }
            }
            catch (Exception e) {
                try {
                    fos.close();
                }
                catch (IOException | NullPointerException ex) {
                    Log.e((String)TAG, (String)("Failed to close file streams: " + e.getMessage()), null);
                    return null;
                }
                Log.e((String)TAG, (String)("Failed to retrieve path: " + e.getMessage()), null);
                return null;
            }
        }
        Log.d((String)TAG, (String)("File loaded and cached at:" + path));
        if (withData) {
            FileUtils.loadData(file, fileInfo);
        }
        fileInfo.withPath(path).withName(fileName).withUri(uri).withSize(Long.parseLong(String.valueOf(file.length())));
        return fileInfo.build();
    }

    @RequiresApi(api=19)
    @Nullable
    public static String getFullPathFromTreeUri(@Nullable Uri treeUri, Context con) {
        String documentPath;
        if (treeUri == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 30 && FileUtils.isDownloadsDocument(treeUri)) {
            String docId = DocumentsContract.getDocumentId((Uri)treeUri);
            String extPath = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getPath();
            if (docId.equals("downloads")) {
                return extPath;
            }
            if (docId.matches("^ms[df]\\:.*")) {
                String fileName = FileUtils.getFileName(treeUri, con);
                return extPath + "/" + fileName;
            }
            if (docId.startsWith("raw:")) {
                String rawPath = docId.split(":")[1];
                return rawPath;
            }
            return null;
        }
        String volumePath = FileUtils.getVolumePath(FileUtils.getVolumeIdFromTreeUri(treeUri), con);
        FileInfo.Builder fileInfo = new FileInfo.Builder();
        if (volumePath == null) {
            return File.separator;
        }
        if (volumePath.endsWith(File.separator)) {
            volumePath = volumePath.substring(0, volumePath.length() - 1);
        }
        if ((documentPath = FileUtils.getDocumentPathFromTreeUri(treeUri)).endsWith(File.separator)) {
            documentPath = documentPath.substring(0, documentPath.length() - 1);
        }
        if (documentPath.length() > 0) {
            if (documentPath.startsWith(File.separator)) {
                return volumePath + documentPath;
            }
            return volumePath + File.separator + documentPath;
        }
        return volumePath;
    }

    @Nullable
    private static String getDirectoryPath(Class<?> storageVolumeClazz, Object storageVolumeElement) {
        try {
            if (Build.VERSION.SDK_INT < 30) {
                Method getPath = storageVolumeClazz.getMethod("getPath", new Class[0]);
                return (String)getPath.invoke(storageVolumeElement, new Object[0]);
            }
            Method getDirectory = storageVolumeClazz.getMethod("getDirectory", new Class[0]);
            File f = (File)getDirectory.invoke(storageVolumeElement, new Object[0]);
            if (f != null) {
                return f.getPath();
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    private static String getVolumePath(String volumeId, Context context) {
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        try {
            StorageManager mStorageManager = (StorageManager)context.getSystemService("storage");
            Class<?> storageVolumeClazz = Class.forName("android.os.storage.StorageVolume");
            Method getVolumeList = mStorageManager.getClass().getMethod("getVolumeList", new Class[0]);
            Method getUuid = storageVolumeClazz.getMethod("getUuid", new Class[0]);
            Method isPrimary = storageVolumeClazz.getMethod("isPrimary", new Class[0]);
            Object result = getVolumeList.invoke((Object)mStorageManager, new Object[0]);
            if (result == null) {
                return null;
            }
            int length = Array.getLength(result);
            for (int i = 0; i < length; ++i) {
                Object storageVolumeElement = Array.get(result, i);
                String uuid = (String)getUuid.invoke(storageVolumeElement, new Object[0]);
                Boolean primary = (Boolean)isPrimary.invoke(storageVolumeElement, new Object[0]);
                if (primary != null && PRIMARY_VOLUME_NAME.equals(volumeId)) {
                    return FileUtils.getDirectoryPath(storageVolumeClazz, storageVolumeElement);
                }
                if (uuid == null || !uuid.equals(volumeId)) continue;
                return FileUtils.getDirectoryPath(storageVolumeClazz, storageVolumeElement);
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @TargetApi(value=21)
    private static String getVolumeIdFromTreeUri(Uri treeUri) {
        String docId = DocumentsContract.getTreeDocumentId((Uri)treeUri);
        String[] split = docId.split(":");
        if (split.length > 0) {
            return split[0];
        }
        return null;
    }

    @TargetApi(value=21)
    private static String getDocumentPathFromTreeUri(Uri treeUri) {
        String docId = DocumentsContract.getTreeDocumentId((Uri)treeUri);
        String[] split = docId.split(":");
        if (split.length >= 2 && split[1] != null) {
            return split[1];
        }
        return File.separator;
    }

    private static void recursiveDeleteFile(File file) throws Exception {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                FileUtils.recursiveDeleteFile(child);
            }
        }
        file.delete();
    }
}

