/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.auth;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.MultiFactor;
import com.google.firebase.auth.MultiFactorAssertion;
import com.google.firebase.auth.MultiFactorResolver;
import com.google.firebase.auth.MultiFactorSession;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.PhoneMultiFactorAssertion;
import com.google.firebase.auth.PhoneMultiFactorGenerator;
import com.google.firebase.internal.api.FirebaseNoSignedInUserException;
import io.flutter.plugins.firebase.auth.FlutterFirebaseAuthPluginException;
import io.flutter.plugins.firebase.auth.FlutterFirebaseAuthUser;
import io.flutter.plugins.firebase.auth.GeneratedAndroidFirebaseAuth;
import io.flutter.plugins.firebase.auth.PigeonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class FlutterFirebaseMultiFactor
implements GeneratedAndroidFirebaseAuth.MultiFactorUserHostApi,
GeneratedAndroidFirebaseAuth.MultiFactoResolverHostApi {
    static final Map<String, Map<String, MultiFactor>> multiFactorUserMap = new HashMap<String, Map<String, MultiFactor>>();
    static final Map<String, MultiFactorSession> multiFactorSessionMap = new HashMap<String, MultiFactorSession>();
    static final Map<String, MultiFactorResolver> multiFactorResolverMap = new HashMap<String, MultiFactorResolver>();
    static final Map<String, MultiFactorAssertion> multiFactorAssertionMap = new HashMap<String, MultiFactorAssertion>();

    MultiFactor getAppMultiFactor(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app) throws FirebaseNoSignedInUserException {
        Map<String, MultiFactor> appMultiFactorUser;
        FirebaseUser currentUser = FlutterFirebaseAuthUser.getCurrentUserFromPigeon(app);
        if (currentUser == null) {
            throw new FirebaseNoSignedInUserException("No user is signed in");
        }
        if (multiFactorUserMap.get(app.getAppName()) == null) {
            multiFactorUserMap.put(app.getAppName(), new HashMap());
        }
        if ((appMultiFactorUser = multiFactorUserMap.get(app.getAppName())).get(currentUser.getUid()) == null) {
            appMultiFactorUser.put(currentUser.getUid(), currentUser.getMultiFactor());
        }
        return appMultiFactorUser.get(currentUser.getUid());
    }

    @Override
    public void enrollPhone(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseAuth.PigeonPhoneMultiFactorAssertion assertion, @Nullable String displayName, @NonNull GeneratedAndroidFirebaseAuth.VoidResult result) {
        MultiFactor multiFactor;
        try {
            multiFactor = this.getAppMultiFactor(app);
        }
        catch (FirebaseNoSignedInUserException e) {
            result.error(e);
            return;
        }
        PhoneAuthCredential credential = PhoneAuthProvider.getCredential((String)assertion.getVerificationId(), (String)assertion.getVerificationCode());
        PhoneMultiFactorAssertion multiFactorAssertion = PhoneMultiFactorGenerator.getAssertion((PhoneAuthCredential)credential);
        multiFactor.enroll((MultiFactorAssertion)multiFactorAssertion, displayName).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                result.success();
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void enrollTotp(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull String assertionId, @Nullable String displayName, @NonNull GeneratedAndroidFirebaseAuth.VoidResult result) {
        MultiFactor multiFactor;
        try {
            multiFactor = this.getAppMultiFactor(app);
        }
        catch (FirebaseNoSignedInUserException e) {
            result.error(e);
            return;
        }
        MultiFactorAssertion multiFactorAssertion = multiFactorAssertionMap.get(assertionId);
        assert (multiFactorAssertion != null);
        multiFactor.enroll(multiFactorAssertion, displayName).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                result.success();
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void getSession(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseAuth.Result<GeneratedAndroidFirebaseAuth.PigeonMultiFactorSession> result) {
        MultiFactor multiFactor;
        try {
            multiFactor = this.getAppMultiFactor(app);
        }
        catch (FirebaseNoSignedInUserException e) {
            result.error(e);
            return;
        }
        multiFactor.getSession().addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                MultiFactorSession sessionResult = (MultiFactorSession)task.getResult();
                String id = UUID.randomUUID().toString();
                multiFactorSessionMap.put(id, sessionResult);
                result.success(new GeneratedAndroidFirebaseAuth.PigeonMultiFactorSession.Builder().setId(id).build());
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void unenroll(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull String factorUid, @NonNull GeneratedAndroidFirebaseAuth.VoidResult result) {
        MultiFactor multiFactor;
        try {
            multiFactor = this.getAppMultiFactor(app);
        }
        catch (FirebaseNoSignedInUserException e) {
            result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter((Exception)((Object)e)));
            return;
        }
        multiFactor.unenroll(factorUid).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                result.success();
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void getEnrolledFactors(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseAuth.Result<List<GeneratedAndroidFirebaseAuth.PigeonMultiFactorInfo>> result) {
        MultiFactor multiFactor;
        try {
            multiFactor = this.getAppMultiFactor(app);
        }
        catch (FirebaseNoSignedInUserException e) {
            result.error(e);
            return;
        }
        List factors = multiFactor.getEnrolledFactors();
        List<GeneratedAndroidFirebaseAuth.PigeonMultiFactorInfo> resultFactors = PigeonParser.multiFactorInfoToPigeon(factors);
        result.success(resultFactors);
    }

    @Override
    public void resolveSignIn(@NonNull String resolverId, @Nullable GeneratedAndroidFirebaseAuth.PigeonPhoneMultiFactorAssertion assertion, @Nullable String totpAssertionId, @NonNull GeneratedAndroidFirebaseAuth.Result<GeneratedAndroidFirebaseAuth.PigeonUserCredential> result) {
        MultiFactorAssertion multiFactorAssertion;
        MultiFactorResolver resolver = multiFactorResolverMap.get(resolverId);
        if (resolver == null) {
            result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(new Exception("Resolver not found")));
            return;
        }
        if (assertion != null) {
            PhoneAuthCredential credential = PhoneAuthProvider.getCredential((String)assertion.getVerificationId(), (String)assertion.getVerificationCode());
            multiFactorAssertion = PhoneMultiFactorGenerator.getAssertion((PhoneAuthCredential)credential);
        } else {
            multiFactorAssertion = multiFactorAssertionMap.get(totpAssertionId);
        }
        resolver.resolveSignIn(multiFactorAssertion).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                AuthResult authResult = (AuthResult)task.getResult();
                result.success(PigeonParser.parseAuthResult(authResult));
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }
}

