/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.auth;

import androidx.annotation.NonNull;
import com.google.firebase.auth.MultiFactorAssertion;
import com.google.firebase.auth.MultiFactorSession;
import com.google.firebase.auth.TotpMultiFactorAssertion;
import com.google.firebase.auth.TotpMultiFactorGenerator;
import com.google.firebase.auth.TotpSecret;
import io.flutter.plugins.firebase.auth.FlutterFirebaseAuthPluginException;
import io.flutter.plugins.firebase.auth.FlutterFirebaseMultiFactor;
import io.flutter.plugins.firebase.auth.GeneratedAndroidFirebaseAuth;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class FlutterFirebaseTotpMultiFactor
implements GeneratedAndroidFirebaseAuth.MultiFactorTotpHostApi {
    static final Map<String, TotpSecret> multiFactorSecret = new HashMap<String, TotpSecret>();

    @Override
    public void generateSecret(@NonNull String sessionId, @NonNull GeneratedAndroidFirebaseAuth.Result<GeneratedAndroidFirebaseAuth.PigeonTotpSecret> result) {
        MultiFactorSession multiFactorSession = FlutterFirebaseMultiFactor.multiFactorSessionMap.get(sessionId);
        assert (multiFactorSession != null);
        TotpMultiFactorGenerator.generateSecret((MultiFactorSession)multiFactorSession).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                TotpSecret secret = (TotpSecret)task.getResult();
                multiFactorSecret.put(secret.getSharedSecretKey(), secret);
                result.success(new GeneratedAndroidFirebaseAuth.PigeonTotpSecret.Builder().setCodeIntervalSeconds(Long.valueOf(secret.getCodeIntervalSeconds())).setCodeLength(Long.valueOf(secret.getCodeLength())).setSecretKey(secret.getSharedSecretKey()).setHashingAlgorithm(secret.getHashAlgorithm()).setEnrollmentCompletionDeadline(secret.getEnrollmentCompletionDeadline()).build());
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void getAssertionForEnrollment(@NonNull String secretKey, @NonNull String oneTimePassword, @NonNull GeneratedAndroidFirebaseAuth.Result<String> result) {
        TotpSecret secret = multiFactorSecret.get(secretKey);
        assert (secret != null);
        TotpMultiFactorAssertion assertion = TotpMultiFactorGenerator.getAssertionForEnrollment((TotpSecret)secret, (String)oneTimePassword);
        String assertionId = UUID.randomUUID().toString();
        FlutterFirebaseMultiFactor.multiFactorAssertionMap.put(assertionId, (MultiFactorAssertion)assertion);
        result.success(assertionId);
    }

    @Override
    public void getAssertionForSignIn(@NonNull String enrollmentId, @NonNull String oneTimePassword, @NonNull GeneratedAndroidFirebaseAuth.Result<String> result) {
        TotpMultiFactorAssertion assertion = TotpMultiFactorGenerator.getAssertionForSignIn((String)enrollmentId, (String)oneTimePassword);
        String assertionId = UUID.randomUUID().toString();
        FlutterFirebaseMultiFactor.multiFactorAssertionMap.put(assertionId, (MultiFactorAssertion)assertion);
        result.success(assertionId);
    }
}

