/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.auth;

import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugins.firebase.auth.PigeonParser;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class AuthStateChannelStreamHandler
implements EventChannel.StreamHandler {
    private final FirebaseAuth firebaseAuth;
    private FirebaseAuth.AuthStateListener authStateListener;

    public AuthStateChannelStreamHandler(FirebaseAuth firebaseAuth) {
        this.firebaseAuth = firebaseAuth;
    }

    public void onListen(Object arguments, EventChannel.EventSink events) {
        HashMap<String, String> event = new HashMap<String, String>();
        event.put("appName", this.firebaseAuth.getApp().getName());
        AtomicBoolean initialAuthState = new AtomicBoolean(true);
        this.authStateListener = auth -> {
            if (initialAuthState.get()) {
                initialAuthState.set(false);
                return;
            }
            FirebaseUser user = auth.getCurrentUser();
            if (user == null) {
                event.put("user", null);
            } else {
                event.put("user", (String)((Object)PigeonParser.manuallyToList(PigeonParser.parseFirebaseUser(user))));
            }
            events.success((Object)event);
        };
        this.firebaseAuth.addAuthStateListener(this.authStateListener);
    }

    public void onCancel(Object arguments) {
        if (this.authStateListener != null) {
            this.firebaseAuth.removeAuthStateListener(this.authStateListener);
            this.authStateListener = null;
        }
    }
}

