/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.auth;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.MultiFactor;
import com.google.firebase.auth.MultiFactorInfo;
import com.google.firebase.auth.MultiFactorSession;
import com.google.firebase.auth.OAuthProvider;
import com.google.firebase.auth.PhoneMultiFactorInfo;
import com.google.firebase.auth.SignInMethodQueryResult;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugins.firebase.auth.AuthStateChannelStreamHandler;
import io.flutter.plugins.firebase.auth.FlutterFirebaseAuthPluginException;
import io.flutter.plugins.firebase.auth.FlutterFirebaseAuthUser;
import io.flutter.plugins.firebase.auth.FlutterFirebaseMultiFactor;
import io.flutter.plugins.firebase.auth.FlutterFirebaseTotpMultiFactor;
import io.flutter.plugins.firebase.auth.FlutterFirebaseTotpSecret;
import io.flutter.plugins.firebase.auth.GeneratedAndroidFirebaseAuth;
import io.flutter.plugins.firebase.auth.IdTokenChannelStreamHandler;
import io.flutter.plugins.firebase.auth.PhoneNumberVerificationStreamHandler;
import io.flutter.plugins.firebase.auth.PigeonParser;
import io.flutter.plugins.firebase.core.FlutterFirebaseCorePlugin;
import io.flutter.plugins.firebase.core.FlutterFirebasePlugin;
import io.flutter.plugins.firebase.core.FlutterFirebasePluginRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class FlutterFirebaseAuthPlugin
implements FlutterFirebasePlugin,
FlutterPlugin,
ActivityAware,
GeneratedAndroidFirebaseAuth.FirebaseAuthHostApi {
    private static final String METHOD_CHANNEL_NAME = "plugins.flutter.io/firebase_auth";
    static final HashMap<Integer, AuthCredential> authCredentials = new HashMap();
    @Nullable
    private BinaryMessenger messenger;
    private MethodChannel channel;
    private Activity activity;
    private final Map<EventChannel, EventChannel.StreamHandler> streamHandlers = new HashMap<EventChannel, EventChannel.StreamHandler>();
    private final FlutterFirebaseAuthUser firebaseAuthUser = new FlutterFirebaseAuthUser();
    private final FlutterFirebaseMultiFactor firebaseMultiFactor = new FlutterFirebaseMultiFactor();
    private final FlutterFirebaseTotpMultiFactor firebaseTotpMultiFactor = new FlutterFirebaseTotpMultiFactor();
    private final FlutterFirebaseTotpSecret firebaseTotpSecret = new FlutterFirebaseTotpSecret();

    private void initInstance(BinaryMessenger messenger) {
        FlutterFirebasePluginRegistry.registerPlugin((String)METHOD_CHANNEL_NAME, (FlutterFirebasePlugin)this);
        this.channel = new MethodChannel(messenger, METHOD_CHANNEL_NAME);
        GeneratedAndroidFirebaseAuth.FirebaseAuthHostApi.setUp(messenger, this);
        GeneratedAndroidFirebaseAuth.FirebaseAuthUserHostApi.setUp(messenger, this.firebaseAuthUser);
        GeneratedAndroidFirebaseAuth.MultiFactorUserHostApi.setUp(messenger, this.firebaseMultiFactor);
        GeneratedAndroidFirebaseAuth.MultiFactoResolverHostApi.setUp(messenger, this.firebaseMultiFactor);
        GeneratedAndroidFirebaseAuth.MultiFactorTotpHostApi.setUp(messenger, this.firebaseTotpMultiFactor);
        GeneratedAndroidFirebaseAuth.MultiFactorTotpSecretHostApi.setUp(messenger, this.firebaseTotpSecret);
        this.messenger = messenger;
    }

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.initInstance(binding.getBinaryMessenger());
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.channel.setMethodCallHandler(null);
        assert (this.messenger != null);
        GeneratedAndroidFirebaseAuth.FirebaseAuthHostApi.setUp(this.messenger, null);
        GeneratedAndroidFirebaseAuth.FirebaseAuthUserHostApi.setUp(this.messenger, null);
        GeneratedAndroidFirebaseAuth.MultiFactorUserHostApi.setUp(this.messenger, null);
        GeneratedAndroidFirebaseAuth.MultiFactoResolverHostApi.setUp(this.messenger, null);
        GeneratedAndroidFirebaseAuth.MultiFactorTotpHostApi.setUp(this.messenger, null);
        GeneratedAndroidFirebaseAuth.MultiFactorTotpSecretHostApi.setUp(this.messenger, null);
        this.channel = null;
        this.messenger = null;
        this.removeEventListeners();
    }

    public void onAttachedToActivity(ActivityPluginBinding activityPluginBinding) {
        this.activity = activityPluginBinding.getActivity();
        this.firebaseAuthUser.setActivity(this.activity);
    }

    public void onDetachedFromActivityForConfigChanges() {
        this.activity = null;
        this.firebaseAuthUser.setActivity(null);
    }

    public void onReattachedToActivityForConfigChanges(ActivityPluginBinding activityPluginBinding) {
        this.activity = activityPluginBinding.getActivity();
        this.firebaseAuthUser.setActivity(this.activity);
    }

    public void onDetachedFromActivity() {
        this.activity = null;
        this.firebaseAuthUser.setActivity(null);
    }

    @Nullable
    private Activity getActivity() {
        return this.activity;
    }

    static FirebaseAuth getAuthFromPigeon(GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp pigeonApp) {
        String customDomain;
        FirebaseApp app = FirebaseApp.getInstance((String)pigeonApp.getAppName());
        FirebaseAuth auth = FirebaseAuth.getInstance((FirebaseApp)app);
        if (pigeonApp.getTenantId() != null) {
            auth.setTenantId(pigeonApp.getTenantId());
        }
        if ((customDomain = (String)FlutterFirebaseCorePlugin.customAuthDomain.get(pigeonApp.getAppName())) != null) {
            auth.setCustomAuthDomain(customDomain);
        }
        if (pigeonApp.getCustomAuthDomain() != null) {
            auth.setCustomAuthDomain(pigeonApp.getCustomAuthDomain());
        }
        return auth;
    }

    @Override
    public void registerIdTokenListener(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseAuth.Result<String> result) {
        try {
            FirebaseAuth auth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
            IdTokenChannelStreamHandler handler = new IdTokenChannelStreamHandler(auth);
            String name = "plugins.flutter.io/firebase_auth/id-token/" + auth.getApp().getName();
            EventChannel channel = new EventChannel(this.messenger, name);
            channel.setStreamHandler((EventChannel.StreamHandler)handler);
            this.streamHandlers.put(channel, handler);
            result.success(name);
        }
        catch (Exception e) {
            result.error(e);
        }
    }

    @Override
    public void registerAuthStateListener(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseAuth.Result<String> result) {
        try {
            FirebaseAuth auth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
            AuthStateChannelStreamHandler handler = new AuthStateChannelStreamHandler(auth);
            String name = "plugins.flutter.io/firebase_auth/auth-state/" + auth.getApp().getName();
            EventChannel channel = new EventChannel(this.messenger, name);
            channel.setStreamHandler((EventChannel.StreamHandler)handler);
            this.streamHandlers.put(channel, handler);
            result.success(name);
        }
        catch (Exception e) {
            result.error(e);
        }
    }

    @Override
    public void useEmulator(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull String host, @NonNull Long port, @NonNull GeneratedAndroidFirebaseAuth.VoidResult result) {
        try {
            FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
            firebaseAuth.useEmulator(host, port.intValue());
            result.success();
        }
        catch (Exception e) {
            result.error(e);
        }
    }

    @Override
    public void applyActionCode(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull String code, @NonNull GeneratedAndroidFirebaseAuth.VoidResult result) {
        FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
        firebaseAuth.applyActionCode(code).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                result.success();
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void checkActionCode(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull String code, @NonNull GeneratedAndroidFirebaseAuth.Result<GeneratedAndroidFirebaseAuth.PigeonActionCodeInfo> result) {
        FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
        firebaseAuth.checkActionCode(code).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                ActionCodeResult actionCodeInfo = (ActionCodeResult)task.getResult();
                result.success(PigeonParser.parseActionCodeResult(actionCodeInfo));
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void confirmPasswordReset(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull String code, @NonNull String newPassword, @NonNull GeneratedAndroidFirebaseAuth.VoidResult result) {
        FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
        firebaseAuth.confirmPasswordReset(code, newPassword).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                result.success();
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void createUserWithEmailAndPassword(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull String email, @NonNull String password, @NonNull GeneratedAndroidFirebaseAuth.Result<GeneratedAndroidFirebaseAuth.PigeonUserCredential> result) {
        FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
        firebaseAuth.createUserWithEmailAndPassword(email, password).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                AuthResult authResult = (AuthResult)task.getResult();
                result.success(PigeonParser.parseAuthResult(authResult));
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void signInAnonymously(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseAuth.Result<GeneratedAndroidFirebaseAuth.PigeonUserCredential> result) {
        FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
        firebaseAuth.signInAnonymously().addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                AuthResult authResult = (AuthResult)task.getResult();
                result.success(PigeonParser.parseAuthResult(authResult));
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void signInWithCredential(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull Map<String, Object> input, @NonNull GeneratedAndroidFirebaseAuth.Result<GeneratedAndroidFirebaseAuth.PigeonUserCredential> result) {
        FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
        AuthCredential credential = PigeonParser.getCredential(input);
        if (credential == null) {
            throw FlutterFirebaseAuthPluginException.invalidCredential();
        }
        firebaseAuth.signInWithCredential(credential).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                AuthResult authResult = (AuthResult)task.getResult();
                result.success(PigeonParser.parseAuthResult(authResult));
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void signInWithCustomToken(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull String token, @NonNull GeneratedAndroidFirebaseAuth.Result<GeneratedAndroidFirebaseAuth.PigeonUserCredential> result) {
        FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
        firebaseAuth.signInWithCustomToken(token).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                AuthResult authResult = (AuthResult)task.getResult();
                result.success(PigeonParser.parseAuthResult(authResult));
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void signInWithEmailAndPassword(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull String email, @NonNull String password, @NonNull GeneratedAndroidFirebaseAuth.Result<GeneratedAndroidFirebaseAuth.PigeonUserCredential> result) {
        FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
        firebaseAuth.signInWithEmailAndPassword(email, password).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                result.success(PigeonParser.parseAuthResult((AuthResult)task.getResult()));
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void signInWithEmailLink(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull String email, @NonNull String emailLink, @NonNull GeneratedAndroidFirebaseAuth.Result<GeneratedAndroidFirebaseAuth.PigeonUserCredential> result) {
        FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
        firebaseAuth.signInWithEmailLink(email, emailLink).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                AuthResult authResult = (AuthResult)task.getResult();
                result.success(PigeonParser.parseAuthResult(authResult));
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void signInWithProvider(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseAuth.PigeonSignInProvider signInProvider, @NonNull GeneratedAndroidFirebaseAuth.Result<GeneratedAndroidFirebaseAuth.PigeonUserCredential> result) {
        FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
        OAuthProvider.Builder provider = OAuthProvider.newBuilder((String)signInProvider.getProviderId(), (FirebaseAuth)firebaseAuth);
        if (signInProvider.getScopes() != null) {
            provider.setScopes(signInProvider.getScopes());
        }
        if (signInProvider.getCustomParameters() != null) {
            provider.addCustomParameters(signInProvider.getCustomParameters());
        }
        firebaseAuth.startActivityForSignInWithProvider(this.getActivity(), (FederatedAuthProvider)provider.build()).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                AuthResult authResult = (AuthResult)task.getResult();
                result.success(PigeonParser.parseAuthResult(authResult));
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void signOut(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseAuth.VoidResult result) {
        try {
            Map<String, MultiFactor> appMultiFactorUser;
            FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
            if (firebaseAuth.getCurrentUser() != null && (appMultiFactorUser = FlutterFirebaseMultiFactor.multiFactorUserMap.get(app.getAppName())) != null) {
                appMultiFactorUser.remove(firebaseAuth.getCurrentUser().getUid());
            }
            firebaseAuth.signOut();
            result.success();
        }
        catch (Exception e) {
            result.error(e);
        }
    }

    @Override
    public void fetchSignInMethodsForEmail(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull String email, @NonNull GeneratedAndroidFirebaseAuth.Result<List<String>> result) {
        FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
        firebaseAuth.fetchSignInMethodsForEmail(email).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                SignInMethodQueryResult signInMethodQueryResult = (SignInMethodQueryResult)task.getResult();
                result.success(signInMethodQueryResult.getSignInMethods());
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void sendPasswordResetEmail(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull String email, @Nullable GeneratedAndroidFirebaseAuth.PigeonActionCodeSettings actionCodeSettings, @NonNull GeneratedAndroidFirebaseAuth.VoidResult result) {
        FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
        if (actionCodeSettings == null) {
            firebaseAuth.sendPasswordResetEmail(email).addOnCompleteListener(task -> {
                if (task.isSuccessful()) {
                    result.success();
                } else {
                    result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
                }
            });
            return;
        }
        firebaseAuth.sendPasswordResetEmail(email, PigeonParser.getActionCodeSettings(actionCodeSettings)).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                result.success();
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void sendSignInLinkToEmail(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull String email, @NonNull GeneratedAndroidFirebaseAuth.PigeonActionCodeSettings actionCodeSettings, @NonNull GeneratedAndroidFirebaseAuth.VoidResult result) {
        FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
        firebaseAuth.sendSignInLinkToEmail(email, PigeonParser.getActionCodeSettings(actionCodeSettings)).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                result.success();
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void setLanguageCode(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @Nullable String languageCode, @NonNull GeneratedAndroidFirebaseAuth.Result<String> result) {
        try {
            FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
            if (languageCode == null) {
                firebaseAuth.useAppLanguage();
            } else {
                firebaseAuth.setLanguageCode(languageCode);
            }
            result.success(firebaseAuth.getLanguageCode());
        }
        catch (Exception e) {
            result.error(e);
        }
    }

    @Override
    public void setSettings(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseAuth.PigeonFirebaseAuthSettings settings, @NonNull GeneratedAndroidFirebaseAuth.VoidResult result) {
        try {
            FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
            firebaseAuth.getFirebaseAuthSettings().setAppVerificationDisabledForTesting(settings.getAppVerificationDisabledForTesting().booleanValue());
            if (settings.getForceRecaptchaFlow() != null) {
                firebaseAuth.getFirebaseAuthSettings().forceRecaptchaFlowForTesting(settings.getForceRecaptchaFlow().booleanValue());
            }
            if (settings.getPhoneNumber() != null && settings.getSmsCode() != null) {
                firebaseAuth.getFirebaseAuthSettings().setAutoRetrievedSmsCodeForPhoneNumber(settings.getPhoneNumber(), settings.getSmsCode());
            }
            result.success();
        }
        catch (Exception e) {
            result.error(e);
        }
    }

    @Override
    public void verifyPasswordResetCode(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull String code, @NonNull GeneratedAndroidFirebaseAuth.Result<String> result) {
        FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
        firebaseAuth.verifyPasswordResetCode(code).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                result.success((String)task.getResult());
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void verifyPhoneNumber(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseAuth.PigeonVerifyPhoneNumberRequest request, @NonNull GeneratedAndroidFirebaseAuth.Result<String> result) {
        try {
            String eventChannelName = "plugins.flutter.io/firebase_auth/phone/" + UUID.randomUUID().toString();
            EventChannel channel = new EventChannel(this.messenger, eventChannelName);
            MultiFactorSession multiFactorSession = null;
            if (request.getMultiFactorSessionId() != null) {
                multiFactorSession = FlutterFirebaseMultiFactor.multiFactorSessionMap.get(request.getMultiFactorSessionId());
            }
            String multiFactorInfoId = request.getMultiFactorInfoId();
            PhoneMultiFactorInfo multiFactorInfo = null;
            if (multiFactorInfoId != null) {
                block2: for (String resolverId : FlutterFirebaseMultiFactor.multiFactorResolverMap.keySet()) {
                    for (MultiFactorInfo info : FlutterFirebaseMultiFactor.multiFactorResolverMap.get(resolverId).getHints()) {
                        if (!info.getUid().equals(multiFactorInfoId) || !(info instanceof PhoneMultiFactorInfo)) continue;
                        multiFactorInfo = (PhoneMultiFactorInfo)info;
                        continue block2;
                    }
                }
            }
            PhoneNumberVerificationStreamHandler handler = new PhoneNumberVerificationStreamHandler(this.getActivity(), app, request, multiFactorSession, multiFactorInfo, credential -> {
                int hashCode = credential.hashCode();
                authCredentials.put(hashCode, (AuthCredential)credential);
            });
            channel.setStreamHandler((EventChannel.StreamHandler)handler);
            this.streamHandlers.put(channel, handler);
            result.success(eventChannelName);
        }
        catch (Exception e) {
            result.error(e);
        }
    }

    @Override
    public void revokeTokenWithAuthorizationCode(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull String authorizationCode, @NonNull GeneratedAndroidFirebaseAuth.VoidResult result) {
        result.success();
    }

    @Override
    public void initializeRecaptchaConfig(@NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseAuth.VoidResult result) {
        FirebaseAuth firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
        firebaseAuth.initializeRecaptchaConfig().addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                result.success();
            } else {
                result.error(FlutterFirebaseAuthPluginException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    public Task<Map<String, Object>> getPluginConstantsForFirebaseApp(FirebaseApp firebaseApp) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                GeneratedAndroidFirebaseAuth.PigeonUserDetails user;
                HashMap<String, Object> constants = new HashMap<String, Object>();
                FirebaseAuth firebaseAuth = FirebaseAuth.getInstance((FirebaseApp)firebaseApp);
                FirebaseUser firebaseUser = firebaseAuth.getCurrentUser();
                String languageCode = firebaseAuth.getLanguageCode();
                GeneratedAndroidFirebaseAuth.PigeonUserDetails pigeonUserDetails = user = firebaseUser == null ? null : PigeonParser.parseFirebaseUser(firebaseUser);
                if (languageCode != null) {
                    constants.put("APP_LANGUAGE_CODE", languageCode);
                }
                if (user != null) {
                    constants.put("APP_CURRENT_USER", PigeonParser.manuallyToList(user));
                }
                taskCompletionSource.setResult(constants);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    public Task<Void> didReinitializeFirebaseCore() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                this.removeEventListeners();
                authCredentials.clear();
                taskCompletionSource.setResult(null);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    private void removeEventListeners() {
        for (EventChannel eventChannel : this.streamHandlers.keySet()) {
            EventChannel.StreamHandler streamHandler = this.streamHandlers.get(eventChannel);
            if (streamHandler != null) {
                streamHandler.onCancel(null);
            }
            eventChannel.setStreamHandler(null);
        }
        this.streamHandlers.clear();
    }
}

