/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.auth;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.auth.TotpSecret;
import io.flutter.plugins.firebase.auth.FlutterFirebaseTotpMultiFactor;
import io.flutter.plugins.firebase.auth.GeneratedAndroidFirebaseAuth;

public class FlutterFirebaseTotpSecret
implements GeneratedAndroidFirebaseAuth.MultiFactorTotpSecretHostApi {
    @Override
    public void generateQrCodeUrl(@NonNull String secretKey, @Nullable String accountName, @Nullable String issuer, @NonNull GeneratedAndroidFirebaseAuth.Result<String> result) {
        TotpSecret secret = FlutterFirebaseTotpMultiFactor.multiFactorSecret.get(secretKey);
        assert (secret != null);
        if (accountName == null || issuer == null) {
            result.success(secret.generateQrCodeUrl());
            return;
        }
        result.success(secret.generateQrCodeUrl(accountName, issuer));
    }

    @Override
    public void openInOtpApp(@NonNull String secretKey, @NonNull String qrCodeUrl, @NonNull GeneratedAndroidFirebaseAuth.VoidResult result) {
        TotpSecret secret = FlutterFirebaseTotpMultiFactor.multiFactorSecret.get(secretKey);
        assert (secret != null);
        secret.openInOtpApp(qrCodeUrl);
        result.success();
    }
}

