/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.auth;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GeneratedAndroidFirebaseAuth {
    @NonNull
    protected static ArrayList<Object> wrapError(@NonNull Throwable exception) {
        ArrayList<Object> errorList = new ArrayList<Object>(3);
        if (exception instanceof FlutterError) {
            FlutterError error = (FlutterError)exception;
            errorList.add(error.code);
            errorList.add(error.getMessage());
            errorList.add(error.details);
        } else {
            errorList.add(exception.toString());
            errorList.add(exception.getClass().getSimpleName());
            errorList.add("Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString((Throwable)exception));
        }
        return errorList;
    }

    public static class FlutterError
    extends RuntimeException {
        public final String code;
        public final Object details;

        public FlutterError(@NonNull String code, @Nullable String message, @Nullable Object details) {
            super(message);
            this.code = code;
            this.details = details;
        }
    }

    public static interface GenerateInterfaces {
        public void pigeonInterface(@NonNull PigeonMultiFactorInfo var1);

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return GenerateInterfacesCodec.INSTANCE;
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable GenerateInterfaces api) {
            GenerateInterfaces.setUp(binaryMessenger, "", api);
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable GenerateInterfaces api) {
            messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.GenerateInterfaces.pigeonInterface" + messageChannelSuffix, GenerateInterfaces.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    ArrayList args = (ArrayList)message;
                    PigeonMultiFactorInfo infoArg = (PigeonMultiFactorInfo)args.get(0);
                    try {
                        api.pigeonInterface(infoArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(exception);
                        wrapped = wrappedError;
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    private static class GenerateInterfacesCodec
    extends StandardMessageCodec {
        public static final GenerateInterfacesCodec INSTANCE = new GenerateInterfacesCodec();

        private GenerateInterfacesCodec() {
        }

        protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
            switch (type) {
                case -128: {
                    return PigeonMultiFactorInfo.fromList((ArrayList)this.readValue(buffer));
                }
            }
            return super.readValueOfType(type, buffer);
        }

        protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
            if (value instanceof PigeonMultiFactorInfo) {
                stream.write(128);
                this.writeValue(stream, ((PigeonMultiFactorInfo)value).toList());
            } else {
                super.writeValue(stream, value);
            }
        }
    }

    public static interface MultiFactorTotpSecretHostApi {
        public void generateQrCodeUrl(@NonNull String var1, @Nullable String var2, @Nullable String var3, @NonNull Result<String> var4);

        public void openInOtpApp(@NonNull String var1, @NonNull String var2, @NonNull VoidResult var3);

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return new StandardMessageCodec();
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable MultiFactorTotpSecretHostApi api) {
            MultiFactorTotpSecretHostApi.setUp(binaryMessenger, "", api);
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable MultiFactorTotpSecretHostApi api) {
            messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.MultiFactorTotpSecretHostApi.generateQrCodeUrl" + messageChannelSuffix, MultiFactorTotpSecretHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String secretKeyArg = (String)args.get(0);
                    String accountNameArg = (String)args.get(1);
                    String issuerArg = (String)args.get(2);
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.generateQrCodeUrl(secretKeyArg, accountNameArg, issuerArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.MultiFactorTotpSecretHostApi.openInOtpApp" + messageChannelSuffix, MultiFactorTotpSecretHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String secretKeyArg = (String)args.get(0);
                    String qrCodeUrlArg = (String)args.get(1);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.openInOtpApp(secretKeyArg, qrCodeUrlArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    public static interface MultiFactorTotpHostApi {
        public void generateSecret(@NonNull String var1, @NonNull Result<PigeonTotpSecret> var2);

        public void getAssertionForEnrollment(@NonNull String var1, @NonNull String var2, @NonNull Result<String> var3);

        public void getAssertionForSignIn(@NonNull String var1, @NonNull String var2, @NonNull Result<String> var3);

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return MultiFactorTotpHostApiCodec.INSTANCE;
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable MultiFactorTotpHostApi api) {
            MultiFactorTotpHostApi.setUp(binaryMessenger, "", api);
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable MultiFactorTotpHostApi api) {
            messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.MultiFactorTotpHostApi.generateSecret" + messageChannelSuffix, MultiFactorTotpHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String sessionIdArg = (String)args.get(0);
                    Result<PigeonTotpSecret> resultCallback = new Result<PigeonTotpSecret>(){

                        @Override
                        public void success(PigeonTotpSecret result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.generateSecret(sessionIdArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.MultiFactorTotpHostApi.getAssertionForEnrollment" + messageChannelSuffix, MultiFactorTotpHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String secretKeyArg = (String)args.get(0);
                    String oneTimePasswordArg = (String)args.get(1);
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.getAssertionForEnrollment(secretKeyArg, oneTimePasswordArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.MultiFactorTotpHostApi.getAssertionForSignIn" + messageChannelSuffix, MultiFactorTotpHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String enrollmentIdArg = (String)args.get(0);
                    String oneTimePasswordArg = (String)args.get(1);
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.getAssertionForSignIn(enrollmentIdArg, oneTimePasswordArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    private static class MultiFactorTotpHostApiCodec
    extends StandardMessageCodec {
        public static final MultiFactorTotpHostApiCodec INSTANCE = new MultiFactorTotpHostApiCodec();

        private MultiFactorTotpHostApiCodec() {
        }

        protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
            switch (type) {
                case -128: {
                    return PigeonTotpSecret.fromList((ArrayList)this.readValue(buffer));
                }
            }
            return super.readValueOfType(type, buffer);
        }

        protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
            if (value instanceof PigeonTotpSecret) {
                stream.write(128);
                this.writeValue(stream, ((PigeonTotpSecret)value).toList());
            } else {
                super.writeValue(stream, value);
            }
        }
    }

    public static interface MultiFactoResolverHostApi {
        public void resolveSignIn(@NonNull String var1, @Nullable PigeonPhoneMultiFactorAssertion var2, @Nullable String var3, @NonNull Result<PigeonUserCredential> var4);

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return MultiFactoResolverHostApiCodec.INSTANCE;
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable MultiFactoResolverHostApi api) {
            MultiFactoResolverHostApi.setUp(binaryMessenger, "", api);
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable MultiFactoResolverHostApi api) {
            messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.MultiFactoResolverHostApi.resolveSignIn" + messageChannelSuffix, MultiFactoResolverHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String resolverIdArg = (String)args.get(0);
                    PigeonPhoneMultiFactorAssertion assertionArg = (PigeonPhoneMultiFactorAssertion)args.get(1);
                    String totpAssertionIdArg = (String)args.get(2);
                    Result<PigeonUserCredential> resultCallback = new Result<PigeonUserCredential>(){

                        @Override
                        public void success(PigeonUserCredential result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.resolveSignIn(resolverIdArg, assertionArg, totpAssertionIdArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    private static class MultiFactoResolverHostApiCodec
    extends StandardMessageCodec {
        public static final MultiFactoResolverHostApiCodec INSTANCE = new MultiFactoResolverHostApiCodec();

        private MultiFactoResolverHostApiCodec() {
        }

        protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
            switch (type) {
                case -128: {
                    return PigeonAdditionalUserInfo.fromList((ArrayList)this.readValue(buffer));
                }
                case -127: {
                    return PigeonAuthCredential.fromList((ArrayList)this.readValue(buffer));
                }
                case -126: {
                    return PigeonPhoneMultiFactorAssertion.fromList((ArrayList)this.readValue(buffer));
                }
                case -125: {
                    return PigeonUserCredential.fromList((ArrayList)this.readValue(buffer));
                }
                case -124: {
                    return PigeonUserDetails.fromList((ArrayList)this.readValue(buffer));
                }
                case -123: {
                    return PigeonUserInfo.fromList((ArrayList)this.readValue(buffer));
                }
            }
            return super.readValueOfType(type, buffer);
        }

        protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
            if (value instanceof PigeonAdditionalUserInfo) {
                stream.write(128);
                this.writeValue(stream, ((PigeonAdditionalUserInfo)value).toList());
            } else if (value instanceof PigeonAuthCredential) {
                stream.write(129);
                this.writeValue(stream, ((PigeonAuthCredential)value).toList());
            } else if (value instanceof PigeonPhoneMultiFactorAssertion) {
                stream.write(130);
                this.writeValue(stream, ((PigeonPhoneMultiFactorAssertion)value).toList());
            } else if (value instanceof PigeonUserCredential) {
                stream.write(131);
                this.writeValue(stream, ((PigeonUserCredential)value).toList());
            } else if (value instanceof PigeonUserDetails) {
                stream.write(132);
                this.writeValue(stream, ((PigeonUserDetails)value).toList());
            } else if (value instanceof PigeonUserInfo) {
                stream.write(133);
                this.writeValue(stream, ((PigeonUserInfo)value).toList());
            } else {
                super.writeValue(stream, value);
            }
        }
    }

    public static interface MultiFactorUserHostApi {
        public void enrollPhone(@NonNull AuthPigeonFirebaseApp var1, @NonNull PigeonPhoneMultiFactorAssertion var2, @Nullable String var3, @NonNull VoidResult var4);

        public void enrollTotp(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @Nullable String var3, @NonNull VoidResult var4);

        public void getSession(@NonNull AuthPigeonFirebaseApp var1, @NonNull Result<PigeonMultiFactorSession> var2);

        public void unenroll(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @NonNull VoidResult var3);

        public void getEnrolledFactors(@NonNull AuthPigeonFirebaseApp var1, @NonNull Result<List<PigeonMultiFactorInfo>> var2);

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return MultiFactorUserHostApiCodec.INSTANCE;
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable MultiFactorUserHostApi api) {
            MultiFactorUserHostApi.setUp(binaryMessenger, "", api);
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable MultiFactorUserHostApi api) {
            messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.MultiFactorUserHostApi.enrollPhone" + messageChannelSuffix, MultiFactorUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    PigeonPhoneMultiFactorAssertion assertionArg = (PigeonPhoneMultiFactorAssertion)args.get(1);
                    String displayNameArg = (String)args.get(2);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.enrollPhone(appArg, assertionArg, displayNameArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.MultiFactorUserHostApi.enrollTotp" + messageChannelSuffix, MultiFactorUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String assertionIdArg = (String)args.get(1);
                    String displayNameArg = (String)args.get(2);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.enrollTotp(appArg, assertionIdArg, displayNameArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.MultiFactorUserHostApi.getSession" + messageChannelSuffix, MultiFactorUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    Result<PigeonMultiFactorSession> resultCallback = new Result<PigeonMultiFactorSession>(){

                        @Override
                        public void success(PigeonMultiFactorSession result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.getSession(appArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.MultiFactorUserHostApi.unenroll" + messageChannelSuffix, MultiFactorUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String factorUidArg = (String)args.get(1);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.unenroll(appArg, factorUidArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.MultiFactorUserHostApi.getEnrolledFactors" + messageChannelSuffix, MultiFactorUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    Result<List<PigeonMultiFactorInfo>> resultCallback = new Result<List<PigeonMultiFactorInfo>>(){

                        @Override
                        public void success(List<PigeonMultiFactorInfo> result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.getEnrolledFactors(appArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    private static class MultiFactorUserHostApiCodec
    extends StandardMessageCodec {
        public static final MultiFactorUserHostApiCodec INSTANCE = new MultiFactorUserHostApiCodec();

        private MultiFactorUserHostApiCodec() {
        }

        protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
            switch (type) {
                case -128: {
                    return AuthPigeonFirebaseApp.fromList((ArrayList)this.readValue(buffer));
                }
                case -127: {
                    return PigeonMultiFactorInfo.fromList((ArrayList)this.readValue(buffer));
                }
                case -126: {
                    return PigeonMultiFactorSession.fromList((ArrayList)this.readValue(buffer));
                }
                case -125: {
                    return PigeonPhoneMultiFactorAssertion.fromList((ArrayList)this.readValue(buffer));
                }
            }
            return super.readValueOfType(type, buffer);
        }

        protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
            if (value instanceof AuthPigeonFirebaseApp) {
                stream.write(128);
                this.writeValue(stream, ((AuthPigeonFirebaseApp)value).toList());
            } else if (value instanceof PigeonMultiFactorInfo) {
                stream.write(129);
                this.writeValue(stream, ((PigeonMultiFactorInfo)value).toList());
            } else if (value instanceof PigeonMultiFactorSession) {
                stream.write(130);
                this.writeValue(stream, ((PigeonMultiFactorSession)value).toList());
            } else if (value instanceof PigeonPhoneMultiFactorAssertion) {
                stream.write(131);
                this.writeValue(stream, ((PigeonPhoneMultiFactorAssertion)value).toList());
            } else {
                super.writeValue(stream, value);
            }
        }
    }

    public static interface FirebaseAuthUserHostApi {
        public void delete(@NonNull AuthPigeonFirebaseApp var1, @NonNull VoidResult var2);

        public void getIdToken(@NonNull AuthPigeonFirebaseApp var1, @NonNull Boolean var2, @NonNull Result<PigeonIdTokenResult> var3);

        public void linkWithCredential(@NonNull AuthPigeonFirebaseApp var1, @NonNull Map<String, Object> var2, @NonNull Result<PigeonUserCredential> var3);

        public void linkWithProvider(@NonNull AuthPigeonFirebaseApp var1, @NonNull PigeonSignInProvider var2, @NonNull Result<PigeonUserCredential> var3);

        public void reauthenticateWithCredential(@NonNull AuthPigeonFirebaseApp var1, @NonNull Map<String, Object> var2, @NonNull Result<PigeonUserCredential> var3);

        public void reauthenticateWithProvider(@NonNull AuthPigeonFirebaseApp var1, @NonNull PigeonSignInProvider var2, @NonNull Result<PigeonUserCredential> var3);

        public void reload(@NonNull AuthPigeonFirebaseApp var1, @NonNull Result<PigeonUserDetails> var2);

        public void sendEmailVerification(@NonNull AuthPigeonFirebaseApp var1, @Nullable PigeonActionCodeSettings var2, @NonNull VoidResult var3);

        public void unlink(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @NonNull Result<PigeonUserCredential> var3);

        public void updateEmail(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @NonNull Result<PigeonUserDetails> var3);

        public void updatePassword(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @NonNull Result<PigeonUserDetails> var3);

        public void updatePhoneNumber(@NonNull AuthPigeonFirebaseApp var1, @NonNull Map<String, Object> var2, @NonNull Result<PigeonUserDetails> var3);

        public void updateProfile(@NonNull AuthPigeonFirebaseApp var1, @NonNull PigeonUserProfile var2, @NonNull Result<PigeonUserDetails> var3);

        public void verifyBeforeUpdateEmail(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @Nullable PigeonActionCodeSettings var3, @NonNull VoidResult var4);

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return FirebaseAuthUserHostApiCodec.INSTANCE;
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable FirebaseAuthUserHostApi api) {
            FirebaseAuthUserHostApi.setUp(binaryMessenger, "", api);
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable FirebaseAuthUserHostApi api) {
            messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthUserHostApi.delete" + messageChannelSuffix, FirebaseAuthUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.delete(appArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthUserHostApi.getIdToken" + messageChannelSuffix, FirebaseAuthUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    Boolean forceRefreshArg = (Boolean)args.get(1);
                    Result<PigeonIdTokenResult> resultCallback = new Result<PigeonIdTokenResult>(){

                        @Override
                        public void success(PigeonIdTokenResult result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.getIdToken(appArg, forceRefreshArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthUserHostApi.linkWithCredential" + messageChannelSuffix, FirebaseAuthUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    Map inputArg = (Map)args.get(1);
                    Result<PigeonUserCredential> resultCallback = new Result<PigeonUserCredential>(){

                        @Override
                        public void success(PigeonUserCredential result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.linkWithCredential(appArg, inputArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthUserHostApi.linkWithProvider" + messageChannelSuffix, FirebaseAuthUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    PigeonSignInProvider signInProviderArg = (PigeonSignInProvider)args.get(1);
                    Result<PigeonUserCredential> resultCallback = new Result<PigeonUserCredential>(){

                        @Override
                        public void success(PigeonUserCredential result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.linkWithProvider(appArg, signInProviderArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthUserHostApi.reauthenticateWithCredential" + messageChannelSuffix, FirebaseAuthUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    Map inputArg = (Map)args.get(1);
                    Result<PigeonUserCredential> resultCallback = new Result<PigeonUserCredential>(){

                        @Override
                        public void success(PigeonUserCredential result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.reauthenticateWithCredential(appArg, inputArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthUserHostApi.reauthenticateWithProvider" + messageChannelSuffix, FirebaseAuthUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    PigeonSignInProvider signInProviderArg = (PigeonSignInProvider)args.get(1);
                    Result<PigeonUserCredential> resultCallback = new Result<PigeonUserCredential>(){

                        @Override
                        public void success(PigeonUserCredential result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.reauthenticateWithProvider(appArg, signInProviderArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthUserHostApi.reload" + messageChannelSuffix, FirebaseAuthUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    Result<PigeonUserDetails> resultCallback = new Result<PigeonUserDetails>(){

                        @Override
                        public void success(PigeonUserDetails result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.reload(appArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthUserHostApi.sendEmailVerification" + messageChannelSuffix, FirebaseAuthUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    PigeonActionCodeSettings actionCodeSettingsArg = (PigeonActionCodeSettings)args.get(1);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.sendEmailVerification(appArg, actionCodeSettingsArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthUserHostApi.unlink" + messageChannelSuffix, FirebaseAuthUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String providerIdArg = (String)args.get(1);
                    Result<PigeonUserCredential> resultCallback = new Result<PigeonUserCredential>(){

                        @Override
                        public void success(PigeonUserCredential result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.unlink(appArg, providerIdArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthUserHostApi.updateEmail" + messageChannelSuffix, FirebaseAuthUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String newEmailArg = (String)args.get(1);
                    Result<PigeonUserDetails> resultCallback = new Result<PigeonUserDetails>(){

                        @Override
                        public void success(PigeonUserDetails result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.updateEmail(appArg, newEmailArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthUserHostApi.updatePassword" + messageChannelSuffix, FirebaseAuthUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String newPasswordArg = (String)args.get(1);
                    Result<PigeonUserDetails> resultCallback = new Result<PigeonUserDetails>(){

                        @Override
                        public void success(PigeonUserDetails result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.updatePassword(appArg, newPasswordArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthUserHostApi.updatePhoneNumber" + messageChannelSuffix, FirebaseAuthUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    Map inputArg = (Map)args.get(1);
                    Result<PigeonUserDetails> resultCallback = new Result<PigeonUserDetails>(){

                        @Override
                        public void success(PigeonUserDetails result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.updatePhoneNumber(appArg, inputArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthUserHostApi.updateProfile" + messageChannelSuffix, FirebaseAuthUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    PigeonUserProfile profileArg = (PigeonUserProfile)args.get(1);
                    Result<PigeonUserDetails> resultCallback = new Result<PigeonUserDetails>(){

                        @Override
                        public void success(PigeonUserDetails result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.updateProfile(appArg, profileArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthUserHostApi.verifyBeforeUpdateEmail" + messageChannelSuffix, FirebaseAuthUserHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String newEmailArg = (String)args.get(1);
                    PigeonActionCodeSettings actionCodeSettingsArg = (PigeonActionCodeSettings)args.get(2);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.verifyBeforeUpdateEmail(appArg, newEmailArg, actionCodeSettingsArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    private static class FirebaseAuthUserHostApiCodec
    extends StandardMessageCodec {
        public static final FirebaseAuthUserHostApiCodec INSTANCE = new FirebaseAuthUserHostApiCodec();

        private FirebaseAuthUserHostApiCodec() {
        }

        protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
            switch (type) {
                case -128: {
                    return AuthPigeonFirebaseApp.fromList((ArrayList)this.readValue(buffer));
                }
                case -127: {
                    return PigeonActionCodeInfo.fromList((ArrayList)this.readValue(buffer));
                }
                case -126: {
                    return PigeonActionCodeInfoData.fromList((ArrayList)this.readValue(buffer));
                }
                case -125: {
                    return PigeonActionCodeSettings.fromList((ArrayList)this.readValue(buffer));
                }
                case -124: {
                    return PigeonAdditionalUserInfo.fromList((ArrayList)this.readValue(buffer));
                }
                case -123: {
                    return PigeonAuthCredential.fromList((ArrayList)this.readValue(buffer));
                }
                case -122: {
                    return PigeonFirebaseAuthSettings.fromList((ArrayList)this.readValue(buffer));
                }
                case -121: {
                    return PigeonIdTokenResult.fromList((ArrayList)this.readValue(buffer));
                }
                case -120: {
                    return PigeonMultiFactorInfo.fromList((ArrayList)this.readValue(buffer));
                }
                case -119: {
                    return PigeonMultiFactorSession.fromList((ArrayList)this.readValue(buffer));
                }
                case -118: {
                    return PigeonPhoneMultiFactorAssertion.fromList((ArrayList)this.readValue(buffer));
                }
                case -117: {
                    return PigeonSignInProvider.fromList((ArrayList)this.readValue(buffer));
                }
                case -116: {
                    return PigeonTotpSecret.fromList((ArrayList)this.readValue(buffer));
                }
                case -115: {
                    return PigeonUserCredential.fromList((ArrayList)this.readValue(buffer));
                }
                case -114: {
                    return PigeonUserDetails.fromList((ArrayList)this.readValue(buffer));
                }
                case -113: {
                    return PigeonUserInfo.fromList((ArrayList)this.readValue(buffer));
                }
                case -112: {
                    return PigeonUserProfile.fromList((ArrayList)this.readValue(buffer));
                }
                case -111: {
                    return PigeonVerifyPhoneNumberRequest.fromList((ArrayList)this.readValue(buffer));
                }
            }
            return super.readValueOfType(type, buffer);
        }

        protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
            if (value instanceof AuthPigeonFirebaseApp) {
                stream.write(128);
                this.writeValue(stream, ((AuthPigeonFirebaseApp)value).toList());
            } else if (value instanceof PigeonActionCodeInfo) {
                stream.write(129);
                this.writeValue(stream, ((PigeonActionCodeInfo)value).toList());
            } else if (value instanceof PigeonActionCodeInfoData) {
                stream.write(130);
                this.writeValue(stream, ((PigeonActionCodeInfoData)value).toList());
            } else if (value instanceof PigeonActionCodeSettings) {
                stream.write(131);
                this.writeValue(stream, ((PigeonActionCodeSettings)value).toList());
            } else if (value instanceof PigeonAdditionalUserInfo) {
                stream.write(132);
                this.writeValue(stream, ((PigeonAdditionalUserInfo)value).toList());
            } else if (value instanceof PigeonAuthCredential) {
                stream.write(133);
                this.writeValue(stream, ((PigeonAuthCredential)value).toList());
            } else if (value instanceof PigeonFirebaseAuthSettings) {
                stream.write(134);
                this.writeValue(stream, ((PigeonFirebaseAuthSettings)value).toList());
            } else if (value instanceof PigeonIdTokenResult) {
                stream.write(135);
                this.writeValue(stream, ((PigeonIdTokenResult)value).toList());
            } else if (value instanceof PigeonMultiFactorInfo) {
                stream.write(136);
                this.writeValue(stream, ((PigeonMultiFactorInfo)value).toList());
            } else if (value instanceof PigeonMultiFactorSession) {
                stream.write(137);
                this.writeValue(stream, ((PigeonMultiFactorSession)value).toList());
            } else if (value instanceof PigeonPhoneMultiFactorAssertion) {
                stream.write(138);
                this.writeValue(stream, ((PigeonPhoneMultiFactorAssertion)value).toList());
            } else if (value instanceof PigeonSignInProvider) {
                stream.write(139);
                this.writeValue(stream, ((PigeonSignInProvider)value).toList());
            } else if (value instanceof PigeonTotpSecret) {
                stream.write(140);
                this.writeValue(stream, ((PigeonTotpSecret)value).toList());
            } else if (value instanceof PigeonUserCredential) {
                stream.write(141);
                this.writeValue(stream, ((PigeonUserCredential)value).toList());
            } else if (value instanceof PigeonUserDetails) {
                stream.write(142);
                this.writeValue(stream, ((PigeonUserDetails)value).toList());
            } else if (value instanceof PigeonUserInfo) {
                stream.write(143);
                this.writeValue(stream, ((PigeonUserInfo)value).toList());
            } else if (value instanceof PigeonUserProfile) {
                stream.write(144);
                this.writeValue(stream, ((PigeonUserProfile)value).toList());
            } else if (value instanceof PigeonVerifyPhoneNumberRequest) {
                stream.write(145);
                this.writeValue(stream, ((PigeonVerifyPhoneNumberRequest)value).toList());
            } else {
                super.writeValue(stream, value);
            }
        }
    }

    public static interface FirebaseAuthHostApi {
        public void registerIdTokenListener(@NonNull AuthPigeonFirebaseApp var1, @NonNull Result<String> var2);

        public void registerAuthStateListener(@NonNull AuthPigeonFirebaseApp var1, @NonNull Result<String> var2);

        public void useEmulator(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @NonNull Long var3, @NonNull VoidResult var4);

        public void applyActionCode(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @NonNull VoidResult var3);

        public void checkActionCode(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @NonNull Result<PigeonActionCodeInfo> var3);

        public void confirmPasswordReset(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @NonNull String var3, @NonNull VoidResult var4);

        public void createUserWithEmailAndPassword(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @NonNull String var3, @NonNull Result<PigeonUserCredential> var4);

        public void signInAnonymously(@NonNull AuthPigeonFirebaseApp var1, @NonNull Result<PigeonUserCredential> var2);

        public void signInWithCredential(@NonNull AuthPigeonFirebaseApp var1, @NonNull Map<String, Object> var2, @NonNull Result<PigeonUserCredential> var3);

        public void signInWithCustomToken(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @NonNull Result<PigeonUserCredential> var3);

        public void signInWithEmailAndPassword(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @NonNull String var3, @NonNull Result<PigeonUserCredential> var4);

        public void signInWithEmailLink(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @NonNull String var3, @NonNull Result<PigeonUserCredential> var4);

        public void signInWithProvider(@NonNull AuthPigeonFirebaseApp var1, @NonNull PigeonSignInProvider var2, @NonNull Result<PigeonUserCredential> var3);

        public void signOut(@NonNull AuthPigeonFirebaseApp var1, @NonNull VoidResult var2);

        public void fetchSignInMethodsForEmail(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @NonNull Result<List<String>> var3);

        public void sendPasswordResetEmail(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @Nullable PigeonActionCodeSettings var3, @NonNull VoidResult var4);

        public void sendSignInLinkToEmail(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @NonNull PigeonActionCodeSettings var3, @NonNull VoidResult var4);

        public void setLanguageCode(@NonNull AuthPigeonFirebaseApp var1, @Nullable String var2, @NonNull Result<String> var3);

        public void setSettings(@NonNull AuthPigeonFirebaseApp var1, @NonNull PigeonFirebaseAuthSettings var2, @NonNull VoidResult var3);

        public void verifyPasswordResetCode(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @NonNull Result<String> var3);

        public void verifyPhoneNumber(@NonNull AuthPigeonFirebaseApp var1, @NonNull PigeonVerifyPhoneNumberRequest var2, @NonNull Result<String> var3);

        public void revokeTokenWithAuthorizationCode(@NonNull AuthPigeonFirebaseApp var1, @NonNull String var2, @NonNull VoidResult var3);

        public void initializeRecaptchaConfig(@NonNull AuthPigeonFirebaseApp var1, @NonNull VoidResult var2);

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return FirebaseAuthHostApiCodec.INSTANCE;
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable FirebaseAuthHostApi api) {
            FirebaseAuthHostApi.setUp(binaryMessenger, "", api);
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable FirebaseAuthHostApi api) {
            messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.registerIdTokenListener" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.registerIdTokenListener(appArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.registerAuthStateListener" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.registerAuthStateListener(appArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.useEmulator" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String hostArg = (String)args.get(1);
                    Number portArg = (Number)args.get(2);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.useEmulator(appArg, hostArg, portArg == null ? null : Long.valueOf(portArg.longValue()), resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.applyActionCode" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String codeArg = (String)args.get(1);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.applyActionCode(appArg, codeArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.checkActionCode" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String codeArg = (String)args.get(1);
                    Result<PigeonActionCodeInfo> resultCallback = new Result<PigeonActionCodeInfo>(){

                        @Override
                        public void success(PigeonActionCodeInfo result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.checkActionCode(appArg, codeArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.confirmPasswordReset" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String codeArg = (String)args.get(1);
                    String newPasswordArg = (String)args.get(2);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.confirmPasswordReset(appArg, codeArg, newPasswordArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.createUserWithEmailAndPassword" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String emailArg = (String)args.get(1);
                    String passwordArg = (String)args.get(2);
                    Result<PigeonUserCredential> resultCallback = new Result<PigeonUserCredential>(){

                        @Override
                        public void success(PigeonUserCredential result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.createUserWithEmailAndPassword(appArg, emailArg, passwordArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.signInAnonymously" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    Result<PigeonUserCredential> resultCallback = new Result<PigeonUserCredential>(){

                        @Override
                        public void success(PigeonUserCredential result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.signInAnonymously(appArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.signInWithCredential" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    Map inputArg = (Map)args.get(1);
                    Result<PigeonUserCredential> resultCallback = new Result<PigeonUserCredential>(){

                        @Override
                        public void success(PigeonUserCredential result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.signInWithCredential(appArg, inputArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.signInWithCustomToken" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String tokenArg = (String)args.get(1);
                    Result<PigeonUserCredential> resultCallback = new Result<PigeonUserCredential>(){

                        @Override
                        public void success(PigeonUserCredential result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.signInWithCustomToken(appArg, tokenArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.signInWithEmailAndPassword" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String emailArg = (String)args.get(1);
                    String passwordArg = (String)args.get(2);
                    Result<PigeonUserCredential> resultCallback = new Result<PigeonUserCredential>(){

                        @Override
                        public void success(PigeonUserCredential result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.signInWithEmailAndPassword(appArg, emailArg, passwordArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.signInWithEmailLink" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String emailArg = (String)args.get(1);
                    String emailLinkArg = (String)args.get(2);
                    Result<PigeonUserCredential> resultCallback = new Result<PigeonUserCredential>(){

                        @Override
                        public void success(PigeonUserCredential result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.signInWithEmailLink(appArg, emailArg, emailLinkArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.signInWithProvider" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    PigeonSignInProvider signInProviderArg = (PigeonSignInProvider)args.get(1);
                    Result<PigeonUserCredential> resultCallback = new Result<PigeonUserCredential>(){

                        @Override
                        public void success(PigeonUserCredential result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.signInWithProvider(appArg, signInProviderArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.signOut" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.signOut(appArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.fetchSignInMethodsForEmail" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String emailArg = (String)args.get(1);
                    Result<List<String>> resultCallback = new Result<List<String>>(){

                        @Override
                        public void success(List<String> result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.fetchSignInMethodsForEmail(appArg, emailArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.sendPasswordResetEmail" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String emailArg = (String)args.get(1);
                    PigeonActionCodeSettings actionCodeSettingsArg = (PigeonActionCodeSettings)args.get(2);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.sendPasswordResetEmail(appArg, emailArg, actionCodeSettingsArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.sendSignInLinkToEmail" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String emailArg = (String)args.get(1);
                    PigeonActionCodeSettings actionCodeSettingsArg = (PigeonActionCodeSettings)args.get(2);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.sendSignInLinkToEmail(appArg, emailArg, actionCodeSettingsArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.setLanguageCode" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String languageCodeArg = (String)args.get(1);
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.setLanguageCode(appArg, languageCodeArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.setSettings" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    PigeonFirebaseAuthSettings settingsArg = (PigeonFirebaseAuthSettings)args.get(1);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.setSettings(appArg, settingsArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.verifyPasswordResetCode" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String codeArg = (String)args.get(1);
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.verifyPasswordResetCode(appArg, codeArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.verifyPhoneNumber" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    PigeonVerifyPhoneNumberRequest requestArg = (PigeonVerifyPhoneNumberRequest)args.get(1);
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.verifyPhoneNumber(appArg, requestArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.revokeTokenWithAuthorizationCode" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    String authorizationCodeArg = (String)args.get(1);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.revokeTokenWithAuthorizationCode(appArg, authorizationCodeArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_auth_platform_interface.FirebaseAuthHostApi.initializeRecaptchaConfig" + messageChannelSuffix, FirebaseAuthHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    AuthPigeonFirebaseApp appArg = (AuthPigeonFirebaseApp)args.get(0);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseAuth.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.initializeRecaptchaConfig(appArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    private static class FirebaseAuthHostApiCodec
    extends StandardMessageCodec {
        public static final FirebaseAuthHostApiCodec INSTANCE = new FirebaseAuthHostApiCodec();

        private FirebaseAuthHostApiCodec() {
        }

        protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
            switch (type) {
                case -128: {
                    return AuthPigeonFirebaseApp.fromList((ArrayList)this.readValue(buffer));
                }
                case -127: {
                    return PigeonActionCodeInfo.fromList((ArrayList)this.readValue(buffer));
                }
                case -126: {
                    return PigeonActionCodeInfoData.fromList((ArrayList)this.readValue(buffer));
                }
                case -125: {
                    return PigeonActionCodeSettings.fromList((ArrayList)this.readValue(buffer));
                }
                case -124: {
                    return PigeonAdditionalUserInfo.fromList((ArrayList)this.readValue(buffer));
                }
                case -123: {
                    return PigeonAuthCredential.fromList((ArrayList)this.readValue(buffer));
                }
                case -122: {
                    return PigeonFirebaseAuthSettings.fromList((ArrayList)this.readValue(buffer));
                }
                case -121: {
                    return PigeonIdTokenResult.fromList((ArrayList)this.readValue(buffer));
                }
                case -120: {
                    return PigeonMultiFactorInfo.fromList((ArrayList)this.readValue(buffer));
                }
                case -119: {
                    return PigeonMultiFactorSession.fromList((ArrayList)this.readValue(buffer));
                }
                case -118: {
                    return PigeonPhoneMultiFactorAssertion.fromList((ArrayList)this.readValue(buffer));
                }
                case -117: {
                    return PigeonSignInProvider.fromList((ArrayList)this.readValue(buffer));
                }
                case -116: {
                    return PigeonTotpSecret.fromList((ArrayList)this.readValue(buffer));
                }
                case -115: {
                    return PigeonUserCredential.fromList((ArrayList)this.readValue(buffer));
                }
                case -114: {
                    return PigeonUserDetails.fromList((ArrayList)this.readValue(buffer));
                }
                case -113: {
                    return PigeonUserInfo.fromList((ArrayList)this.readValue(buffer));
                }
                case -112: {
                    return PigeonUserProfile.fromList((ArrayList)this.readValue(buffer));
                }
                case -111: {
                    return PigeonVerifyPhoneNumberRequest.fromList((ArrayList)this.readValue(buffer));
                }
            }
            return super.readValueOfType(type, buffer);
        }

        protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
            if (value instanceof AuthPigeonFirebaseApp) {
                stream.write(128);
                this.writeValue(stream, ((AuthPigeonFirebaseApp)value).toList());
            } else if (value instanceof PigeonActionCodeInfo) {
                stream.write(129);
                this.writeValue(stream, ((PigeonActionCodeInfo)value).toList());
            } else if (value instanceof PigeonActionCodeInfoData) {
                stream.write(130);
                this.writeValue(stream, ((PigeonActionCodeInfoData)value).toList());
            } else if (value instanceof PigeonActionCodeSettings) {
                stream.write(131);
                this.writeValue(stream, ((PigeonActionCodeSettings)value).toList());
            } else if (value instanceof PigeonAdditionalUserInfo) {
                stream.write(132);
                this.writeValue(stream, ((PigeonAdditionalUserInfo)value).toList());
            } else if (value instanceof PigeonAuthCredential) {
                stream.write(133);
                this.writeValue(stream, ((PigeonAuthCredential)value).toList());
            } else if (value instanceof PigeonFirebaseAuthSettings) {
                stream.write(134);
                this.writeValue(stream, ((PigeonFirebaseAuthSettings)value).toList());
            } else if (value instanceof PigeonIdTokenResult) {
                stream.write(135);
                this.writeValue(stream, ((PigeonIdTokenResult)value).toList());
            } else if (value instanceof PigeonMultiFactorInfo) {
                stream.write(136);
                this.writeValue(stream, ((PigeonMultiFactorInfo)value).toList());
            } else if (value instanceof PigeonMultiFactorSession) {
                stream.write(137);
                this.writeValue(stream, ((PigeonMultiFactorSession)value).toList());
            } else if (value instanceof PigeonPhoneMultiFactorAssertion) {
                stream.write(138);
                this.writeValue(stream, ((PigeonPhoneMultiFactorAssertion)value).toList());
            } else if (value instanceof PigeonSignInProvider) {
                stream.write(139);
                this.writeValue(stream, ((PigeonSignInProvider)value).toList());
            } else if (value instanceof PigeonTotpSecret) {
                stream.write(140);
                this.writeValue(stream, ((PigeonTotpSecret)value).toList());
            } else if (value instanceof PigeonUserCredential) {
                stream.write(141);
                this.writeValue(stream, ((PigeonUserCredential)value).toList());
            } else if (value instanceof PigeonUserDetails) {
                stream.write(142);
                this.writeValue(stream, ((PigeonUserDetails)value).toList());
            } else if (value instanceof PigeonUserInfo) {
                stream.write(143);
                this.writeValue(stream, ((PigeonUserInfo)value).toList());
            } else if (value instanceof PigeonUserProfile) {
                stream.write(144);
                this.writeValue(stream, ((PigeonUserProfile)value).toList());
            } else if (value instanceof PigeonVerifyPhoneNumberRequest) {
                stream.write(145);
                this.writeValue(stream, ((PigeonVerifyPhoneNumberRequest)value).toList());
            } else {
                super.writeValue(stream, value);
            }
        }
    }

    public static interface VoidResult {
        public void success();

        public void error(@NonNull Throwable var1);
    }

    public static interface NullableResult<T> {
        public void success(@Nullable T var1);

        public void error(@NonNull Throwable var1);
    }

    public static interface Result<T> {
        public void success(@NonNull T var1);

        public void error(@NonNull Throwable var1);
    }

    public static final class PigeonTotpSecret {
        @Nullable
        private Long codeIntervalSeconds;
        @Nullable
        private Long codeLength;
        @Nullable
        private Long enrollmentCompletionDeadline;
        @Nullable
        private String hashingAlgorithm;
        @NonNull
        private String secretKey;

        @Nullable
        public Long getCodeIntervalSeconds() {
            return this.codeIntervalSeconds;
        }

        public void setCodeIntervalSeconds(@Nullable Long setterArg) {
            this.codeIntervalSeconds = setterArg;
        }

        @Nullable
        public Long getCodeLength() {
            return this.codeLength;
        }

        public void setCodeLength(@Nullable Long setterArg) {
            this.codeLength = setterArg;
        }

        @Nullable
        public Long getEnrollmentCompletionDeadline() {
            return this.enrollmentCompletionDeadline;
        }

        public void setEnrollmentCompletionDeadline(@Nullable Long setterArg) {
            this.enrollmentCompletionDeadline = setterArg;
        }

        @Nullable
        public String getHashingAlgorithm() {
            return this.hashingAlgorithm;
        }

        public void setHashingAlgorithm(@Nullable String setterArg) {
            this.hashingAlgorithm = setterArg;
        }

        @NonNull
        public String getSecretKey() {
            return this.secretKey;
        }

        public void setSecretKey(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"secretKey\" is null.");
            }
            this.secretKey = setterArg;
        }

        PigeonTotpSecret() {
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(5);
            toListResult.add(this.codeIntervalSeconds);
            toListResult.add(this.codeLength);
            toListResult.add(this.enrollmentCompletionDeadline);
            toListResult.add(this.hashingAlgorithm);
            toListResult.add(this.secretKey);
            return toListResult;
        }

        @NonNull
        static PigeonTotpSecret fromList(@NonNull ArrayList<Object> __pigeon_list) {
            PigeonTotpSecret pigeonResult = new PigeonTotpSecret();
            Object codeIntervalSeconds = __pigeon_list.get(0);
            pigeonResult.setCodeIntervalSeconds(codeIntervalSeconds == null ? null : Long.valueOf(codeIntervalSeconds instanceof Integer ? (long)((Integer)codeIntervalSeconds).intValue() : (Long)codeIntervalSeconds));
            Object codeLength = __pigeon_list.get(1);
            pigeonResult.setCodeLength(codeLength == null ? null : Long.valueOf(codeLength instanceof Integer ? (long)((Integer)codeLength).intValue() : (Long)codeLength));
            Object enrollmentCompletionDeadline = __pigeon_list.get(2);
            pigeonResult.setEnrollmentCompletionDeadline(enrollmentCompletionDeadline == null ? null : Long.valueOf(enrollmentCompletionDeadline instanceof Integer ? (long)((Integer)enrollmentCompletionDeadline).intValue() : (Long)enrollmentCompletionDeadline));
            Object hashingAlgorithm = __pigeon_list.get(3);
            pigeonResult.setHashingAlgorithm((String)hashingAlgorithm);
            Object secretKey = __pigeon_list.get(4);
            pigeonResult.setSecretKey((String)secretKey);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Long codeIntervalSeconds;
            @Nullable
            private Long codeLength;
            @Nullable
            private Long enrollmentCompletionDeadline;
            @Nullable
            private String hashingAlgorithm;
            @Nullable
            private String secretKey;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCodeIntervalSeconds(@Nullable Long setterArg) {
                this.codeIntervalSeconds = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCodeLength(@Nullable Long setterArg) {
                this.codeLength = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setEnrollmentCompletionDeadline(@Nullable Long setterArg) {
                this.enrollmentCompletionDeadline = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setHashingAlgorithm(@Nullable String setterArg) {
                this.hashingAlgorithm = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setSecretKey(@NonNull String setterArg) {
                this.secretKey = setterArg;
                return this;
            }

            @NonNull
            public PigeonTotpSecret build() {
                PigeonTotpSecret pigeonReturn = new PigeonTotpSecret();
                pigeonReturn.setCodeIntervalSeconds(this.codeIntervalSeconds);
                pigeonReturn.setCodeLength(this.codeLength);
                pigeonReturn.setEnrollmentCompletionDeadline(this.enrollmentCompletionDeadline);
                pigeonReturn.setHashingAlgorithm(this.hashingAlgorithm);
                pigeonReturn.setSecretKey(this.secretKey);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonUserProfile {
        @Nullable
        private String displayName;
        @Nullable
        private String photoUrl;
        @NonNull
        private Boolean displayNameChanged;
        @NonNull
        private Boolean photoUrlChanged;

        @Nullable
        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(@Nullable String setterArg) {
            this.displayName = setterArg;
        }

        @Nullable
        public String getPhotoUrl() {
            return this.photoUrl;
        }

        public void setPhotoUrl(@Nullable String setterArg) {
            this.photoUrl = setterArg;
        }

        @NonNull
        public Boolean getDisplayNameChanged() {
            return this.displayNameChanged;
        }

        public void setDisplayNameChanged(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"displayNameChanged\" is null.");
            }
            this.displayNameChanged = setterArg;
        }

        @NonNull
        public Boolean getPhotoUrlChanged() {
            return this.photoUrlChanged;
        }

        public void setPhotoUrlChanged(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"photoUrlChanged\" is null.");
            }
            this.photoUrlChanged = setterArg;
        }

        PigeonUserProfile() {
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(4);
            toListResult.add(this.displayName);
            toListResult.add(this.photoUrl);
            toListResult.add(this.displayNameChanged);
            toListResult.add(this.photoUrlChanged);
            return toListResult;
        }

        @NonNull
        static PigeonUserProfile fromList(@NonNull ArrayList<Object> __pigeon_list) {
            PigeonUserProfile pigeonResult = new PigeonUserProfile();
            Object displayName = __pigeon_list.get(0);
            pigeonResult.setDisplayName((String)displayName);
            Object photoUrl = __pigeon_list.get(1);
            pigeonResult.setPhotoUrl((String)photoUrl);
            Object displayNameChanged = __pigeon_list.get(2);
            pigeonResult.setDisplayNameChanged((Boolean)displayNameChanged);
            Object photoUrlChanged = __pigeon_list.get(3);
            pigeonResult.setPhotoUrlChanged((Boolean)photoUrlChanged);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String displayName;
            @Nullable
            private String photoUrl;
            @Nullable
            private Boolean displayNameChanged;
            @Nullable
            private Boolean photoUrlChanged;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setDisplayName(@Nullable String setterArg) {
                this.displayName = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPhotoUrl(@Nullable String setterArg) {
                this.photoUrl = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setDisplayNameChanged(@NonNull Boolean setterArg) {
                this.displayNameChanged = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPhotoUrlChanged(@NonNull Boolean setterArg) {
                this.photoUrlChanged = setterArg;
                return this;
            }

            @NonNull
            public PigeonUserProfile build() {
                PigeonUserProfile pigeonReturn = new PigeonUserProfile();
                pigeonReturn.setDisplayName(this.displayName);
                pigeonReturn.setPhotoUrl(this.photoUrl);
                pigeonReturn.setDisplayNameChanged(this.displayNameChanged);
                pigeonReturn.setPhotoUrlChanged(this.photoUrlChanged);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonIdTokenResult {
        @Nullable
        private String token;
        @Nullable
        private Long expirationTimestamp;
        @Nullable
        private Long authTimestamp;
        @Nullable
        private Long issuedAtTimestamp;
        @Nullable
        private String signInProvider;
        @Nullable
        private Map<String, Object> claims;
        @Nullable
        private String signInSecondFactor;

        @Nullable
        public String getToken() {
            return this.token;
        }

        public void setToken(@Nullable String setterArg) {
            this.token = setterArg;
        }

        @Nullable
        public Long getExpirationTimestamp() {
            return this.expirationTimestamp;
        }

        public void setExpirationTimestamp(@Nullable Long setterArg) {
            this.expirationTimestamp = setterArg;
        }

        @Nullable
        public Long getAuthTimestamp() {
            return this.authTimestamp;
        }

        public void setAuthTimestamp(@Nullable Long setterArg) {
            this.authTimestamp = setterArg;
        }

        @Nullable
        public Long getIssuedAtTimestamp() {
            return this.issuedAtTimestamp;
        }

        public void setIssuedAtTimestamp(@Nullable Long setterArg) {
            this.issuedAtTimestamp = setterArg;
        }

        @Nullable
        public String getSignInProvider() {
            return this.signInProvider;
        }

        public void setSignInProvider(@Nullable String setterArg) {
            this.signInProvider = setterArg;
        }

        @Nullable
        public Map<String, Object> getClaims() {
            return this.claims;
        }

        public void setClaims(@Nullable Map<String, Object> setterArg) {
            this.claims = setterArg;
        }

        @Nullable
        public String getSignInSecondFactor() {
            return this.signInSecondFactor;
        }

        public void setSignInSecondFactor(@Nullable String setterArg) {
            this.signInSecondFactor = setterArg;
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(7);
            toListResult.add(this.token);
            toListResult.add(this.expirationTimestamp);
            toListResult.add(this.authTimestamp);
            toListResult.add(this.issuedAtTimestamp);
            toListResult.add(this.signInProvider);
            toListResult.add(this.claims);
            toListResult.add(this.signInSecondFactor);
            return toListResult;
        }

        @NonNull
        static PigeonIdTokenResult fromList(@NonNull ArrayList<Object> __pigeon_list) {
            PigeonIdTokenResult pigeonResult = new PigeonIdTokenResult();
            Object token = __pigeon_list.get(0);
            pigeonResult.setToken((String)token);
            Object expirationTimestamp = __pigeon_list.get(1);
            pigeonResult.setExpirationTimestamp(expirationTimestamp == null ? null : Long.valueOf(expirationTimestamp instanceof Integer ? (long)((Integer)expirationTimestamp).intValue() : (Long)expirationTimestamp));
            Object authTimestamp = __pigeon_list.get(2);
            pigeonResult.setAuthTimestamp(authTimestamp == null ? null : Long.valueOf(authTimestamp instanceof Integer ? (long)((Integer)authTimestamp).intValue() : (Long)authTimestamp));
            Object issuedAtTimestamp = __pigeon_list.get(3);
            pigeonResult.setIssuedAtTimestamp(issuedAtTimestamp == null ? null : Long.valueOf(issuedAtTimestamp instanceof Integer ? (long)((Integer)issuedAtTimestamp).intValue() : (Long)issuedAtTimestamp));
            Object signInProvider = __pigeon_list.get(4);
            pigeonResult.setSignInProvider((String)signInProvider);
            Object claims = __pigeon_list.get(5);
            pigeonResult.setClaims((Map)claims);
            Object signInSecondFactor = __pigeon_list.get(6);
            pigeonResult.setSignInSecondFactor((String)signInSecondFactor);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String token;
            @Nullable
            private Long expirationTimestamp;
            @Nullable
            private Long authTimestamp;
            @Nullable
            private Long issuedAtTimestamp;
            @Nullable
            private String signInProvider;
            @Nullable
            private Map<String, Object> claims;
            @Nullable
            private String signInSecondFactor;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setToken(@Nullable String setterArg) {
                this.token = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setExpirationTimestamp(@Nullable Long setterArg) {
                this.expirationTimestamp = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAuthTimestamp(@Nullable Long setterArg) {
                this.authTimestamp = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setIssuedAtTimestamp(@Nullable Long setterArg) {
                this.issuedAtTimestamp = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setSignInProvider(@Nullable String setterArg) {
                this.signInProvider = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setClaims(@Nullable Map<String, Object> setterArg) {
                this.claims = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setSignInSecondFactor(@Nullable String setterArg) {
                this.signInSecondFactor = setterArg;
                return this;
            }

            @NonNull
            public PigeonIdTokenResult build() {
                PigeonIdTokenResult pigeonReturn = new PigeonIdTokenResult();
                pigeonReturn.setToken(this.token);
                pigeonReturn.setExpirationTimestamp(this.expirationTimestamp);
                pigeonReturn.setAuthTimestamp(this.authTimestamp);
                pigeonReturn.setIssuedAtTimestamp(this.issuedAtTimestamp);
                pigeonReturn.setSignInProvider(this.signInProvider);
                pigeonReturn.setClaims(this.claims);
                pigeonReturn.setSignInSecondFactor(this.signInSecondFactor);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonVerifyPhoneNumberRequest {
        @Nullable
        private String phoneNumber;
        @NonNull
        private Long timeout;
        @Nullable
        private Long forceResendingToken;
        @Nullable
        private String autoRetrievedSmsCodeForTesting;
        @Nullable
        private String multiFactorInfoId;
        @Nullable
        private String multiFactorSessionId;

        @Nullable
        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public void setPhoneNumber(@Nullable String setterArg) {
            this.phoneNumber = setterArg;
        }

        @NonNull
        public Long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"timeout\" is null.");
            }
            this.timeout = setterArg;
        }

        @Nullable
        public Long getForceResendingToken() {
            return this.forceResendingToken;
        }

        public void setForceResendingToken(@Nullable Long setterArg) {
            this.forceResendingToken = setterArg;
        }

        @Nullable
        public String getAutoRetrievedSmsCodeForTesting() {
            return this.autoRetrievedSmsCodeForTesting;
        }

        public void setAutoRetrievedSmsCodeForTesting(@Nullable String setterArg) {
            this.autoRetrievedSmsCodeForTesting = setterArg;
        }

        @Nullable
        public String getMultiFactorInfoId() {
            return this.multiFactorInfoId;
        }

        public void setMultiFactorInfoId(@Nullable String setterArg) {
            this.multiFactorInfoId = setterArg;
        }

        @Nullable
        public String getMultiFactorSessionId() {
            return this.multiFactorSessionId;
        }

        public void setMultiFactorSessionId(@Nullable String setterArg) {
            this.multiFactorSessionId = setterArg;
        }

        PigeonVerifyPhoneNumberRequest() {
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(6);
            toListResult.add(this.phoneNumber);
            toListResult.add(this.timeout);
            toListResult.add(this.forceResendingToken);
            toListResult.add(this.autoRetrievedSmsCodeForTesting);
            toListResult.add(this.multiFactorInfoId);
            toListResult.add(this.multiFactorSessionId);
            return toListResult;
        }

        @NonNull
        static PigeonVerifyPhoneNumberRequest fromList(@NonNull ArrayList<Object> __pigeon_list) {
            PigeonVerifyPhoneNumberRequest pigeonResult = new PigeonVerifyPhoneNumberRequest();
            Object phoneNumber = __pigeon_list.get(0);
            pigeonResult.setPhoneNumber((String)phoneNumber);
            Object timeout = __pigeon_list.get(1);
            pigeonResult.setTimeout(timeout == null ? null : Long.valueOf(timeout instanceof Integer ? (long)((Integer)timeout).intValue() : (Long)timeout));
            Object forceResendingToken = __pigeon_list.get(2);
            pigeonResult.setForceResendingToken(forceResendingToken == null ? null : Long.valueOf(forceResendingToken instanceof Integer ? (long)((Integer)forceResendingToken).intValue() : (Long)forceResendingToken));
            Object autoRetrievedSmsCodeForTesting = __pigeon_list.get(3);
            pigeonResult.setAutoRetrievedSmsCodeForTesting((String)autoRetrievedSmsCodeForTesting);
            Object multiFactorInfoId = __pigeon_list.get(4);
            pigeonResult.setMultiFactorInfoId((String)multiFactorInfoId);
            Object multiFactorSessionId = __pigeon_list.get(5);
            pigeonResult.setMultiFactorSessionId((String)multiFactorSessionId);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String phoneNumber;
            @Nullable
            private Long timeout;
            @Nullable
            private Long forceResendingToken;
            @Nullable
            private String autoRetrievedSmsCodeForTesting;
            @Nullable
            private String multiFactorInfoId;
            @Nullable
            private String multiFactorSessionId;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPhoneNumber(@Nullable String setterArg) {
                this.phoneNumber = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setTimeout(@NonNull Long setterArg) {
                this.timeout = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setForceResendingToken(@Nullable Long setterArg) {
                this.forceResendingToken = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAutoRetrievedSmsCodeForTesting(@Nullable String setterArg) {
                this.autoRetrievedSmsCodeForTesting = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMultiFactorInfoId(@Nullable String setterArg) {
                this.multiFactorInfoId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMultiFactorSessionId(@Nullable String setterArg) {
                this.multiFactorSessionId = setterArg;
                return this;
            }

            @NonNull
            public PigeonVerifyPhoneNumberRequest build() {
                PigeonVerifyPhoneNumberRequest pigeonReturn = new PigeonVerifyPhoneNumberRequest();
                pigeonReturn.setPhoneNumber(this.phoneNumber);
                pigeonReturn.setTimeout(this.timeout);
                pigeonReturn.setForceResendingToken(this.forceResendingToken);
                pigeonReturn.setAutoRetrievedSmsCodeForTesting(this.autoRetrievedSmsCodeForTesting);
                pigeonReturn.setMultiFactorInfoId(this.multiFactorInfoId);
                pigeonReturn.setMultiFactorSessionId(this.multiFactorSessionId);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonSignInProvider {
        @NonNull
        private String providerId;
        @Nullable
        private List<String> scopes;
        @Nullable
        private Map<String, String> customParameters;

        @NonNull
        public String getProviderId() {
            return this.providerId;
        }

        public void setProviderId(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"providerId\" is null.");
            }
            this.providerId = setterArg;
        }

        @Nullable
        public List<String> getScopes() {
            return this.scopes;
        }

        public void setScopes(@Nullable List<String> setterArg) {
            this.scopes = setterArg;
        }

        @Nullable
        public Map<String, String> getCustomParameters() {
            return this.customParameters;
        }

        public void setCustomParameters(@Nullable Map<String, String> setterArg) {
            this.customParameters = setterArg;
        }

        PigeonSignInProvider() {
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add(this.providerId);
            toListResult.add(this.scopes);
            toListResult.add(this.customParameters);
            return toListResult;
        }

        @NonNull
        static PigeonSignInProvider fromList(@NonNull ArrayList<Object> __pigeon_list) {
            PigeonSignInProvider pigeonResult = new PigeonSignInProvider();
            Object providerId = __pigeon_list.get(0);
            pigeonResult.setProviderId((String)providerId);
            Object scopes = __pigeon_list.get(1);
            pigeonResult.setScopes((List)scopes);
            Object customParameters = __pigeon_list.get(2);
            pigeonResult.setCustomParameters((Map)customParameters);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String providerId;
            @Nullable
            private List<String> scopes;
            @Nullable
            private Map<String, String> customParameters;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setProviderId(@NonNull String setterArg) {
                this.providerId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setScopes(@Nullable List<String> setterArg) {
                this.scopes = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCustomParameters(@Nullable Map<String, String> setterArg) {
                this.customParameters = setterArg;
                return this;
            }

            @NonNull
            public PigeonSignInProvider build() {
                PigeonSignInProvider pigeonReturn = new PigeonSignInProvider();
                pigeonReturn.setProviderId(this.providerId);
                pigeonReturn.setScopes(this.scopes);
                pigeonReturn.setCustomParameters(this.customParameters);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonFirebaseAuthSettings {
        @NonNull
        private Boolean appVerificationDisabledForTesting;
        @Nullable
        private String userAccessGroup;
        @Nullable
        private String phoneNumber;
        @Nullable
        private String smsCode;
        @Nullable
        private Boolean forceRecaptchaFlow;

        @NonNull
        public Boolean getAppVerificationDisabledForTesting() {
            return this.appVerificationDisabledForTesting;
        }

        public void setAppVerificationDisabledForTesting(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"appVerificationDisabledForTesting\" is null.");
            }
            this.appVerificationDisabledForTesting = setterArg;
        }

        @Nullable
        public String getUserAccessGroup() {
            return this.userAccessGroup;
        }

        public void setUserAccessGroup(@Nullable String setterArg) {
            this.userAccessGroup = setterArg;
        }

        @Nullable
        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public void setPhoneNumber(@Nullable String setterArg) {
            this.phoneNumber = setterArg;
        }

        @Nullable
        public String getSmsCode() {
            return this.smsCode;
        }

        public void setSmsCode(@Nullable String setterArg) {
            this.smsCode = setterArg;
        }

        @Nullable
        public Boolean getForceRecaptchaFlow() {
            return this.forceRecaptchaFlow;
        }

        public void setForceRecaptchaFlow(@Nullable Boolean setterArg) {
            this.forceRecaptchaFlow = setterArg;
        }

        PigeonFirebaseAuthSettings() {
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(5);
            toListResult.add(this.appVerificationDisabledForTesting);
            toListResult.add(this.userAccessGroup);
            toListResult.add(this.phoneNumber);
            toListResult.add(this.smsCode);
            toListResult.add(this.forceRecaptchaFlow);
            return toListResult;
        }

        @NonNull
        static PigeonFirebaseAuthSettings fromList(@NonNull ArrayList<Object> __pigeon_list) {
            PigeonFirebaseAuthSettings pigeonResult = new PigeonFirebaseAuthSettings();
            Object appVerificationDisabledForTesting = __pigeon_list.get(0);
            pigeonResult.setAppVerificationDisabledForTesting((Boolean)appVerificationDisabledForTesting);
            Object userAccessGroup = __pigeon_list.get(1);
            pigeonResult.setUserAccessGroup((String)userAccessGroup);
            Object phoneNumber = __pigeon_list.get(2);
            pigeonResult.setPhoneNumber((String)phoneNumber);
            Object smsCode = __pigeon_list.get(3);
            pigeonResult.setSmsCode((String)smsCode);
            Object forceRecaptchaFlow = __pigeon_list.get(4);
            pigeonResult.setForceRecaptchaFlow((Boolean)forceRecaptchaFlow);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Boolean appVerificationDisabledForTesting;
            @Nullable
            private String userAccessGroup;
            @Nullable
            private String phoneNumber;
            @Nullable
            private String smsCode;
            @Nullable
            private Boolean forceRecaptchaFlow;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAppVerificationDisabledForTesting(@NonNull Boolean setterArg) {
                this.appVerificationDisabledForTesting = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setUserAccessGroup(@Nullable String setterArg) {
                this.userAccessGroup = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPhoneNumber(@Nullable String setterArg) {
                this.phoneNumber = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setSmsCode(@Nullable String setterArg) {
                this.smsCode = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setForceRecaptchaFlow(@Nullable Boolean setterArg) {
                this.forceRecaptchaFlow = setterArg;
                return this;
            }

            @NonNull
            public PigeonFirebaseAuthSettings build() {
                PigeonFirebaseAuthSettings pigeonReturn = new PigeonFirebaseAuthSettings();
                pigeonReturn.setAppVerificationDisabledForTesting(this.appVerificationDisabledForTesting);
                pigeonReturn.setUserAccessGroup(this.userAccessGroup);
                pigeonReturn.setPhoneNumber(this.phoneNumber);
                pigeonReturn.setSmsCode(this.smsCode);
                pigeonReturn.setForceRecaptchaFlow(this.forceRecaptchaFlow);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonActionCodeSettings {
        @NonNull
        private String url;
        @Nullable
        private String dynamicLinkDomain;
        @NonNull
        private Boolean handleCodeInApp;
        @Nullable
        private String iOSBundleId;
        @Nullable
        private String androidPackageName;
        @NonNull
        private Boolean androidInstallApp;
        @Nullable
        private String androidMinimumVersion;
        @Nullable
        private String linkDomain;

        @NonNull
        public String getUrl() {
            return this.url;
        }

        public void setUrl(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"url\" is null.");
            }
            this.url = setterArg;
        }

        @Nullable
        public String getDynamicLinkDomain() {
            return this.dynamicLinkDomain;
        }

        public void setDynamicLinkDomain(@Nullable String setterArg) {
            this.dynamicLinkDomain = setterArg;
        }

        @NonNull
        public Boolean getHandleCodeInApp() {
            return this.handleCodeInApp;
        }

        public void setHandleCodeInApp(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"handleCodeInApp\" is null.");
            }
            this.handleCodeInApp = setterArg;
        }

        @Nullable
        public String getIOSBundleId() {
            return this.iOSBundleId;
        }

        public void setIOSBundleId(@Nullable String setterArg) {
            this.iOSBundleId = setterArg;
        }

        @Nullable
        public String getAndroidPackageName() {
            return this.androidPackageName;
        }

        public void setAndroidPackageName(@Nullable String setterArg) {
            this.androidPackageName = setterArg;
        }

        @NonNull
        public Boolean getAndroidInstallApp() {
            return this.androidInstallApp;
        }

        public void setAndroidInstallApp(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"androidInstallApp\" is null.");
            }
            this.androidInstallApp = setterArg;
        }

        @Nullable
        public String getAndroidMinimumVersion() {
            return this.androidMinimumVersion;
        }

        public void setAndroidMinimumVersion(@Nullable String setterArg) {
            this.androidMinimumVersion = setterArg;
        }

        @Nullable
        public String getLinkDomain() {
            return this.linkDomain;
        }

        public void setLinkDomain(@Nullable String setterArg) {
            this.linkDomain = setterArg;
        }

        PigeonActionCodeSettings() {
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(8);
            toListResult.add(this.url);
            toListResult.add(this.dynamicLinkDomain);
            toListResult.add(this.handleCodeInApp);
            toListResult.add(this.iOSBundleId);
            toListResult.add(this.androidPackageName);
            toListResult.add(this.androidInstallApp);
            toListResult.add(this.androidMinimumVersion);
            toListResult.add(this.linkDomain);
            return toListResult;
        }

        @NonNull
        static PigeonActionCodeSettings fromList(@NonNull ArrayList<Object> __pigeon_list) {
            PigeonActionCodeSettings pigeonResult = new PigeonActionCodeSettings();
            Object url = __pigeon_list.get(0);
            pigeonResult.setUrl((String)url);
            Object dynamicLinkDomain = __pigeon_list.get(1);
            pigeonResult.setDynamicLinkDomain((String)dynamicLinkDomain);
            Object handleCodeInApp = __pigeon_list.get(2);
            pigeonResult.setHandleCodeInApp((Boolean)handleCodeInApp);
            Object iOSBundleId = __pigeon_list.get(3);
            pigeonResult.setIOSBundleId((String)iOSBundleId);
            Object androidPackageName = __pigeon_list.get(4);
            pigeonResult.setAndroidPackageName((String)androidPackageName);
            Object androidInstallApp = __pigeon_list.get(5);
            pigeonResult.setAndroidInstallApp((Boolean)androidInstallApp);
            Object androidMinimumVersion = __pigeon_list.get(6);
            pigeonResult.setAndroidMinimumVersion((String)androidMinimumVersion);
            Object linkDomain = __pigeon_list.get(7);
            pigeonResult.setLinkDomain((String)linkDomain);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String url;
            @Nullable
            private String dynamicLinkDomain;
            @Nullable
            private Boolean handleCodeInApp;
            @Nullable
            private String iOSBundleId;
            @Nullable
            private String androidPackageName;
            @Nullable
            private Boolean androidInstallApp;
            @Nullable
            private String androidMinimumVersion;
            @Nullable
            private String linkDomain;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setUrl(@NonNull String setterArg) {
                this.url = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setDynamicLinkDomain(@Nullable String setterArg) {
                this.dynamicLinkDomain = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setHandleCodeInApp(@NonNull Boolean setterArg) {
                this.handleCodeInApp = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setIOSBundleId(@Nullable String setterArg) {
                this.iOSBundleId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAndroidPackageName(@Nullable String setterArg) {
                this.androidPackageName = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAndroidInstallApp(@NonNull Boolean setterArg) {
                this.androidInstallApp = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAndroidMinimumVersion(@Nullable String setterArg) {
                this.androidMinimumVersion = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setLinkDomain(@Nullable String setterArg) {
                this.linkDomain = setterArg;
                return this;
            }

            @NonNull
            public PigeonActionCodeSettings build() {
                PigeonActionCodeSettings pigeonReturn = new PigeonActionCodeSettings();
                pigeonReturn.setUrl(this.url);
                pigeonReturn.setDynamicLinkDomain(this.dynamicLinkDomain);
                pigeonReturn.setHandleCodeInApp(this.handleCodeInApp);
                pigeonReturn.setIOSBundleId(this.iOSBundleId);
                pigeonReturn.setAndroidPackageName(this.androidPackageName);
                pigeonReturn.setAndroidInstallApp(this.androidInstallApp);
                pigeonReturn.setAndroidMinimumVersion(this.androidMinimumVersion);
                pigeonReturn.setLinkDomain(this.linkDomain);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonUserCredential {
        @Nullable
        private PigeonUserDetails user;
        @Nullable
        private PigeonAdditionalUserInfo additionalUserInfo;
        @Nullable
        private PigeonAuthCredential credential;

        @Nullable
        public PigeonUserDetails getUser() {
            return this.user;
        }

        public void setUser(@Nullable PigeonUserDetails setterArg) {
            this.user = setterArg;
        }

        @Nullable
        public PigeonAdditionalUserInfo getAdditionalUserInfo() {
            return this.additionalUserInfo;
        }

        public void setAdditionalUserInfo(@Nullable PigeonAdditionalUserInfo setterArg) {
            this.additionalUserInfo = setterArg;
        }

        @Nullable
        public PigeonAuthCredential getCredential() {
            return this.credential;
        }

        public void setCredential(@Nullable PigeonAuthCredential setterArg) {
            this.credential = setterArg;
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add(this.user);
            toListResult.add(this.additionalUserInfo);
            toListResult.add(this.credential);
            return toListResult;
        }

        @NonNull
        static PigeonUserCredential fromList(@NonNull ArrayList<Object> __pigeon_list) {
            PigeonUserCredential pigeonResult = new PigeonUserCredential();
            Object user = __pigeon_list.get(0);
            pigeonResult.setUser((PigeonUserDetails)user);
            Object additionalUserInfo = __pigeon_list.get(1);
            pigeonResult.setAdditionalUserInfo((PigeonAdditionalUserInfo)additionalUserInfo);
            Object credential = __pigeon_list.get(2);
            pigeonResult.setCredential((PigeonAuthCredential)credential);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private PigeonUserDetails user;
            @Nullable
            private PigeonAdditionalUserInfo additionalUserInfo;
            @Nullable
            private PigeonAuthCredential credential;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setUser(@Nullable PigeonUserDetails setterArg) {
                this.user = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAdditionalUserInfo(@Nullable PigeonAdditionalUserInfo setterArg) {
                this.additionalUserInfo = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCredential(@Nullable PigeonAuthCredential setterArg) {
                this.credential = setterArg;
                return this;
            }

            @NonNull
            public PigeonUserCredential build() {
                PigeonUserCredential pigeonReturn = new PigeonUserCredential();
                pigeonReturn.setUser(this.user);
                pigeonReturn.setAdditionalUserInfo(this.additionalUserInfo);
                pigeonReturn.setCredential(this.credential);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonUserDetails {
        @NonNull
        private PigeonUserInfo userInfo;
        @NonNull
        private List<Map<Object, Object>> providerData;

        @NonNull
        public PigeonUserInfo getUserInfo() {
            return this.userInfo;
        }

        public void setUserInfo(@NonNull PigeonUserInfo setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"userInfo\" is null.");
            }
            this.userInfo = setterArg;
        }

        @NonNull
        public List<Map<Object, Object>> getProviderData() {
            return this.providerData;
        }

        public void setProviderData(@NonNull List<Map<Object, Object>> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"providerData\" is null.");
            }
            this.providerData = setterArg;
        }

        PigeonUserDetails() {
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.userInfo);
            toListResult.add(this.providerData);
            return toListResult;
        }

        @NonNull
        static PigeonUserDetails fromList(@NonNull ArrayList<Object> __pigeon_list) {
            PigeonUserDetails pigeonResult = new PigeonUserDetails();
            Object userInfo = __pigeon_list.get(0);
            pigeonResult.setUserInfo((PigeonUserInfo)userInfo);
            Object providerData = __pigeon_list.get(1);
            pigeonResult.setProviderData((List)providerData);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private PigeonUserInfo userInfo;
            @Nullable
            private List<Map<Object, Object>> providerData;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setUserInfo(@NonNull PigeonUserInfo setterArg) {
                this.userInfo = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setProviderData(@NonNull List<Map<Object, Object>> setterArg) {
                this.providerData = setterArg;
                return this;
            }

            @NonNull
            public PigeonUserDetails build() {
                PigeonUserDetails pigeonReturn = new PigeonUserDetails();
                pigeonReturn.setUserInfo(this.userInfo);
                pigeonReturn.setProviderData(this.providerData);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonUserInfo {
        @NonNull
        private String uid;
        @Nullable
        private String email;
        @Nullable
        private String displayName;
        @Nullable
        private String photoUrl;
        @Nullable
        private String phoneNumber;
        @NonNull
        private Boolean isAnonymous;
        @NonNull
        private Boolean isEmailVerified;
        @Nullable
        private String providerId;
        @Nullable
        private String tenantId;
        @Nullable
        private String refreshToken;
        @Nullable
        private Long creationTimestamp;
        @Nullable
        private Long lastSignInTimestamp;

        @NonNull
        public String getUid() {
            return this.uid;
        }

        public void setUid(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"uid\" is null.");
            }
            this.uid = setterArg;
        }

        @Nullable
        public String getEmail() {
            return this.email;
        }

        public void setEmail(@Nullable String setterArg) {
            this.email = setterArg;
        }

        @Nullable
        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(@Nullable String setterArg) {
            this.displayName = setterArg;
        }

        @Nullable
        public String getPhotoUrl() {
            return this.photoUrl;
        }

        public void setPhotoUrl(@Nullable String setterArg) {
            this.photoUrl = setterArg;
        }

        @Nullable
        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public void setPhoneNumber(@Nullable String setterArg) {
            this.phoneNumber = setterArg;
        }

        @NonNull
        public Boolean getIsAnonymous() {
            return this.isAnonymous;
        }

        public void setIsAnonymous(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"isAnonymous\" is null.");
            }
            this.isAnonymous = setterArg;
        }

        @NonNull
        public Boolean getIsEmailVerified() {
            return this.isEmailVerified;
        }

        public void setIsEmailVerified(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"isEmailVerified\" is null.");
            }
            this.isEmailVerified = setterArg;
        }

        @Nullable
        public String getProviderId() {
            return this.providerId;
        }

        public void setProviderId(@Nullable String setterArg) {
            this.providerId = setterArg;
        }

        @Nullable
        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(@Nullable String setterArg) {
            this.tenantId = setterArg;
        }

        @Nullable
        public String getRefreshToken() {
            return this.refreshToken;
        }

        public void setRefreshToken(@Nullable String setterArg) {
            this.refreshToken = setterArg;
        }

        @Nullable
        public Long getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public void setCreationTimestamp(@Nullable Long setterArg) {
            this.creationTimestamp = setterArg;
        }

        @Nullable
        public Long getLastSignInTimestamp() {
            return this.lastSignInTimestamp;
        }

        public void setLastSignInTimestamp(@Nullable Long setterArg) {
            this.lastSignInTimestamp = setterArg;
        }

        PigeonUserInfo() {
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(12);
            toListResult.add(this.uid);
            toListResult.add(this.email);
            toListResult.add(this.displayName);
            toListResult.add(this.photoUrl);
            toListResult.add(this.phoneNumber);
            toListResult.add(this.isAnonymous);
            toListResult.add(this.isEmailVerified);
            toListResult.add(this.providerId);
            toListResult.add(this.tenantId);
            toListResult.add(this.refreshToken);
            toListResult.add(this.creationTimestamp);
            toListResult.add(this.lastSignInTimestamp);
            return toListResult;
        }

        @NonNull
        static PigeonUserInfo fromList(@NonNull ArrayList<Object> __pigeon_list) {
            PigeonUserInfo pigeonResult = new PigeonUserInfo();
            Object uid = __pigeon_list.get(0);
            pigeonResult.setUid((String)uid);
            Object email = __pigeon_list.get(1);
            pigeonResult.setEmail((String)email);
            Object displayName = __pigeon_list.get(2);
            pigeonResult.setDisplayName((String)displayName);
            Object photoUrl = __pigeon_list.get(3);
            pigeonResult.setPhotoUrl((String)photoUrl);
            Object phoneNumber = __pigeon_list.get(4);
            pigeonResult.setPhoneNumber((String)phoneNumber);
            Object isAnonymous = __pigeon_list.get(5);
            pigeonResult.setIsAnonymous((Boolean)isAnonymous);
            Object isEmailVerified = __pigeon_list.get(6);
            pigeonResult.setIsEmailVerified((Boolean)isEmailVerified);
            Object providerId = __pigeon_list.get(7);
            pigeonResult.setProviderId((String)providerId);
            Object tenantId = __pigeon_list.get(8);
            pigeonResult.setTenantId((String)tenantId);
            Object refreshToken = __pigeon_list.get(9);
            pigeonResult.setRefreshToken((String)refreshToken);
            Object creationTimestamp = __pigeon_list.get(10);
            pigeonResult.setCreationTimestamp(creationTimestamp == null ? null : Long.valueOf(creationTimestamp instanceof Integer ? (long)((Integer)creationTimestamp).intValue() : (Long)creationTimestamp));
            Object lastSignInTimestamp = __pigeon_list.get(11);
            pigeonResult.setLastSignInTimestamp(lastSignInTimestamp == null ? null : Long.valueOf(lastSignInTimestamp instanceof Integer ? (long)((Integer)lastSignInTimestamp).intValue() : (Long)lastSignInTimestamp));
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String uid;
            @Nullable
            private String email;
            @Nullable
            private String displayName;
            @Nullable
            private String photoUrl;
            @Nullable
            private String phoneNumber;
            @Nullable
            private Boolean isAnonymous;
            @Nullable
            private Boolean isEmailVerified;
            @Nullable
            private String providerId;
            @Nullable
            private String tenantId;
            @Nullable
            private String refreshToken;
            @Nullable
            private Long creationTimestamp;
            @Nullable
            private Long lastSignInTimestamp;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setUid(@NonNull String setterArg) {
                this.uid = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setEmail(@Nullable String setterArg) {
                this.email = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setDisplayName(@Nullable String setterArg) {
                this.displayName = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPhotoUrl(@Nullable String setterArg) {
                this.photoUrl = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPhoneNumber(@Nullable String setterArg) {
                this.phoneNumber = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setIsAnonymous(@NonNull Boolean setterArg) {
                this.isAnonymous = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setIsEmailVerified(@NonNull Boolean setterArg) {
                this.isEmailVerified = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setProviderId(@Nullable String setterArg) {
                this.providerId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setTenantId(@Nullable String setterArg) {
                this.tenantId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setRefreshToken(@Nullable String setterArg) {
                this.refreshToken = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCreationTimestamp(@Nullable Long setterArg) {
                this.creationTimestamp = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setLastSignInTimestamp(@Nullable Long setterArg) {
                this.lastSignInTimestamp = setterArg;
                return this;
            }

            @NonNull
            public PigeonUserInfo build() {
                PigeonUserInfo pigeonReturn = new PigeonUserInfo();
                pigeonReturn.setUid(this.uid);
                pigeonReturn.setEmail(this.email);
                pigeonReturn.setDisplayName(this.displayName);
                pigeonReturn.setPhotoUrl(this.photoUrl);
                pigeonReturn.setPhoneNumber(this.phoneNumber);
                pigeonReturn.setIsAnonymous(this.isAnonymous);
                pigeonReturn.setIsEmailVerified(this.isEmailVerified);
                pigeonReturn.setProviderId(this.providerId);
                pigeonReturn.setTenantId(this.tenantId);
                pigeonReturn.setRefreshToken(this.refreshToken);
                pigeonReturn.setCreationTimestamp(this.creationTimestamp);
                pigeonReturn.setLastSignInTimestamp(this.lastSignInTimestamp);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonAuthCredential {
        @NonNull
        private String providerId;
        @NonNull
        private String signInMethod;
        @NonNull
        private Long nativeId;
        @Nullable
        private String accessToken;

        @NonNull
        public String getProviderId() {
            return this.providerId;
        }

        public void setProviderId(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"providerId\" is null.");
            }
            this.providerId = setterArg;
        }

        @NonNull
        public String getSignInMethod() {
            return this.signInMethod;
        }

        public void setSignInMethod(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"signInMethod\" is null.");
            }
            this.signInMethod = setterArg;
        }

        @NonNull
        public Long getNativeId() {
            return this.nativeId;
        }

        public void setNativeId(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"nativeId\" is null.");
            }
            this.nativeId = setterArg;
        }

        @Nullable
        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(@Nullable String setterArg) {
            this.accessToken = setterArg;
        }

        PigeonAuthCredential() {
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(4);
            toListResult.add(this.providerId);
            toListResult.add(this.signInMethod);
            toListResult.add(this.nativeId);
            toListResult.add(this.accessToken);
            return toListResult;
        }

        @NonNull
        static PigeonAuthCredential fromList(@NonNull ArrayList<Object> __pigeon_list) {
            PigeonAuthCredential pigeonResult = new PigeonAuthCredential();
            Object providerId = __pigeon_list.get(0);
            pigeonResult.setProviderId((String)providerId);
            Object signInMethod = __pigeon_list.get(1);
            pigeonResult.setSignInMethod((String)signInMethod);
            Object nativeId = __pigeon_list.get(2);
            pigeonResult.setNativeId(nativeId == null ? null : Long.valueOf(nativeId instanceof Integer ? (long)((Integer)nativeId).intValue() : (Long)nativeId));
            Object accessToken = __pigeon_list.get(3);
            pigeonResult.setAccessToken((String)accessToken);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String providerId;
            @Nullable
            private String signInMethod;
            @Nullable
            private Long nativeId;
            @Nullable
            private String accessToken;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setProviderId(@NonNull String setterArg) {
                this.providerId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setSignInMethod(@NonNull String setterArg) {
                this.signInMethod = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setNativeId(@NonNull Long setterArg) {
                this.nativeId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAccessToken(@Nullable String setterArg) {
                this.accessToken = setterArg;
                return this;
            }

            @NonNull
            public PigeonAuthCredential build() {
                PigeonAuthCredential pigeonReturn = new PigeonAuthCredential();
                pigeonReturn.setProviderId(this.providerId);
                pigeonReturn.setSignInMethod(this.signInMethod);
                pigeonReturn.setNativeId(this.nativeId);
                pigeonReturn.setAccessToken(this.accessToken);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonAdditionalUserInfo {
        @NonNull
        private Boolean isNewUser;
        @Nullable
        private String providerId;
        @Nullable
        private String username;
        @Nullable
        private String authorizationCode;
        @Nullable
        private Map<String, Object> profile;

        @NonNull
        public Boolean getIsNewUser() {
            return this.isNewUser;
        }

        public void setIsNewUser(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"isNewUser\" is null.");
            }
            this.isNewUser = setterArg;
        }

        @Nullable
        public String getProviderId() {
            return this.providerId;
        }

        public void setProviderId(@Nullable String setterArg) {
            this.providerId = setterArg;
        }

        @Nullable
        public String getUsername() {
            return this.username;
        }

        public void setUsername(@Nullable String setterArg) {
            this.username = setterArg;
        }

        @Nullable
        public String getAuthorizationCode() {
            return this.authorizationCode;
        }

        public void setAuthorizationCode(@Nullable String setterArg) {
            this.authorizationCode = setterArg;
        }

        @Nullable
        public Map<String, Object> getProfile() {
            return this.profile;
        }

        public void setProfile(@Nullable Map<String, Object> setterArg) {
            this.profile = setterArg;
        }

        PigeonAdditionalUserInfo() {
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(5);
            toListResult.add(this.isNewUser);
            toListResult.add(this.providerId);
            toListResult.add(this.username);
            toListResult.add(this.authorizationCode);
            toListResult.add(this.profile);
            return toListResult;
        }

        @NonNull
        static PigeonAdditionalUserInfo fromList(@NonNull ArrayList<Object> __pigeon_list) {
            PigeonAdditionalUserInfo pigeonResult = new PigeonAdditionalUserInfo();
            Object isNewUser = __pigeon_list.get(0);
            pigeonResult.setIsNewUser((Boolean)isNewUser);
            Object providerId = __pigeon_list.get(1);
            pigeonResult.setProviderId((String)providerId);
            Object username = __pigeon_list.get(2);
            pigeonResult.setUsername((String)username);
            Object authorizationCode = __pigeon_list.get(3);
            pigeonResult.setAuthorizationCode((String)authorizationCode);
            Object profile = __pigeon_list.get(4);
            pigeonResult.setProfile((Map)profile);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Boolean isNewUser;
            @Nullable
            private String providerId;
            @Nullable
            private String username;
            @Nullable
            private String authorizationCode;
            @Nullable
            private Map<String, Object> profile;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setIsNewUser(@NonNull Boolean setterArg) {
                this.isNewUser = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setProviderId(@Nullable String setterArg) {
                this.providerId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setUsername(@Nullable String setterArg) {
                this.username = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAuthorizationCode(@Nullable String setterArg) {
                this.authorizationCode = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setProfile(@Nullable Map<String, Object> setterArg) {
                this.profile = setterArg;
                return this;
            }

            @NonNull
            public PigeonAdditionalUserInfo build() {
                PigeonAdditionalUserInfo pigeonReturn = new PigeonAdditionalUserInfo();
                pigeonReturn.setIsNewUser(this.isNewUser);
                pigeonReturn.setProviderId(this.providerId);
                pigeonReturn.setUsername(this.username);
                pigeonReturn.setAuthorizationCode(this.authorizationCode);
                pigeonReturn.setProfile(this.profile);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonActionCodeInfo {
        @NonNull
        private ActionCodeInfoOperation operation;
        @NonNull
        private PigeonActionCodeInfoData data;

        @NonNull
        public ActionCodeInfoOperation getOperation() {
            return this.operation;
        }

        public void setOperation(@NonNull ActionCodeInfoOperation setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"operation\" is null.");
            }
            this.operation = setterArg;
        }

        @NonNull
        public PigeonActionCodeInfoData getData() {
            return this.data;
        }

        public void setData(@NonNull PigeonActionCodeInfoData setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"data\" is null.");
            }
            this.data = setterArg;
        }

        PigeonActionCodeInfo() {
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.operation == null ? null : Integer.valueOf(this.operation.index));
            toListResult.add(this.data);
            return toListResult;
        }

        @NonNull
        static PigeonActionCodeInfo fromList(@NonNull ArrayList<Object> __pigeon_list) {
            PigeonActionCodeInfo pigeonResult = new PigeonActionCodeInfo();
            Object operation = __pigeon_list.get(0);
            pigeonResult.setOperation(ActionCodeInfoOperation.values()[(Integer)operation]);
            Object data = __pigeon_list.get(1);
            pigeonResult.setData((PigeonActionCodeInfoData)data);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private ActionCodeInfoOperation operation;
            @Nullable
            private PigeonActionCodeInfoData data;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setOperation(@NonNull ActionCodeInfoOperation setterArg) {
                this.operation = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setData(@NonNull PigeonActionCodeInfoData setterArg) {
                this.data = setterArg;
                return this;
            }

            @NonNull
            public PigeonActionCodeInfo build() {
                PigeonActionCodeInfo pigeonReturn = new PigeonActionCodeInfo();
                pigeonReturn.setOperation(this.operation);
                pigeonReturn.setData(this.data);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonActionCodeInfoData {
        @Nullable
        private String email;
        @Nullable
        private String previousEmail;

        @Nullable
        public String getEmail() {
            return this.email;
        }

        public void setEmail(@Nullable String setterArg) {
            this.email = setterArg;
        }

        @Nullable
        public String getPreviousEmail() {
            return this.previousEmail;
        }

        public void setPreviousEmail(@Nullable String setterArg) {
            this.previousEmail = setterArg;
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.email);
            toListResult.add(this.previousEmail);
            return toListResult;
        }

        @NonNull
        static PigeonActionCodeInfoData fromList(@NonNull ArrayList<Object> __pigeon_list) {
            PigeonActionCodeInfoData pigeonResult = new PigeonActionCodeInfoData();
            Object email = __pigeon_list.get(0);
            pigeonResult.setEmail((String)email);
            Object previousEmail = __pigeon_list.get(1);
            pigeonResult.setPreviousEmail((String)previousEmail);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String email;
            @Nullable
            private String previousEmail;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setEmail(@Nullable String setterArg) {
                this.email = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPreviousEmail(@Nullable String setterArg) {
                this.previousEmail = setterArg;
                return this;
            }

            @NonNull
            public PigeonActionCodeInfoData build() {
                PigeonActionCodeInfoData pigeonReturn = new PigeonActionCodeInfoData();
                pigeonReturn.setEmail(this.email);
                pigeonReturn.setPreviousEmail(this.previousEmail);
                return pigeonReturn;
            }
        }
    }

    public static final class AuthPigeonFirebaseApp {
        @NonNull
        private String appName;
        @Nullable
        private String tenantId;
        @Nullable
        private String customAuthDomain;

        @NonNull
        public String getAppName() {
            return this.appName;
        }

        public void setAppName(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"appName\" is null.");
            }
            this.appName = setterArg;
        }

        @Nullable
        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(@Nullable String setterArg) {
            this.tenantId = setterArg;
        }

        @Nullable
        public String getCustomAuthDomain() {
            return this.customAuthDomain;
        }

        public void setCustomAuthDomain(@Nullable String setterArg) {
            this.customAuthDomain = setterArg;
        }

        AuthPigeonFirebaseApp() {
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add(this.appName);
            toListResult.add(this.tenantId);
            toListResult.add(this.customAuthDomain);
            return toListResult;
        }

        @NonNull
        static AuthPigeonFirebaseApp fromList(@NonNull ArrayList<Object> __pigeon_list) {
            AuthPigeonFirebaseApp pigeonResult = new AuthPigeonFirebaseApp();
            Object appName = __pigeon_list.get(0);
            pigeonResult.setAppName((String)appName);
            Object tenantId = __pigeon_list.get(1);
            pigeonResult.setTenantId((String)tenantId);
            Object customAuthDomain = __pigeon_list.get(2);
            pigeonResult.setCustomAuthDomain((String)customAuthDomain);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String appName;
            @Nullable
            private String tenantId;
            @Nullable
            private String customAuthDomain;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAppName(@NonNull String setterArg) {
                this.appName = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setTenantId(@Nullable String setterArg) {
                this.tenantId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCustomAuthDomain(@Nullable String setterArg) {
                this.customAuthDomain = setterArg;
                return this;
            }

            @NonNull
            public AuthPigeonFirebaseApp build() {
                AuthPigeonFirebaseApp pigeonReturn = new AuthPigeonFirebaseApp();
                pigeonReturn.setAppName(this.appName);
                pigeonReturn.setTenantId(this.tenantId);
                pigeonReturn.setCustomAuthDomain(this.customAuthDomain);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonMultiFactorInfo {
        @Nullable
        private String displayName;
        @NonNull
        private Double enrollmentTimestamp;
        @Nullable
        private String factorId;
        @NonNull
        private String uid;
        @Nullable
        private String phoneNumber;

        @Nullable
        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(@Nullable String setterArg) {
            this.displayName = setterArg;
        }

        @NonNull
        public Double getEnrollmentTimestamp() {
            return this.enrollmentTimestamp;
        }

        public void setEnrollmentTimestamp(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"enrollmentTimestamp\" is null.");
            }
            this.enrollmentTimestamp = setterArg;
        }

        @Nullable
        public String getFactorId() {
            return this.factorId;
        }

        public void setFactorId(@Nullable String setterArg) {
            this.factorId = setterArg;
        }

        @NonNull
        public String getUid() {
            return this.uid;
        }

        public void setUid(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"uid\" is null.");
            }
            this.uid = setterArg;
        }

        @Nullable
        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public void setPhoneNumber(@Nullable String setterArg) {
            this.phoneNumber = setterArg;
        }

        PigeonMultiFactorInfo() {
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(5);
            toListResult.add(this.displayName);
            toListResult.add(this.enrollmentTimestamp);
            toListResult.add(this.factorId);
            toListResult.add(this.uid);
            toListResult.add(this.phoneNumber);
            return toListResult;
        }

        @NonNull
        static PigeonMultiFactorInfo fromList(@NonNull ArrayList<Object> __pigeon_list) {
            PigeonMultiFactorInfo pigeonResult = new PigeonMultiFactorInfo();
            Object displayName = __pigeon_list.get(0);
            pigeonResult.setDisplayName((String)displayName);
            Object enrollmentTimestamp = __pigeon_list.get(1);
            pigeonResult.setEnrollmentTimestamp((Double)enrollmentTimestamp);
            Object factorId = __pigeon_list.get(2);
            pigeonResult.setFactorId((String)factorId);
            Object uid = __pigeon_list.get(3);
            pigeonResult.setUid((String)uid);
            Object phoneNumber = __pigeon_list.get(4);
            pigeonResult.setPhoneNumber((String)phoneNumber);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String displayName;
            @Nullable
            private Double enrollmentTimestamp;
            @Nullable
            private String factorId;
            @Nullable
            private String uid;
            @Nullable
            private String phoneNumber;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setDisplayName(@Nullable String setterArg) {
                this.displayName = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setEnrollmentTimestamp(@NonNull Double setterArg) {
                this.enrollmentTimestamp = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setFactorId(@Nullable String setterArg) {
                this.factorId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setUid(@NonNull String setterArg) {
                this.uid = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPhoneNumber(@Nullable String setterArg) {
                this.phoneNumber = setterArg;
                return this;
            }

            @NonNull
            public PigeonMultiFactorInfo build() {
                PigeonMultiFactorInfo pigeonReturn = new PigeonMultiFactorInfo();
                pigeonReturn.setDisplayName(this.displayName);
                pigeonReturn.setEnrollmentTimestamp(this.enrollmentTimestamp);
                pigeonReturn.setFactorId(this.factorId);
                pigeonReturn.setUid(this.uid);
                pigeonReturn.setPhoneNumber(this.phoneNumber);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonPhoneMultiFactorAssertion {
        @NonNull
        private String verificationId;
        @NonNull
        private String verificationCode;

        @NonNull
        public String getVerificationId() {
            return this.verificationId;
        }

        public void setVerificationId(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"verificationId\" is null.");
            }
            this.verificationId = setterArg;
        }

        @NonNull
        public String getVerificationCode() {
            return this.verificationCode;
        }

        public void setVerificationCode(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"verificationCode\" is null.");
            }
            this.verificationCode = setterArg;
        }

        PigeonPhoneMultiFactorAssertion() {
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.verificationId);
            toListResult.add(this.verificationCode);
            return toListResult;
        }

        @NonNull
        static PigeonPhoneMultiFactorAssertion fromList(@NonNull ArrayList<Object> __pigeon_list) {
            PigeonPhoneMultiFactorAssertion pigeonResult = new PigeonPhoneMultiFactorAssertion();
            Object verificationId = __pigeon_list.get(0);
            pigeonResult.setVerificationId((String)verificationId);
            Object verificationCode = __pigeon_list.get(1);
            pigeonResult.setVerificationCode((String)verificationCode);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String verificationId;
            @Nullable
            private String verificationCode;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setVerificationId(@NonNull String setterArg) {
                this.verificationId = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setVerificationCode(@NonNull String setterArg) {
                this.verificationCode = setterArg;
                return this;
            }

            @NonNull
            public PigeonPhoneMultiFactorAssertion build() {
                PigeonPhoneMultiFactorAssertion pigeonReturn = new PigeonPhoneMultiFactorAssertion();
                pigeonReturn.setVerificationId(this.verificationId);
                pigeonReturn.setVerificationCode(this.verificationCode);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonMultiFactorSession {
        @NonNull
        private String id;

        @NonNull
        public String getId() {
            return this.id;
        }

        public void setId(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"id\" is null.");
            }
            this.id = setterArg;
        }

        PigeonMultiFactorSession() {
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(1);
            toListResult.add(this.id);
            return toListResult;
        }

        @NonNull
        static PigeonMultiFactorSession fromList(@NonNull ArrayList<Object> __pigeon_list) {
            PigeonMultiFactorSession pigeonResult = new PigeonMultiFactorSession();
            Object id = __pigeon_list.get(0);
            pigeonResult.setId((String)id);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String id;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setId(@NonNull String setterArg) {
                this.id = setterArg;
                return this;
            }

            @NonNull
            public PigeonMultiFactorSession build() {
                PigeonMultiFactorSession pigeonReturn = new PigeonMultiFactorSession();
                pigeonReturn.setId(this.id);
                return pigeonReturn;
            }
        }
    }

    public static enum ActionCodeInfoOperation {
        UNKNOWN(0),
        PASSWORD_RESET(1),
        VERIFY_EMAIL(2),
        RECOVER_EMAIL(3),
        EMAIL_SIGN_IN(4),
        VERIFY_AND_CHANGE_EMAIL(5),
        REVERT_SECOND_FACTOR_ADDITION(6);

        final int index;

        private ActionCodeInfoOperation(int index) {
            this.index = index;
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    static @interface CanIgnoreReturnValue {
    }
}

