/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.auth;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.FirebaseException;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.MultiFactorSession;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthOptions;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.PhoneMultiFactorInfo;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugins.firebase.auth.FlutterFirebaseAuthPlugin;
import io.flutter.plugins.firebase.auth.FlutterFirebaseAuthPluginException;
import io.flutter.plugins.firebase.auth.GeneratedAndroidFirebaseAuth;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class PhoneNumberVerificationStreamHandler
implements EventChannel.StreamHandler {
    final AtomicReference<Activity> activityRef = new AtomicReference<Object>(null);
    final FirebaseAuth firebaseAuth;
    final String phoneNumber;
    final PhoneMultiFactorInfo multiFactorInfo;
    final int timeout;
    final OnCredentialsListener onCredentialsListener;
    final MultiFactorSession multiFactorSession;
    String autoRetrievedSmsCodeForTesting;
    Integer forceResendingToken;
    private static final HashMap<Integer, PhoneAuthProvider.ForceResendingToken> forceResendingTokens = new HashMap();
    @Nullable
    private EventChannel.EventSink eventSink;

    public PhoneNumberVerificationStreamHandler(Activity activity, @NonNull GeneratedAndroidFirebaseAuth.AuthPigeonFirebaseApp app, @NonNull GeneratedAndroidFirebaseAuth.PigeonVerifyPhoneNumberRequest request, @Nullable MultiFactorSession multiFactorSession, @Nullable PhoneMultiFactorInfo multiFactorInfo, OnCredentialsListener onCredentialsListener) {
        this.activityRef.set(activity);
        this.multiFactorSession = multiFactorSession;
        this.multiFactorInfo = multiFactorInfo;
        this.firebaseAuth = FlutterFirebaseAuthPlugin.getAuthFromPigeon(app);
        this.phoneNumber = request.getPhoneNumber();
        this.timeout = Math.toIntExact(request.getTimeout());
        if (request.getAutoRetrievedSmsCodeForTesting() != null) {
            this.autoRetrievedSmsCodeForTesting = request.getAutoRetrievedSmsCodeForTesting();
        }
        if (request.getForceResendingToken() != null) {
            this.forceResendingToken = Math.toIntExact(request.getForceResendingToken());
        }
        this.onCredentialsListener = onCredentialsListener;
    }

    public void onListen(Object arguments, EventChannel.EventSink events) {
        PhoneAuthProvider.ForceResendingToken forceResendingToken;
        this.eventSink = events;
        PhoneAuthProvider.OnVerificationStateChangedCallbacks callbacks = new PhoneAuthProvider.OnVerificationStateChangedCallbacks(){

            public void onVerificationCompleted(@NonNull PhoneAuthCredential phoneAuthCredential) {
                int phoneAuthCredentialHashCode = phoneAuthCredential.hashCode();
                PhoneNumberVerificationStreamHandler.this.onCredentialsListener.onCredentialsReceived(phoneAuthCredential);
                HashMap<String, Object> event = new HashMap<String, Object>();
                event.put("token", phoneAuthCredentialHashCode);
                if (phoneAuthCredential.getSmsCode() != null) {
                    event.put("smsCode", phoneAuthCredential.getSmsCode());
                }
                event.put("name", "Auth#phoneVerificationCompleted");
                if (PhoneNumberVerificationStreamHandler.this.eventSink != null) {
                    PhoneNumberVerificationStreamHandler.this.eventSink.success(event);
                }
            }

            public void onVerificationFailed(@NonNull FirebaseException e) {
                HashMap<String, Object> event = new HashMap<String, Object>();
                HashMap<String, Object> error = new HashMap<String, Object>();
                GeneratedAndroidFirebaseAuth.FlutterError flutterError = FlutterFirebaseAuthPluginException.parserExceptionToFlutter((Exception)e);
                error.put("code", flutterError.code.replaceAll("ERROR_", "").toLowerCase(Locale.ROOT).replaceAll("_", "-"));
                error.put("message", flutterError.getMessage());
                error.put("details", flutterError.details);
                event.put("error", error);
                event.put("name", "Auth#phoneVerificationFailed");
                if (PhoneNumberVerificationStreamHandler.this.eventSink != null) {
                    PhoneNumberVerificationStreamHandler.this.eventSink.success(event);
                }
            }

            public void onCodeSent(@NonNull String verificationId, @NonNull PhoneAuthProvider.ForceResendingToken token) {
                int forceResendingTokenHashCode = token.hashCode();
                forceResendingTokens.put(forceResendingTokenHashCode, token);
                HashMap<String, Object> event = new HashMap<String, Object>();
                event.put("verificationId", verificationId);
                event.put("forceResendingToken", forceResendingTokenHashCode);
                event.put("name", "Auth#phoneCodeSent");
                if (PhoneNumberVerificationStreamHandler.this.eventSink != null) {
                    PhoneNumberVerificationStreamHandler.this.eventSink.success(event);
                }
            }

            public void onCodeAutoRetrievalTimeOut(@NonNull String verificationId) {
                HashMap<String, String> event = new HashMap<String, String>();
                event.put("verificationId", verificationId);
                event.put("name", "Auth#phoneCodeAutoRetrievalTimeout");
                if (PhoneNumberVerificationStreamHandler.this.eventSink != null) {
                    PhoneNumberVerificationStreamHandler.this.eventSink.success(event);
                }
            }
        };
        if (this.autoRetrievedSmsCodeForTesting != null) {
            this.firebaseAuth.getFirebaseAuthSettings().setAutoRetrievedSmsCodeForPhoneNumber(this.phoneNumber, this.autoRetrievedSmsCodeForTesting);
        }
        PhoneAuthOptions.Builder phoneAuthOptionsBuilder = new PhoneAuthOptions.Builder(this.firebaseAuth);
        phoneAuthOptionsBuilder.setActivity(this.activityRef.get());
        phoneAuthOptionsBuilder.setCallbacks(callbacks);
        if (this.phoneNumber != null) {
            phoneAuthOptionsBuilder.setPhoneNumber(this.phoneNumber);
        }
        if (this.multiFactorSession != null) {
            phoneAuthOptionsBuilder.setMultiFactorSession(this.multiFactorSession);
        }
        if (this.multiFactorInfo != null) {
            phoneAuthOptionsBuilder.setMultiFactorHint(this.multiFactorInfo);
        }
        phoneAuthOptionsBuilder.setTimeout(Long.valueOf(this.timeout), TimeUnit.MILLISECONDS);
        if (this.forceResendingToken != null && (forceResendingToken = forceResendingTokens.get(this.forceResendingToken)) != null) {
            phoneAuthOptionsBuilder.setForceResendingToken(forceResendingToken);
        }
        PhoneAuthProvider.verifyPhoneNumber((PhoneAuthOptions)phoneAuthOptionsBuilder.build());
    }

    public void onCancel(Object arguments) {
        this.eventSink = null;
        this.activityRef.set(null);
    }

    static interface OnCredentialsListener {
        public void onCredentialsReceived(PhoneAuthCredential var1);
    }
}

