/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.messaging;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationManagerCompat;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.RemoteMessage;
import io.flutter.embedding.engine.FlutterShellArgs;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.plugins.firebase.core.FlutterFirebasePlugin;
import io.flutter.plugins.firebase.core.FlutterFirebasePluginRegistry;
import io.flutter.plugins.firebase.messaging.ContextHolder;
import io.flutter.plugins.firebase.messaging.FlutterFirebaseMessagingBackgroundService;
import io.flutter.plugins.firebase.messaging.FlutterFirebaseMessagingReceiver;
import io.flutter.plugins.firebase.messaging.FlutterFirebaseMessagingStore;
import io.flutter.plugins.firebase.messaging.FlutterFirebaseMessagingUtils;
import io.flutter.plugins.firebase.messaging.FlutterFirebasePermissionManager;
import io.flutter.plugins.firebase.messaging.FlutterFirebaseRemoteMessageLiveData;
import io.flutter.plugins.firebase.messaging.FlutterFirebaseTokenLiveData;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class FlutterFirebaseMessagingPlugin
implements FlutterFirebasePlugin,
MethodChannel.MethodCallHandler,
PluginRegistry.NewIntentListener,
FlutterPlugin,
ActivityAware {
    private final HashMap<String, Boolean> consumedInitialMessages = new HashMap();
    private MethodChannel channel;
    private Activity mainActivity;
    private final LiveData<RemoteMessage> liveDataRemoteMessage = FlutterFirebaseRemoteMessageLiveData.getInstance();
    private Observer<RemoteMessage> remoteMessageObserver;
    private final LiveData<String> liveDataToken = FlutterFirebaseTokenLiveData.getInstance();
    private Observer<String> tokenObserver;
    private RemoteMessage initialMessage;
    private Map<String, Object> initialMessageNotification;
    FlutterFirebasePermissionManager permissionManager;

    private void initInstance(BinaryMessenger messenger) {
        String channelName = "plugins.flutter.io/firebase_messaging";
        this.channel = new MethodChannel(messenger, channelName);
        this.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
        this.permissionManager = new FlutterFirebasePermissionManager();
        this.remoteMessageObserver = remoteMessage -> {
            Map<String, Object> content = FlutterFirebaseMessagingUtils.remoteMessageToMap(remoteMessage);
            this.channel.invokeMethod("Messaging#onMessage", content);
        };
        this.tokenObserver = token -> this.channel.invokeMethod("Messaging#onTokenRefresh", token);
        this.liveDataRemoteMessage.observeForever(this.remoteMessageObserver);
        this.liveDataToken.observeForever(this.tokenObserver);
        FlutterFirebasePluginRegistry.registerPlugin((String)channelName, (FlutterFirebasePlugin)this);
    }

    public void onAttachedToEngine(FlutterPlugin.FlutterPluginBinding binding) {
        ContextHolder.setApplicationContext(binding.getApplicationContext());
        this.initInstance(binding.getBinaryMessenger());
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.liveDataToken.removeObserver(this.tokenObserver);
        this.liveDataRemoteMessage.removeObserver(this.remoteMessageObserver);
    }

    public void onAttachedToActivity(ActivityPluginBinding binding) {
        binding.addOnNewIntentListener((PluginRegistry.NewIntentListener)this);
        binding.addRequestPermissionsResultListener((PluginRegistry.RequestPermissionsResultListener)this.permissionManager);
        this.mainActivity = binding.getActivity();
        if (this.mainActivity.getIntent() != null && this.mainActivity.getIntent().getExtras() != null && (this.mainActivity.getIntent().getFlags() & 0x100000) != 0x100000) {
            this.onNewIntent(this.mainActivity.getIntent());
        }
    }

    public void onDetachedFromActivityForConfigChanges() {
        this.mainActivity = null;
    }

    public void onReattachedToActivityForConfigChanges(ActivityPluginBinding binding) {
        binding.addOnNewIntentListener((PluginRegistry.NewIntentListener)this);
        this.mainActivity = binding.getActivity();
    }

    public void onDetachedFromActivity() {
        this.mainActivity = null;
    }

    private Task<Void> deleteToken() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                Tasks.await((Task)FirebaseMessaging.getInstance().deleteToken());
                taskCompletionSource.setResult(null);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    private Task<Map<String, Object>> getToken() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                final String token = (String)Tasks.await((Task)FirebaseMessaging.getInstance().getToken());
                taskCompletionSource.setResult((Object)new HashMap<String, Object>(){
                    {
                        this.put("token", token);
                    }
                });
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    private Task<Void> subscribeToTopic(Map<String, Object> arguments) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                FirebaseMessaging firebaseMessaging = FlutterFirebaseMessagingUtils.getFirebaseMessagingForArguments(arguments);
                String topic = (String)Objects.requireNonNull(arguments.get("topic"));
                Tasks.await((Task)firebaseMessaging.subscribeToTopic(topic));
                taskCompletionSource.setResult(null);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    private Task<Void> unsubscribeFromTopic(Map<String, Object> arguments) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                FirebaseMessaging firebaseMessaging = FlutterFirebaseMessagingUtils.getFirebaseMessagingForArguments(arguments);
                String topic = (String)Objects.requireNonNull(arguments.get("topic"));
                Tasks.await((Task)firebaseMessaging.unsubscribeFromTopic(topic));
                taskCompletionSource.setResult(null);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    private Task<Void> sendMessage(Map<String, Object> arguments) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                FirebaseMessaging firebaseMessaging = FlutterFirebaseMessagingUtils.getFirebaseMessagingForArguments(arguments);
                RemoteMessage remoteMessage = FlutterFirebaseMessagingUtils.getRemoteMessageForArguments(arguments);
                firebaseMessaging.send(remoteMessage);
                taskCompletionSource.setResult(null);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    private Task<Map<String, Object>> setAutoInitEnabled(Map<String, Object> arguments) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                final FirebaseMessaging firebaseMessaging = FlutterFirebaseMessagingUtils.getFirebaseMessagingForArguments(arguments);
                Boolean enabled = (Boolean)Objects.requireNonNull(arguments.get("enabled"));
                firebaseMessaging.setAutoInitEnabled(enabled.booleanValue());
                taskCompletionSource.setResult((Object)new HashMap<String, Object>(){
                    {
                        this.put("isAutoInitEnabled", firebaseMessaging.isAutoInitEnabled());
                    }
                });
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    private Task<Void> setDeliveryMetricsExportToBigQuery(Map<String, Object> arguments) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                FirebaseMessaging firebaseMessaging = FlutterFirebaseMessagingUtils.getFirebaseMessagingForArguments(arguments);
                Boolean enabled = (Boolean)Objects.requireNonNull(arguments.get("enabled"));
                firebaseMessaging.setDeliveryMetricsExportToBigQuery(enabled.booleanValue());
                taskCompletionSource.setResult(null);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    private Task<Map<String, Object>> getInitialMessage() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                if (this.initialMessage != null) {
                    Map<String, Object> remoteMessageMap = FlutterFirebaseMessagingUtils.remoteMessageToMap(this.initialMessage);
                    if (this.initialMessageNotification != null) {
                        remoteMessageMap.put("notification", this.initialMessageNotification);
                    }
                    taskCompletionSource.setResult(remoteMessageMap);
                    this.initialMessage = null;
                    this.initialMessageNotification = null;
                    return;
                }
                if (this.mainActivity == null) {
                    taskCompletionSource.setResult(null);
                    return;
                }
                Intent intent = this.mainActivity.getIntent();
                if (intent == null || intent.getExtras() == null) {
                    taskCompletionSource.setResult(null);
                    return;
                }
                String messageId = intent.getExtras().getString("google.message_id");
                if (messageId == null) {
                    messageId = intent.getExtras().getString("message_id");
                }
                if (messageId == null || this.consumedInitialMessages.get(messageId) != null) {
                    taskCompletionSource.setResult(null);
                    return;
                }
                RemoteMessage remoteMessage = FlutterFirebaseMessagingReceiver.notifications.get(messageId);
                Map<String, Object> notificationMap = null;
                if (remoteMessage == null) {
                    Map<String, Object> messageMap = FlutterFirebaseMessagingStore.getInstance().getFirebaseMessageMap(messageId);
                    if (messageMap != null) {
                        remoteMessage = FlutterFirebaseMessagingUtils.getRemoteMessageForArguments(messageMap);
                        if (messageMap.get("notification") != null) {
                            notificationMap = this.uncheckedCastToMap(messageMap.get("notification"));
                        }
                    }
                    FlutterFirebaseMessagingStore.getInstance().removeFirebaseMessage(messageId);
                }
                if (remoteMessage == null) {
                    taskCompletionSource.setResult(null);
                    return;
                }
                this.consumedInitialMessages.put(messageId, true);
                Map<String, Object> remoteMessageMap = FlutterFirebaseMessagingUtils.remoteMessageToMap(remoteMessage);
                if (remoteMessage.getNotification() == null && notificationMap != null) {
                    remoteMessageMap.put("notification", notificationMap);
                }
                taskCompletionSource.setResult(remoteMessageMap);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    @RequiresApi(api=33)
    private Task<Map<String, Integer>> requestPermissions() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            HashMap<String, Integer> permissions = new HashMap<String, Integer>();
            try {
                boolean areNotificationsEnabled = this.checkPermissions();
                if (!areNotificationsEnabled) {
                    this.permissionManager.requestPermissions(this.mainActivity, notificationsEnabled -> {
                        permissions.put("authorizationStatus", notificationsEnabled);
                        taskCompletionSource.setResult((Object)permissions);
                    }, errorDescription -> taskCompletionSource.setException(new Exception(errorDescription)));
                } else {
                    permissions.put("authorizationStatus", 1);
                    taskCompletionSource.setResult(permissions);
                }
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    @RequiresApi(api=33)
    private Boolean checkPermissions() {
        return ContextHolder.getApplicationContext().checkSelfPermission("android.permission.POST_NOTIFICATIONS") == 0;
    }

    private Task<Map<String, Integer>> getPermissions() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                HashMap<String, Integer> permissions = new HashMap<String, Integer>();
                boolean areNotificationsEnabled = Build.VERSION.SDK_INT >= 33 ? this.checkPermissions().booleanValue() : NotificationManagerCompat.from((Context)this.mainActivity).areNotificationsEnabled();
                permissions.put("authorizationStatus", areNotificationsEnabled ? 1 : 0);
                taskCompletionSource.setResult(permissions);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    public void onMethodCall(MethodCall call, @NonNull MethodChannel.Result result) {
        Task methodCallTask;
        switch (call.method) {
            case "Messaging#startBackgroundIsolate": {
                long userCallbackHandle;
                long pluginCallbackHandle;
                Map arguments = (Map)call.arguments;
                Object arg1 = arguments.get("pluginCallbackHandle");
                Object arg2 = arguments.get("userCallbackHandle");
                if (arg1 instanceof Long) {
                    pluginCallbackHandle = (Long)arg1;
                } else if (arg1 instanceof Integer) {
                    pluginCallbackHandle = ((Integer)arg1).intValue();
                } else {
                    throw new IllegalArgumentException("Expected 'Long' or 'Integer' type for 'pluginCallbackHandle'.");
                }
                if (arg2 instanceof Long) {
                    userCallbackHandle = (Long)arg2;
                } else if (arg2 instanceof Integer) {
                    userCallbackHandle = ((Integer)arg2).intValue();
                } else {
                    throw new IllegalArgumentException("Expected 'Long' or 'Integer' type for 'userCallbackHandle'.");
                }
                FlutterShellArgs shellArgs = null;
                if (this.mainActivity != null) {
                    shellArgs = FlutterShellArgs.fromIntent((Intent)this.mainActivity.getIntent());
                }
                FlutterFirebaseMessagingBackgroundService.setCallbackDispatcher(pluginCallbackHandle);
                FlutterFirebaseMessagingBackgroundService.setUserCallbackHandle(userCallbackHandle);
                FlutterFirebaseMessagingBackgroundService.startBackgroundIsolate(pluginCallbackHandle, shellArgs);
                methodCallTask = Tasks.forResult(null);
                break;
            }
            case "Messaging#getInitialMessage": {
                methodCallTask = this.getInitialMessage();
                break;
            }
            case "Messaging#deleteToken": {
                methodCallTask = this.deleteToken();
                break;
            }
            case "Messaging#getToken": {
                methodCallTask = this.getToken();
                break;
            }
            case "Messaging#subscribeToTopic": {
                methodCallTask = this.subscribeToTopic((Map)call.arguments());
                break;
            }
            case "Messaging#unsubscribeFromTopic": {
                methodCallTask = this.unsubscribeFromTopic((Map)call.arguments());
                break;
            }
            case "Messaging#sendMessage": {
                methodCallTask = this.sendMessage((Map)call.arguments());
                break;
            }
            case "Messaging#setAutoInitEnabled": {
                methodCallTask = this.setAutoInitEnabled((Map)call.arguments());
                break;
            }
            case "Messaging#setDeliveryMetricsExportToBigQuery": {
                methodCallTask = this.setDeliveryMetricsExportToBigQuery((Map)call.arguments());
                break;
            }
            case "Messaging#requestPermission": {
                if (Build.VERSION.SDK_INT >= 33) {
                    methodCallTask = this.requestPermissions();
                    break;
                }
                methodCallTask = this.getPermissions();
                break;
            }
            case "Messaging#getNotificationSettings": {
                methodCallTask = this.getPermissions();
                break;
            }
            default: {
                result.notImplemented();
                return;
            }
        }
        methodCallTask.addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                result.success(task.getResult());
            } else {
                Exception exception = task.getException();
                result.error("firebase_messaging", exception != null ? exception.getMessage() : null, this.getExceptionDetails(exception));
            }
        });
    }

    private Map<String, Object> getExceptionDetails(@Nullable Exception exception) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("code", "unknown");
        if (exception != null) {
            details.put("message", exception.getMessage());
        } else {
            details.put("message", "An unknown error has occurred.");
        }
        return details;
    }

    public boolean onNewIntent(@NonNull Intent intent) {
        Map<String, Object> messageMap;
        if (intent.getExtras() == null) {
            return false;
        }
        String messageId = intent.getExtras().getString("google.message_id");
        if (messageId == null) {
            messageId = intent.getExtras().getString("message_id");
        }
        if (messageId == null) {
            return false;
        }
        RemoteMessage remoteMessage = FlutterFirebaseMessagingReceiver.notifications.get(messageId);
        Map<String, Object> notificationMap = null;
        if (remoteMessage == null && (messageMap = FlutterFirebaseMessagingStore.getInstance().getFirebaseMessageMap(messageId)) != null) {
            remoteMessage = FlutterFirebaseMessagingUtils.getRemoteMessageForArguments(messageMap);
            notificationMap = FlutterFirebaseMessagingUtils.getRemoteMessageNotificationForArguments(messageMap);
        }
        if (remoteMessage == null) {
            return false;
        }
        this.initialMessage = remoteMessage;
        this.initialMessageNotification = notificationMap;
        FlutterFirebaseMessagingReceiver.notifications.remove(messageId);
        Map<String, Object> message = FlutterFirebaseMessagingUtils.remoteMessageToMap(remoteMessage);
        if (remoteMessage.getNotification() == null && this.initialMessageNotification != null) {
            message.put("notification", this.initialMessageNotification);
        }
        this.channel.invokeMethod("Messaging#onMessageOpenedApp", message);
        this.mainActivity.setIntent(intent);
        return true;
    }

    public Task<Map<String, Object>> getPluginConstantsForFirebaseApp(FirebaseApp firebaseApp) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            try {
                HashMap<String, Boolean> constants = new HashMap<String, Boolean>();
                if (firebaseApp.getName().equals("[DEFAULT]")) {
                    FirebaseMessaging firebaseMessaging = FirebaseMessaging.getInstance();
                    constants.put("AUTO_INIT_ENABLED", firebaseMessaging.isAutoInitEnabled());
                }
                taskCompletionSource.setResult(constants);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    public Task<Void> didReinitializeFirebaseCore() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> taskCompletionSource.setResult(null));
        return taskCompletionSource.getTask();
    }

    private Map<String, Object> uncheckedCastToMap(Object obj) {
        Map result = (Map)obj;
        return result;
    }
}

