/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.messaging;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.plugins.firebase.messaging.ErrorCallback;
import java.util.ArrayList;

class FlutterFirebasePermissionManager
implements PluginRegistry.RequestPermissionsResultListener {
    private final int permissionCode = 240;
    @Nullable
    private RequestPermissionsSuccessCallback successCallback;
    private boolean requestInProgress = false;

    FlutterFirebasePermissionManager() {
    }

    public boolean onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (this.requestInProgress && requestCode == 240 && this.successCallback != null) {
            this.requestInProgress = false;
            boolean granted = grantResults.length > 0 && grantResults[0] == 0;
            this.successCallback.onSuccess(granted ? 1 : 0);
            return true;
        }
        return false;
    }

    @RequiresApi(api=33)
    public void requestPermissions(Activity activity, RequestPermissionsSuccessCallback successCallback, ErrorCallback errorCallback) {
        if (this.requestInProgress) {
            errorCallback.onError("A request for permissions is already running, please wait for it to finish before doing another request.");
            return;
        }
        if (activity == null) {
            errorCallback.onError("Unable to detect current Android Activity.");
            return;
        }
        this.successCallback = successCallback;
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add("android.permission.POST_NOTIFICATIONS");
        String[] requestNotificationPermission = permissions.toArray(new String[0]);
        if (!this.requestInProgress) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])requestNotificationPermission, (int)240);
            this.requestInProgress = true;
        }
    }

    @FunctionalInterface
    static interface RequestPermissionsSuccessCallback {
        public void onSuccess(int var1);
    }
}

