/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.messaging;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.firebase.messaging.RemoteMessage;
import io.flutter.FlutterInjector;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterShellArgs;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.loader.FlutterLoader;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugins.firebase.messaging.ContextHolder;
import io.flutter.plugins.firebase.messaging.FlutterFirebaseMessagingBackgroundService;
import io.flutter.plugins.firebase.messaging.FlutterFirebaseMessagingUtils;
import io.flutter.plugins.firebase.messaging.PluginRegistrantException;
import io.flutter.view.FlutterCallbackInformation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public class FlutterFirebaseMessagingBackgroundExecutor
implements MethodChannel.MethodCallHandler {
    private static final String TAG = "FLTFireBGExecutor";
    private static final String CALLBACK_HANDLE_KEY = "callback_handle";
    private static final String USER_CALLBACK_HANDLE_KEY = "user_callback_handle";
    private final AtomicBoolean isCallbackDispatcherReady = new AtomicBoolean(false);
    private MethodChannel backgroundChannel;
    private FlutterEngine backgroundFlutterEngine;

    public static void setCallbackDispatcher(long callbackHandle) {
        Context context = ContextHolder.getApplicationContext();
        if (context == null) {
            Log.e((String)TAG, (String)"Context is null, cannot continue.");
            return;
        }
        SharedPreferences prefs = context.getSharedPreferences("io.flutter.firebase.messaging.callback", 0);
        prefs.edit().putLong(CALLBACK_HANDLE_KEY, callbackHandle).apply();
    }

    public boolean isNotRunning() {
        return !this.isCallbackDispatcherReady.get();
    }

    private void onInitialized() {
        this.isCallbackDispatcherReady.set(true);
        FlutterFirebaseMessagingBackgroundService.onInitialized();
    }

    public void onMethodCall(MethodCall call, @NonNull MethodChannel.Result result) {
        String method = call.method;
        try {
            if (method.equals("MessagingBackground#initialized")) {
                this.onInitialized();
                result.success((Object)true);
            } else {
                result.notImplemented();
            }
        }
        catch (PluginRegistrantException e) {
            result.error("error", "Flutter FCM error: " + e.getMessage(), null);
        }
    }

    public void startBackgroundIsolate() {
        long callbackHandle;
        if (this.isNotRunning() && (callbackHandle = this.getPluginCallbackHandle()) != 0L) {
            this.startBackgroundIsolate(callbackHandle, null);
        }
    }

    public void startBackgroundIsolate(long callbackHandle, FlutterShellArgs shellArgs) {
        if (this.backgroundFlutterEngine != null) {
            Log.e((String)TAG, (String)"Background isolate already started.");
            return;
        }
        FlutterLoader loader = FlutterInjector.instance().flutterLoader();
        Handler mainHandler = new Handler(Looper.getMainLooper());
        Runnable myRunnable = () -> {
            loader.startInitialization(ContextHolder.getApplicationContext());
            loader.ensureInitializationCompleteAsync(ContextHolder.getApplicationContext(), null, mainHandler, () -> {
                String appBundlePath = loader.findAppBundlePath();
                AssetManager assets = ContextHolder.getApplicationContext().getAssets();
                if (this.isNotRunning()) {
                    if (shellArgs != null) {
                        Log.i((String)TAG, (String)("Creating background FlutterEngine instance, with args: " + Arrays.toString(shellArgs.toArray())));
                        this.backgroundFlutterEngine = new FlutterEngine(ContextHolder.getApplicationContext(), shellArgs.toArray());
                    } else {
                        Log.i((String)TAG, (String)"Creating background FlutterEngine instance.");
                        this.backgroundFlutterEngine = new FlutterEngine(ContextHolder.getApplicationContext());
                    }
                    FlutterCallbackInformation flutterCallback = FlutterCallbackInformation.lookupCallbackInformation((long)callbackHandle);
                    if (flutterCallback == null) {
                        Log.e((String)TAG, (String)"Failed to find registered callback");
                        return;
                    }
                    DartExecutor executor = this.backgroundFlutterEngine.getDartExecutor();
                    this.initializeMethodChannel((BinaryMessenger)executor);
                    DartExecutor.DartCallback dartCallback = new DartExecutor.DartCallback(assets, appBundlePath, flutterCallback);
                    executor.executeDartCallback(dartCallback);
                }
            });
        };
        mainHandler.post(myRunnable);
    }

    boolean isDartBackgroundHandlerRegistered() {
        return this.getPluginCallbackHandle() != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDartCallbackInBackgroundIsolate(Intent intent, final CountDownLatch latch) {
        byte[] parcelBytes;
        if (this.backgroundFlutterEngine == null) {
            Log.i((String)TAG, (String)"A background message could not be handled in Dart as no onBackgroundMessage handler has been registered.");
            return;
        }
        MethodChannel.Result result = null;
        if (latch != null) {
            result = new MethodChannel.Result(){

                public void success(Object result) {
                    latch.countDown();
                }

                public void error(String errorCode, String errorMessage, Object errorDetails) {
                    latch.countDown();
                }

                public void notImplemented() {
                    latch.countDown();
                }
            };
        }
        if ((parcelBytes = intent.getByteArrayExtra("notification")) != null) {
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(parcelBytes, 0, parcelBytes.length);
                parcel.setDataPosition(0);
                RemoteMessage remoteMessage = (RemoteMessage)RemoteMessage.CREATOR.createFromParcel(parcel);
                final Map<String, Object> remoteMessageMap = FlutterFirebaseMessagingUtils.remoteMessageToMap(remoteMessage);
                this.backgroundChannel.invokeMethod("MessagingBackground#onMessage", (Object)new HashMap<String, Object>(){
                    {
                        this.put("userCallbackHandle", FlutterFirebaseMessagingBackgroundExecutor.this.getUserCallbackHandle());
                        this.put("message", remoteMessageMap);
                    }
                }, result);
            }
            finally {
                parcel.recycle();
            }
        } else {
            Log.e((String)TAG, (String)"RemoteMessage byte array not found in Intent.");
        }
    }

    private long getUserCallbackHandle() {
        SharedPreferences prefs = ContextHolder.getApplicationContext().getSharedPreferences("io.flutter.firebase.messaging.callback", 0);
        return prefs.getLong(USER_CALLBACK_HANDLE_KEY, 0L);
    }

    public static void setUserCallbackHandle(long callbackHandle) {
        Context context = ContextHolder.getApplicationContext();
        SharedPreferences prefs = context.getSharedPreferences("io.flutter.firebase.messaging.callback", 0);
        prefs.edit().putLong(USER_CALLBACK_HANDLE_KEY, callbackHandle).apply();
    }

    private long getPluginCallbackHandle() {
        SharedPreferences prefs = ContextHolder.getApplicationContext().getSharedPreferences("io.flutter.firebase.messaging.callback", 0);
        return prefs.getLong(CALLBACK_HANDLE_KEY, 0L);
    }

    private void initializeMethodChannel(BinaryMessenger isolate) {
        this.backgroundChannel = new MethodChannel(isolate, "plugins.flutter.io/firebase_messaging_background");
        this.backgroundChannel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
    }
}

