/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.storage;

import android.net.Uri;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.ListResult;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugins.firebase.core.FlutterFirebasePlugin;
import io.flutter.plugins.firebase.core.FlutterFirebasePluginRegistry;
import io.flutter.plugins.firebase.storage.FlutterFirebaseStorageException;
import io.flutter.plugins.firebase.storage.FlutterFirebaseStorageTask;
import io.flutter.plugins.firebase.storage.GeneratedAndroidFirebaseStorage;
import io.flutter.plugins.firebase.storage.TaskStateChannelStreamHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class FlutterFirebaseStoragePlugin
implements FlutterFirebasePlugin,
FlutterPlugin,
GeneratedAndroidFirebaseStorage.FirebaseStorageHostApi {
    private MethodChannel channel;
    @Nullable
    private BinaryMessenger messenger;
    static final String STORAGE_METHOD_CHANNEL_NAME = "plugins.flutter.io/firebase_storage";
    static final String STORAGE_TASK_EVENT_NAME = "taskEvent";
    static final String DEFAULT_ERROR_CODE = "firebase_storage";
    static final Map<String, EventChannel> eventChannels = new HashMap<String, EventChannel>();
    static final Map<String, EventChannel.StreamHandler> streamHandlers = new HashMap<String, EventChannel.StreamHandler>();

    static Map<String, String> getExceptionDetails(Exception exception) {
        HashMap<String, String> details = new HashMap<String, String>();
        GeneratedAndroidFirebaseStorage.FlutterError storageException = FlutterFirebaseStorageException.parserExceptionToFlutter(exception);
        details.put("code", storageException.code);
        details.put("message", storageException.getMessage());
        return details;
    }

    static Map<String, Object> parseMetadataToMap(StorageMetadata storageMetadata) {
        if (storageMetadata == null) {
            return null;
        }
        HashMap<String, Object> out = new HashMap<String, Object>();
        if (storageMetadata.getName() != null) {
            out.put("name", storageMetadata.getName());
        }
        if (storageMetadata.getBucket() != null) {
            out.put("bucket", storageMetadata.getBucket());
        }
        if (storageMetadata.getGeneration() != null) {
            out.put("generation", storageMetadata.getGeneration());
        }
        if (storageMetadata.getMetadataGeneration() != null) {
            out.put("metadataGeneration", storageMetadata.getMetadataGeneration());
        }
        out.put("fullPath", storageMetadata.getPath());
        out.put("size", storageMetadata.getSizeBytes());
        out.put("creationTimeMillis", storageMetadata.getCreationTimeMillis());
        out.put("updatedTimeMillis", storageMetadata.getUpdatedTimeMillis());
        if (storageMetadata.getMd5Hash() != null) {
            out.put("md5Hash", storageMetadata.getMd5Hash());
        }
        if (storageMetadata.getCacheControl() != null) {
            out.put("cacheControl", storageMetadata.getCacheControl());
        }
        if (storageMetadata.getContentDisposition() != null) {
            out.put("contentDisposition", storageMetadata.getContentDisposition());
        }
        if (storageMetadata.getContentEncoding() != null) {
            out.put("contentEncoding", storageMetadata.getContentEncoding());
        }
        if (storageMetadata.getContentLanguage() != null) {
            out.put("contentLanguage", storageMetadata.getContentLanguage());
        }
        if (storageMetadata.getContentType() != null) {
            out.put("contentType", storageMetadata.getContentType());
        }
        HashMap<String, String> customMetadata = new HashMap<String, String>();
        for (String key : storageMetadata.getCustomMetadataKeys()) {
            if (storageMetadata.getCustomMetadata(key) == null) {
                customMetadata.put(key, "");
                continue;
            }
            customMetadata.put(key, Objects.requireNonNull(storageMetadata.getCustomMetadata(key)));
        }
        out.put("customMetadata", customMetadata);
        return out;
    }

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.initInstance(binding.getBinaryMessenger());
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        FlutterFirebaseStorageTask.cancelInProgressTasks();
        this.channel.setMethodCallHandler(null);
        assert (this.messenger != null);
        GeneratedAndroidFirebaseStorage.FirebaseStorageHostApi.setup(this.messenger, null);
        this.channel = null;
        this.messenger = null;
        this.removeEventListeners();
    }

    private void initInstance(BinaryMessenger messenger) {
        FlutterFirebasePluginRegistry.registerPlugin((String)STORAGE_METHOD_CHANNEL_NAME, (FlutterFirebasePlugin)this);
        this.channel = new MethodChannel(messenger, STORAGE_METHOD_CHANNEL_NAME);
        GeneratedAndroidFirebaseStorage.FirebaseStorageHostApi.setup(messenger, this);
        this.messenger = messenger;
    }

    private String registerEventChannel(String prefix, String identifier, EventChannel.StreamHandler handler) {
        String channelName = prefix + "/" + identifier;
        EventChannel channel = new EventChannel(this.messenger, channelName);
        channel.setStreamHandler(handler);
        eventChannels.put(identifier, channel);
        streamHandlers.put(identifier, handler);
        return identifier;
    }

    private synchronized void removeEventListeners() {
        ArrayList<String> eventChannelKeys = new ArrayList<String>(eventChannels.keySet());
        for (String identifier : eventChannelKeys) {
            EventChannel eventChannel = eventChannels.get(identifier);
            if (eventChannel != null) {
                eventChannel.setStreamHandler(null);
            }
            eventChannels.remove(identifier);
        }
        ArrayList<String> streamHandlerKeys = new ArrayList<String>(streamHandlers.keySet());
        for (String identifier : streamHandlerKeys) {
            EventChannel.StreamHandler streamHandler = streamHandlers.get(identifier);
            if (streamHandler != null) {
                streamHandler.onCancel(null);
            }
            streamHandlers.remove(identifier);
        }
    }

    private FirebaseStorage getStorageFromPigeon(GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app) {
        FirebaseApp androidApp = FirebaseApp.getInstance((String)app.getAppName());
        return FirebaseStorage.getInstance((FirebaseApp)androidApp, (String)("gs://" + app.getBucket()));
    }

    private StorageReference getReferenceFromPigeon(GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, GeneratedAndroidFirebaseStorage.PigeonStorageReference reference) {
        FirebaseStorage androidStorage = this.getStorageFromPigeon(app);
        return androidStorage.getReference(reference.getFullPath());
    }

    private GeneratedAndroidFirebaseStorage.PigeonStorageReference convertToPigeonReference(StorageReference reference) {
        return new GeneratedAndroidFirebaseStorage.PigeonStorageReference.Builder().setBucket(reference.getBucket()).setFullPath(reference.getPath()).setName(reference.getName()).build();
    }

    @Override
    public void getReferencebyPath(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull String path, @Nullable String bucket, @NonNull GeneratedAndroidFirebaseStorage.Result<GeneratedAndroidFirebaseStorage.PigeonStorageReference> result) {
        StorageReference androidReference = this.getStorageFromPigeon(app).getReference(path);
        result.success(this.convertToPigeonReference(androidReference));
    }

    @Override
    public void useStorageEmulator(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull String host, @NonNull Long port, @NonNull GeneratedAndroidFirebaseStorage.Result<Void> result) {
        try {
            FirebaseStorage androidStorage = this.getStorageFromPigeon(app);
            androidStorage.useEmulator(host, port.intValue());
            result.success(null);
        }
        catch (Exception e) {
            result.error(FlutterFirebaseStorageException.parserExceptionToFlutter(e));
        }
    }

    @Override
    public void referenceDelete(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull GeneratedAndroidFirebaseStorage.PigeonStorageReference reference, @NonNull GeneratedAndroidFirebaseStorage.Result<Void> result) {
        FirebaseStorage firebaseStorage = this.getStorageFromPigeon(app);
        StorageReference androidReference = firebaseStorage.getReference(reference.getFullPath());
        androidReference.delete().addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                result.success(null);
            } else {
                result.error(FlutterFirebaseStorageException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void referenceGetDownloadURL(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull GeneratedAndroidFirebaseStorage.PigeonStorageReference reference, @NonNull GeneratedAndroidFirebaseStorage.Result<String> result) {
        FirebaseStorage firebaseStorage = this.getStorageFromPigeon(app);
        StorageReference androidReference = firebaseStorage.getReference(reference.getFullPath());
        androidReference.getDownloadUrl().addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                Uri androidUrl = (Uri)task.getResult();
                result.success(androidUrl.toString());
            } else {
                result.error(FlutterFirebaseStorageException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void referenceGetData(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull GeneratedAndroidFirebaseStorage.PigeonStorageReference reference, @NonNull Long maxSize, @NonNull GeneratedAndroidFirebaseStorage.Result<byte[]> result) {
        FirebaseStorage firebaseStorage = this.getStorageFromPigeon(app);
        StorageReference androidReference = firebaseStorage.getReference(reference.getFullPath());
        androidReference.getBytes(maxSize.longValue()).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                byte[] androidData = (byte[])task.getResult();
                result.success(androidData);
            } else {
                result.error(FlutterFirebaseStorageException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    GeneratedAndroidFirebaseStorage.PigeonFullMetaData convertToPigeonMetaData(StorageMetadata meteData) {
        return new GeneratedAndroidFirebaseStorage.PigeonFullMetaData.Builder().setMetadata(FlutterFirebaseStoragePlugin.parseMetadataToMap(meteData)).build();
    }

    @Override
    public void referenceGetMetaData(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull GeneratedAndroidFirebaseStorage.PigeonStorageReference reference, @NonNull GeneratedAndroidFirebaseStorage.Result<GeneratedAndroidFirebaseStorage.PigeonFullMetaData> result) {
        FirebaseStorage firebaseStorage = this.getStorageFromPigeon(app);
        StorageReference androidReference = firebaseStorage.getReference(reference.getFullPath());
        androidReference.getMetadata().addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                StorageMetadata androidMetaData = (StorageMetadata)task.getResult();
                result.success(this.convertToPigeonMetaData(androidMetaData));
            } else {
                result.error(FlutterFirebaseStorageException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    GeneratedAndroidFirebaseStorage.PigeonListResult convertToPigeonListResult(ListResult listResult) {
        ArrayList<GeneratedAndroidFirebaseStorage.PigeonStorageReference> pigeonItems = new ArrayList<GeneratedAndroidFirebaseStorage.PigeonStorageReference>();
        for (StorageReference storageReference : listResult.getItems()) {
            pigeonItems.add(this.convertToPigeonReference(storageReference));
        }
        ArrayList<GeneratedAndroidFirebaseStorage.PigeonStorageReference> pigeonPrefixes = new ArrayList<GeneratedAndroidFirebaseStorage.PigeonStorageReference>();
        for (StorageReference storageReference : listResult.getPrefixes()) {
            pigeonPrefixes.add(this.convertToPigeonReference(storageReference));
        }
        return new GeneratedAndroidFirebaseStorage.PigeonListResult.Builder().setItems(pigeonItems).setPageToken(listResult.getPageToken()).setPrefixs(pigeonPrefixes).build();
    }

    @Override
    public void referenceList(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull GeneratedAndroidFirebaseStorage.PigeonStorageReference reference, @NonNull GeneratedAndroidFirebaseStorage.PigeonListOptions options, @NonNull GeneratedAndroidFirebaseStorage.Result<GeneratedAndroidFirebaseStorage.PigeonListResult> result) {
        FirebaseStorage firebaseStorage = this.getStorageFromPigeon(app);
        StorageReference androidReference = firebaseStorage.getReference(reference.getFullPath());
        Task androidResult = options.getPageToken() != null ? androidReference.list(options.getMaxResults().intValue(), options.getPageToken()) : androidReference.list(options.getMaxResults().intValue());
        androidResult.addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                ListResult androidListResult = (ListResult)task.getResult();
                result.success(this.convertToPigeonListResult(androidListResult));
            } else {
                result.error(FlutterFirebaseStorageException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void referenceListAll(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull GeneratedAndroidFirebaseStorage.PigeonStorageReference reference, @NonNull GeneratedAndroidFirebaseStorage.Result<GeneratedAndroidFirebaseStorage.PigeonListResult> result) {
        FirebaseStorage firebaseStorage = this.getStorageFromPigeon(app);
        StorageReference androidReference = firebaseStorage.getReference(reference.getFullPath());
        androidReference.listAll().addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                ListResult androidListResult = (ListResult)task.getResult();
                result.success(this.convertToPigeonListResult(androidListResult));
            } else {
                result.error(FlutterFirebaseStorageException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    StorageMetadata getMetaDataFromPigeon(GeneratedAndroidFirebaseStorage.PigeonSettableMetadata pigeonSettableMetatdata) {
        Map<String, String> pigeonCustomMetadata;
        StorageMetadata.Builder androidMetaDataBuilder = new StorageMetadata.Builder();
        if (pigeonSettableMetatdata.getContentType() != null) {
            androidMetaDataBuilder.setContentType(pigeonSettableMetatdata.getContentType());
        }
        if (pigeonSettableMetatdata.getCacheControl() != null) {
            androidMetaDataBuilder.setCacheControl(pigeonSettableMetatdata.getCacheControl());
        }
        if (pigeonSettableMetatdata.getContentDisposition() != null) {
            androidMetaDataBuilder.setContentDisposition(pigeonSettableMetatdata.getContentDisposition());
        }
        if (pigeonSettableMetatdata.getContentEncoding() != null) {
            androidMetaDataBuilder.setContentEncoding(pigeonSettableMetatdata.getContentEncoding());
        }
        if (pigeonSettableMetatdata.getContentLanguage() != null) {
            androidMetaDataBuilder.setContentLanguage(pigeonSettableMetatdata.getContentLanguage());
        }
        if ((pigeonCustomMetadata = pigeonSettableMetatdata.getCustomMetadata()) != null) {
            for (Map.Entry<String, String> entry : pigeonCustomMetadata.entrySet()) {
                androidMetaDataBuilder.setCustomMetadata(entry.getKey(), entry.getValue());
            }
        }
        return androidMetaDataBuilder.build();
    }

    @Override
    public void referenceUpdateMetadata(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull GeneratedAndroidFirebaseStorage.PigeonStorageReference reference, @NonNull GeneratedAndroidFirebaseStorage.PigeonSettableMetadata metadata, @NonNull GeneratedAndroidFirebaseStorage.Result<GeneratedAndroidFirebaseStorage.PigeonFullMetaData> result) {
        FirebaseStorage firebaseStorage = this.getStorageFromPigeon(app);
        StorageReference androidReference = firebaseStorage.getReference(reference.getFullPath());
        androidReference.updateMetadata(this.getMetaDataFromPigeon(metadata)).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                StorageMetadata androidMetadata = (StorageMetadata)task.getResult();
                result.success(this.convertToPigeonMetaData(androidMetadata));
            } else {
                result.error(FlutterFirebaseStorageException.parserExceptionToFlutter(task.getException()));
            }
        });
    }

    @Override
    public void referencePutData(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull GeneratedAndroidFirebaseStorage.PigeonStorageReference reference, @NonNull byte[] data, @NonNull GeneratedAndroidFirebaseStorage.PigeonSettableMetadata settableMetaData, @NonNull Long handle, @NonNull GeneratedAndroidFirebaseStorage.Result<String> result) {
        StorageReference androidReference = this.getReferenceFromPigeon(app, reference);
        StorageMetadata androidMetaData = this.getMetaDataFromPigeon(settableMetaData);
        FlutterFirebaseStorageTask storageTask = FlutterFirebaseStorageTask.uploadBytes(handle.intValue(), androidReference, data, androidMetaData);
        try {
            String identifier = UUID.randomUUID().toString().toLowerCase(Locale.US);
            TaskStateChannelStreamHandler handler = storageTask.startTaskWithMethodChannel(this.channel, identifier);
            result.success(this.registerEventChannel("plugins.flutter.io/firebase_storage/taskEvent", identifier, handler));
        }
        catch (Exception e) {
            result.error(FlutterFirebaseStorageException.parserExceptionToFlutter(e));
        }
    }

    @Override
    public void referencePutString(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull GeneratedAndroidFirebaseStorage.PigeonStorageReference reference, @NonNull String data, @NonNull Long format, @NonNull GeneratedAndroidFirebaseStorage.PigeonSettableMetadata settableMetaData, @NonNull Long handle, @NonNull GeneratedAndroidFirebaseStorage.Result<String> result) {
        StorageReference androidReference = this.getReferenceFromPigeon(app, reference);
        StorageMetadata androidMetaData = this.getMetaDataFromPigeon(settableMetaData);
        FlutterFirebaseStorageTask storageTask = FlutterFirebaseStorageTask.uploadBytes(handle.intValue(), androidReference, this.stringToByteData(data, format.intValue()), androidMetaData);
        try {
            String identifier = UUID.randomUUID().toString().toLowerCase(Locale.US);
            TaskStateChannelStreamHandler handler = storageTask.startTaskWithMethodChannel(this.channel, identifier);
            result.success(this.registerEventChannel("plugins.flutter.io/firebase_storage/taskEvent", identifier, handler));
        }
        catch (Exception e) {
            result.error(FlutterFirebaseStorageException.parserExceptionToFlutter(e));
        }
    }

    @Override
    public void referencePutFile(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull GeneratedAndroidFirebaseStorage.PigeonStorageReference reference, @NonNull String filePath, @Nullable GeneratedAndroidFirebaseStorage.PigeonSettableMetadata settableMetaData, @NonNull Long handle, @NonNull GeneratedAndroidFirebaseStorage.Result<String> result) {
        StorageReference androidReference = this.getReferenceFromPigeon(app, reference);
        FlutterFirebaseStorageTask storageTask = FlutterFirebaseStorageTask.uploadFile(handle.intValue(), androidReference, Uri.fromFile((File)new File(filePath)), settableMetaData == null ? null : this.getMetaDataFromPigeon(settableMetaData));
        try {
            String identifier = UUID.randomUUID().toString().toLowerCase(Locale.US);
            TaskStateChannelStreamHandler handler = storageTask.startTaskWithMethodChannel(this.channel, identifier);
            result.success(this.registerEventChannel("plugins.flutter.io/firebase_storage/taskEvent", identifier, handler));
        }
        catch (Exception e) {
            result.error(FlutterFirebaseStorageException.parserExceptionToFlutter(e));
        }
    }

    @Override
    public void referenceDownloadFile(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull GeneratedAndroidFirebaseStorage.PigeonStorageReference reference, @NonNull String filePath, @NonNull Long handle, @NonNull GeneratedAndroidFirebaseStorage.Result<String> result) {
        StorageReference androidReference = this.getReferenceFromPigeon(app, reference);
        FlutterFirebaseStorageTask storageTask = FlutterFirebaseStorageTask.downloadFile(handle.intValue(), androidReference, new File(filePath));
        try {
            String identifier = UUID.randomUUID().toString().toLowerCase(Locale.US);
            TaskStateChannelStreamHandler handler = storageTask.startTaskWithMethodChannel(this.channel, identifier);
            result.success(this.registerEventChannel("plugins.flutter.io/firebase_storage/taskEvent", identifier, handler));
        }
        catch (Exception e) {
            result.error(FlutterFirebaseStorageException.parserExceptionToFlutter(e));
        }
    }

    @Override
    public void taskPause(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull Long handle, @NonNull GeneratedAndroidFirebaseStorage.Result<Map<String, Object>> result) {
        FlutterFirebaseStorageTask storageTask = FlutterFirebaseStorageTask.getInProgressTaskForHandle(handle.intValue());
        if (storageTask == null) {
            result.error(new GeneratedAndroidFirebaseStorage.FlutterError("unknown", "Pause operation was called on a task which does not exist.", null));
            return;
        }
        HashMap<String, Object> statusMap = new HashMap<String, Object>();
        try {
            boolean paused = storageTask.getAndroidTask().pause();
            statusMap.put("status", paused);
            if (paused) {
                statusMap.put("snapshot", FlutterFirebaseStorageTask.parseTaskSnapshot(storageTask.getSnapshot()));
            }
            result.success(statusMap);
        }
        catch (Exception e) {
            result.error(FlutterFirebaseStorageException.parserExceptionToFlutter(e));
        }
    }

    @Override
    public void taskResume(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull Long handle, @NonNull GeneratedAndroidFirebaseStorage.Result<Map<String, Object>> result) {
        FlutterFirebaseStorageTask storageTask = FlutterFirebaseStorageTask.getInProgressTaskForHandle(handle.intValue());
        if (storageTask == null) {
            result.error(new GeneratedAndroidFirebaseStorage.FlutterError("unknown", "Resume operation was called on a task which does not exist.", null));
            return;
        }
        try {
            boolean resumed = storageTask.getAndroidTask().resume();
            HashMap<String, Object> statusMap = new HashMap<String, Object>();
            statusMap.put("status", resumed);
            if (resumed) {
                statusMap.put("snapshot", FlutterFirebaseStorageTask.parseTaskSnapshot(storageTask.getSnapshot()));
            }
            result.success(statusMap);
        }
        catch (Exception e) {
            result.error(FlutterFirebaseStorageException.parserExceptionToFlutter(e));
        }
    }

    @Override
    public void taskCancel(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull Long handle, @NonNull GeneratedAndroidFirebaseStorage.Result<Map<String, Object>> result) {
        FlutterFirebaseStorageTask storageTask = FlutterFirebaseStorageTask.getInProgressTaskForHandle(handle.intValue());
        if (storageTask == null) {
            result.error(new GeneratedAndroidFirebaseStorage.FlutterError("unknown", "Cancel operation was called on a task which does not exist.", null));
            return;
        }
        try {
            boolean canceled = storageTask.getAndroidTask().cancel();
            HashMap<String, Object> statusMap = new HashMap<String, Object>();
            statusMap.put("status", canceled);
            if (canceled) {
                statusMap.put("snapshot", FlutterFirebaseStorageTask.parseTaskSnapshot(storageTask.getSnapshot()));
            }
            result.success(statusMap);
        }
        catch (Exception e) {
            result.error(FlutterFirebaseStorageException.parserExceptionToFlutter(e));
        }
    }

    @Override
    public void setMaxOperationRetryTime(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull Long time, @NonNull GeneratedAndroidFirebaseStorage.Result<Void> result) {
        FirebaseStorage androidStorage = this.getStorageFromPigeon(app);
        androidStorage.setMaxOperationRetryTimeMillis(time.longValue());
        result.success(null);
    }

    @Override
    public void setMaxUploadRetryTime(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull Long time, @NonNull GeneratedAndroidFirebaseStorage.Result<Void> result) {
        FirebaseStorage androidStorage = this.getStorageFromPigeon(app);
        androidStorage.setMaxUploadRetryTimeMillis(time.longValue());
        result.success(null);
    }

    @Override
    public void setMaxDownloadRetryTime(@NonNull GeneratedAndroidFirebaseStorage.PigeonStorageFirebaseApp app, @NonNull Long time, @NonNull GeneratedAndroidFirebaseStorage.Result<Void> result) {
        FirebaseStorage androidStorage = this.getStorageFromPigeon(app);
        androidStorage.setMaxDownloadRetryTimeMillis(time.longValue());
        result.success(null);
    }

    private byte[] stringToByteData(@NonNull String data, int format) {
        switch (format) {
            case 1: {
                return Base64.decode((String)data, (int)0);
            }
            case 2: {
                return Base64.decode((String)data, (int)8);
            }
        }
        return null;
    }

    public Task<Map<String, Object>> getPluginConstantsForFirebaseApp(FirebaseApp firebaseApp) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            HashMap obj = new HashMap();
            taskCompletionSource.setResult(obj);
        });
        return taskCompletionSource.getTask();
    }

    public Task<Void> didReinitializeFirebaseCore() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        cachedThreadPool.execute(() -> {
            FlutterFirebaseStorageTask.cancelInProgressTasks();
            taskCompletionSource.setResult(null);
            this.removeEventListeners();
        });
        return taskCompletionSource.getTask();
    }
}

