/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.storage;

import androidx.annotation.Nullable;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageTask;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugins.firebase.storage.FlutterFirebaseStorageException;
import io.flutter.plugins.firebase.storage.FlutterFirebaseStoragePlugin;
import io.flutter.plugins.firebase.storage.FlutterFirebaseStorageTask;
import io.flutter.plugins.firebase.storage.GeneratedAndroidFirebaseStorage;
import java.util.HashMap;
import java.util.Map;

public class TaskStateChannelStreamHandler
implements EventChannel.StreamHandler {
    private final FlutterFirebaseStorageTask flutterTask;
    private final FirebaseStorage androidStorage;
    private final StorageTask<?> androidTask;
    private final String identifier;
    private final String TASK_STATE_NAME = "taskState";
    private final String TASK_APP_NAME = "appName";
    private final String TASK_SNAPSHOT = "snapshot";
    private final String TASK_ERROR = "error";

    public TaskStateChannelStreamHandler(FlutterFirebaseStorageTask flutterTask, FirebaseStorage androidStorage, StorageTask androidTask, String identifier) {
        this.flutterTask = flutterTask;
        this.androidStorage = androidStorage;
        this.androidTask = androidTask;
        this.identifier = identifier;
    }

    public void onListen(Object arguments, EventChannel.EventSink events) {
        this.androidTask.addOnProgressListener(taskSnapshot -> {
            if (this.flutterTask.isDestroyed()) {
                return;
            }
            Map<String, Object> event = this.getTaskEventMap(taskSnapshot, null);
            event.put("taskState", GeneratedAndroidFirebaseStorage.PigeonStorageTaskState.RUNNING.index);
            events.success(event);
            this.flutterTask.notifyResumeObjects();
        });
        this.androidTask.addOnPausedListener(taskSnapshot -> {
            if (this.flutterTask.isDestroyed()) {
                return;
            }
            Map<String, Object> event = this.getTaskEventMap(taskSnapshot, null);
            event.put("taskState", GeneratedAndroidFirebaseStorage.PigeonStorageTaskState.PAUSED.index);
            events.success(event);
            this.flutterTask.notifyPauseObjects();
        });
        this.androidTask.addOnSuccessListener(taskSnapshot -> {
            if (this.flutterTask.isDestroyed()) {
                return;
            }
            Map<String, Object> event = this.getTaskEventMap(taskSnapshot, null);
            event.put("taskState", GeneratedAndroidFirebaseStorage.PigeonStorageTaskState.SUCCESS.index);
            events.success(event);
            this.flutterTask.destroy();
        });
        this.androidTask.addOnCanceledListener(() -> {
            if (this.flutterTask.isDestroyed()) {
                return;
            }
            Map<String, Object> event = this.getTaskEventMap(null, null);
            event.put("taskState", GeneratedAndroidFirebaseStorage.PigeonStorageTaskState.ERROR.index);
            HashMap<String, String> syntheticException = new HashMap<String, String>();
            syntheticException.put("code", FlutterFirebaseStorageException.getCode(-13040));
            syntheticException.put("message", FlutterFirebaseStorageException.getMessage(-13040));
            event.put("error", syntheticException);
            events.success(event);
            this.flutterTask.notifyCancelObjects();
            this.flutterTask.destroy();
        });
        this.androidTask.addOnFailureListener(exception -> {
            if (this.flutterTask.isDestroyed()) {
                return;
            }
            Map<String, Object> event = this.getTaskEventMap(null, exception);
            event.put("taskState", GeneratedAndroidFirebaseStorage.PigeonStorageTaskState.ERROR.index);
            events.success(event);
            this.flutterTask.destroy();
        });
    }

    public void onCancel(Object arguments) {
        EventChannel eventChannel;
        if (!this.androidTask.isCanceled()) {
            this.androidTask.cancel();
        }
        if (!this.flutterTask.isDestroyed()) {
            this.flutterTask.destroy();
        }
        if ((eventChannel = FlutterFirebaseStoragePlugin.eventChannels.get(this.identifier)) != null) {
            eventChannel.setStreamHandler(null);
            FlutterFirebaseStoragePlugin.eventChannels.remove(this.identifier);
        }
        if (FlutterFirebaseStoragePlugin.streamHandlers.get(this.identifier) != null) {
            FlutterFirebaseStoragePlugin.streamHandlers.remove(this.identifier);
        }
    }

    private Map<String, Object> getTaskEventMap(@Nullable Object snapshot, @Nullable Exception exception) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("appName", this.androidStorage.getApp().getName());
        if (snapshot != null) {
            arguments.put("snapshot", FlutterFirebaseStorageTask.parseTaskSnapshot(snapshot));
        }
        if (exception != null) {
            arguments.put("error", FlutterFirebaseStoragePlugin.getExceptionDetails(exception));
        }
        return arguments;
    }
}

