/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.storage;

import androidx.annotation.Nullable;
import com.google.firebase.storage.StorageException;
import io.flutter.plugins.firebase.storage.GeneratedAndroidFirebaseStorage;

class FlutterFirebaseStorageException {
    FlutterFirebaseStorageException() {
    }

    static GeneratedAndroidFirebaseStorage.FlutterError parserExceptionToFlutter(@Nullable Exception nativeException) {
        if (nativeException == null) {
            return new GeneratedAndroidFirebaseStorage.FlutterError("UNKNOWN", "An unknown error occurred", null);
        }
        String code = "UNKNOWN";
        String message = "An unknown error occurred:" + nativeException.getMessage();
        if (nativeException instanceof StorageException) {
            int codeNumber = ((StorageException)nativeException).getErrorCode();
            code = FlutterFirebaseStorageException.getCode(codeNumber);
            message = FlutterFirebaseStorageException.getMessage(codeNumber);
        }
        return new GeneratedAndroidFirebaseStorage.FlutterError(code, message, null);
    }

    public static String getCode(int codeNumber) {
        switch (codeNumber) {
            case -13010: {
                return "object-not-found";
            }
            case -13011: {
                return "bucket-not-found";
            }
            case -13012: {
                return "project-not-found";
            }
            case -13013: {
                return "quota-exceeded";
            }
            case -13020: {
                return "unauthenticated";
            }
            case -13021: {
                return "unauthorized";
            }
            case -13030: {
                return "retry-limit-exceeded";
            }
            case -13031: {
                return "invalid-checksum";
            }
            case -13040: {
                return "canceled";
            }
        }
        return "unknown";
    }

    public static String getMessage(int codeNumber) {
        switch (codeNumber) {
            case -13010: {
                return "No object exists at the desired reference.";
            }
            case -13011: {
                return "No bucket is configured for Firebase Storage.";
            }
            case -13012: {
                return "No project is configured for Firebase Storage.";
            }
            case -13013: {
                return "Quota on your Firebase Storage bucket has been exceeded.";
            }
            case -13020: {
                return "User is unauthenticated. Authenticate and try again.";
            }
            case -13021: {
                return "User is not authorized to perform the desired action.";
            }
            case -13030: {
                return "The maximum time limit on an operation (upload, download, delete, etc.) has been exceeded.";
            }
            case -13031: {
                return "File on the client does not match the checksum of the file received by the server.";
            }
            case -13040: {
                return "User cancelled the operation.";
            }
        }
        return "An unknown error occurred";
    }
}

