/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.storage;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GeneratedAndroidFirebaseStorage {
    @NonNull
    protected static ArrayList<Object> wrapError(@NonNull Throwable exception) {
        ArrayList<Object> errorList = new ArrayList<Object>(3);
        if (exception instanceof FlutterError) {
            FlutterError error = (FlutterError)exception;
            errorList.add(error.code);
            errorList.add(error.getMessage());
            errorList.add(error.details);
        } else {
            errorList.add(exception.toString());
            errorList.add(exception.getClass().getSimpleName());
            errorList.add("Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString((Throwable)exception));
        }
        return errorList;
    }

    public static class FlutterError
    extends RuntimeException {
        public final String code;
        public final Object details;

        public FlutterError(@NonNull String code, @Nullable String message, @Nullable Object details) {
            super(message);
            this.code = code;
            this.details = details;
        }
    }

    public static interface FirebaseStorageHostApi {
        public void getReferencebyPath(@NonNull PigeonStorageFirebaseApp var1, @NonNull String var2, @Nullable String var3, @NonNull Result<PigeonStorageReference> var4);

        public void setMaxOperationRetryTime(@NonNull PigeonStorageFirebaseApp var1, @NonNull Long var2, @NonNull Result<Void> var3);

        public void setMaxUploadRetryTime(@NonNull PigeonStorageFirebaseApp var1, @NonNull Long var2, @NonNull Result<Void> var3);

        public void setMaxDownloadRetryTime(@NonNull PigeonStorageFirebaseApp var1, @NonNull Long var2, @NonNull Result<Void> var3);

        public void useStorageEmulator(@NonNull PigeonStorageFirebaseApp var1, @NonNull String var2, @NonNull Long var3, @NonNull Result<Void> var4);

        public void referenceDelete(@NonNull PigeonStorageFirebaseApp var1, @NonNull PigeonStorageReference var2, @NonNull Result<Void> var3);

        public void referenceGetDownloadURL(@NonNull PigeonStorageFirebaseApp var1, @NonNull PigeonStorageReference var2, @NonNull Result<String> var3);

        public void referenceGetMetaData(@NonNull PigeonStorageFirebaseApp var1, @NonNull PigeonStorageReference var2, @NonNull Result<PigeonFullMetaData> var3);

        public void referenceList(@NonNull PigeonStorageFirebaseApp var1, @NonNull PigeonStorageReference var2, @NonNull PigeonListOptions var3, @NonNull Result<PigeonListResult> var4);

        public void referenceListAll(@NonNull PigeonStorageFirebaseApp var1, @NonNull PigeonStorageReference var2, @NonNull Result<PigeonListResult> var3);

        public void referenceGetData(@NonNull PigeonStorageFirebaseApp var1, @NonNull PigeonStorageReference var2, @NonNull Long var3, @NonNull Result<byte[]> var4);

        public void referencePutData(@NonNull PigeonStorageFirebaseApp var1, @NonNull PigeonStorageReference var2, @NonNull byte[] var3, @NonNull PigeonSettableMetadata var4, @NonNull Long var5, @NonNull Result<String> var6);

        public void referencePutString(@NonNull PigeonStorageFirebaseApp var1, @NonNull PigeonStorageReference var2, @NonNull String var3, @NonNull Long var4, @NonNull PigeonSettableMetadata var5, @NonNull Long var6, @NonNull Result<String> var7);

        public void referencePutFile(@NonNull PigeonStorageFirebaseApp var1, @NonNull PigeonStorageReference var2, @NonNull String var3, @Nullable PigeonSettableMetadata var4, @NonNull Long var5, @NonNull Result<String> var6);

        public void referenceDownloadFile(@NonNull PigeonStorageFirebaseApp var1, @NonNull PigeonStorageReference var2, @NonNull String var3, @NonNull Long var4, @NonNull Result<String> var5);

        public void referenceUpdateMetadata(@NonNull PigeonStorageFirebaseApp var1, @NonNull PigeonStorageReference var2, @NonNull PigeonSettableMetadata var3, @NonNull Result<PigeonFullMetaData> var4);

        public void taskPause(@NonNull PigeonStorageFirebaseApp var1, @NonNull Long var2, @NonNull Result<Map<String, Object>> var3);

        public void taskResume(@NonNull PigeonStorageFirebaseApp var1, @NonNull Long var2, @NonNull Result<Map<String, Object>> var3);

        public void taskCancel(@NonNull PigeonStorageFirebaseApp var1, @NonNull Long var2, @NonNull Result<Map<String, Object>> var3);

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return FirebaseStorageHostApiCodec.INSTANCE;
        }

        public static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable FirebaseStorageHostApi api) {
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.getReferencebyPath", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    String pathArg = (String)args.get(1);
                    String bucketArg = (String)args.get(2);
                    Result<PigeonStorageReference> resultCallback = new Result<PigeonStorageReference>(){

                        @Override
                        public void success(PigeonStorageReference result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.getReferencebyPath(appArg, pathArg, bucketArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.setMaxOperationRetryTime", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    Number timeArg = (Number)args.get(1);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.setMaxOperationRetryTime(appArg, timeArg == null ? null : Long.valueOf(timeArg.longValue()), resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.setMaxUploadRetryTime", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    Number timeArg = (Number)args.get(1);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.setMaxUploadRetryTime(appArg, timeArg == null ? null : Long.valueOf(timeArg.longValue()), resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.setMaxDownloadRetryTime", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    Number timeArg = (Number)args.get(1);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.setMaxDownloadRetryTime(appArg, timeArg == null ? null : Long.valueOf(timeArg.longValue()), resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.useStorageEmulator", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    String hostArg = (String)args.get(1);
                    Number portArg = (Number)args.get(2);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.useStorageEmulator(appArg, hostArg, portArg == null ? null : Long.valueOf(portArg.longValue()), resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.referenceDelete", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    PigeonStorageReference referenceArg = (PigeonStorageReference)args.get(1);
                    Result<Void> resultCallback = new Result<Void>(){

                        @Override
                        public void success(Void result) {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.referenceDelete(appArg, referenceArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.referenceGetDownloadURL", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    PigeonStorageReference referenceArg = (PigeonStorageReference)args.get(1);
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.referenceGetDownloadURL(appArg, referenceArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.referenceGetMetaData", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    PigeonStorageReference referenceArg = (PigeonStorageReference)args.get(1);
                    Result<PigeonFullMetaData> resultCallback = new Result<PigeonFullMetaData>(){

                        @Override
                        public void success(PigeonFullMetaData result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.referenceGetMetaData(appArg, referenceArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.referenceList", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    PigeonStorageReference referenceArg = (PigeonStorageReference)args.get(1);
                    PigeonListOptions optionsArg = (PigeonListOptions)args.get(2);
                    Result<PigeonListResult> resultCallback = new Result<PigeonListResult>(){

                        @Override
                        public void success(PigeonListResult result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.referenceList(appArg, referenceArg, optionsArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.referenceListAll", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    PigeonStorageReference referenceArg = (PigeonStorageReference)args.get(1);
                    Result<PigeonListResult> resultCallback = new Result<PigeonListResult>(){

                        @Override
                        public void success(PigeonListResult result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.referenceListAll(appArg, referenceArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.referenceGetData", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    PigeonStorageReference referenceArg = (PigeonStorageReference)args.get(1);
                    Number maxSizeArg = (Number)args.get(2);
                    Result<byte[]> resultCallback = new Result<byte[]>(){

                        @Override
                        public void success(byte[] result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.referenceGetData(appArg, referenceArg, maxSizeArg == null ? null : Long.valueOf(maxSizeArg.longValue()), resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.referencePutData", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    PigeonStorageReference referenceArg = (PigeonStorageReference)args.get(1);
                    byte[] dataArg = (byte[])args.get(2);
                    PigeonSettableMetadata settableMetaDataArg = (PigeonSettableMetadata)args.get(3);
                    Number handleArg = (Number)args.get(4);
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.referencePutData(appArg, referenceArg, dataArg, settableMetaDataArg, handleArg == null ? null : Long.valueOf(handleArg.longValue()), resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.referencePutString", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    PigeonStorageReference referenceArg = (PigeonStorageReference)args.get(1);
                    String dataArg = (String)args.get(2);
                    Number formatArg = (Number)args.get(3);
                    PigeonSettableMetadata settableMetaDataArg = (PigeonSettableMetadata)args.get(4);
                    Number handleArg = (Number)args.get(5);
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.referencePutString(appArg, referenceArg, dataArg, formatArg == null ? null : Long.valueOf(formatArg.longValue()), settableMetaDataArg, handleArg == null ? null : Long.valueOf(handleArg.longValue()), resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.referencePutFile", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    PigeonStorageReference referenceArg = (PigeonStorageReference)args.get(1);
                    String filePathArg = (String)args.get(2);
                    PigeonSettableMetadata settableMetaDataArg = (PigeonSettableMetadata)args.get(3);
                    Number handleArg = (Number)args.get(4);
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.referencePutFile(appArg, referenceArg, filePathArg, settableMetaDataArg, handleArg == null ? null : Long.valueOf(handleArg.longValue()), resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.referenceDownloadFile", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    PigeonStorageReference referenceArg = (PigeonStorageReference)args.get(1);
                    String filePathArg = (String)args.get(2);
                    Number handleArg = (Number)args.get(3);
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.referenceDownloadFile(appArg, referenceArg, filePathArg, handleArg == null ? null : Long.valueOf(handleArg.longValue()), resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.referenceUpdateMetadata", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    PigeonStorageReference referenceArg = (PigeonStorageReference)args.get(1);
                    PigeonSettableMetadata metadataArg = (PigeonSettableMetadata)args.get(2);
                    Result<PigeonFullMetaData> resultCallback = new Result<PigeonFullMetaData>(){

                        @Override
                        public void success(PigeonFullMetaData result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.referenceUpdateMetadata(appArg, referenceArg, metadataArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.taskPause", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    Number handleArg = (Number)args.get(1);
                    Result<Map<String, Object>> resultCallback = new Result<Map<String, Object>>(){

                        @Override
                        public void success(Map<String, Object> result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.taskPause(appArg, handleArg == null ? null : Long.valueOf(handleArg.longValue()), resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.taskResume", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    Number handleArg = (Number)args.get(1);
                    Result<Map<String, Object>> resultCallback = new Result<Map<String, Object>>(){

                        @Override
                        public void success(Map<String, Object> result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.taskResume(appArg, handleArg == null ? null : Long.valueOf(handleArg.longValue()), resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.firebase_storage_platform_interface.FirebaseStorageHostApi.taskCancel", FirebaseStorageHostApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PigeonStorageFirebaseApp appArg = (PigeonStorageFirebaseApp)args.get(0);
                    Number handleArg = (Number)args.get(1);
                    Result<Map<String, Object>> resultCallback = new Result<Map<String, Object>>(){

                        @Override
                        public void success(Map<String, Object> result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = GeneratedAndroidFirebaseStorage.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.taskCancel(appArg, handleArg == null ? null : Long.valueOf(handleArg.longValue()), resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    private static class FirebaseStorageHostApiCodec
    extends StandardMessageCodec {
        public static final FirebaseStorageHostApiCodec INSTANCE = new FirebaseStorageHostApiCodec();

        private FirebaseStorageHostApiCodec() {
        }

        protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
            switch (type) {
                case -128: {
                    return PigeonFullMetaData.fromList((ArrayList)this.readValue(buffer));
                }
                case -127: {
                    return PigeonListOptions.fromList((ArrayList)this.readValue(buffer));
                }
                case -126: {
                    return PigeonListResult.fromList((ArrayList)this.readValue(buffer));
                }
                case -125: {
                    return PigeonSettableMetadata.fromList((ArrayList)this.readValue(buffer));
                }
                case -124: {
                    return PigeonStorageFirebaseApp.fromList((ArrayList)this.readValue(buffer));
                }
                case -123: {
                    return PigeonStorageReference.fromList((ArrayList)this.readValue(buffer));
                }
            }
            return super.readValueOfType(type, buffer);
        }

        protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
            if (value instanceof PigeonFullMetaData) {
                stream.write(128);
                this.writeValue(stream, ((PigeonFullMetaData)value).toList());
            } else if (value instanceof PigeonListOptions) {
                stream.write(129);
                this.writeValue(stream, ((PigeonListOptions)value).toList());
            } else if (value instanceof PigeonListResult) {
                stream.write(130);
                this.writeValue(stream, ((PigeonListResult)value).toList());
            } else if (value instanceof PigeonSettableMetadata) {
                stream.write(131);
                this.writeValue(stream, ((PigeonSettableMetadata)value).toList());
            } else if (value instanceof PigeonStorageFirebaseApp) {
                stream.write(132);
                this.writeValue(stream, ((PigeonStorageFirebaseApp)value).toList());
            } else if (value instanceof PigeonStorageReference) {
                stream.write(133);
                this.writeValue(stream, ((PigeonStorageReference)value).toList());
            } else {
                super.writeValue(stream, value);
            }
        }
    }

    public static interface Result<T> {
        public void success(T var1);

        public void error(@NonNull Throwable var1);
    }

    public static final class PigeonListResult {
        @NonNull
        private List<PigeonStorageReference> items;
        @Nullable
        private String pageToken;
        @NonNull
        private List<PigeonStorageReference> prefixs;

        @NonNull
        public List<PigeonStorageReference> getItems() {
            return this.items;
        }

        public void setItems(@NonNull List<PigeonStorageReference> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"items\" is null.");
            }
            this.items = setterArg;
        }

        @Nullable
        public String getPageToken() {
            return this.pageToken;
        }

        public void setPageToken(@Nullable String setterArg) {
            this.pageToken = setterArg;
        }

        @NonNull
        public List<PigeonStorageReference> getPrefixs() {
            return this.prefixs;
        }

        public void setPrefixs(@NonNull List<PigeonStorageReference> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"prefixs\" is null.");
            }
            this.prefixs = setterArg;
        }

        PigeonListResult() {
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add(this.items);
            toListResult.add(this.pageToken);
            toListResult.add(this.prefixs);
            return toListResult;
        }

        @NonNull
        static PigeonListResult fromList(@NonNull ArrayList<Object> list) {
            PigeonListResult pigeonResult = new PigeonListResult();
            Object items = list.get(0);
            pigeonResult.setItems((List)items);
            Object pageToken = list.get(1);
            pigeonResult.setPageToken((String)pageToken);
            Object prefixs = list.get(2);
            pigeonResult.setPrefixs((List)prefixs);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private List<PigeonStorageReference> items;
            @Nullable
            private String pageToken;
            @Nullable
            private List<PigeonStorageReference> prefixs;

            @NonNull
            public Builder setItems(@NonNull List<PigeonStorageReference> setterArg) {
                this.items = setterArg;
                return this;
            }

            @NonNull
            public Builder setPageToken(@Nullable String setterArg) {
                this.pageToken = setterArg;
                return this;
            }

            @NonNull
            public Builder setPrefixs(@NonNull List<PigeonStorageReference> setterArg) {
                this.prefixs = setterArg;
                return this;
            }

            @NonNull
            public PigeonListResult build() {
                PigeonListResult pigeonReturn = new PigeonListResult();
                pigeonReturn.setItems(this.items);
                pigeonReturn.setPageToken(this.pageToken);
                pigeonReturn.setPrefixs(this.prefixs);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonSettableMetadata {
        @Nullable
        private String cacheControl;
        @Nullable
        private String contentDisposition;
        @Nullable
        private String contentEncoding;
        @Nullable
        private String contentLanguage;
        @Nullable
        private String contentType;
        @Nullable
        private Map<String, String> customMetadata;

        @Nullable
        public String getCacheControl() {
            return this.cacheControl;
        }

        public void setCacheControl(@Nullable String setterArg) {
            this.cacheControl = setterArg;
        }

        @Nullable
        public String getContentDisposition() {
            return this.contentDisposition;
        }

        public void setContentDisposition(@Nullable String setterArg) {
            this.contentDisposition = setterArg;
        }

        @Nullable
        public String getContentEncoding() {
            return this.contentEncoding;
        }

        public void setContentEncoding(@Nullable String setterArg) {
            this.contentEncoding = setterArg;
        }

        @Nullable
        public String getContentLanguage() {
            return this.contentLanguage;
        }

        public void setContentLanguage(@Nullable String setterArg) {
            this.contentLanguage = setterArg;
        }

        @Nullable
        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(@Nullable String setterArg) {
            this.contentType = setterArg;
        }

        @Nullable
        public Map<String, String> getCustomMetadata() {
            return this.customMetadata;
        }

        public void setCustomMetadata(@Nullable Map<String, String> setterArg) {
            this.customMetadata = setterArg;
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(6);
            toListResult.add(this.cacheControl);
            toListResult.add(this.contentDisposition);
            toListResult.add(this.contentEncoding);
            toListResult.add(this.contentLanguage);
            toListResult.add(this.contentType);
            toListResult.add(this.customMetadata);
            return toListResult;
        }

        @NonNull
        static PigeonSettableMetadata fromList(@NonNull ArrayList<Object> list) {
            PigeonSettableMetadata pigeonResult = new PigeonSettableMetadata();
            Object cacheControl = list.get(0);
            pigeonResult.setCacheControl((String)cacheControl);
            Object contentDisposition = list.get(1);
            pigeonResult.setContentDisposition((String)contentDisposition);
            Object contentEncoding = list.get(2);
            pigeonResult.setContentEncoding((String)contentEncoding);
            Object contentLanguage = list.get(3);
            pigeonResult.setContentLanguage((String)contentLanguage);
            Object contentType = list.get(4);
            pigeonResult.setContentType((String)contentType);
            Object customMetadata = list.get(5);
            pigeonResult.setCustomMetadata((Map)customMetadata);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String cacheControl;
            @Nullable
            private String contentDisposition;
            @Nullable
            private String contentEncoding;
            @Nullable
            private String contentLanguage;
            @Nullable
            private String contentType;
            @Nullable
            private Map<String, String> customMetadata;

            @NonNull
            public Builder setCacheControl(@Nullable String setterArg) {
                this.cacheControl = setterArg;
                return this;
            }

            @NonNull
            public Builder setContentDisposition(@Nullable String setterArg) {
                this.contentDisposition = setterArg;
                return this;
            }

            @NonNull
            public Builder setContentEncoding(@Nullable String setterArg) {
                this.contentEncoding = setterArg;
                return this;
            }

            @NonNull
            public Builder setContentLanguage(@Nullable String setterArg) {
                this.contentLanguage = setterArg;
                return this;
            }

            @NonNull
            public Builder setContentType(@Nullable String setterArg) {
                this.contentType = setterArg;
                return this;
            }

            @NonNull
            public Builder setCustomMetadata(@Nullable Map<String, String> setterArg) {
                this.customMetadata = setterArg;
                return this;
            }

            @NonNull
            public PigeonSettableMetadata build() {
                PigeonSettableMetadata pigeonReturn = new PigeonSettableMetadata();
                pigeonReturn.setCacheControl(this.cacheControl);
                pigeonReturn.setContentDisposition(this.contentDisposition);
                pigeonReturn.setContentEncoding(this.contentEncoding);
                pigeonReturn.setContentLanguage(this.contentLanguage);
                pigeonReturn.setContentType(this.contentType);
                pigeonReturn.setCustomMetadata(this.customMetadata);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonListOptions {
        @NonNull
        private Long maxResults;
        @Nullable
        private String pageToken;

        @NonNull
        public Long getMaxResults() {
            return this.maxResults;
        }

        public void setMaxResults(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"maxResults\" is null.");
            }
            this.maxResults = setterArg;
        }

        @Nullable
        public String getPageToken() {
            return this.pageToken;
        }

        public void setPageToken(@Nullable String setterArg) {
            this.pageToken = setterArg;
        }

        PigeonListOptions() {
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.maxResults);
            toListResult.add(this.pageToken);
            return toListResult;
        }

        @NonNull
        static PigeonListOptions fromList(@NonNull ArrayList<Object> list) {
            PigeonListOptions pigeonResult = new PigeonListOptions();
            Object maxResults = list.get(0);
            pigeonResult.setMaxResults(maxResults == null ? null : Long.valueOf(maxResults instanceof Integer ? (long)((Integer)maxResults).intValue() : (Long)maxResults));
            Object pageToken = list.get(1);
            pigeonResult.setPageToken((String)pageToken);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Long maxResults;
            @Nullable
            private String pageToken;

            @NonNull
            public Builder setMaxResults(@NonNull Long setterArg) {
                this.maxResults = setterArg;
                return this;
            }

            @NonNull
            public Builder setPageToken(@Nullable String setterArg) {
                this.pageToken = setterArg;
                return this;
            }

            @NonNull
            public PigeonListOptions build() {
                PigeonListOptions pigeonReturn = new PigeonListOptions();
                pigeonReturn.setMaxResults(this.maxResults);
                pigeonReturn.setPageToken(this.pageToken);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonFullMetaData {
        @Nullable
        private Map<String, Object> metadata;

        @Nullable
        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        public void setMetadata(@Nullable Map<String, Object> setterArg) {
            this.metadata = setterArg;
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(1);
            toListResult.add(this.metadata);
            return toListResult;
        }

        @NonNull
        static PigeonFullMetaData fromList(@NonNull ArrayList<Object> list) {
            PigeonFullMetaData pigeonResult = new PigeonFullMetaData();
            Object metadata = list.get(0);
            pigeonResult.setMetadata((Map)metadata);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Map<String, Object> metadata;

            @NonNull
            public Builder setMetadata(@Nullable Map<String, Object> setterArg) {
                this.metadata = setterArg;
                return this;
            }

            @NonNull
            public PigeonFullMetaData build() {
                PigeonFullMetaData pigeonReturn = new PigeonFullMetaData();
                pigeonReturn.setMetadata(this.metadata);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonStorageReference {
        @NonNull
        private String bucket;
        @NonNull
        private String fullPath;
        @NonNull
        private String name;

        @NonNull
        public String getBucket() {
            return this.bucket;
        }

        public void setBucket(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"bucket\" is null.");
            }
            this.bucket = setterArg;
        }

        @NonNull
        public String getFullPath() {
            return this.fullPath;
        }

        public void setFullPath(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"fullPath\" is null.");
            }
            this.fullPath = setterArg;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        public void setName(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"name\" is null.");
            }
            this.name = setterArg;
        }

        PigeonStorageReference() {
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add(this.bucket);
            toListResult.add(this.fullPath);
            toListResult.add(this.name);
            return toListResult;
        }

        @NonNull
        static PigeonStorageReference fromList(@NonNull ArrayList<Object> list) {
            PigeonStorageReference pigeonResult = new PigeonStorageReference();
            Object bucket = list.get(0);
            pigeonResult.setBucket((String)bucket);
            Object fullPath = list.get(1);
            pigeonResult.setFullPath((String)fullPath);
            Object name = list.get(2);
            pigeonResult.setName((String)name);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String bucket;
            @Nullable
            private String fullPath;
            @Nullable
            private String name;

            @NonNull
            public Builder setBucket(@NonNull String setterArg) {
                this.bucket = setterArg;
                return this;
            }

            @NonNull
            public Builder setFullPath(@NonNull String setterArg) {
                this.fullPath = setterArg;
                return this;
            }

            @NonNull
            public Builder setName(@NonNull String setterArg) {
                this.name = setterArg;
                return this;
            }

            @NonNull
            public PigeonStorageReference build() {
                PigeonStorageReference pigeonReturn = new PigeonStorageReference();
                pigeonReturn.setBucket(this.bucket);
                pigeonReturn.setFullPath(this.fullPath);
                pigeonReturn.setName(this.name);
                return pigeonReturn;
            }
        }
    }

    public static final class PigeonStorageFirebaseApp {
        @NonNull
        private String appName;
        @Nullable
        private String tenantId;
        @NonNull
        private String bucket;

        @NonNull
        public String getAppName() {
            return this.appName;
        }

        public void setAppName(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"appName\" is null.");
            }
            this.appName = setterArg;
        }

        @Nullable
        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(@Nullable String setterArg) {
            this.tenantId = setterArg;
        }

        @NonNull
        public String getBucket() {
            return this.bucket;
        }

        public void setBucket(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"bucket\" is null.");
            }
            this.bucket = setterArg;
        }

        PigeonStorageFirebaseApp() {
        }

        @NonNull
        public ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add(this.appName);
            toListResult.add(this.tenantId);
            toListResult.add(this.bucket);
            return toListResult;
        }

        @NonNull
        static PigeonStorageFirebaseApp fromList(@NonNull ArrayList<Object> list) {
            PigeonStorageFirebaseApp pigeonResult = new PigeonStorageFirebaseApp();
            Object appName = list.get(0);
            pigeonResult.setAppName((String)appName);
            Object tenantId = list.get(1);
            pigeonResult.setTenantId((String)tenantId);
            Object bucket = list.get(2);
            pigeonResult.setBucket((String)bucket);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String appName;
            @Nullable
            private String tenantId;
            @Nullable
            private String bucket;

            @NonNull
            public Builder setAppName(@NonNull String setterArg) {
                this.appName = setterArg;
                return this;
            }

            @NonNull
            public Builder setTenantId(@Nullable String setterArg) {
                this.tenantId = setterArg;
                return this;
            }

            @NonNull
            public Builder setBucket(@NonNull String setterArg) {
                this.bucket = setterArg;
                return this;
            }

            @NonNull
            public PigeonStorageFirebaseApp build() {
                PigeonStorageFirebaseApp pigeonReturn = new PigeonStorageFirebaseApp();
                pigeonReturn.setAppName(this.appName);
                pigeonReturn.setTenantId(this.tenantId);
                pigeonReturn.setBucket(this.bucket);
                return pigeonReturn;
            }
        }
    }

    public static enum PigeonStorageTaskState {
        PAUSED(0),
        RUNNING(1),
        SUCCESS(2),
        CANCELED(3),
        ERROR(4);

        final int index;

        private PigeonStorageTaskState(int index) {
            this.index = index;
        }
    }
}

