/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.storage;

import android.net.Uri;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.storage.FileDownloadTask;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.UploadTask;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugins.firebase.storage.FlutterFirebaseStoragePlugin;
import io.flutter.plugins.firebase.storage.TaskStateChannelStreamHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

class FlutterFirebaseStorageTask {
    static final SparseArray<FlutterFirebaseStorageTask> inProgressTasks = new SparseArray();
    private final FlutterFirebaseStorageTaskType type;
    private final int handle;
    private final StorageReference reference;
    private final byte[] bytes;
    private final Uri fileUri;
    private final StorageMetadata metadata;
    private final Object pauseSyncObject = new Object();
    private final Object resumeSyncObject = new Object();
    private final Object cancelSyncObject = new Object();
    private StorageTask<?> storageTask;
    private Boolean destroyed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlutterFirebaseStorageTask(FlutterFirebaseStorageTaskType type, int handle, StorageReference reference, @Nullable byte[] bytes, @Nullable Uri fileUri, @Nullable StorageMetadata metadata) {
        this.type = type;
        this.handle = handle;
        this.reference = reference;
        this.bytes = bytes;
        this.fileUri = fileUri;
        this.metadata = metadata;
        SparseArray<FlutterFirebaseStorageTask> sparseArray = inProgressTasks;
        synchronized (sparseArray) {
            inProgressTasks.put(handle, (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static FlutterFirebaseStorageTask getInProgressTaskForHandle(int handle) {
        SparseArray<FlutterFirebaseStorageTask> sparseArray = inProgressTasks;
        synchronized (sparseArray) {
            return (FlutterFirebaseStorageTask)inProgressTasks.get(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cancelInProgressTasks() {
        SparseArray<FlutterFirebaseStorageTask> sparseArray = inProgressTasks;
        synchronized (sparseArray) {
            for (int i = 0; i < inProgressTasks.size(); ++i) {
                FlutterFirebaseStorageTask task = null;
                task = (FlutterFirebaseStorageTask)inProgressTasks.valueAt(i);
                if (task == null) continue;
                task.destroy();
            }
            inProgressTasks.clear();
        }
    }

    public static FlutterFirebaseStorageTask uploadBytes(int handle, StorageReference reference, byte[] data, @Nullable StorageMetadata metadata) {
        return new FlutterFirebaseStorageTask(FlutterFirebaseStorageTaskType.BYTES, handle, reference, data, null, metadata);
    }

    public static FlutterFirebaseStorageTask uploadFile(int handle, StorageReference reference, @NonNull Uri fileUri, @Nullable StorageMetadata metadata) {
        return new FlutterFirebaseStorageTask(FlutterFirebaseStorageTaskType.FILE, handle, reference, null, fileUri, metadata);
    }

    public static FlutterFirebaseStorageTask downloadFile(int handle, StorageReference reference, @NonNull File file) {
        return new FlutterFirebaseStorageTask(FlutterFirebaseStorageTaskType.DOWNLOAD, handle, reference, null, Uri.fromFile((File)file), null);
    }

    public static Map<String, Object> parseUploadTaskSnapshot(UploadTask.TaskSnapshot snapshot) {
        HashMap<String, Object> out = new HashMap<String, Object>();
        out.put("path", snapshot.getStorage().getPath());
        out.put("bytesTransferred", snapshot.getBytesTransferred());
        out.put("totalBytes", snapshot.getTotalByteCount());
        if (snapshot.getMetadata() != null) {
            out.put("metadata", FlutterFirebaseStoragePlugin.parseMetadataToMap(snapshot.getMetadata()));
        }
        return out;
    }

    public static Map<String, Object> parseDownloadTaskSnapshot(FileDownloadTask.TaskSnapshot snapshot) {
        HashMap<String, Object> out = new HashMap<String, Object>();
        out.put("path", snapshot.getStorage().getPath());
        if (snapshot.getTask().isSuccessful()) {
            out.put("bytesTransferred", snapshot.getTotalByteCount());
        } else {
            out.put("bytesTransferred", snapshot.getBytesTransferred());
        }
        out.put("totalBytes", snapshot.getTotalByteCount());
        return out;
    }

    static Map<String, Object> parseTaskSnapshot(Object snapshot) {
        if (snapshot instanceof FileDownloadTask.TaskSnapshot) {
            return FlutterFirebaseStorageTask.parseDownloadTaskSnapshot((FileDownloadTask.TaskSnapshot)snapshot);
        }
        return FlutterFirebaseStorageTask.parseUploadTaskSnapshot((UploadTask.TaskSnapshot)snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        if (this.destroyed.booleanValue()) {
            return;
        }
        this.destroyed = true;
        Object object = inProgressTasks;
        synchronized (object) {
            if (this.storageTask.isInProgress() || this.storageTask.isPaused()) {
                this.storageTask.cancel();
            }
            inProgressTasks.remove(this.handle);
        }
        object = this.cancelSyncObject;
        synchronized (object) {
            this.cancelSyncObject.notifyAll();
        }
        object = this.pauseSyncObject;
        synchronized (object) {
            this.pauseSyncObject.notifyAll();
        }
        object = this.resumeSyncObject;
        synchronized (object) {
            this.resumeSyncObject.notifyAll();
        }
    }

    TaskStateChannelStreamHandler startTaskWithMethodChannel(@NonNull MethodChannel channel, @NonNull String identifier) throws Exception {
        if (this.type == FlutterFirebaseStorageTaskType.BYTES && this.bytes != null) {
            this.storageTask = this.metadata == null ? this.reference.putBytes(this.bytes) : this.reference.putBytes(this.bytes, this.metadata);
        } else if (this.type == FlutterFirebaseStorageTaskType.FILE && this.fileUri != null) {
            this.storageTask = this.metadata == null ? this.reference.putFile(this.fileUri) : this.reference.putFile(this.fileUri, this.metadata);
        } else if (this.type == FlutterFirebaseStorageTaskType.DOWNLOAD && this.fileUri != null) {
            this.storageTask = this.reference.getFile(this.fileUri);
        } else {
            throw new Exception("Unable to start task. Some arguments have no been initialized.");
        }
        return new TaskStateChannelStreamHandler(this, this.reference.getStorage(), this.storageTask, identifier);
    }

    public Object getSnapshot() {
        return this.storageTask.getSnapshot();
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyResumeObjects() {
        Object object = this.resumeSyncObject;
        synchronized (object) {
            this.resumeSyncObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCancelObjects() {
        Object object = this.cancelSyncObject;
        synchronized (object) {
            this.cancelSyncObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPauseObjects() {
        Object object = this.pauseSyncObject;
        synchronized (object) {
            this.pauseSyncObject.notifyAll();
        }
    }

    public StorageTask<?> getAndroidTask() {
        return this.storageTask;
    }

    private static enum FlutterFirebaseStorageTaskType {
        FILE,
        BYTES,
        DOWNLOAD;

    }
}

