/*
 * Decompiled with CFR 0.152.
 */
package com.dexterous.flutterlocalnotifications.models;

import android.graphics.Color;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.dexterous.flutterlocalnotifications.models.IconSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Keep
public class NotificationAction
implements Serializable {
    private static final String ID = "id";
    private static final String INPUTS = "inputs";
    private static final String TITLE = "title";
    private static final String TITLE_COLOR_ALPHA = "titleColorAlpha";
    private static final String TITLE_COLOR_RED = "titleColorRed";
    private static final String TITLE_COLOR_GREEN = "titleColorGreen";
    private static final String TITLE_COLOR_BLUE = "titleColorBlue";
    private static final String ICON = "icon";
    private static final String ICON_SOURCE = "iconBitmapSource";
    private static final String CONTEXTUAL = "contextual";
    private static final String SHOWS_USER_INTERFACE = "showsUserInterface";
    private static final String ALLOW_GENERATED_REPLIES = "allowGeneratedReplies";
    private static final String CANCEL_NOTIFICATION = "cancelNotification";
    private static final String SEMANTIC_ACTION = "semanticAction";
    private static final String INVISIBLE = "invisible";
    public final String id;
    public final String title;
    @Nullable
    public final Integer titleColor;
    @Nullable
    public final String icon;
    @Nullable
    public final Boolean cancelNotification;
    @Nullable
    public final Boolean contextual;
    @Nullable
    public final Boolean showsUserInterface;
    @Nullable
    public final Boolean allowGeneratedReplies;
    @Nullable
    public final Integer semanticAction;
    @Nullable
    public final Boolean invisible;
    @Nullable
    public final IconSource iconSource;
    @Nullable
    public final List<NotificationActionInput> actionInputs = new ArrayList<NotificationActionInput>();

    public NotificationAction(Map<String, Object> arguments) {
        List inputs;
        this.id = (String)arguments.get(ID);
        this.cancelNotification = (Boolean)arguments.get(CANCEL_NOTIFICATION);
        this.title = (String)arguments.get(TITLE);
        Integer a = (Integer)arguments.get(TITLE_COLOR_ALPHA);
        Integer r = (Integer)arguments.get(TITLE_COLOR_RED);
        Integer g = (Integer)arguments.get(TITLE_COLOR_GREEN);
        Integer b = (Integer)arguments.get(TITLE_COLOR_BLUE);
        this.titleColor = a != null && r != null && g != null && b != null ? Integer.valueOf(Color.argb((int)a, (int)r, (int)g, (int)b)) : null;
        this.icon = (String)arguments.get(ICON);
        this.contextual = (Boolean)arguments.get(CONTEXTUAL);
        this.showsUserInterface = (Boolean)arguments.get(SHOWS_USER_INTERFACE);
        this.allowGeneratedReplies = (Boolean)arguments.get(ALLOW_GENERATED_REPLIES);
        this.semanticAction = (Integer)arguments.get(SEMANTIC_ACTION);
        this.invisible = (Boolean)arguments.get(INVISIBLE);
        Integer iconSourceIndex = (Integer)arguments.get(ICON_SOURCE);
        this.iconSource = iconSourceIndex != null ? IconSource.values()[iconSourceIndex] : null;
        if (arguments.get(INPUTS) != null && (inputs = (List)arguments.get(INPUTS)) != null) {
            for (Map input : inputs) {
                this.actionInputs.add(new NotificationActionInput(NotificationAction.castList(String.class, (Collection)input.get("choices")), (Boolean)input.get("allowFreeFormInput"), (String)input.get("label"), NotificationAction.castList(String.class, (Collection)input.get("allowedMimeTypes"))));
            }
        }
    }

    public static <T> List<T> castList(Class<? extends T> clazz, @Nullable Collection<?> rawCollection) {
        if (rawCollection == null) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(rawCollection.size());
        for (Object o : rawCollection) {
            try {
                result.add(clazz.cast(o));
            }
            catch (ClassCastException classCastException) {}
        }
        return result;
    }

    public static class NotificationActionInput
    implements Serializable {
        @Nullable
        public final List<String> choices;
        public final Boolean allowFreeFormInput;
        public final String label;
        @Nullable
        public final List<String> allowedMimeTypes;

        public NotificationActionInput(@Nullable List<String> choices, Boolean allowFreeFormInput, String label, @Nullable List<String> allowedMimeTypes) {
            this.choices = choices;
            this.allowFreeFormInput = allowFreeFormInput;
            this.label = label;
            this.allowedMimeTypes = allowedMimeTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotificationActionInput that = (NotificationActionInput)o;
            if (this.choices != null ? !this.choices.equals(that.choices) : that.choices != null) {
                return false;
            }
            if (this.allowFreeFormInput != null ? !this.allowFreeFormInput.equals(that.allowFreeFormInput) : that.allowFreeFormInput != null) {
                return false;
            }
            if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
                return false;
            }
            return this.allowedMimeTypes != null ? this.allowedMimeTypes.equals(that.allowedMimeTypes) : that.allowedMimeTypes == null;
        }

        public int hashCode() {
            int result = this.choices != null ? this.choices.hashCode() : 0;
            result = 31 * result + (this.allowFreeFormInput != null ? this.allowFreeFormInput.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.allowedMimeTypes != null ? this.allowedMimeTypes.hashCode() : 0);
            return result;
        }
    }
}

