/*
 * Decompiled with CFR 0.152.
 */
package com.dexterous.flutterlocalnotifications;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.AudioAttributes;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.service.notification.StatusBarNotification;
import android.text.Html;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.app.AlarmManagerCompat;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.app.Person;
import androidx.core.app.RemoteInput;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.IconCompat;
import androidx.media.app.NotificationCompat;
import com.dexterous.flutterlocalnotifications.ActionBroadcastReceiver;
import com.dexterous.flutterlocalnotifications.ForegroundService;
import com.dexterous.flutterlocalnotifications.ForegroundServiceStartParameter;
import com.dexterous.flutterlocalnotifications.PermissionRequestListener;
import com.dexterous.flutterlocalnotifications.RuntimeTypeAdapterFactory;
import com.dexterous.flutterlocalnotifications.ScheduledNotificationReceiver;
import com.dexterous.flutterlocalnotifications.isolate.IsolatePreferences;
import com.dexterous.flutterlocalnotifications.models.BitmapSource;
import com.dexterous.flutterlocalnotifications.models.DateTimeComponents;
import com.dexterous.flutterlocalnotifications.models.IconSource;
import com.dexterous.flutterlocalnotifications.models.MessageDetails;
import com.dexterous.flutterlocalnotifications.models.NotificationAction;
import com.dexterous.flutterlocalnotifications.models.NotificationChannelAction;
import com.dexterous.flutterlocalnotifications.models.NotificationChannelDetails;
import com.dexterous.flutterlocalnotifications.models.NotificationChannelGroupDetails;
import com.dexterous.flutterlocalnotifications.models.NotificationDetails;
import com.dexterous.flutterlocalnotifications.models.NotificationStyle;
import com.dexterous.flutterlocalnotifications.models.PersonDetails;
import com.dexterous.flutterlocalnotifications.models.ScheduleMode;
import com.dexterous.flutterlocalnotifications.models.ScheduledNotificationRepeatFrequency;
import com.dexterous.flutterlocalnotifications.models.SoundSource;
import com.dexterous.flutterlocalnotifications.models.styles.BigPictureStyleInformation;
import com.dexterous.flutterlocalnotifications.models.styles.BigTextStyleInformation;
import com.dexterous.flutterlocalnotifications.models.styles.DefaultStyleInformation;
import com.dexterous.flutterlocalnotifications.models.styles.InboxStyleInformation;
import com.dexterous.flutterlocalnotifications.models.styles.MessagingStyleInformation;
import com.dexterous.flutterlocalnotifications.models.styles.StyleInformation;
import com.dexterous.flutterlocalnotifications.utils.BooleanUtils;
import com.dexterous.flutterlocalnotifications.utils.LongUtils;
import com.dexterous.flutterlocalnotifications.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.flutter.FlutterInjector;
import io.flutter.embedding.engine.loader.FlutterLoader;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Keep
public class FlutterLocalNotificationsPlugin
implements MethodChannel.MethodCallHandler,
PluginRegistry.NewIntentListener,
PluginRegistry.RequestPermissionsResultListener,
PluginRegistry.ActivityResultListener,
FlutterPlugin,
ActivityAware {
    static final String PAYLOAD = "payload";
    static final String NOTIFICATION_ID = "notificationId";
    static final String NOTIFICATION_TAG = "notificationTag";
    static final String CANCEL_NOTIFICATION = "cancelNotification";
    private static final String TAG = "FLTLocalNotifPlugin";
    private static final String SHARED_PREFERENCES_KEY = "notification_plugin_cache";
    private static final String DISPATCHER_HANDLE = "dispatcher_handle";
    private static final String CALLBACK_HANDLE = "callback_handle";
    private static final String DRAWABLE = "drawable";
    private static final String DEFAULT_ICON = "defaultIcon";
    private static final String SELECT_NOTIFICATION = "SELECT_NOTIFICATION";
    private static final String SELECT_FOREGROUND_NOTIFICATION_ACTION = "SELECT_FOREGROUND_NOTIFICATION";
    private static final String SCHEDULED_NOTIFICATIONS = "scheduled_notifications";
    private static final String INITIALIZE_METHOD = "initialize";
    private static final String GET_CALLBACK_HANDLE_METHOD = "getCallbackHandle";
    private static final String ARE_NOTIFICATIONS_ENABLED_METHOD = "areNotificationsEnabled";
    private static final String CAN_SCHEDULE_EXACT_NOTIFICATIONS_METHOD = "canScheduleExactNotifications";
    private static final String CREATE_NOTIFICATION_CHANNEL_GROUP_METHOD = "createNotificationChannelGroup";
    private static final String DELETE_NOTIFICATION_CHANNEL_GROUP_METHOD = "deleteNotificationChannelGroup";
    private static final String CREATE_NOTIFICATION_CHANNEL_METHOD = "createNotificationChannel";
    private static final String DELETE_NOTIFICATION_CHANNEL_METHOD = "deleteNotificationChannel";
    private static final String GET_ACTIVE_NOTIFICATION_MESSAGING_STYLE_METHOD = "getActiveNotificationMessagingStyle";
    private static final String GET_NOTIFICATION_CHANNELS_METHOD = "getNotificationChannels";
    private static final String START_FOREGROUND_SERVICE = "startForegroundService";
    private static final String STOP_FOREGROUND_SERVICE = "stopForegroundService";
    private static final String PENDING_NOTIFICATION_REQUESTS_METHOD = "pendingNotificationRequests";
    private static final String GET_ACTIVE_NOTIFICATIONS_METHOD = "getActiveNotifications";
    private static final String SHOW_METHOD = "show";
    private static final String CANCEL_METHOD = "cancel";
    private static final String CANCEL_ALL_METHOD = "cancelAll";
    private static final String CANCEL_ALL_PENDING_NOTIFICATIONS_METHOD = "cancelAllPendingNotifications";
    private static final String ZONED_SCHEDULE_METHOD = "zonedSchedule";
    private static final String PERIODICALLY_SHOW_METHOD = "periodicallyShow";
    private static final String PERIODICALLY_SHOW_WITH_DURATION_METHOD = "periodicallyShowWithDuration";
    private static final String GET_NOTIFICATION_APP_LAUNCH_DETAILS_METHOD = "getNotificationAppLaunchDetails";
    private static final String REQUEST_NOTIFICATIONS_PERMISSION_METHOD = "requestNotificationsPermission";
    private static final String REQUEST_EXACT_ALARMS_PERMISSION_METHOD = "requestExactAlarmsPermission";
    private static final String REQUEST_FULL_SCREEN_INTENT_PERMISSION_METHOD = "requestFullScreenIntentPermission";
    private static final String REQUEST_NOTIFICATION_POLICY_ACCESS_METHOD = "requestNotificationPolicyAccess";
    private static final String HAS_NOTIFICATION_POLICY_ACCESS_METHOD = "hasNotificationPolicyAccess";
    private static final String METHOD_CHANNEL = "dexterous.com/flutter/local_notifications";
    private static final String INVALID_ICON_ERROR_CODE = "invalid_icon";
    private static final String INVALID_LARGE_ICON_ERROR_CODE = "invalid_large_icon";
    private static final String INVALID_BIG_PICTURE_ERROR_CODE = "invalid_big_picture";
    private static final String INVALID_SOUND_ERROR_CODE = "invalid_sound";
    private static final String INVALID_LED_DETAILS_ERROR_CODE = "invalid_led_details";
    private static final String UNSUPPORTED_OS_VERSION_ERROR_CODE = "unsupported_os_version";
    private static final String GET_ACTIVE_NOTIFICATIONS_ERROR_MESSAGE = "Android version must be 6.0 or newer to use getActiveNotifications";
    private static final String GET_NOTIFICATION_CHANNELS_ERROR_CODE = "getNotificationChannelsError";
    private static final String GET_ACTIVE_NOTIFICATION_MESSAGING_STYLE_ERROR_CODE = "getActiveNotificationMessagingStyleError";
    private static final String INVALID_LED_DETAILS_ERROR_MESSAGE = "Must specify both ledOnMs and ledOffMs to configure the blink cycle on older versions of Android before Oreo";
    private static final String NOTIFICATION_LAUNCHED_APP = "notificationLaunchedApp";
    private static final String INVALID_DRAWABLE_RESOURCE_ERROR_MESSAGE = "The resource %s could not be found. Please make sure it has been added as a drawable resource to your Android head project.";
    private static final String INVALID_RAW_RESOURCE_ERROR_MESSAGE = "The resource %s could not be found. Please make sure it has been added as a raw resource to your Android head project.";
    private static final String PERMISSION_REQUEST_IN_PROGRESS_ERROR_CODE = "permissionRequestInProgress";
    private static final String PERMISSION_REQUEST_IN_PROGRESS_ERROR_MESSAGE = "Another permission request is already in progress";
    private static final String EXACT_ALARMS_PERMISSION_ERROR_CODE = "exact_alarms_not_permitted";
    private static final String CANCEL_ID = "id";
    private static final String CANCEL_TAG = "tag";
    private static final String ACTION_ID = "actionId";
    private static final String INPUT_RESULT = "FlutterLocalNotificationsPluginInputResult";
    private static final String INPUT = "input";
    private static final String NOTIFICATION_RESPONSE_TYPE = "notificationResponseType";
    static String NOTIFICATION_DETAILS = "notificationDetails";
    static Gson gson;
    private MethodChannel channel;
    private Context applicationContext;
    private Activity mainActivity;
    static final int NOTIFICATION_PERMISSION_REQUEST_CODE = 1;
    static final int EXACT_ALARM_PERMISSION_REQUEST_CODE = 2;
    static final int FULL_SCREEN_INTENT_PERMISSION_REQUEST_CODE = 3;
    static final int NOTIFICATION_POLICY_ACCESS_REQUEST_CODE = 4;
    private PermissionRequestListener callback;
    private PermissionRequestProgress permissionRequestProgress = PermissionRequestProgress.None;

    static void rescheduleNotifications(Context context) {
        ArrayList<NotificationDetails> scheduledNotifications = FlutterLocalNotificationsPlugin.loadScheduledNotifications(context);
        for (NotificationDetails notificationDetails : scheduledNotifications) {
            try {
                if (notificationDetails.repeatInterval != null || notificationDetails.repeatIntervalMilliseconds != null) {
                    FlutterLocalNotificationsPlugin.repeatNotification(context, notificationDetails, false);
                    continue;
                }
                if (notificationDetails.timeZoneName != null) {
                    FlutterLocalNotificationsPlugin.zonedScheduleNotification(context, notificationDetails, false);
                    continue;
                }
                FlutterLocalNotificationsPlugin.scheduleNotification(context, notificationDetails, false);
            }
            catch (ExactAlarmPermissionException e) {
                Log.e((String)TAG, (String)e.getMessage());
                FlutterLocalNotificationsPlugin.removeNotificationFromCache(context, notificationDetails.id);
            }
        }
    }

    static void scheduleNextNotification(Context context, NotificationDetails notificationDetails) {
        try {
            if (notificationDetails.scheduledNotificationRepeatFrequency != null) {
                FlutterLocalNotificationsPlugin.zonedScheduleNextNotification(context, notificationDetails);
            } else if (notificationDetails.matchDateTimeComponents != null) {
                FlutterLocalNotificationsPlugin.zonedScheduleNextNotificationMatchingDateComponents(context, notificationDetails);
            } else if (notificationDetails.repeatInterval != null || notificationDetails.repeatIntervalMilliseconds != null) {
                FlutterLocalNotificationsPlugin.scheduleNextRepeatingNotification(context, notificationDetails);
            } else {
                FlutterLocalNotificationsPlugin.removeNotificationFromCache(context, notificationDetails.id);
            }
        }
        catch (ExactAlarmPermissionException e) {
            Log.e((String)TAG, (String)e.getMessage());
            FlutterLocalNotificationsPlugin.removeNotificationFromCache(context, notificationDetails.id);
        }
    }

    protected static Notification createNotification(Context context, NotificationDetails notificationDetails) {
        NotificationChannelDetails notificationChannelDetails = NotificationChannelDetails.fromNotificationDetails(notificationDetails);
        if (FlutterLocalNotificationsPlugin.canCreateNotificationChannel(context, notificationChannelDetails).booleanValue()) {
            FlutterLocalNotificationsPlugin.setupNotificationChannel(context, notificationChannelDetails);
        }
        Intent intent = FlutterLocalNotificationsPlugin.getLaunchIntent(context);
        intent.setAction(SELECT_NOTIFICATION);
        intent.putExtra(NOTIFICATION_ID, (Serializable)notificationDetails.id);
        intent.putExtra(PAYLOAD, notificationDetails.payload);
        int flags = 0x8000000;
        if (Build.VERSION.SDK_INT >= 23) {
            flags |= 0x4000000;
        }
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)notificationDetails.id, (Intent)intent, (int)flags);
        DefaultStyleInformation defaultStyleInformation = (DefaultStyleInformation)notificationDetails.styleInformation;
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, notificationDetails.channelId).setContentTitle((CharSequence)(defaultStyleInformation.htmlFormatTitle != false ? FlutterLocalNotificationsPlugin.fromHtml(notificationDetails.title) : notificationDetails.title)).setContentText((CharSequence)(defaultStyleInformation.htmlFormatBody != false ? FlutterLocalNotificationsPlugin.fromHtml(notificationDetails.body) : notificationDetails.body)).setTicker((CharSequence)notificationDetails.ticker).setAutoCancel(BooleanUtils.getValue(notificationDetails.autoCancel)).setContentIntent(pendingIntent).setPriority(notificationDetails.priority.intValue()).setOngoing(BooleanUtils.getValue(notificationDetails.ongoing)).setSilent(BooleanUtils.getValue(notificationDetails.silent)).setOnlyAlertOnce(BooleanUtils.getValue(notificationDetails.onlyAlertOnce));
        if (notificationDetails.actions != null) {
            int requestCode = notificationDetails.id * 16;
            for (NotificationAction action : notificationDetails.actions) {
                Intent actionIntent;
                IconCompat icon = null;
                if (!TextUtils.isEmpty((CharSequence)action.icon) && action.iconSource != null) {
                    icon = FlutterLocalNotificationsPlugin.getIconFromSource(context, action.icon, action.iconSource);
                }
                if (action.showsUserInterface != null && action.showsUserInterface.booleanValue()) {
                    actionIntent = FlutterLocalNotificationsPlugin.getLaunchIntent(context);
                    actionIntent.setAction(SELECT_FOREGROUND_NOTIFICATION_ACTION);
                } else {
                    actionIntent = new Intent(context, ActionBroadcastReceiver.class);
                    actionIntent.setAction("com.dexterous.flutterlocalnotifications.ActionBroadcastReceiver.ACTION_TAPPED");
                }
                actionIntent.putExtra(NOTIFICATION_ID, (Serializable)notificationDetails.id).putExtra(NOTIFICATION_TAG, notificationDetails.tag).putExtra(ACTION_ID, action.id).putExtra(CANCEL_NOTIFICATION, (Serializable)action.cancelNotification).putExtra(PAYLOAD, notificationDetails.payload);
                int actionFlags = 0x8000000;
                if (action.actionInputs == null || action.actionInputs.isEmpty()) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        actionFlags |= 0x4000000;
                    }
                } else if (Build.VERSION.SDK_INT >= 31) {
                    actionFlags |= 0x2000000;
                }
                PendingIntent actionPendingIntent = action.showsUserInterface != null && action.showsUserInterface != false ? PendingIntent.getActivity((Context)context, (int)requestCode++, (Intent)actionIntent, (int)actionFlags) : PendingIntent.getBroadcast((Context)context, (int)requestCode++, (Intent)actionIntent, (int)actionFlags);
                SpannableString actionTitleSpannable = new SpannableString((CharSequence)action.title);
                if (action.titleColor != null) {
                    actionTitleSpannable.setSpan((Object)new ForegroundColorSpan(action.titleColor.intValue()), 0, actionTitleSpannable.length(), 0);
                }
                NotificationCompat.Action.Builder actionBuilder = new NotificationCompat.Action.Builder(icon, (CharSequence)actionTitleSpannable, actionPendingIntent);
                if (action.contextual != null) {
                    actionBuilder.setContextual(action.contextual.booleanValue());
                }
                if (action.showsUserInterface != null) {
                    actionBuilder.setShowsUserInterface(action.showsUserInterface.booleanValue());
                }
                if (action.allowGeneratedReplies != null) {
                    actionBuilder.setAllowGeneratedReplies(action.allowGeneratedReplies.booleanValue());
                }
                if (action.semanticAction != null) {
                    actionBuilder.setSemanticAction(action.semanticAction.intValue());
                }
                if (action.actionInputs != null) {
                    for (NotificationAction.NotificationActionInput input : action.actionInputs) {
                        RemoteInput.Builder remoteInput = new RemoteInput.Builder(INPUT_RESULT).setLabel((CharSequence)input.label);
                        if (input.allowFreeFormInput != null) {
                            remoteInput.setAllowFreeFormInput(input.allowFreeFormInput.booleanValue());
                        }
                        if (input.allowedMimeTypes != null) {
                            for (String mimeType : input.allowedMimeTypes) {
                                remoteInput.setAllowDataType(mimeType, true);
                            }
                        }
                        if (input.choices != null) {
                            remoteInput.setChoices(input.choices.toArray(new CharSequence[0]));
                        }
                        actionBuilder.addRemoteInput(remoteInput.build());
                    }
                }
                if (BooleanUtils.getValue(action.invisible)) {
                    builder.addInvisibleAction(actionBuilder.build());
                    continue;
                }
                builder.addAction(actionBuilder.build());
            }
        }
        FlutterLocalNotificationsPlugin.setSmallIcon(context, notificationDetails, builder);
        builder.setLargeIcon(FlutterLocalNotificationsPlugin.getBitmapFromSource(context, notificationDetails.largeIcon, notificationDetails.largeIconBitmapSource));
        if (notificationDetails.color != null) {
            builder.setColor(notificationDetails.color.intValue());
        }
        if (notificationDetails.colorized != null) {
            builder.setColorized(notificationDetails.colorized.booleanValue());
        }
        if (notificationDetails.showWhen != null) {
            builder.setShowWhen(BooleanUtils.getValue(notificationDetails.showWhen));
        }
        if (notificationDetails.when != null) {
            builder.setWhen(notificationDetails.when.longValue());
        }
        if (notificationDetails.usesChronometer != null) {
            builder.setUsesChronometer(notificationDetails.usesChronometer.booleanValue());
        }
        if (notificationDetails.chronometerCountDown != null && Build.VERSION.SDK_INT >= 24) {
            builder.setChronometerCountDown(notificationDetails.chronometerCountDown.booleanValue());
        }
        if (BooleanUtils.getValue(notificationDetails.fullScreenIntent)) {
            builder.setFullScreenIntent(pendingIntent, true);
        }
        if (!StringUtils.isNullOrEmpty(notificationDetails.shortcutId).booleanValue()) {
            builder.setShortcutId(notificationDetails.shortcutId);
        }
        if (!StringUtils.isNullOrEmpty(notificationDetails.subText).booleanValue()) {
            builder.setSubText((CharSequence)notificationDetails.subText);
        }
        if (notificationDetails.number != null) {
            builder.setNumber(notificationDetails.number.intValue());
        }
        FlutterLocalNotificationsPlugin.setVisibility(notificationDetails, builder);
        FlutterLocalNotificationsPlugin.applyGrouping(notificationDetails, builder);
        FlutterLocalNotificationsPlugin.setSound(context, notificationDetails, builder);
        FlutterLocalNotificationsPlugin.setVibrationPattern(notificationDetails, builder);
        FlutterLocalNotificationsPlugin.setLights(notificationDetails, builder);
        FlutterLocalNotificationsPlugin.setStyle(context, notificationDetails, builder);
        FlutterLocalNotificationsPlugin.setProgress(notificationDetails, builder);
        FlutterLocalNotificationsPlugin.setCategory(notificationDetails, builder);
        FlutterLocalNotificationsPlugin.setTimeoutAfter(notificationDetails, builder);
        Notification notification = builder.build();
        if (notificationDetails.additionalFlags != null && notificationDetails.additionalFlags.length > 0) {
            for (Object additionalFlag : (Object)notificationDetails.additionalFlags) {
                notification.flags |= additionalFlag;
            }
        }
        return notification;
    }

    private static Boolean canCreateNotificationChannel(Context context, NotificationChannelDetails notificationChannelDetails) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            NotificationChannel notificationChannel = notificationManager.getNotificationChannel(notificationChannelDetails.id);
            return notificationChannel == null && (notificationChannelDetails.channelAction == null || notificationChannelDetails.channelAction == NotificationChannelAction.CreateIfNotExists) || notificationChannel != null && notificationChannelDetails.channelAction == NotificationChannelAction.Update;
        }
        return false;
    }

    private static void setSmallIcon(Context context, NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        if (!StringUtils.isNullOrEmpty(notificationDetails.icon).booleanValue()) {
            builder.setSmallIcon(FlutterLocalNotificationsPlugin.getDrawableResourceId(context, notificationDetails.icon));
        } else {
            SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_KEY, 0);
            String defaultIcon = sharedPreferences.getString(DEFAULT_ICON, null);
            if (StringUtils.isNullOrEmpty(defaultIcon).booleanValue()) {
                builder.setSmallIcon(notificationDetails.iconResourceId.intValue());
            } else {
                builder.setSmallIcon(FlutterLocalNotificationsPlugin.getDrawableResourceId(context, defaultIcon));
            }
        }
    }

    @NonNull
    static Gson buildGson() {
        if (gson == null) {
            RuntimeTypeAdapterFactory<MessagingStyleInformation> styleInformationAdapter = RuntimeTypeAdapterFactory.of(StyleInformation.class).registerSubtype(DefaultStyleInformation.class).registerSubtype(BigTextStyleInformation.class).registerSubtype(BigPictureStyleInformation.class).registerSubtype(InboxStyleInformation.class).registerSubtype(MessagingStyleInformation.class);
            GsonBuilder builder = new GsonBuilder().registerTypeAdapter(ScheduleMode.class, (Object)new ScheduleMode.Deserializer()).registerTypeAdapterFactory(styleInformationAdapter);
            gson = builder.create();
        }
        return gson;
    }

    private static ArrayList<NotificationDetails> loadScheduledNotifications(Context context) {
        ArrayList scheduledNotifications = new ArrayList();
        SharedPreferences sharedPreferences = context.getSharedPreferences(SCHEDULED_NOTIFICATIONS, 0);
        String json = sharedPreferences.getString(SCHEDULED_NOTIFICATIONS, null);
        if (json != null) {
            Gson gson = FlutterLocalNotificationsPlugin.buildGson();
            Type type = new TypeToken<ArrayList<NotificationDetails>>(){}.getType();
            scheduledNotifications = (ArrayList)gson.fromJson(json, type);
        }
        return scheduledNotifications;
    }

    private static void saveScheduledNotifications(Context context, ArrayList<NotificationDetails> scheduledNotifications) {
        Gson gson = FlutterLocalNotificationsPlugin.buildGson();
        String json = gson.toJson(scheduledNotifications);
        SharedPreferences sharedPreferences = context.getSharedPreferences(SCHEDULED_NOTIFICATIONS, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(SCHEDULED_NOTIFICATIONS, json).apply();
    }

    static void removeNotificationFromCache(Context context, Integer notificationId) {
        ArrayList<NotificationDetails> scheduledNotifications = FlutterLocalNotificationsPlugin.loadScheduledNotifications(context);
        Iterator<NotificationDetails> it = scheduledNotifications.iterator();
        while (it.hasNext()) {
            NotificationDetails notificationDetails = it.next();
            if (!notificationDetails.id.equals(notificationId)) continue;
            it.remove();
            break;
        }
        FlutterLocalNotificationsPlugin.saveScheduledNotifications(context, scheduledNotifications);
    }

    private static Spanned fromHtml(String html) {
        if (html == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            return Html.fromHtml((String)html, (int)0);
        }
        return Html.fromHtml((String)html);
    }

    private static void scheduleNotification(Context context, NotificationDetails notificationDetails, Boolean updateScheduledNotificationsCache) {
        Gson gson = FlutterLocalNotificationsPlugin.buildGson();
        String notificationDetailsJson = gson.toJson((Object)notificationDetails);
        Intent notificationIntent = new Intent(context, ScheduledNotificationReceiver.class);
        notificationIntent.putExtra(NOTIFICATION_DETAILS, notificationDetailsJson);
        PendingIntent pendingIntent = FlutterLocalNotificationsPlugin.getBroadcastPendingIntent(context, notificationDetails.id, notificationIntent);
        AlarmManager alarmManager = FlutterLocalNotificationsPlugin.getAlarmManager(context);
        FlutterLocalNotificationsPlugin.setupAlarm(notificationDetails, alarmManager, notificationDetails.millisecondsSinceEpoch, pendingIntent);
        if (updateScheduledNotificationsCache.booleanValue()) {
            FlutterLocalNotificationsPlugin.saveScheduledNotification(context, notificationDetails);
        }
    }

    private static void zonedScheduleNotification(Context context, NotificationDetails notificationDetails, Boolean updateScheduledNotificationsCache) {
        Gson gson = FlutterLocalNotificationsPlugin.buildGson();
        String notificationDetailsJson = gson.toJson((Object)notificationDetails);
        Intent notificationIntent = new Intent(context, ScheduledNotificationReceiver.class);
        notificationIntent.putExtra(NOTIFICATION_DETAILS, notificationDetailsJson);
        PendingIntent pendingIntent = FlutterLocalNotificationsPlugin.getBroadcastPendingIntent(context, notificationDetails.id, notificationIntent);
        AlarmManager alarmManager = FlutterLocalNotificationsPlugin.getAlarmManager(context);
        long epochMilli = ZonedDateTime.of(LocalDateTime.parse(notificationDetails.scheduledDateTime), ZoneId.of(notificationDetails.timeZoneName)).toInstant().toEpochMilli();
        FlutterLocalNotificationsPlugin.setupAlarm(notificationDetails, alarmManager, epochMilli, pendingIntent);
        if (updateScheduledNotificationsCache.booleanValue()) {
            FlutterLocalNotificationsPlugin.saveScheduledNotification(context, notificationDetails);
        }
    }

    private static void scheduleNextRepeatingNotification(Context context, NotificationDetails notificationDetails) {
        long repeatInterval = FlutterLocalNotificationsPlugin.calculateRepeatIntervalMilliseconds(notificationDetails);
        long notificationTriggerTime = FlutterLocalNotificationsPlugin.calculateNextNotificationTrigger(notificationDetails.calledAt, repeatInterval);
        Gson gson = FlutterLocalNotificationsPlugin.buildGson();
        String notificationDetailsJson = gson.toJson((Object)notificationDetails);
        Intent notificationIntent = new Intent(context, ScheduledNotificationReceiver.class);
        notificationIntent.putExtra(NOTIFICATION_DETAILS, notificationDetailsJson);
        PendingIntent pendingIntent = FlutterLocalNotificationsPlugin.getBroadcastPendingIntent(context, notificationDetails.id, notificationIntent);
        AlarmManager alarmManager = FlutterLocalNotificationsPlugin.getAlarmManager(context);
        if (notificationDetails.scheduleMode == null) {
            notificationDetails.scheduleMode = ScheduleMode.exactAllowWhileIdle;
        }
        FlutterLocalNotificationsPlugin.setupAllowWhileIdleAlarm(notificationDetails, alarmManager, notificationTriggerTime, pendingIntent);
        FlutterLocalNotificationsPlugin.saveScheduledNotification(context, notificationDetails);
    }

    static Map<String, Object> extractNotificationResponseMap(Intent intent) {
        int notificationId = intent.getIntExtra(NOTIFICATION_ID, 0);
        HashMap<String, Object> notificationResponseMap = new HashMap<String, Object>();
        notificationResponseMap.put(NOTIFICATION_ID, notificationId);
        notificationResponseMap.put(NOTIFICATION_TAG, intent.getStringExtra(NOTIFICATION_TAG));
        notificationResponseMap.put(ACTION_ID, intent.getStringExtra(ACTION_ID));
        notificationResponseMap.put(PAYLOAD, intent.getStringExtra(PAYLOAD));
        Bundle remoteInput = RemoteInput.getResultsFromIntent((Intent)intent);
        if (remoteInput != null) {
            notificationResponseMap.put(INPUT, remoteInput.getString(INPUT_RESULT));
        }
        if (SELECT_NOTIFICATION.equals(intent.getAction())) {
            notificationResponseMap.put(NOTIFICATION_RESPONSE_TYPE, 0);
        }
        if (SELECT_FOREGROUND_NOTIFICATION_ACTION.equals(intent.getAction())) {
            notificationResponseMap.put(NOTIFICATION_RESPONSE_TYPE, 1);
        }
        return notificationResponseMap;
    }

    private static PendingIntent getBroadcastPendingIntent(Context context, int id, Intent intent) {
        int flags = 0x8000000;
        if (Build.VERSION.SDK_INT >= 23) {
            flags |= 0x4000000;
        }
        return PendingIntent.getBroadcast((Context)context, (int)id, (Intent)intent, (int)flags);
    }

    private static void repeatNotification(Context context, NotificationDetails notificationDetails, Boolean updateScheduledNotificationsCache) {
        long repeatInterval = FlutterLocalNotificationsPlugin.calculateRepeatIntervalMilliseconds(notificationDetails);
        long notificationTriggerTime = notificationDetails.calledAt;
        if (notificationDetails.repeatTime != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            calendar.set(11, notificationDetails.repeatTime.hour);
            calendar.set(12, notificationDetails.repeatTime.minute);
            calendar.set(13, notificationDetails.repeatTime.second);
            if (notificationDetails.day != null) {
                calendar.set(7, notificationDetails.day);
            }
            notificationTriggerTime = calendar.getTimeInMillis();
        }
        notificationTriggerTime = FlutterLocalNotificationsPlugin.calculateNextNotificationTrigger(notificationTriggerTime, repeatInterval);
        Gson gson = FlutterLocalNotificationsPlugin.buildGson();
        String notificationDetailsJson = gson.toJson((Object)notificationDetails);
        Intent notificationIntent = new Intent(context, ScheduledNotificationReceiver.class);
        notificationIntent.putExtra(NOTIFICATION_DETAILS, notificationDetailsJson);
        PendingIntent pendingIntent = FlutterLocalNotificationsPlugin.getBroadcastPendingIntent(context, notificationDetails.id, notificationIntent);
        AlarmManager alarmManager = FlutterLocalNotificationsPlugin.getAlarmManager(context);
        if (notificationDetails.scheduleMode == null) {
            notificationDetails.scheduleMode = ScheduleMode.inexact;
        }
        if (notificationDetails.scheduleMode.useAllowWhileIdle()) {
            FlutterLocalNotificationsPlugin.setupAllowWhileIdleAlarm(notificationDetails, alarmManager, notificationTriggerTime, pendingIntent);
        } else {
            alarmManager.setInexactRepeating(0, notificationTriggerTime, repeatInterval, pendingIntent);
        }
        if (updateScheduledNotificationsCache.booleanValue()) {
            FlutterLocalNotificationsPlugin.saveScheduledNotification(context, notificationDetails);
        }
    }

    private static void setupAlarm(NotificationDetails notificationDetails, AlarmManager alarmManager, long epochMilli, PendingIntent pendingIntent) {
        if (notificationDetails.scheduleMode == null) {
            notificationDetails.scheduleMode = ScheduleMode.exact;
        }
        if (notificationDetails.scheduleMode.useAllowWhileIdle()) {
            FlutterLocalNotificationsPlugin.setupAllowWhileIdleAlarm(notificationDetails, alarmManager, epochMilli, pendingIntent);
        } else if (notificationDetails.scheduleMode.useExactAlarm()) {
            FlutterLocalNotificationsPlugin.checkCanScheduleExactAlarms(alarmManager);
            AlarmManagerCompat.setExact((AlarmManager)alarmManager, (int)0, (long)epochMilli, (PendingIntent)pendingIntent);
        } else if (notificationDetails.scheduleMode.useAlarmClock()) {
            FlutterLocalNotificationsPlugin.checkCanScheduleExactAlarms(alarmManager);
            AlarmManagerCompat.setAlarmClock((AlarmManager)alarmManager, (long)epochMilli, (PendingIntent)pendingIntent, (PendingIntent)pendingIntent);
        } else {
            alarmManager.set(0, epochMilli, pendingIntent);
        }
    }

    private static void setupAllowWhileIdleAlarm(NotificationDetails notificationDetails, AlarmManager alarmManager, long epochMilli, PendingIntent pendingIntent) {
        if (notificationDetails.scheduleMode.useExactAlarm()) {
            FlutterLocalNotificationsPlugin.checkCanScheduleExactAlarms(alarmManager);
            AlarmManagerCompat.setExactAndAllowWhileIdle((AlarmManager)alarmManager, (int)0, (long)epochMilli, (PendingIntent)pendingIntent);
        } else if (notificationDetails.scheduleMode.useAlarmClock()) {
            FlutterLocalNotificationsPlugin.checkCanScheduleExactAlarms(alarmManager);
            AlarmManagerCompat.setAlarmClock((AlarmManager)alarmManager, (long)epochMilli, (PendingIntent)pendingIntent, (PendingIntent)pendingIntent);
        } else {
            AlarmManagerCompat.setAndAllowWhileIdle((AlarmManager)alarmManager, (int)0, (long)epochMilli, (PendingIntent)pendingIntent);
        }
    }

    private static void checkCanScheduleExactAlarms(AlarmManager alarmManager) {
        if (Build.VERSION.SDK_INT >= 31 && !alarmManager.canScheduleExactAlarms()) {
            throw new ExactAlarmPermissionException();
        }
    }

    private static long calculateNextNotificationTrigger(long notificationTriggerTime, long repeatInterval) {
        long currentTime = System.currentTimeMillis();
        while (notificationTriggerTime < currentTime) {
            notificationTriggerTime += repeatInterval;
        }
        return notificationTriggerTime;
    }

    private static long calculateRepeatIntervalMilliseconds(NotificationDetails notificationDetails) {
        long repeatInterval = 0L;
        if (notificationDetails.repeatIntervalMilliseconds != null) {
            repeatInterval = notificationDetails.repeatIntervalMilliseconds.intValue();
            return repeatInterval;
        }
        switch (notificationDetails.repeatInterval) {
            case EveryMinute: {
                repeatInterval = 60000L;
                break;
            }
            case Hourly: {
                repeatInterval = 3600000L;
                break;
            }
            case Daily: {
                repeatInterval = 86400000L;
                break;
            }
            case Weekly: {
                repeatInterval = 604800000L;
                break;
            }
        }
        return repeatInterval;
    }

    private static void saveScheduledNotification(Context context, NotificationDetails notificationDetails) {
        ArrayList<NotificationDetails> scheduledNotifications = FlutterLocalNotificationsPlugin.loadScheduledNotifications(context);
        ArrayList<NotificationDetails> scheduledNotificationsToSave = new ArrayList<NotificationDetails>();
        for (NotificationDetails scheduledNotification : scheduledNotifications) {
            if (scheduledNotification.id.equals(notificationDetails.id)) continue;
            scheduledNotificationsToSave.add(scheduledNotification);
        }
        scheduledNotificationsToSave.add(notificationDetails);
        FlutterLocalNotificationsPlugin.saveScheduledNotifications(context, scheduledNotificationsToSave);
    }

    private static int getDrawableResourceId(Context context, String name) {
        return context.getResources().getIdentifier(name, DRAWABLE, context.getPackageName());
    }

    private static byte[] castObjectToByteArray(Object data) {
        byte[] byteArray;
        if (data instanceof ArrayList) {
            ArrayList l = (ArrayList)data;
            byteArray = new byte[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                byteArray[i] = (byte)((Double)l.get(i)).intValue();
            }
        } else {
            byteArray = (byte[])data;
        }
        return byteArray;
    }

    private static Bitmap getBitmapFromSource(Context context, Object data, BitmapSource bitmapSource) {
        Bitmap bitmap = null;
        if (bitmapSource == BitmapSource.DrawableResource) {
            bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)FlutterLocalNotificationsPlugin.getDrawableResourceId(context, (String)data));
        } else if (bitmapSource == BitmapSource.FilePath) {
            bitmap = BitmapFactory.decodeFile((String)((String)data));
        } else if (bitmapSource == BitmapSource.ByteArray) {
            byte[] byteArray = FlutterLocalNotificationsPlugin.castObjectToByteArray(data);
            bitmap = BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length);
        }
        return bitmap;
    }

    private static IconCompat getIconFromSource(Context context, Object data, IconSource iconSource) {
        IconCompat icon = null;
        switch (iconSource) {
            case DrawableResource: {
                icon = IconCompat.createWithResource((Context)context, (int)FlutterLocalNotificationsPlugin.getDrawableResourceId(context, (String)data));
                break;
            }
            case BitmapFilePath: {
                icon = IconCompat.createWithBitmap((Bitmap)BitmapFactory.decodeFile((String)((String)data)));
                break;
            }
            case ContentUri: {
                icon = IconCompat.createWithContentUri((String)((String)data));
                break;
            }
            case FlutterBitmapAsset: {
                try {
                    FlutterLoader flutterLoader = FlutterInjector.instance().flutterLoader();
                    AssetFileDescriptor assetFileDescriptor = context.getAssets().openFd(flutterLoader.getLookupKeyForAsset((String)data));
                    FileInputStream fileInputStream = assetFileDescriptor.createInputStream();
                    icon = IconCompat.createWithBitmap((Bitmap)BitmapFactory.decodeStream((InputStream)fileInputStream));
                    fileInputStream.close();
                    assetFileDescriptor.close();
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case ByteArray: {
                byte[] byteArray = FlutterLocalNotificationsPlugin.castObjectToByteArray(data);
                icon = IconCompat.createWithData((byte[])byteArray, (int)0, (int)byteArray.length);
            }
        }
        return icon;
    }

    private static void setVisibility(NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        int visibility;
        if (notificationDetails.visibility == null) {
            return;
        }
        switch (notificationDetails.visibility) {
            case 0: {
                visibility = 0;
                break;
            }
            case 1: {
                visibility = 1;
                break;
            }
            case 2: {
                visibility = -1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown index: " + notificationDetails.visibility);
            }
        }
        builder.setVisibility(visibility);
    }

    private static void applyGrouping(NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        boolean isGrouped = false;
        if (!StringUtils.isNullOrEmpty(notificationDetails.groupKey).booleanValue()) {
            builder.setGroup(notificationDetails.groupKey);
            isGrouped = true;
        }
        if (isGrouped) {
            if (BooleanUtils.getValue(notificationDetails.setAsGroupSummary)) {
                builder.setGroupSummary(true);
            }
            builder.setGroupAlertBehavior(notificationDetails.groupAlertBehavior.intValue());
        }
    }

    private static void setVibrationPattern(NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        if (BooleanUtils.getValue(notificationDetails.enableVibration)) {
            if (notificationDetails.vibrationPattern != null && notificationDetails.vibrationPattern.length > 0) {
                builder.setVibrate(notificationDetails.vibrationPattern);
            }
        } else {
            builder.setVibrate(new long[]{0L});
        }
    }

    private static void setLights(NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        if (BooleanUtils.getValue(notificationDetails.enableLights) && notificationDetails.ledOnMs != null && notificationDetails.ledOffMs != null) {
            builder.setLights(notificationDetails.ledColor.intValue(), notificationDetails.ledOnMs.intValue(), notificationDetails.ledOffMs.intValue());
        }
    }

    private static void setSound(Context context, NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        if (BooleanUtils.getValue(notificationDetails.playSound)) {
            Uri uri = FlutterLocalNotificationsPlugin.retrieveSoundResourceUri(context, notificationDetails.sound, notificationDetails.soundSource);
            builder.setSound(uri);
        } else {
            builder.setSound(null);
        }
    }

    private static void setCategory(NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        if (notificationDetails.category == null) {
            return;
        }
        builder.setCategory(notificationDetails.category);
    }

    private static void setTimeoutAfter(NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        if (notificationDetails.timeoutAfter == null) {
            return;
        }
        builder.setTimeoutAfter(notificationDetails.timeoutAfter.longValue());
    }

    private static Intent getLaunchIntent(Context context) {
        String packageName = context.getPackageName();
        PackageManager packageManager = context.getPackageManager();
        return packageManager.getLaunchIntentForPackage(packageName);
    }

    private static void setStyle(Context context, NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        switch (notificationDetails.style) {
            case BigPicture: {
                FlutterLocalNotificationsPlugin.setBigPictureStyle(context, notificationDetails, builder);
                break;
            }
            case BigText: {
                FlutterLocalNotificationsPlugin.setBigTextStyle(notificationDetails, builder);
                break;
            }
            case Inbox: {
                FlutterLocalNotificationsPlugin.setInboxStyle(notificationDetails, builder);
                break;
            }
            case Messaging: {
                FlutterLocalNotificationsPlugin.setMessagingStyle(context, notificationDetails, builder);
                break;
            }
            case Media: {
                FlutterLocalNotificationsPlugin.setMediaStyle(builder);
                break;
            }
        }
    }

    private static void setProgress(NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        if (BooleanUtils.getValue(notificationDetails.showProgress)) {
            builder.setProgress(notificationDetails.maxProgress.intValue(), notificationDetails.progress.intValue(), notificationDetails.indeterminate.booleanValue());
        }
    }

    private static void setBigPictureStyle(Context context, NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        BigPictureStyleInformation bigPictureStyleInformation = (BigPictureStyleInformation)notificationDetails.styleInformation;
        NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle();
        if (bigPictureStyleInformation.contentTitle != null) {
            String contentTitle = bigPictureStyleInformation.htmlFormatContentTitle != false ? FlutterLocalNotificationsPlugin.fromHtml(bigPictureStyleInformation.contentTitle) : bigPictureStyleInformation.contentTitle;
            bigPictureStyle.setBigContentTitle((CharSequence)contentTitle);
        }
        if (bigPictureStyleInformation.summaryText != null) {
            String summaryText = bigPictureStyleInformation.htmlFormatSummaryText != false ? FlutterLocalNotificationsPlugin.fromHtml(bigPictureStyleInformation.summaryText) : bigPictureStyleInformation.summaryText;
            bigPictureStyle.setSummaryText((CharSequence)summaryText);
        }
        if (bigPictureStyleInformation.hideExpandedLargeIcon.booleanValue()) {
            bigPictureStyle.bigLargeIcon((Bitmap)null);
        } else if (bigPictureStyleInformation.largeIcon != null) {
            bigPictureStyle.bigLargeIcon(FlutterLocalNotificationsPlugin.getBitmapFromSource(context, bigPictureStyleInformation.largeIcon, bigPictureStyleInformation.largeIconBitmapSource));
        }
        bigPictureStyle.bigPicture(FlutterLocalNotificationsPlugin.getBitmapFromSource(context, bigPictureStyleInformation.bigPicture, bigPictureStyleInformation.bigPictureBitmapSource));
        builder.setStyle((NotificationCompat.Style)bigPictureStyle);
    }

    private static void setInboxStyle(NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        InboxStyleInformation inboxStyleInformation = (InboxStyleInformation)notificationDetails.styleInformation;
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
        if (inboxStyleInformation.contentTitle != null) {
            String contentTitle = inboxStyleInformation.htmlFormatContentTitle != false ? FlutterLocalNotificationsPlugin.fromHtml(inboxStyleInformation.contentTitle) : inboxStyleInformation.contentTitle;
            inboxStyle.setBigContentTitle((CharSequence)contentTitle);
        }
        if (inboxStyleInformation.summaryText != null) {
            String summaryText = inboxStyleInformation.htmlFormatSummaryText != false ? FlutterLocalNotificationsPlugin.fromHtml(inboxStyleInformation.summaryText) : inboxStyleInformation.summaryText;
            inboxStyle.setSummaryText((CharSequence)summaryText);
        }
        if (inboxStyleInformation.lines != null) {
            for (String line : inboxStyleInformation.lines) {
                inboxStyle.addLine((CharSequence)(inboxStyleInformation.htmlFormatLines != false ? FlutterLocalNotificationsPlugin.fromHtml(line) : line));
            }
        }
        builder.setStyle((NotificationCompat.Style)inboxStyle);
    }

    private static void setMediaStyle(NotificationCompat.Builder builder) {
        NotificationCompat.MediaStyle mediaStyle = new NotificationCompat.MediaStyle();
        builder.setStyle((NotificationCompat.Style)mediaStyle);
    }

    private static void setMessagingStyle(Context context, NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        MessagingStyleInformation messagingStyleInformation = (MessagingStyleInformation)notificationDetails.styleInformation;
        Person person = FlutterLocalNotificationsPlugin.buildPerson(context, messagingStyleInformation.person);
        NotificationCompat.MessagingStyle messagingStyle = new NotificationCompat.MessagingStyle(person);
        messagingStyle.setGroupConversation(BooleanUtils.getValue(messagingStyleInformation.groupConversation));
        if (messagingStyleInformation.conversationTitle != null) {
            messagingStyle.setConversationTitle((CharSequence)messagingStyleInformation.conversationTitle);
        }
        if (messagingStyleInformation.messages != null && !messagingStyleInformation.messages.isEmpty()) {
            for (MessageDetails messageDetails : messagingStyleInformation.messages) {
                NotificationCompat.MessagingStyle.Message message = FlutterLocalNotificationsPlugin.createMessage(context, messageDetails);
                messagingStyle.addMessage(message);
            }
        }
        builder.setStyle((NotificationCompat.Style)messagingStyle);
    }

    private static NotificationCompat.MessagingStyle.Message createMessage(Context context, MessageDetails messageDetails) {
        NotificationCompat.MessagingStyle.Message message = new NotificationCompat.MessagingStyle.Message((CharSequence)messageDetails.text, messageDetails.timestamp.longValue(), FlutterLocalNotificationsPlugin.buildPerson(context, messageDetails.person));
        if (messageDetails.dataUri != null && messageDetails.dataMimeType != null) {
            message.setData(messageDetails.dataMimeType, Uri.parse((String)messageDetails.dataUri));
        }
        return message;
    }

    private static Person buildPerson(Context context, PersonDetails personDetails) {
        if (personDetails == null) {
            return null;
        }
        Person.Builder personBuilder = new Person.Builder();
        personBuilder.setBot(BooleanUtils.getValue(personDetails.bot));
        if (personDetails.icon != null && personDetails.iconBitmapSource != null) {
            personBuilder.setIcon(FlutterLocalNotificationsPlugin.getIconFromSource(context, personDetails.icon, personDetails.iconBitmapSource));
        }
        personBuilder.setImportant(BooleanUtils.getValue(personDetails.important));
        if (personDetails.key != null) {
            personBuilder.setKey(personDetails.key);
        }
        if (personDetails.name != null) {
            personBuilder.setName((CharSequence)personDetails.name);
        }
        if (personDetails.uri != null) {
            personBuilder.setUri(personDetails.uri);
        }
        return personBuilder.build();
    }

    private static void setBigTextStyle(NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        BigTextStyleInformation bigTextStyleInformation = (BigTextStyleInformation)notificationDetails.styleInformation;
        NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle();
        if (bigTextStyleInformation.bigText != null) {
            String bigText = bigTextStyleInformation.htmlFormatBigText != false ? FlutterLocalNotificationsPlugin.fromHtml(bigTextStyleInformation.bigText) : bigTextStyleInformation.bigText;
            bigTextStyle.bigText((CharSequence)bigText);
        }
        if (bigTextStyleInformation.contentTitle != null) {
            String contentTitle = bigTextStyleInformation.htmlFormatContentTitle != false ? FlutterLocalNotificationsPlugin.fromHtml(bigTextStyleInformation.contentTitle) : bigTextStyleInformation.contentTitle;
            bigTextStyle.setBigContentTitle((CharSequence)contentTitle);
        }
        if (bigTextStyleInformation.summaryText != null) {
            String summaryText = bigTextStyleInformation.htmlFormatSummaryText != false ? FlutterLocalNotificationsPlugin.fromHtml(bigTextStyleInformation.summaryText) : bigTextStyleInformation.summaryText;
            bigTextStyle.setSummaryText((CharSequence)summaryText);
        }
        builder.setStyle((NotificationCompat.Style)bigTextStyle);
    }

    private static void setupNotificationChannel(Context context, NotificationChannelDetails notificationChannelDetails) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            NotificationChannel notificationChannel = new NotificationChannel(notificationChannelDetails.id, (CharSequence)notificationChannelDetails.name, notificationChannelDetails.importance.intValue());
            notificationChannel.setDescription(notificationChannelDetails.description);
            notificationChannel.setGroup(notificationChannelDetails.groupId);
            if (notificationChannelDetails.playSound.booleanValue()) {
                Integer audioAttributesUsage = notificationChannelDetails.audioAttributesUsage != null ? notificationChannelDetails.audioAttributesUsage : 5;
                AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(audioAttributesUsage.intValue()).build();
                Uri uri = FlutterLocalNotificationsPlugin.retrieveSoundResourceUri(context, notificationChannelDetails.sound, notificationChannelDetails.soundSource);
                notificationChannel.setSound(uri, audioAttributes);
            } else {
                notificationChannel.setSound(null, null);
            }
            if (BooleanUtils.getValue(notificationChannelDetails.bypassDnd)) {
                boolean isAccessGranted = notificationManager.isNotificationPolicyAccessGranted();
                if (isAccessGranted) {
                    notificationChannel.setBypassDnd(true);
                } else {
                    Log.w((String)TAG, (String)("Channel '" + notificationChannelDetails.name + "' was set to bypass Do Not Disturb but the OS prevents it."));
                }
            }
            notificationChannel.enableVibration(BooleanUtils.getValue(notificationChannelDetails.enableVibration));
            if (notificationChannelDetails.vibrationPattern != null && notificationChannelDetails.vibrationPattern.length > 0) {
                notificationChannel.setVibrationPattern(notificationChannelDetails.vibrationPattern);
            }
            boolean enableLights = BooleanUtils.getValue(notificationChannelDetails.enableLights);
            notificationChannel.enableLights(enableLights);
            if (enableLights && notificationChannelDetails.ledColor != null) {
                notificationChannel.setLightColor(notificationChannelDetails.ledColor.intValue());
            }
            notificationChannel.setShowBadge(BooleanUtils.getValue(notificationChannelDetails.showBadge));
            notificationManager.createNotificationChannel(notificationChannel);
        }
    }

    private static Uri retrieveSoundResourceUri(Context context, String sound, SoundSource soundSource) {
        Uri uri = null;
        if (StringUtils.isNullOrEmpty(sound).booleanValue()) {
            uri = RingtoneManager.getDefaultUri((int)2);
        } else if (soundSource == null || soundSource == SoundSource.RawResource) {
            uri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + sound));
        } else if (soundSource == SoundSource.Uri) {
            uri = Uri.parse((String)sound);
        }
        return uri;
    }

    private static AlarmManager getAlarmManager(Context context) {
        return (AlarmManager)context.getSystemService("alarm");
    }

    private static boolean isValidDrawableResource(Context context, String name, MethodChannel.Result result, String errorCode) {
        int resourceId = context.getResources().getIdentifier(name, DRAWABLE, context.getPackageName());
        if (resourceId == 0) {
            result.error(errorCode, String.format(INVALID_DRAWABLE_RESOURCE_ERROR_MESSAGE, name), null);
            return false;
        }
        return true;
    }

    static void showNotification(Context context, NotificationDetails notificationDetails) {
        Notification notification = FlutterLocalNotificationsPlugin.createNotification(context, notificationDetails);
        NotificationManagerCompat notificationManagerCompat = FlutterLocalNotificationsPlugin.getNotificationManager(context);
        if (notificationDetails.tag != null) {
            notificationManagerCompat.notify(notificationDetails.tag, notificationDetails.id.intValue(), notification);
        } else {
            notificationManagerCompat.notify(notificationDetails.id.intValue(), notification);
        }
    }

    private static void zonedScheduleNextNotification(Context context, NotificationDetails notificationDetails) {
        String nextFireDate = FlutterLocalNotificationsPlugin.getNextFireDate(notificationDetails);
        if (nextFireDate == null) {
            return;
        }
        notificationDetails.scheduledDateTime = nextFireDate;
        FlutterLocalNotificationsPlugin.zonedScheduleNotification(context, notificationDetails, true);
    }

    private static void zonedScheduleNextNotificationMatchingDateComponents(Context context, NotificationDetails notificationDetails) {
        String nextFireDate = FlutterLocalNotificationsPlugin.getNextFireDateMatchingDateTimeComponents(notificationDetails);
        if (nextFireDate == null) {
            return;
        }
        notificationDetails.scheduledDateTime = nextFireDate;
        FlutterLocalNotificationsPlugin.zonedScheduleNotification(context, notificationDetails, true);
    }

    private static String getNextFireDate(NotificationDetails notificationDetails) {
        if (notificationDetails.scheduledNotificationRepeatFrequency == ScheduledNotificationRepeatFrequency.Daily) {
            LocalDateTime localDateTime = LocalDateTime.parse(notificationDetails.scheduledDateTime).plusDays(1L);
            return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(localDateTime);
        }
        if (notificationDetails.scheduledNotificationRepeatFrequency == ScheduledNotificationRepeatFrequency.Weekly) {
            LocalDateTime localDateTime = LocalDateTime.parse(notificationDetails.scheduledDateTime).plusWeeks(1L);
            return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(localDateTime);
        }
        return null;
    }

    private static String getNextFireDateMatchingDateTimeComponents(NotificationDetails notificationDetails) {
        ZoneId zoneId = ZoneId.of(notificationDetails.timeZoneName);
        ZonedDateTime scheduledDateTime = ZonedDateTime.of(LocalDateTime.parse(notificationDetails.scheduledDateTime), zoneId);
        ZonedDateTime now = ZonedDateTime.now(zoneId);
        ZonedDateTime nextFireDate = ZonedDateTime.of(now.getYear(), now.getMonthValue(), now.getDayOfMonth(), scheduledDateTime.getHour(), scheduledDateTime.getMinute(), scheduledDateTime.getSecond(), scheduledDateTime.getNano(), zoneId);
        while (nextFireDate.isBefore(now)) {
            nextFireDate = nextFireDate.plusDays(1L);
        }
        if (notificationDetails.matchDateTimeComponents == DateTimeComponents.Time) {
            return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(nextFireDate);
        }
        if (notificationDetails.matchDateTimeComponents == DateTimeComponents.DayOfWeekAndTime) {
            while (nextFireDate.getDayOfWeek() != scheduledDateTime.getDayOfWeek()) {
                nextFireDate = nextFireDate.plusDays(1L);
            }
            return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(nextFireDate);
        }
        if (notificationDetails.matchDateTimeComponents == DateTimeComponents.DayOfMonthAndTime) {
            while (nextFireDate.getDayOfMonth() != scheduledDateTime.getDayOfMonth()) {
                nextFireDate = nextFireDate.plusDays(1L);
            }
            return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(nextFireDate);
        }
        if (notificationDetails.matchDateTimeComponents == DateTimeComponents.DateAndTime) {
            while (nextFireDate.getMonthValue() != scheduledDateTime.getMonthValue() || nextFireDate.getDayOfMonth() != scheduledDateTime.getDayOfMonth()) {
                nextFireDate = nextFireDate.plusDays(1L);
            }
            return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(nextFireDate);
        }
        return null;
    }

    private static NotificationManagerCompat getNotificationManager(Context context) {
        return NotificationManagerCompat.from((Context)context);
    }

    private static boolean launchedActivityFromHistory(Intent intent) {
        return intent != null && (intent.getFlags() & 0x100000) == 0x100000;
    }

    private void setActivity(Activity flutterActivity) {
        this.mainActivity = flutterActivity;
    }

    public void onAttachedToEngine(FlutterPlugin.FlutterPluginBinding binding) {
        this.applicationContext = binding.getApplicationContext();
        this.channel = new MethodChannel(binding.getBinaryMessenger(), METHOD_CHANNEL);
        this.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.channel.setMethodCallHandler(null);
        this.channel = null;
        this.applicationContext = null;
    }

    public void onAttachedToActivity(ActivityPluginBinding binding) {
        binding.addOnNewIntentListener((PluginRegistry.NewIntentListener)this);
        binding.addRequestPermissionsResultListener((PluginRegistry.RequestPermissionsResultListener)this);
        binding.addActivityResultListener((PluginRegistry.ActivityResultListener)this);
        this.mainActivity = binding.getActivity();
        Intent mainActivityIntent = this.mainActivity.getIntent();
        if (!FlutterLocalNotificationsPlugin.launchedActivityFromHistory(mainActivityIntent) && SELECT_FOREGROUND_NOTIFICATION_ACTION.equals(mainActivityIntent.getAction())) {
            Map<String, Object> notificationResponse = FlutterLocalNotificationsPlugin.extractNotificationResponseMap(mainActivityIntent);
            this.processForegroundNotificationAction(mainActivityIntent, notificationResponse);
        }
    }

    public void onDetachedFromActivityForConfigChanges() {
        this.mainActivity = null;
    }

    public void onReattachedToActivityForConfigChanges(ActivityPluginBinding binding) {
        binding.addOnNewIntentListener((PluginRegistry.NewIntentListener)this);
        binding.addRequestPermissionsResultListener((PluginRegistry.RequestPermissionsResultListener)this);
        binding.addActivityResultListener((PluginRegistry.ActivityResultListener)this);
        this.mainActivity = binding.getActivity();
    }

    public void onDetachedFromActivity() {
        this.mainActivity = null;
    }

    public void onMethodCall(MethodCall call, final @NonNull MethodChannel.Result result) {
        switch (call.method) {
            case "initialize": {
                this.initialize(call, result);
                break;
            }
            case "getCallbackHandle": {
                this.getCallbackHandle(result);
                break;
            }
            case "getNotificationAppLaunchDetails": {
                this.getNotificationAppLaunchDetails(result);
                break;
            }
            case "show": {
                this.show(call, result);
                break;
            }
            case "zonedSchedule": {
                this.zonedSchedule(call, result);
                break;
            }
            case "requestNotificationsPermission": {
                this.requestNotificationsPermission(new PermissionRequestListener(){

                    @Override
                    public void complete(boolean granted) {
                        result.success((Object)granted);
                    }

                    @Override
                    public void fail(String message) {
                        result.error(FlutterLocalNotificationsPlugin.PERMISSION_REQUEST_IN_PROGRESS_ERROR_CODE, message, null);
                    }
                });
                break;
            }
            case "requestExactAlarmsPermission": {
                this.requestExactAlarmsPermission(new PermissionRequestListener(){

                    @Override
                    public void complete(boolean granted) {
                        result.success((Object)granted);
                    }

                    @Override
                    public void fail(String message) {
                        result.error(FlutterLocalNotificationsPlugin.PERMISSION_REQUEST_IN_PROGRESS_ERROR_CODE, message, null);
                    }
                });
                break;
            }
            case "requestFullScreenIntentPermission": {
                this.requestFullScreenIntentPermission(new PermissionRequestListener(){

                    @Override
                    public void complete(boolean granted) {
                        result.success((Object)granted);
                    }

                    @Override
                    public void fail(String message) {
                        result.error(FlutterLocalNotificationsPlugin.PERMISSION_REQUEST_IN_PROGRESS_ERROR_CODE, message, null);
                    }
                });
                break;
            }
            case "requestNotificationPolicyAccess": {
                this.requestNotificationPolicyAccess(new PermissionRequestListener(){

                    @Override
                    public void complete(boolean granted) {
                        result.success((Object)granted);
                    }

                    @Override
                    public void fail(String message) {
                        result.error(FlutterLocalNotificationsPlugin.PERMISSION_REQUEST_IN_PROGRESS_ERROR_CODE, message, null);
                    }
                });
                break;
            }
            case "hasNotificationPolicyAccess": {
                this.hasNotificationPolicyAccess(result);
                break;
            }
            case "periodicallyShow": {
                this.repeat(call, result);
                break;
            }
            case "periodicallyShowWithDuration": {
                this.repeat(call, result);
                break;
            }
            case "cancel": {
                this.cancel(call, result);
                break;
            }
            case "cancelAll": {
                this.cancelAllNotifications(result);
                break;
            }
            case "cancelAllPendingNotifications": {
                this.cancelAllPendingNotifications(result);
                break;
            }
            case "pendingNotificationRequests": {
                this.pendingNotificationRequests(result);
                break;
            }
            case "areNotificationsEnabled": {
                this.areNotificationsEnabled(result);
                break;
            }
            case "canScheduleExactNotifications": {
                this.setCanScheduleExactNotifications(result);
                break;
            }
            case "createNotificationChannelGroup": {
                this.createNotificationChannelGroup(call, result);
                break;
            }
            case "deleteNotificationChannelGroup": {
                this.deleteNotificationChannelGroup(call, result);
                break;
            }
            case "createNotificationChannel": {
                this.createNotificationChannel(call, result);
                break;
            }
            case "deleteNotificationChannel": {
                this.deleteNotificationChannel(call, result);
                break;
            }
            case "getActiveNotifications": {
                this.getActiveNotifications(result);
                break;
            }
            case "getActiveNotificationMessagingStyle": {
                this.getActiveNotificationMessagingStyle(call, result);
                break;
            }
            case "getNotificationChannels": {
                this.getNotificationChannels(result);
                break;
            }
            case "startForegroundService": {
                this.startForegroundService(call, result);
                break;
            }
            case "stopForegroundService": {
                this.stopForegroundService(result);
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    private void pendingNotificationRequests(MethodChannel.Result result) {
        ArrayList<NotificationDetails> scheduledNotifications = FlutterLocalNotificationsPlugin.loadScheduledNotifications(this.applicationContext);
        ArrayList pendingNotifications = new ArrayList();
        for (NotificationDetails scheduledNotification : scheduledNotifications) {
            HashMap<String, Object> pendingNotification = new HashMap<String, Object>();
            pendingNotification.put(CANCEL_ID, scheduledNotification.id);
            pendingNotification.put("title", scheduledNotification.title);
            pendingNotification.put("body", scheduledNotification.body);
            pendingNotification.put(PAYLOAD, scheduledNotification.payload);
            pendingNotifications.add(pendingNotification);
        }
        result.success(pendingNotifications);
    }

    private void getActiveNotifications(MethodChannel.Result result) {
        if (Build.VERSION.SDK_INT < 23) {
            result.error(UNSUPPORTED_OS_VERSION_ERROR_CODE, GET_ACTIVE_NOTIFICATIONS_ERROR_MESSAGE, null);
            return;
        }
        NotificationManager notificationManager = (NotificationManager)this.applicationContext.getSystemService("notification");
        try {
            StatusBarNotification[] activeNotifications = notificationManager.getActiveNotifications();
            ArrayList activeNotificationsPayload = new ArrayList();
            for (StatusBarNotification activeNotification : activeNotifications) {
                HashMap<String, Object> activeNotificationPayload = new HashMap<String, Object>();
                activeNotificationPayload.put(CANCEL_ID, activeNotification.getId());
                Notification notification = activeNotification.getNotification();
                if (Build.VERSION.SDK_INT >= 26) {
                    activeNotificationPayload.put("channelId", notification.getChannelId());
                }
                activeNotificationPayload.put(CANCEL_TAG, activeNotification.getTag());
                activeNotificationPayload.put("groupKey", notification.getGroup());
                activeNotificationPayload.put("title", notification.extras.getCharSequence("android.title"));
                activeNotificationPayload.put("body", notification.extras.getCharSequence("android.text"));
                activeNotificationPayload.put("bigText", notification.extras.getCharSequence("android.bigText"));
                activeNotificationsPayload.add(activeNotificationPayload);
            }
            result.success(activeNotificationsPayload);
        }
        catch (Throwable e) {
            result.error(UNSUPPORTED_OS_VERSION_ERROR_CODE, e.getMessage(), (Object)Log.getStackTraceString((Throwable)e));
        }
    }

    private void cancel(MethodCall call, MethodChannel.Result result) {
        Map arguments = (Map)call.arguments();
        Integer id = (Integer)arguments.get(CANCEL_ID);
        String tag = (String)arguments.get(CANCEL_TAG);
        this.cancelNotification(id, tag);
        result.success(null);
    }

    private void repeat(MethodCall call, MethodChannel.Result result) {
        NotificationDetails notificationDetails = this.extractNotificationDetails(result, (Map)call.arguments());
        if (notificationDetails != null) {
            try {
                FlutterLocalNotificationsPlugin.repeatNotification(this.applicationContext, notificationDetails, true);
                result.success(null);
            }
            catch (PluginException e) {
                result.error(e.code, e.getMessage(), null);
            }
        }
    }

    private void zonedSchedule(MethodCall call, MethodChannel.Result result) {
        NotificationDetails notificationDetails = this.extractNotificationDetails(result, (Map)call.arguments());
        if (notificationDetails != null) {
            if (notificationDetails.matchDateTimeComponents != null) {
                notificationDetails.scheduledDateTime = FlutterLocalNotificationsPlugin.getNextFireDateMatchingDateTimeComponents(notificationDetails);
            }
            try {
                FlutterLocalNotificationsPlugin.zonedScheduleNotification(this.applicationContext, notificationDetails, true);
                result.success(null);
            }
            catch (PluginException e) {
                result.error(e.code, e.getMessage(), null);
            }
        }
    }

    private void show(MethodCall call, MethodChannel.Result result) {
        Map arguments = (Map)call.arguments();
        NotificationDetails notificationDetails = this.extractNotificationDetails(result, arguments);
        if (notificationDetails != null) {
            FlutterLocalNotificationsPlugin.showNotification(this.applicationContext, notificationDetails);
            result.success(null);
        }
    }

    private void getNotificationAppLaunchDetails(MethodChannel.Result result) {
        Intent launchIntent;
        HashMap<String, Object> notificationAppLaunchDetails = new HashMap<String, Object>();
        Boolean notificationLaunchedApp = false;
        if (this.mainActivity != null && (notificationLaunchedApp = Boolean.valueOf((launchIntent = this.mainActivity.getIntent()) != null && (SELECT_NOTIFICATION.equals(launchIntent.getAction()) || SELECT_FOREGROUND_NOTIFICATION_ACTION.equals(launchIntent.getAction())) && !FlutterLocalNotificationsPlugin.launchedActivityFromHistory(launchIntent))).booleanValue()) {
            notificationAppLaunchDetails.put("notificationResponse", FlutterLocalNotificationsPlugin.extractNotificationResponseMap(launchIntent));
        }
        notificationAppLaunchDetails.put(NOTIFICATION_LAUNCHED_APP, notificationLaunchedApp);
        result.success(notificationAppLaunchDetails);
    }

    private void initialize(MethodCall call, MethodChannel.Result result) {
        Map arguments = (Map)call.arguments();
        String defaultIcon = (String)arguments.get(DEFAULT_ICON);
        if (!FlutterLocalNotificationsPlugin.isValidDrawableResource(this.applicationContext, defaultIcon, result, INVALID_ICON_ERROR_CODE)) {
            return;
        }
        Long dispatcherHandle = LongUtils.parseLong(call.argument(DISPATCHER_HANDLE));
        Long callbackHandle = LongUtils.parseLong(call.argument(CALLBACK_HANDLE));
        if (dispatcherHandle != null && callbackHandle != null) {
            new IsolatePreferences(this.applicationContext).saveCallbackKeys(dispatcherHandle, callbackHandle);
        }
        SharedPreferences sharedPreferences = this.applicationContext.getSharedPreferences(SHARED_PREFERENCES_KEY, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(DEFAULT_ICON, defaultIcon).apply();
        result.success((Object)true);
    }

    private void getCallbackHandle(MethodChannel.Result result) {
        Long handle = new IsolatePreferences(this.applicationContext).getCallbackHandle();
        result.success((Object)handle);
    }

    private NotificationDetails extractNotificationDetails(MethodChannel.Result result, Map<String, Object> arguments) {
        NotificationDetails notificationDetails = NotificationDetails.from(arguments);
        if (this.hasInvalidIcon(result, notificationDetails.icon) || this.hasInvalidLargeIcon(result, notificationDetails.largeIcon, notificationDetails.largeIconBitmapSource) || this.hasInvalidBigPictureResources(result, notificationDetails) || this.hasInvalidRawSoundResource(result, notificationDetails) || this.hasInvalidLedDetails(result, notificationDetails)) {
            return null;
        }
        return notificationDetails;
    }

    private boolean hasInvalidLedDetails(MethodChannel.Result result, NotificationDetails notificationDetails) {
        if (notificationDetails.ledColor != null && (notificationDetails.ledOnMs == null || notificationDetails.ledOffMs == null)) {
            result.error(INVALID_LED_DETAILS_ERROR_CODE, INVALID_LED_DETAILS_ERROR_MESSAGE, null);
            return true;
        }
        return false;
    }

    private boolean hasInvalidRawSoundResource(MethodChannel.Result result, NotificationDetails notificationDetails) {
        int soundResourceId;
        if (!(StringUtils.isNullOrEmpty(notificationDetails.sound).booleanValue() || notificationDetails.soundSource != null && notificationDetails.soundSource != SoundSource.RawResource || (soundResourceId = this.applicationContext.getResources().getIdentifier(notificationDetails.sound, "raw", this.applicationContext.getPackageName())) != 0)) {
            result.error(INVALID_SOUND_ERROR_CODE, String.format(INVALID_RAW_RESOURCE_ERROR_MESSAGE, notificationDetails.sound), null);
            return true;
        }
        return false;
    }

    private boolean hasInvalidBigPictureResources(MethodChannel.Result result, NotificationDetails notificationDetails) {
        if (notificationDetails.style == NotificationStyle.BigPicture) {
            BigPictureStyleInformation bigPictureStyleInformation = (BigPictureStyleInformation)notificationDetails.styleInformation;
            if (this.hasInvalidLargeIcon(result, bigPictureStyleInformation.largeIcon, bigPictureStyleInformation.largeIconBitmapSource)) {
                return true;
            }
            if (bigPictureStyleInformation.bigPictureBitmapSource == BitmapSource.DrawableResource) {
                String bigPictureResourceName = (String)bigPictureStyleInformation.bigPicture;
                return StringUtils.isNullOrEmpty(bigPictureResourceName) != false && !FlutterLocalNotificationsPlugin.isValidDrawableResource(this.applicationContext, bigPictureResourceName, result, INVALID_BIG_PICTURE_ERROR_CODE);
            }
            if (bigPictureStyleInformation.bigPictureBitmapSource == BitmapSource.FilePath) {
                String largeIconPath = (String)bigPictureStyleInformation.bigPicture;
                return StringUtils.isNullOrEmpty(largeIconPath);
            }
            if (bigPictureStyleInformation.bigPictureBitmapSource == BitmapSource.ByteArray) {
                byte[] byteArray = (byte[])bigPictureStyleInformation.bigPicture;
                return byteArray == null || byteArray.length == 0;
            }
        }
        return false;
    }

    private boolean hasInvalidLargeIcon(MethodChannel.Result result, Object largeIcon, BitmapSource largeIconBitmapSource) {
        if (largeIconBitmapSource == BitmapSource.DrawableResource || largeIconBitmapSource == BitmapSource.FilePath) {
            String largeIconPath = (String)largeIcon;
            return StringUtils.isNullOrEmpty(largeIconPath) == false && largeIconBitmapSource == BitmapSource.DrawableResource && !FlutterLocalNotificationsPlugin.isValidDrawableResource(this.applicationContext, largeIconPath, result, INVALID_LARGE_ICON_ERROR_CODE);
        }
        if (largeIconBitmapSource == BitmapSource.ByteArray) {
            byte[] byteArray = (byte[])largeIcon;
            return byteArray.length == 0;
        }
        return false;
    }

    private boolean hasInvalidIcon(MethodChannel.Result result, String icon) {
        return StringUtils.isNullOrEmpty(icon) == false && !FlutterLocalNotificationsPlugin.isValidDrawableResource(this.applicationContext, icon, result, INVALID_ICON_ERROR_CODE);
    }

    private void cancelNotification(Integer id, String tag) {
        Intent intent = new Intent(this.applicationContext, ScheduledNotificationReceiver.class);
        PendingIntent pendingIntent = FlutterLocalNotificationsPlugin.getBroadcastPendingIntent(this.applicationContext, id, intent);
        AlarmManager alarmManager = FlutterLocalNotificationsPlugin.getAlarmManager(this.applicationContext);
        alarmManager.cancel(pendingIntent);
        NotificationManagerCompat notificationManager = FlutterLocalNotificationsPlugin.getNotificationManager(this.applicationContext);
        if (tag == null) {
            notificationManager.cancel(id.intValue());
        } else {
            notificationManager.cancel(tag, id.intValue());
        }
        FlutterLocalNotificationsPlugin.removeNotificationFromCache(this.applicationContext, id);
    }

    private void cancelAllNotifications(MethodChannel.Result result) {
        NotificationManagerCompat notificationManager = FlutterLocalNotificationsPlugin.getNotificationManager(this.applicationContext);
        notificationManager.cancelAll();
        ArrayList<NotificationDetails> scheduledNotifications = FlutterLocalNotificationsPlugin.loadScheduledNotifications(this.applicationContext);
        if (scheduledNotifications == null || scheduledNotifications.isEmpty()) {
            result.success(null);
            return;
        }
        Intent intent = new Intent(this.applicationContext, ScheduledNotificationReceiver.class);
        for (NotificationDetails scheduledNotification : scheduledNotifications) {
            PendingIntent pendingIntent = FlutterLocalNotificationsPlugin.getBroadcastPendingIntent(this.applicationContext, scheduledNotification.id, intent);
            AlarmManager alarmManager = FlutterLocalNotificationsPlugin.getAlarmManager(this.applicationContext);
            alarmManager.cancel(pendingIntent);
        }
        FlutterLocalNotificationsPlugin.saveScheduledNotifications(this.applicationContext, new ArrayList<NotificationDetails>());
        result.success(null);
    }

    private void cancelAllPendingNotifications(MethodChannel.Result result) {
        ArrayList<NotificationDetails> scheduledNotifications = FlutterLocalNotificationsPlugin.loadScheduledNotifications(this.applicationContext);
        if (scheduledNotifications == null || scheduledNotifications.isEmpty()) {
            result.success(null);
            return;
        }
        AlarmManager alarmManager = FlutterLocalNotificationsPlugin.getAlarmManager(this.applicationContext);
        Intent intent = new Intent(this.applicationContext, ScheduledNotificationReceiver.class);
        for (NotificationDetails scheduledNotification : scheduledNotifications) {
            PendingIntent pendingIntent = FlutterLocalNotificationsPlugin.getBroadcastPendingIntent(this.applicationContext, scheduledNotification.id, intent);
            alarmManager.cancel(pendingIntent);
        }
        FlutterLocalNotificationsPlugin.saveScheduledNotifications(this.applicationContext, new ArrayList<NotificationDetails>());
        result.success(null);
    }

    public void requestNotificationsPermission(@NonNull PermissionRequestListener callback) {
        if (this.permissionRequestProgress != PermissionRequestProgress.None) {
            callback.fail(PERMISSION_REQUEST_IN_PROGRESS_ERROR_MESSAGE);
            return;
        }
        this.callback = callback;
        if (Build.VERSION.SDK_INT >= 33) {
            boolean permissionGranted;
            String permission2 = "android.permission.POST_NOTIFICATIONS";
            boolean bl = permissionGranted = ContextCompat.checkSelfPermission((Context)this.mainActivity, (String)permission2) == 0;
            if (!permissionGranted) {
                this.permissionRequestProgress = PermissionRequestProgress.RequestingNotificationPermission;
                ActivityCompat.requestPermissions((Activity)this.mainActivity, (String[])new String[]{permission2}, (int)1);
            } else {
                this.callback.complete(true);
                this.permissionRequestProgress = PermissionRequestProgress.None;
            }
        } else {
            NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)this.mainActivity);
            this.callback.complete(notificationManager.areNotificationsEnabled());
        }
    }

    public void requestExactAlarmsPermission(@NonNull PermissionRequestListener callback) {
        if (this.permissionRequestProgress != PermissionRequestProgress.None) {
            callback.fail(PERMISSION_REQUEST_IN_PROGRESS_ERROR_MESSAGE);
            return;
        }
        this.callback = callback;
        if (Build.VERSION.SDK_INT >= 31) {
            AlarmManager alarmManager = FlutterLocalNotificationsPlugin.getAlarmManager(this.applicationContext);
            boolean permissionGranted = alarmManager.canScheduleExactAlarms();
            if (!permissionGranted) {
                this.permissionRequestProgress = PermissionRequestProgress.RequestingExactAlarmsPermission;
                this.mainActivity.startActivityForResult(new Intent("android.settings.REQUEST_SCHEDULE_EXACT_ALARM", Uri.parse((String)("package:" + this.applicationContext.getPackageName()))), 2);
            } else {
                this.callback.complete(true);
                this.permissionRequestProgress = PermissionRequestProgress.None;
            }
        } else {
            this.callback.complete(true);
        }
    }

    public void requestFullScreenIntentPermission(@NonNull PermissionRequestListener callback) {
        if (this.permissionRequestProgress != PermissionRequestProgress.None) {
            callback.fail(PERMISSION_REQUEST_IN_PROGRESS_ERROR_MESSAGE);
            return;
        }
        this.callback = callback;
        if (Build.VERSION.SDK_INT >= 34) {
            NotificationManager notificationManager = (NotificationManager)this.applicationContext.getSystemService("notification");
            AlarmManager alarmManager = FlutterLocalNotificationsPlugin.getAlarmManager(this.applicationContext);
            boolean permissionGranted = notificationManager.canUseFullScreenIntent();
            if (!permissionGranted) {
                this.permissionRequestProgress = PermissionRequestProgress.RequestingFullScreenIntentPermission;
                this.mainActivity.startActivityForResult(new Intent("android.settings.MANAGE_APP_USE_FULL_SCREEN_INTENT", Uri.parse((String)("package:" + this.applicationContext.getPackageName()))), 3);
            } else {
                this.callback.complete(true);
                this.permissionRequestProgress = PermissionRequestProgress.None;
            }
        } else {
            this.callback.complete(true);
        }
    }

    public void requestNotificationPolicyAccess(@NonNull PermissionRequestListener callback) {
        if (Build.VERSION.SDK_INT < 23) {
            callback.complete(false);
            return;
        }
        if (this.permissionRequestProgress != PermissionRequestProgress.None) {
            callback.fail(PERMISSION_REQUEST_IN_PROGRESS_ERROR_MESSAGE);
            return;
        }
        this.callback = callback;
        NotificationManager notificationManager = (NotificationManager)this.applicationContext.getSystemService("notification");
        boolean permissionGranted = notificationManager.isNotificationPolicyAccessGranted();
        if (permissionGranted) {
            this.callback.complete(true);
            this.permissionRequestProgress = PermissionRequestProgress.None;
        } else {
            this.permissionRequestProgress = PermissionRequestProgress.RequestingNotificationPolicyAccess;
            this.mainActivity.startActivityForResult(new Intent("android.settings.NOTIFICATION_POLICY_ACCESS_SETTINGS"), 4);
        }
    }

    public void hasNotificationPolicyAccess(MethodChannel.Result result) {
        if (Build.VERSION.SDK_INT < 23) {
            result.success((Object)false);
            return;
        }
        NotificationManager notificationManager = (NotificationManager)this.applicationContext.getSystemService("notification");
        boolean isGranted = notificationManager.isNotificationPolicyAccessGranted();
        result.success((Object)isGranted);
    }

    public boolean onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (this.permissionRequestProgress == PermissionRequestProgress.RequestingNotificationPermission && requestCode == 1) {
            boolean granted = grantResults.length > 0 && grantResults[0] == 0;
            this.callback.complete(granted);
            this.permissionRequestProgress = PermissionRequestProgress.None;
            return granted;
        }
        return false;
    }

    public boolean onNewIntent(Intent intent) {
        boolean res = this.sendNotificationPayloadMessage(intent);
        if (res && this.mainActivity != null) {
            this.mainActivity.setIntent(intent);
        }
        return res;
    }

    private Boolean sendNotificationPayloadMessage(Intent intent) {
        if (SELECT_NOTIFICATION.equals(intent.getAction()) || SELECT_FOREGROUND_NOTIFICATION_ACTION.equals(intent.getAction())) {
            Map<String, Object> notificationResponse = FlutterLocalNotificationsPlugin.extractNotificationResponseMap(intent);
            if (SELECT_FOREGROUND_NOTIFICATION_ACTION.equals(intent.getAction())) {
                this.processForegroundNotificationAction(intent, notificationResponse);
            }
            this.channel.invokeMethod("didReceiveNotificationResponse", notificationResponse);
            return true;
        }
        return false;
    }

    private void processForegroundNotificationAction(Intent intent, Map<String, Object> notificationResponse) {
        if (intent.getBooleanExtra(CANCEL_NOTIFICATION, false)) {
            NotificationManagerCompat.from((Context)this.applicationContext).cancel(((Integer)notificationResponse.get(NOTIFICATION_ID)).intValue());
        }
    }

    private void createNotificationChannelGroup(MethodCall call, MethodChannel.Result result) {
        if (Build.VERSION.SDK_INT >= 26) {
            Map arguments = (Map)call.arguments();
            NotificationChannelGroupDetails notificationChannelGroupDetails = NotificationChannelGroupDetails.from(arguments);
            NotificationManager notificationManager = (NotificationManager)this.applicationContext.getSystemService("notification");
            NotificationChannelGroup notificationChannelGroup = new NotificationChannelGroup(notificationChannelGroupDetails.id, (CharSequence)notificationChannelGroupDetails.name);
            if (Build.VERSION.SDK_INT >= 28) {
                notificationChannelGroup.setDescription(notificationChannelGroupDetails.description);
            }
            notificationManager.createNotificationChannelGroup(notificationChannelGroup);
        }
        result.success(null);
    }

    private void deleteNotificationChannelGroup(MethodCall call, MethodChannel.Result result) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager notificationManager = (NotificationManager)this.applicationContext.getSystemService("notification");
            String groupId = (String)call.arguments();
            notificationManager.deleteNotificationChannelGroup(groupId);
        }
        result.success(null);
    }

    private void createNotificationChannel(MethodCall call, MethodChannel.Result result) {
        Map arguments = (Map)call.arguments();
        NotificationChannelDetails notificationChannelDetails = NotificationChannelDetails.from(arguments);
        FlutterLocalNotificationsPlugin.setupNotificationChannel(this.applicationContext, notificationChannelDetails);
        result.success(null);
    }

    private void deleteNotificationChannel(MethodCall call, MethodChannel.Result result) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager notificationManager = (NotificationManager)this.applicationContext.getSystemService("notification");
            String channelId = (String)call.arguments();
            notificationManager.deleteNotificationChannel(channelId);
        }
        result.success(null);
    }

    private void getActiveNotificationMessagingStyle(MethodCall call, MethodChannel.Result result) {
        if (Build.VERSION.SDK_INT < 23) {
            result.error(UNSUPPORTED_OS_VERSION_ERROR_CODE, "Android version must be 6.0 or newer to use getActiveNotificationMessagingStyle", null);
            return;
        }
        NotificationManager notificationManager = (NotificationManager)this.applicationContext.getSystemService("notification");
        try {
            Map arguments = (Map)call.arguments();
            int id = (Integer)arguments.get(CANCEL_ID);
            String tag = (String)arguments.get(CANCEL_TAG);
            StatusBarNotification[] activeNotifications = notificationManager.getActiveNotifications();
            Notification notification = null;
            for (StatusBarNotification activeNotification : activeNotifications) {
                if (activeNotification.getId() != id || tag != null && !tag.equals(activeNotification.getTag())) continue;
                notification = activeNotification.getNotification();
                break;
            }
            if (notification == null) {
                result.success(null);
                return;
            }
            NotificationCompat.MessagingStyle messagingStyle = NotificationCompat.MessagingStyle.extractMessagingStyleFromNotification(notification);
            if (messagingStyle == null) {
                result.success(null);
                return;
            }
            HashMap<String, Object> stylePayload = new HashMap<String, Object>();
            stylePayload.put("groupConversation", messagingStyle.isGroupConversation());
            stylePayload.put("person", this.describePerson(messagingStyle.getUser()));
            stylePayload.put("conversationTitle", messagingStyle.getConversationTitle());
            ArrayList messagesPayload = new ArrayList();
            for (NotificationCompat.MessagingStyle.Message msg : messagingStyle.getMessages()) {
                HashMap<String, Object> msgPayload = new HashMap<String, Object>();
                msgPayload.put("text", msg.getText());
                msgPayload.put("timestamp", msg.getTimestamp());
                msgPayload.put("person", this.describePerson(msg.getPerson()));
                if (msg.getDataUri() != null) {
                    msgPayload.put("dataUri", msg.getDataUri().toString());
                }
                if (msg.getDataMimeType() != null) {
                    msgPayload.put("dataMimeType", msg.getDataMimeType());
                }
                messagesPayload.add(msgPayload);
            }
            stylePayload.put("messages", messagesPayload);
            result.success(stylePayload);
        }
        catch (Throwable e) {
            result.error(GET_ACTIVE_NOTIFICATION_MESSAGING_STYLE_ERROR_CODE, e.getMessage(), (Object)Log.getStackTraceString((Throwable)e));
        }
    }

    private Map<String, Object> describePerson(Person person) {
        if (person == null) {
            return null;
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("key", person.getKey());
        payload.put("name", person.getName());
        payload.put("uri", person.getUri());
        payload.put("bot", person.isBot());
        payload.put("important", person.isImportant());
        payload.put("icon", this.describeIcon(person.getIcon()));
        return payload;
    }

    private Map<String, Object> describeIcon(IconCompat icon) {
        String data;
        IconSource source;
        if (icon == null) {
            return null;
        }
        switch (icon.getType()) {
            case 2: {
                source = IconSource.DrawableResource;
                int resId = icon.getResId();
                Context context = this.applicationContext;
                assert (context.getResources().getResourceTypeName(resId).equals(DRAWABLE));
                assert (context.getResources().getResourcePackageName(resId).equals(context.getPackageName()));
                data = context.getResources().getResourceEntryName(resId);
                break;
            }
            case 4: {
                source = IconSource.ContentUri;
                data = icon.getUri().toString();
                break;
            }
            default: {
                return null;
            }
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("source", source.ordinal());
        payload.put("data", data);
        return payload;
    }

    private void getNotificationChannels(MethodChannel.Result result) {
        try {
            NotificationManagerCompat notificationManagerCompat = FlutterLocalNotificationsPlugin.getNotificationManager(this.applicationContext);
            List channels = notificationManagerCompat.getNotificationChannels();
            ArrayList<HashMap<String, Object>> channelsPayload = new ArrayList<HashMap<String, Object>>();
            for (NotificationChannel channel : channels) {
                HashMap<String, Object> channelPayload = this.getMappedNotificationChannel(channel);
                channelsPayload.add(channelPayload);
            }
            result.success(channelsPayload);
        }
        catch (Throwable e) {
            result.error(GET_NOTIFICATION_CHANNELS_ERROR_CODE, e.getMessage(), (Object)Log.getStackTraceString((Throwable)e));
        }
    }

    private HashMap<String, Object> getMappedNotificationChannel(NotificationChannel channel) {
        HashMap<String, Object> channelPayload = new HashMap<String, Object>();
        if (Build.VERSION.SDK_INT >= 26) {
            channelPayload.put(CANCEL_ID, channel.getId());
            channelPayload.put("name", channel.getName());
            channelPayload.put("description", channel.getDescription());
            channelPayload.put("groupId", channel.getGroup());
            channelPayload.put("showBadge", channel.canShowBadge());
            channelPayload.put("importance", channel.getImportance());
            Uri soundUri = channel.getSound();
            if (soundUri == null) {
                channelPayload.put("sound", null);
                channelPayload.put("playSound", false);
            } else {
                channelPayload.put("playSound", true);
                List<SoundSource> soundSources = Arrays.asList(SoundSource.values());
                if (soundUri.getScheme().equals("android.resource")) {
                    String[] splitUri = soundUri.toString().split("/");
                    String resource = splitUri[splitUri.length - 1];
                    Integer resourceId = this.tryParseInt(resource);
                    if (resourceId == null) {
                        channelPayload.put("soundSource", soundSources.indexOf((Object)SoundSource.RawResource));
                        channelPayload.put("sound", resource);
                    } else {
                        try {
                            String resourceName = this.applicationContext.getResources().getResourceEntryName(resourceId.intValue());
                            if (resourceName != null) {
                                channelPayload.put("soundSource", soundSources.indexOf((Object)SoundSource.RawResource));
                                channelPayload.put("sound", resourceName);
                            }
                        }
                        catch (Exception e) {
                            channelPayload.put("sound", null);
                            channelPayload.put("playSound", false);
                        }
                    }
                } else {
                    channelPayload.put("soundSource", soundSources.indexOf((Object)SoundSource.Uri));
                    channelPayload.put("sound", soundUri.toString());
                }
            }
            channelPayload.put("bypassDnd", channel.canBypassDnd());
            channelPayload.put("enableVibration", channel.shouldVibrate());
            channelPayload.put("vibrationPattern", channel.getVibrationPattern());
            channelPayload.put("enableLights", channel.shouldShowLights());
            channelPayload.put("ledColor", channel.getLightColor());
            AudioAttributes audioAttributes = channel.getAudioAttributes();
            channelPayload.put("audioAttributesUsage", audioAttributes == null ? 5 : audioAttributes.getUsage());
        }
        return channelPayload;
    }

    private Integer tryParseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void startForegroundService(MethodCall call, MethodChannel.Result result) {
        Map notificationData = (Map)call.argument("notificationData");
        Integer startType = (Integer)call.argument("startType");
        ArrayList foregroundServiceTypes = (ArrayList)call.argument("foregroundServiceTypes");
        if (foregroundServiceTypes == null || foregroundServiceTypes.size() != 0) {
            if (notificationData != null && startType != null) {
                NotificationDetails notificationDetails = this.extractNotificationDetails(result, notificationData);
                if (notificationDetails != null) {
                    if (notificationDetails.id != 0) {
                        ForegroundServiceStartParameter parameter = new ForegroundServiceStartParameter(notificationDetails, startType, foregroundServiceTypes);
                        Intent intent = new Intent(this.applicationContext, ForegroundService.class);
                        intent.putExtra("com.dexterous.flutterlocalnotifications.ForegroundServiceStartParameter", (Serializable)parameter);
                        ContextCompat.startForegroundService((Context)this.applicationContext, (Intent)intent);
                        result.success(null);
                    } else {
                        result.error("ARGUMENT_ERROR", "The id of the notification for a foreground service must not be 0!", null);
                    }
                }
            } else {
                result.error("ARGUMENT_ERROR", "An argument passed to startForegroundService was null!", null);
            }
        } else {
            result.error("ARGUMENT_ERROR", "If foregroundServiceTypes is non-null it must not be empty!", null);
        }
    }

    private void stopForegroundService(MethodChannel.Result result) {
        this.applicationContext.stopService(new Intent(this.applicationContext, ForegroundService.class));
        result.success(null);
    }

    private void areNotificationsEnabled(MethodChannel.Result result) {
        NotificationManagerCompat notificationManager = FlutterLocalNotificationsPlugin.getNotificationManager(this.applicationContext);
        result.success((Object)notificationManager.areNotificationsEnabled());
    }

    private void setCanScheduleExactNotifications(MethodChannel.Result result) {
        if (Build.VERSION.SDK_INT < 31) {
            result.success((Object)true);
        } else {
            AlarmManager alarmManager = FlutterLocalNotificationsPlugin.getAlarmManager(this.applicationContext);
            result.success((Object)alarmManager.canScheduleExactAlarms());
        }
    }

    public boolean onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        NotificationManager notificationManager;
        if (requestCode != 1 && requestCode != 2 && requestCode != 3 && requestCode != 4) {
            return false;
        }
        if (this.permissionRequestProgress == PermissionRequestProgress.RequestingExactAlarmsPermission && requestCode == 2 && Build.VERSION.SDK_INT >= 31) {
            AlarmManager alarmManager = FlutterLocalNotificationsPlugin.getAlarmManager(this.applicationContext);
            this.callback.complete(alarmManager.canScheduleExactAlarms());
            this.permissionRequestProgress = PermissionRequestProgress.None;
        }
        if (this.permissionRequestProgress == PermissionRequestProgress.RequestingFullScreenIntentPermission && requestCode == 3 && Build.VERSION.SDK_INT >= 34) {
            notificationManager = (NotificationManager)this.applicationContext.getSystemService("notification");
            this.callback.complete(notificationManager.canUseFullScreenIntent());
            this.permissionRequestProgress = PermissionRequestProgress.None;
        }
        if (this.permissionRequestProgress == PermissionRequestProgress.RequestingNotificationPolicyAccess && requestCode == 4 && Build.VERSION.SDK_INT >= 23) {
            notificationManager = (NotificationManager)this.applicationContext.getSystemService("notification");
            this.callback.complete(notificationManager.isNotificationPolicyAccessGranted());
            this.permissionRequestProgress = PermissionRequestProgress.None;
        }
        return true;
    }

    static enum PermissionRequestProgress {
        None,
        RequestingNotificationPermission,
        RequestingNotificationPolicyAccess,
        RequestingExactAlarmsPermission,
        RequestingFullScreenIntentPermission;

    }

    private static class ExactAlarmPermissionException
    extends PluginException {
        public ExactAlarmPermissionException() {
            super(FlutterLocalNotificationsPlugin.EXACT_ALARMS_PERMISSION_ERROR_CODE, "Exact alarms are not permitted");
        }
    }

    private static class PluginException
    extends RuntimeException {
        public final String code;

        PluginException(String code, String message) {
            super(message);
            this.code = code;
        }
    }
}

