/*
 * Decompiled with CFR 0.152.
 */
package com.dexterous.flutterlocalnotifications;

import android.app.Notification;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.core.app.NotificationManagerCompat;
import com.dexterous.flutterlocalnotifications.FlutterLocalNotificationsPlugin;
import com.dexterous.flutterlocalnotifications.models.NotificationDetails;
import com.dexterous.flutterlocalnotifications.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;

@Keep
public class ScheduledNotificationReceiver
extends BroadcastReceiver {
    private static final String TAG = "ScheduledNotifReceiver";

    public void onReceive(Context context, Intent intent) {
        String notificationDetailsJson = intent.getStringExtra(FlutterLocalNotificationsPlugin.NOTIFICATION_DETAILS);
        if (StringUtils.isNullOrEmpty(notificationDetailsJson).booleanValue()) {
            int notificationId = intent.getIntExtra("notification_id", 0);
            Notification notification = Build.VERSION.SDK_INT >= 33 ? (Notification)intent.getParcelableExtra("notification", Notification.class) : (Notification)intent.getParcelableExtra("notification");
            if (notification == null) {
                FlutterLocalNotificationsPlugin.removeNotificationFromCache(context, notificationId);
                Log.e((String)TAG, (String)("Failed to parse a notification from  Intent. ID: " + notificationId));
                return;
            }
            notification.when = System.currentTimeMillis();
            NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)context);
            notificationManager.notify(notificationId, notification);
            boolean repeat = intent.getBooleanExtra("repeat", false);
            if (!repeat) {
                FlutterLocalNotificationsPlugin.removeNotificationFromCache(context, notificationId);
            }
        } else {
            Gson gson = FlutterLocalNotificationsPlugin.buildGson();
            Type type = new TypeToken<NotificationDetails>(){}.getType();
            NotificationDetails notificationDetails = (NotificationDetails)gson.fromJson(notificationDetailsJson, type);
            FlutterLocalNotificationsPlugin.showNotification(context, notificationDetails);
            FlutterLocalNotificationsPlugin.scheduleNextNotification(context, notificationDetails);
        }
    }
}

