/*
 * Decompiled with CFR 0.152.
 */
package com.dexterous.flutterlocalnotifications;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.NotificationManagerCompat;
import com.dexterous.flutterlocalnotifications.FlutterLocalNotificationsPlugin;
import com.dexterous.flutterlocalnotifications.isolate.IsolatePreferences;
import io.flutter.FlutterInjector;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.loader.FlutterLoader;
import io.flutter.plugin.common.EventChannel;
import io.flutter.view.FlutterCallbackInformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ActionBroadcastReceiver
extends BroadcastReceiver {
    public static final String ACTION_TAPPED = "com.dexterous.flutterlocalnotifications.ActionBroadcastReceiver.ACTION_TAPPED";
    private static final String TAG = "ActionBroadcastReceiver";
    @Nullable
    private static ActionEventSink actionEventSink;
    @Nullable
    private static FlutterEngine engine;
    IsolatePreferences preferences;

    @VisibleForTesting
    ActionBroadcastReceiver(IsolatePreferences preferences) {
        this.preferences = preferences;
    }

    @Keep
    public ActionBroadcastReceiver() {
    }

    public void onReceive(Context context, Intent intent) {
        if (!ACTION_TAPPED.equalsIgnoreCase(intent.getAction())) {
            return;
        }
        this.preferences = this.preferences == null ? new IsolatePreferences(context) : this.preferences;
        Map<String, Object> action = FlutterLocalNotificationsPlugin.extractNotificationResponseMap(intent);
        if (intent.getBooleanExtra("cancelNotification", false)) {
            int notificationId = (Integer)action.get("notificationId");
            Object tag = action.get("notificationTag");
            if (tag instanceof String) {
                NotificationManagerCompat.from((Context)context).cancel((String)tag, notificationId);
            } else {
                NotificationManagerCompat.from((Context)context).cancel(notificationId);
            }
        }
        if (actionEventSink == null) {
            actionEventSink = new ActionEventSink();
        }
        actionEventSink.addItem(action);
        this.startEngine(context);
    }

    private void startEngine(Context context) {
        if (engine != null) {
            Log.e((String)TAG, (String)"Engine is already initialised");
            return;
        }
        FlutterInjector injector = FlutterInjector.instance();
        FlutterLoader loader = injector.flutterLoader();
        loader.startInitialization(context);
        loader.ensureInitializationComplete(context, null);
        engine = new FlutterEngine(context);
        FlutterCallbackInformation dispatcherHandle = this.preferences.lookupDispatcherHandle();
        if (dispatcherHandle == null) {
            Log.w((String)TAG, (String)"Callback information could not be retrieved");
            return;
        }
        DartExecutor dartExecutor = engine.getDartExecutor();
        this.initializeEventChannel(dartExecutor);
        String dartBundlePath = loader.findAppBundlePath();
        dartExecutor.executeDartCallback(new DartExecutor.DartCallback(context.getAssets(), dartBundlePath, dispatcherHandle));
    }

    private void initializeEventChannel(DartExecutor dartExecutor) {
        EventChannel channel = new EventChannel(dartExecutor.getBinaryMessenger(), "dexterous.com/flutter/local_notifications/actions");
        channel.setStreamHandler((EventChannel.StreamHandler)actionEventSink);
    }

    private static class ActionEventSink
    implements EventChannel.StreamHandler {
        final List<Map<String, Object>> cache = new ArrayList<Map<String, Object>>();
        @Nullable
        private EventChannel.EventSink eventSink;

        private ActionEventSink() {
        }

        public void addItem(Map<String, Object> item) {
            if (this.eventSink != null) {
                this.eventSink.success(item);
            } else {
                this.cache.add(item);
            }
        }

        public void onListen(Object arguments, EventChannel.EventSink events) {
            for (Map<String, Object> item : this.cache) {
                events.success(item);
            }
            this.cache.clear();
            this.eventSink = events;
        }

        public void onCancel(Object arguments) {
            this.eventSink = null;
        }
    }
}

