/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.imagepicker;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.embedding.engine.plugins.lifecycle.FlutterLifecycleAdapter;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.plugins.imagepicker.ExifDataCopier;
import io.flutter.plugins.imagepicker.ImagePickerCache;
import io.flutter.plugins.imagepicker.ImagePickerDelegate;
import io.flutter.plugins.imagepicker.ImagePickerUtils;
import io.flutter.plugins.imagepicker.ImageResizer;
import io.flutter.plugins.imagepicker.Messages;
import java.util.List;

public class ImagePickerPlugin
implements FlutterPlugin,
ActivityAware,
Messages.ImagePickerApi {
    private FlutterPlugin.FlutterPluginBinding pluginBinding;
    ActivityState activityState;

    public ImagePickerPlugin() {
    }

    @VisibleForTesting
    ImagePickerPlugin(ImagePickerDelegate delegate, Activity activity) {
        this.activityState = new ActivityState(delegate, activity);
    }

    @VisibleForTesting
    final ActivityState getActivityState() {
        return this.activityState;
    }

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.pluginBinding = binding;
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.pluginBinding = null;
    }

    public void onAttachedToActivity(@NonNull ActivityPluginBinding binding) {
        this.setup(this.pluginBinding.getBinaryMessenger(), (Application)this.pluginBinding.getApplicationContext(), binding.getActivity(), binding);
    }

    public void onDetachedFromActivity() {
        this.tearDown();
    }

    public void onDetachedFromActivityForConfigChanges() {
        this.onDetachedFromActivity();
    }

    public void onReattachedToActivityForConfigChanges(@NonNull ActivityPluginBinding binding) {
        this.onAttachedToActivity(binding);
    }

    private void setup(BinaryMessenger messenger, Application application, Activity activity, ActivityPluginBinding activityBinding) {
        this.activityState = new ActivityState(application, activity, messenger, this, activityBinding);
    }

    private void tearDown() {
        if (this.activityState != null) {
            this.activityState.release();
            this.activityState = null;
        }
    }

    @VisibleForTesting
    final ImagePickerDelegate constructDelegate(Activity setupActivity) {
        ImagePickerCache cache = new ImagePickerCache((Context)setupActivity);
        ExifDataCopier exifDataCopier = new ExifDataCopier();
        ImageResizer imageResizer = new ImageResizer((Context)setupActivity, exifDataCopier);
        return new ImagePickerDelegate(setupActivity, imageResizer, cache);
    }

    @Nullable
    private ImagePickerDelegate getImagePickerDelegate() {
        if (this.activityState == null || this.activityState.getActivity() == null) {
            return null;
        }
        return this.activityState.getDelegate();
    }

    private void setCameraDevice(@NonNull ImagePickerDelegate delegate, @NonNull Messages.SourceSpecification source) {
        Messages.SourceCamera camera = source.getCamera();
        if (camera != null) {
            delegate.setCameraDevice(switch (camera) {
                case Messages.SourceCamera.FRONT -> ImagePickerDelegate.CameraDevice.FRONT;
                default -> ImagePickerDelegate.CameraDevice.REAR;
            });
        }
    }

    @Override
    public void pickImages(@NonNull Messages.SourceSpecification source, @NonNull Messages.ImageSelectionOptions options, @NonNull Messages.GeneralOptions generalOptions, @NonNull Messages.Result<List<String>> result) {
        ImagePickerDelegate delegate = this.getImagePickerDelegate();
        if (delegate == null) {
            result.error(new Messages.FlutterError("no_activity", "image_picker plugin requires a foreground activity.", null));
            return;
        }
        this.setCameraDevice(delegate, source);
        if (generalOptions.getAllowMultiple().booleanValue()) {
            int limit = ImagePickerUtils.getLimitFromOption(generalOptions);
            delegate.chooseMultiImageFromGallery(options, generalOptions.getUsePhotoPicker(), limit, result);
        } else {
            switch (source.getType()) {
                case GALLERY: {
                    delegate.chooseImageFromGallery(options, generalOptions.getUsePhotoPicker(), result);
                    break;
                }
                case CAMERA: {
                    delegate.takeImageWithCamera(options, result);
                }
            }
        }
    }

    @Override
    public void pickMedia(@NonNull Messages.MediaSelectionOptions mediaSelectionOptions, @NonNull Messages.GeneralOptions generalOptions, @NonNull Messages.Result<List<String>> result) {
        ImagePickerDelegate delegate = this.getImagePickerDelegate();
        if (delegate == null) {
            result.error(new Messages.FlutterError("no_activity", "image_picker plugin requires a foreground activity.", null));
            return;
        }
        delegate.chooseMediaFromGallery(mediaSelectionOptions, generalOptions, result);
    }

    @Override
    public void pickVideos(@NonNull Messages.SourceSpecification source, @NonNull Messages.VideoSelectionOptions options, @NonNull Messages.GeneralOptions generalOptions, @NonNull Messages.Result<List<String>> result) {
        ImagePickerDelegate delegate = this.getImagePickerDelegate();
        if (delegate == null) {
            result.error(new Messages.FlutterError("no_activity", "image_picker plugin requires a foreground activity.", null));
            return;
        }
        this.setCameraDevice(delegate, source);
        if (generalOptions.getAllowMultiple().booleanValue()) {
            int limit = ImagePickerUtils.getLimitFromOption(generalOptions);
            delegate.chooseMultiVideoFromGallery(options, generalOptions.getUsePhotoPicker(), limit, result);
        } else {
            switch (source.getType()) {
                case GALLERY: {
                    delegate.chooseVideoFromGallery(options, generalOptions.getUsePhotoPicker(), result);
                    break;
                }
                case CAMERA: {
                    delegate.takeVideoWithCamera(options, result);
                }
            }
        }
    }

    @Override
    @Nullable
    public Messages.CacheRetrievalResult retrieveLostResults() {
        ImagePickerDelegate delegate = this.getImagePickerDelegate();
        if (delegate == null) {
            throw new Messages.FlutterError("no_activity", "image_picker plugin requires a foreground activity.", null);
        }
        return delegate.retrieveLostImage();
    }

    private class ActivityState {
        private Application application;
        private Activity activity;
        private ImagePickerDelegate delegate;
        private LifeCycleObserver observer;
        private ActivityPluginBinding activityBinding;
        private BinaryMessenger messenger;
        private Lifecycle lifecycle;

        ActivityState(Application application, Activity activity, BinaryMessenger messenger, Messages.ImagePickerApi handler, ActivityPluginBinding activityBinding) {
            this.application = application;
            this.activity = activity;
            this.activityBinding = activityBinding;
            this.messenger = messenger;
            this.delegate = ImagePickerPlugin.this.constructDelegate(activity);
            Messages.ImagePickerApi.setUp(messenger, handler);
            this.observer = new LifeCycleObserver(activity);
            activityBinding.addActivityResultListener((PluginRegistry.ActivityResultListener)this.delegate);
            activityBinding.addRequestPermissionsResultListener((PluginRegistry.RequestPermissionsResultListener)this.delegate);
            this.lifecycle = FlutterLifecycleAdapter.getActivityLifecycle((ActivityPluginBinding)activityBinding);
            this.lifecycle.addObserver((LifecycleObserver)this.observer);
        }

        ActivityState(ImagePickerDelegate delegate, Activity activity) {
            this.activity = activity;
            this.delegate = delegate;
        }

        void release() {
            if (this.activityBinding != null) {
                this.activityBinding.removeActivityResultListener((PluginRegistry.ActivityResultListener)this.delegate);
                this.activityBinding.removeRequestPermissionsResultListener((PluginRegistry.RequestPermissionsResultListener)this.delegate);
                this.activityBinding = null;
            }
            if (this.lifecycle != null) {
                this.lifecycle.removeObserver((LifecycleObserver)this.observer);
                this.lifecycle = null;
            }
            Messages.ImagePickerApi.setUp(this.messenger, null);
            if (this.application != null) {
                this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.observer);
                this.application = null;
            }
            this.activity = null;
            this.observer = null;
            this.delegate = null;
        }

        Activity getActivity() {
            return this.activity;
        }

        ImagePickerDelegate getDelegate() {
            return this.delegate;
        }
    }

    private class LifeCycleObserver
    implements Application.ActivityLifecycleCallbacks,
    DefaultLifecycleObserver {
        private final Activity thisActivity;

        LifeCycleObserver(Activity activity) {
            this.thisActivity = activity;
        }

        public void onCreate(@NonNull LifecycleOwner owner) {
        }

        public void onStart(@NonNull LifecycleOwner owner) {
        }

        public void onResume(@NonNull LifecycleOwner owner) {
        }

        public void onPause(@NonNull LifecycleOwner owner) {
        }

        public void onStop(@NonNull LifecycleOwner owner) {
            this.onActivityStopped(this.thisActivity);
        }

        public void onDestroy(@NonNull LifecycleOwner owner) {
            this.onActivityDestroyed(this.thisActivity);
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
            if (this.thisActivity == activity && activity.getApplicationContext() != null) {
                ((Application)activity.getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            }
        }

        public void onActivityStopped(Activity activity) {
            if (this.thisActivity == activity) {
                ImagePickerPlugin.this.activityState.getDelegate().saveStateBeforeResult();
            }
        }
    }
}

