/*
 * Decompiled with CFR 0.152.
 */
package dev.fluttercommunity.plus.packageinfo;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.pm.SigningInfo;
import android.os.Build;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u001eH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ldev/fluttercommunity/plus/packageinfo/PackageInfoPlugin;", "Lio/flutter/plugin/common/MethodChannel$MethodCallHandler;", "Lio/flutter/embedding/engine/plugins/FlutterPlugin;", "<init>", "()V", "applicationContext", "Landroid/content/Context;", "methodChannel", "Lio/flutter/plugin/common/MethodChannel;", "onAttachedToEngine", "", "binding", "Lio/flutter/embedding/engine/plugins/FlutterPlugin$FlutterPluginBinding;", "onDetachedFromEngine", "onMethodCall", "call", "Lio/flutter/plugin/common/MethodCall;", "result", "Lio/flutter/plugin/common/MethodChannel$Result;", "getInstallerPackageName", "", "getLongVersionCode", "", "info", "Landroid/content/pm/PackageInfo;", "getBuildSignature", "pm", "Landroid/content/pm/PackageManager;", "signatureToSha256", "sig", "", "bytesToHex", "bytes", "Companion", "package_info_plus_debug"})
public final class PackageInfoPlugin
implements MethodChannel.MethodCallHandler,
FlutterPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Context applicationContext;
    @Nullable
    private MethodChannel methodChannel;
    @NotNull
    private static final String CHANNEL_NAME = "dev.fluttercommunity.plus/package_info";

    public void onAttachedToEngine(@NotNull FlutterPlugin.FlutterPluginBinding binding) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        this.applicationContext = binding.getApplicationContext();
        MethodChannel methodChannel = this.methodChannel = new MethodChannel(binding.getBinaryMessenger(), CHANNEL_NAME);
        Intrinsics.checkNotNull((Object)methodChannel);
        methodChannel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
    }

    public void onDetachedFromEngine(@NotNull FlutterPlugin.FlutterPluginBinding binding) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        this.applicationContext = null;
        MethodChannel methodChannel = this.methodChannel;
        Intrinsics.checkNotNull((Object)methodChannel);
        methodChannel.setMethodCallHandler(null);
        this.methodChannel = null;
    }

    public void onMethodCall(@NotNull MethodCall call, @NotNull MethodChannel.Result result) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        try {
            if (Intrinsics.areEqual((Object)call.method, (Object)"getAll")) {
                HashMap<String, Object> infoMap;
                HashMap<String, Object> hashMap;
                Context context = this.applicationContext;
                Intrinsics.checkNotNull((Object)context);
                PackageManager packageManager = context.getPackageManager();
                Context context2 = this.applicationContext;
                Intrinsics.checkNotNull((Object)context2);
                PackageInfo info = packageManager.getPackageInfo(context2.getPackageName(), 0);
                Intrinsics.checkNotNull((Object)packageManager);
                String buildSignature = this.getBuildSignature(packageManager);
                String installerPackage = this.getInstallerPackageName();
                long installTimeMillis = info.firstInstallTime;
                long updateTimeMillis = info.lastUpdateTime;
                HashMap<String, Object> $this$onMethodCall_u24lambda_u240 = hashMap = (infoMap = new HashMap<String, Object>());
                boolean bl = false;
                Object object = info.applicationInfo;
                if (object == null || (object = object.loadLabel(packageManager)) == null || (object = object.toString()) == null) {
                    object = "";
                }
                $this$onMethodCall_u24lambda_u240.put("appName", object);
                Context context3 = this.applicationContext;
                Intrinsics.checkNotNull((Object)context3);
                $this$onMethodCall_u24lambda_u240.put("packageName", context3.getPackageName());
                String string = info.versionName;
                if (string == null) {
                    string = "";
                }
                $this$onMethodCall_u24lambda_u240.put("version", string);
                Intrinsics.checkNotNull((Object)info);
                $this$onMethodCall_u24lambda_u240.put("buildNumber", String.valueOf(this.getLongVersionCode(info)));
                if (buildSignature != null) {
                    $this$onMethodCall_u24lambda_u240.put("buildSignature", buildSignature);
                }
                if (installerPackage != null) {
                    $this$onMethodCall_u24lambda_u240.put("installerStore", installerPackage);
                }
                $this$onMethodCall_u24lambda_u240.put("installTime", String.valueOf(installTimeMillis));
                $this$onMethodCall_u24lambda_u240.put("updateTime", String.valueOf(updateTimeMillis));
                HashMap<String, Object> resultingMap = hashMap;
                boolean bl2 = false;
                result.success(resultingMap);
            } else {
                result.notImplemented();
            }
        }
        catch (PackageManager.NameNotFoundException ex) {
            result.error("Name not found", ex.getMessage(), null);
        }
    }

    private final String getInstallerPackageName() {
        Context context = this.applicationContext;
        Intrinsics.checkNotNull((Object)context);
        PackageManager packageManager = context.getPackageManager();
        Context context2 = this.applicationContext;
        Intrinsics.checkNotNull((Object)context2);
        String packageName = context2.getPackageName();
        return Build.VERSION.SDK_INT >= 30 ? packageManager.getInstallSourceInfo(packageName).getInitiatingPackageName() : packageManager.getInstallerPackageName(packageName);
    }

    private final long getLongVersionCode(PackageInfo info) {
        return Build.VERSION.SDK_INT >= 28 ? info.getLongVersionCode() : (long)info.versionCode;
    }

    private final String getBuildSignature(PackageManager pm) {
        String string;
        try {
            String string2;
            if (Build.VERSION.SDK_INT >= 28) {
                Context context = this.applicationContext;
                Intrinsics.checkNotNull((Object)context);
                packageInfo = pm.getPackageInfo(context.getPackageName(), 0x8000000);
                SigningInfo signingInfo = packageInfo.signingInfo;
                if (signingInfo == null) {
                    return null;
                }
                SigningInfo signingInfo2 = signingInfo;
                if (signingInfo2.hasMultipleSigners()) {
                    Signature[] signatureArray = signingInfo2.getApkContentsSigners();
                    Intrinsics.checkNotNullExpressionValue((Object)signatureArray, (String)"getApkContentsSigners(...)");
                    byte[] byArray = ((Signature)ArraysKt.first((Object[])signatureArray)).toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                    string2 = this.signatureToSha256(byArray);
                } else {
                    Signature[] signatureArray = signingInfo2.getSigningCertificateHistory();
                    Intrinsics.checkNotNullExpressionValue((Object)signatureArray, (String)"getSigningCertificateHistory(...)");
                    byte[] byArray = ((Signature)ArraysKt.first((Object[])signatureArray)).toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                    string2 = this.signatureToSha256(byArray);
                }
            } else {
                Object[] signatures;
                Context context = this.applicationContext;
                Intrinsics.checkNotNull((Object)context);
                packageInfo = pm.getPackageInfo(context.getPackageName(), 64);
                Object[] objectArray = signatures = packageInfo.signatures;
                if (objectArray == null || objectArray.length == 0 || ArraysKt.first((Object[])signatures) == null) {
                    string2 = null;
                } else {
                    byte[] byArray = ((Signature)ArraysKt.first((Object[])signatures)).toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                    string2 = this.signatureToSha256(byArray);
                }
            }
            string = string2;
        }
        catch (PackageManager.NameNotFoundException e) {
            string = null;
        }
        catch (NoSuchAlgorithmException e) {
            string = null;
        }
        return string;
    }

    private final String signatureToSha256(byte[] sig) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.update(sig);
        byte[] hashText = digest.digest();
        Intrinsics.checkNotNull((Object)hashText);
        return this.bytesToHex(hashText);
    }

    private final String bytesToHex(byte[] bytes) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hexArray = cArray;
        char[] hexChars = new char[bytes.length * 2];
        int v = 0;
        int n = bytes.length;
        for (int j = 0; j < n; ++j) {
            v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/fluttercommunity/plus/packageinfo/PackageInfoPlugin$Companion;", "", "<init>", "()V", "CHANNEL_NAME", "", "package_info_plus_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

