/*
 * Decompiled with CFR 0.152.
 */
package dev.fluttercommunity.plus.share;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import androidx.core.content.FileProvider;
import dev.fluttercommunity.plus.share.SharePlusPendingIntent;
import dev.fluttercommunity.plus.share.ShareSuccessManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u00020\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J \u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001f\u001a\u00020 J@\u0010!\u001a\u00020\u001b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0#2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010#2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 H\u0002J&\u0010(\u001a\u0012\u0012\u0004\u0012\u00020*0)j\b\u0012\u0004\u0012\u00020*`+2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0#H\u0002J\u0018\u0010,\u001a\u00020\u000b2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010#H\u0002J\u0012\u0010-\u001a\u00020\u000b2\b\u0010.\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020\u0011H\u0002J\b\u00101\u001a\u00020\u001bH\u0002J\u0010\u00102\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000f\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00063"}, d2={"Ldev/fluttercommunity/plus/share/Share;", "", "context", "Landroid/content/Context;", "activity", "Landroid/app/Activity;", "manager", "Ldev/fluttercommunity/plus/share/ShareSuccessManager;", "<init>", "(Landroid/content/Context;Landroid/app/Activity;Ldev/fluttercommunity/plus/share/ShareSuccessManager;)V", "providerAuthority", "", "getProviderAuthority", "()Ljava/lang/String;", "providerAuthority$delegate", "Lkotlin/Lazy;", "shareCacheFolder", "Ljava/io/File;", "getShareCacheFolder", "()Ljava/io/File;", "immutabilityIntentFlags", "", "getImmutabilityIntentFlags", "()I", "immutabilityIntentFlags$delegate", "getContext", "setActivity", "", "share", "text", "subject", "withResult", "", "shareFiles", "paths", "", "mimeTypes", "startActivity", "intent", "Landroid/content/Intent;", "getUrisForPaths", "Ljava/util/ArrayList;", "Landroid/net/Uri;", "Lkotlin/collections/ArrayList;", "reduceMimeTypes", "getMimeTypeBase", "mimeType", "fileIsInShareCache", "file", "clearShareCacheFolder", "copyToShareCacheFolder", "share_plus_debug"})
@SourceDebugExtension(value={"SMAP\nShare.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Share.kt\ndev/fluttercommunity/plus/share/Share\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,251:1\n1855#2:252\n1855#2,2:253\n1856#2:255\n1855#2,2:256\n13579#3,2:258\n*S KotlinDebug\n*F\n+ 1 Share.kt\ndev/fluttercommunity/plus/share/Share\n*L\n144#1:252\n146#1:253,2\n144#1:255\n177#1:256,2\n235#1:258,2\n*E\n"})
public final class Share {
    @NotNull
    private final Context context;
    @Nullable
    private Activity activity;
    @NotNull
    private final ShareSuccessManager manager;
    @NotNull
    private final Lazy providerAuthority$delegate;
    @NotNull
    private final Lazy immutabilityIntentFlags$delegate;

    public Share(@NotNull Context context, @Nullable Activity activity, @NotNull ShareSuccessManager manager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.context = context;
        this.activity = activity;
        this.manager = manager;
        this.providerAuthority$delegate = LazyKt.lazy(() -> Share.providerAuthority_delegate$lambda$0(this));
        this.immutabilityIntentFlags$delegate = LazyKt.lazy(Share::immutabilityIntentFlags_delegate$lambda$0);
    }

    private final String getProviderAuthority() {
        Lazy lazy = this.providerAuthority$delegate;
        return (String)lazy.getValue();
    }

    private final File getShareCacheFolder() {
        return new File(this.getContext().getCacheDir(), "share_plus");
    }

    private final int getImmutabilityIntentFlags() {
        Lazy lazy = this.immutabilityIntentFlags$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final Context getContext() {
        Context context;
        if (this.activity != null) {
            Activity activity = this.activity;
            Intrinsics.checkNotNull((Object)activity);
            context = (Context)activity;
        } else {
            context = this.context;
        }
        return context;
    }

    public final void setActivity(@Nullable Activity activity) {
        this.activity = activity;
    }

    public final void share(@NotNull String text, @Nullable String subject, boolean withResult) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intent $this$share_u24lambda_u240 = intent = new Intent();
        boolean bl = false;
        $this$share_u24lambda_u240.setAction("android.intent.action.SEND");
        $this$share_u24lambda_u240.setType("text/plain");
        $this$share_u24lambda_u240.putExtra("android.intent.extra.TEXT", text);
        if (subject != null) {
            $this$share_u24lambda_u240.putExtra("android.intent.extra.SUBJECT", subject);
        }
        Intent shareIntent = intent;
        Intent chooserIntent = withResult ? Intent.createChooser((Intent)shareIntent, null, (IntentSender)PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(this.context, SharePlusPendingIntent.class), (int)(0x8000000 | this.getImmutabilityIntentFlags())).getIntentSender()) : Intent.createChooser((Intent)shareIntent, null);
        Intrinsics.checkNotNull((Object)chooserIntent);
        this.startActivity(chooserIntent, withResult);
    }

    public final void shareFiles(@NotNull List<String> paths, @Nullable List<String> mimeTypes, @Nullable String text, @Nullable String subject, boolean withResult) throws IOException {
        Object mimeType;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        this.clearShareCacheFolder();
        ArrayList<Uri> fileUris = this.getUrisForPaths(paths);
        Intent shareIntent = new Intent();
        if (fileUris.isEmpty() && !((charSequence = (CharSequence)text) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.share(text, subject, withResult);
            return;
        }
        if (fileUris.size() == 1) {
            Collection collection = mimeTypes;
            mimeType = !(collection == null || collection.isEmpty()) ? (String)CollectionsKt.first(mimeTypes) : "*/*";
            Collection $this$shareFiles_u24lambda_u240 = collection = shareIntent;
            boolean bl = false;
            $this$shareFiles_u24lambda_u240.setAction("android.intent.action.SEND");
            $this$shareFiles_u24lambda_u240.setType((String)mimeType);
            $this$shareFiles_u24lambda_u240.putExtra("android.intent.extra.STREAM", (Parcelable)CollectionsKt.first((List)fileUris));
        } else {
            Intent $this$shareFiles_u24lambda_u241 = mimeType = shareIntent;
            boolean bl = false;
            $this$shareFiles_u24lambda_u241.setAction("android.intent.action.SEND_MULTIPLE");
            $this$shareFiles_u24lambda_u241.setType(this.reduceMimeTypes(mimeTypes));
            $this$shareFiles_u24lambda_u241.putParcelableArrayListExtra("android.intent.extra.STREAM", fileUris);
        }
        if (text != null) {
            shareIntent.putExtra("android.intent.extra.TEXT", text);
        }
        if (subject != null) {
            shareIntent.putExtra("android.intent.extra.SUBJECT", subject);
        }
        shareIntent.addFlags(1);
        Intent chooserIntent = withResult ? Intent.createChooser((Intent)shareIntent, null, (IntentSender)PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(this.context, SharePlusPendingIntent.class), (int)(0x8000000 | this.getImmutabilityIntentFlags())).getIntentSender()) : Intent.createChooser((Intent)shareIntent, null);
        List list = this.getContext().getPackageManager().queryIntentActivities(chooserIntent, 65536);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"queryIntentActivities(...)");
        List resInfoList = list;
        Iterable $this$forEach$iv = resInfoList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolveInfo resolveInfo = (ResolveInfo)element$iv;
            boolean bl = false;
            String packageName = resolveInfo.activityInfo.packageName;
            Iterable $this$forEach$iv2 = fileUris;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Uri fileUri = (Uri)element$iv2;
                boolean bl2 = false;
                this.getContext().grantUriPermission(packageName, fileUri, 3);
            }
        }
        Intrinsics.checkNotNull((Object)chooserIntent);
        this.startActivity(chooserIntent, withResult);
    }

    private final void startActivity(Intent intent, boolean withResult) {
        if (this.activity != null) {
            if (withResult) {
                Activity activity = this.activity;
                Intrinsics.checkNotNull((Object)activity);
                activity.startActivityForResult(intent, 22643);
            } else {
                Activity activity = this.activity;
                Intrinsics.checkNotNull((Object)activity);
                activity.startActivity(intent);
            }
        } else {
            intent.addFlags(0x10000000);
            if (withResult) {
                this.manager.unavailable();
            }
            this.context.startActivity(intent);
        }
    }

    private final ArrayList<Uri> getUrisForPaths(List<String> paths) throws IOException {
        ArrayList<Uri> uris = new ArrayList<Uri>(paths.size());
        Iterable $this$forEach$iv = paths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String path = (String)element$iv;
            boolean bl = false;
            File file = new File(path);
            if (this.fileIsInShareCache(file)) {
                throw new IOException("Shared file can not be located in '" + this.getShareCacheFolder().getCanonicalPath() + '\'');
            }
            file = this.copyToShareCacheFolder(file);
            uris.add(FileProvider.getUriForFile((Context)this.getContext(), (String)this.getProviderAuthority(), (File)file));
        }
        return uris;
    }

    private final String reduceMimeTypes(List<String> mimeTypes) {
        List<String> list = mimeTypes;
        if (list != null ? list.isEmpty() : true) {
            return "*/*";
        }
        List<String> list2 = mimeTypes;
        Intrinsics.checkNotNull(list2);
        if (list2.size() == 1) {
            return (String)CollectionsKt.first(mimeTypes);
        }
        String commonMimeType = (String)CollectionsKt.first(mimeTypes);
        int i = 1;
        int n = CollectionsKt.getLastIndex(mimeTypes);
        if (i <= n) {
            while (true) {
                if (!Intrinsics.areEqual((Object)commonMimeType, (Object)mimeTypes.get(i))) {
                    if (Intrinsics.areEqual((Object)this.getMimeTypeBase(commonMimeType), (Object)this.getMimeTypeBase(mimeTypes.get(i)))) {
                        commonMimeType = this.getMimeTypeBase(mimeTypes.get(i)) + "/*";
                    } else {
                        commonMimeType = "*/*";
                        break;
                    }
                }
                if (i == n) break;
                ++i;
            }
        }
        return commonMimeType;
    }

    private final String getMimeTypeBase(String mimeType) {
        String string;
        if (mimeType == null || !StringsKt.contains$default((CharSequence)mimeType, (CharSequence)"/", (boolean)false, (int)2, null)) {
            string = "*";
        } else {
            String string2 = mimeType.substring(0, StringsKt.indexOf$default((CharSequence)mimeType, (String)"/", (int)0, (boolean)false, (int)6, null));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        return string;
    }

    private final boolean fileIsInShareCache(File file) {
        boolean bl;
        try {
            String filePath = file.getCanonicalPath();
            Intrinsics.checkNotNull((Object)filePath);
            String string = this.getShareCacheFolder().getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
            bl = StringsKt.startsWith$default((String)filePath, (String)string, (boolean)false, (int)2, null);
        }
        catch (IOException e) {
            bl = false;
        }
        return bl;
    }

    private final void clearShareCacheFolder() {
        File[] fileArray;
        File folder = this.getShareCacheFolder();
        File[] files = folder.listFiles();
        if (folder.exists() && !((fileArray = files) == null || fileArray.length == 0)) {
            File[] $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.delete();
            }
            folder.delete();
        }
    }

    private final File copyToShareCacheFolder(File file) throws IOException {
        File folder = this.getShareCacheFolder();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File newFile = new File(folder, file.getName());
        FilesKt.copyTo$default((File)file, (File)newFile, (boolean)true, (int)0, (int)4, null);
        return newFile;
    }

    private static final String providerAuthority_delegate$lambda$0(Share this$0) {
        return this$0.getContext().getPackageName() + ".flutter.share_provider";
    }

    private static final int immutabilityIntentFlags_delegate$lambda$0() {
        return Build.VERSION.SDK_INT >= 23 ? 0x2000000 : 0;
    }
}

