/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.videoplayer;

import io.flutter.plugins.videoplayer.PigeonEventSink;
import io.flutter.plugins.videoplayer.PlatformVideoEvent;
import java.util.ArrayList;

final class QueuingEventSink {
    private PigeonEventSink<PlatformVideoEvent> delegate;
    private final ArrayList<Object> eventQueue = new ArrayList();
    private boolean done = false;

    QueuingEventSink() {
    }

    public void setDelegate(PigeonEventSink<PlatformVideoEvent> delegate) {
        this.delegate = delegate;
        this.maybeFlush();
    }

    public void endOfStream() {
        this.enqueue(new EndOfStreamEvent());
        this.maybeFlush();
        this.done = true;
    }

    public void error(String code, String message, Object details) {
        this.enqueue(new ErrorEvent(code, message, details));
        this.maybeFlush();
    }

    public void success(PlatformVideoEvent event) {
        this.enqueue(event);
        this.maybeFlush();
    }

    private void enqueue(Object event) {
        if (this.done) {
            return;
        }
        this.eventQueue.add(event);
    }

    private void maybeFlush() {
        if (this.delegate == null) {
            return;
        }
        for (Object event : this.eventQueue) {
            if (event instanceof EndOfStreamEvent) {
                this.delegate.endOfStream();
                continue;
            }
            if (event instanceof ErrorEvent) {
                ErrorEvent errorEvent = (ErrorEvent)event;
                this.delegate.error(errorEvent.code, errorEvent.message, errorEvent.details);
                continue;
            }
            this.delegate.success((PlatformVideoEvent)event);
        }
        this.eventQueue.clear();
    }

    static class EndOfStreamEvent {
        EndOfStreamEvent() {
        }
    }

    private static class ErrorEvent {
        String code;
        String message;
        Object details;

        ErrorEvent(String code, String message, Object details) {
            this.code = code;
            this.message = message;
            this.details = details;
        }
    }
}

