/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.videoplayer;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.Format;
import androidx.media3.common.MediaItem;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.Player;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.TrackSelectionOverride;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.Tracks;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.trackselection.DefaultTrackSelector;
import io.flutter.plugins.videoplayer.ExoPlayerAudioTrackData;
import io.flutter.plugins.videoplayer.ExoPlayerEventListener;
import io.flutter.plugins.videoplayer.NativeAudioTrackData;
import io.flutter.plugins.videoplayer.VideoPlayerCallbacks;
import io.flutter.plugins.videoplayer.VideoPlayerInstanceApi;
import io.flutter.plugins.videoplayer.VideoPlayerOptions;
import io.flutter.view.TextureRegistry;
import java.util.ArrayList;

public abstract class VideoPlayer
implements VideoPlayerInstanceApi {
    @NonNull
    protected final VideoPlayerCallbacks videoPlayerEvents;
    @Nullable
    protected final TextureRegistry.SurfaceProducer surfaceProducer;
    @Nullable
    private DisposeHandler disposeHandler;
    @NonNull
    protected ExoPlayer exoPlayer;
    @UnstableApi
    @Nullable
    protected DefaultTrackSelector trackSelector;

    @UnstableApi
    public VideoPlayer(@NonNull VideoPlayerCallbacks events, @NonNull MediaItem mediaItem, @NonNull VideoPlayerOptions options, @Nullable TextureRegistry.SurfaceProducer surfaceProducer, @NonNull ExoPlayerProvider exoPlayerProvider) {
        this.videoPlayerEvents = events;
        this.surfaceProducer = surfaceProducer;
        this.exoPlayer = exoPlayerProvider.get();
        if (this.exoPlayer.getTrackSelector() instanceof DefaultTrackSelector) {
            this.trackSelector = (DefaultTrackSelector)this.exoPlayer.getTrackSelector();
        }
        this.exoPlayer.setMediaItem(mediaItem);
        this.exoPlayer.prepare();
        this.exoPlayer.addListener((Player.Listener)this.createExoPlayerEventListener(this.exoPlayer, surfaceProducer));
        VideoPlayer.setAudioAttributes(this.exoPlayer, options.mixWithOthers);
    }

    public void setDisposeHandler(@Nullable DisposeHandler handler) {
        this.disposeHandler = handler;
    }

    @NonNull
    protected abstract ExoPlayerEventListener createExoPlayerEventListener(@NonNull ExoPlayer var1, @Nullable TextureRegistry.SurfaceProducer var2);

    private static void setAudioAttributes(ExoPlayer exoPlayer, boolean isMixMode) {
        exoPlayer.setAudioAttributes(new AudioAttributes.Builder().setContentType(3).build(), !isMixMode);
    }

    @Override
    public void play() {
        this.exoPlayer.play();
    }

    @Override
    public void pause() {
        this.exoPlayer.pause();
    }

    @Override
    public void setLooping(boolean looping) {
        this.exoPlayer.setRepeatMode(looping ? 2 : 0);
    }

    @Override
    public void setVolume(double volume) {
        float bracketedValue = (float)Math.max(0.0, Math.min(1.0, volume));
        this.exoPlayer.setVolume(bracketedValue);
    }

    @Override
    public void setPlaybackSpeed(double speed) {
        PlaybackParameters playbackParameters = new PlaybackParameters((float)speed);
        this.exoPlayer.setPlaybackParameters(playbackParameters);
    }

    @Override
    public long getCurrentPosition() {
        return this.exoPlayer.getCurrentPosition();
    }

    @Override
    public long getBufferedPosition() {
        return this.exoPlayer.getBufferedPosition();
    }

    @Override
    public void seekTo(long position) {
        this.exoPlayer.seekTo(position);
    }

    @NonNull
    public ExoPlayer getExoPlayer() {
        return this.exoPlayer;
    }

    @Override
    @UnstableApi
    @NonNull
    public NativeAudioTrackData getAudioTracks() {
        ArrayList<ExoPlayerAudioTrackData> audioTracks = new ArrayList<ExoPlayerAudioTrackData>();
        Tracks tracks = this.exoPlayer.getCurrentTracks();
        for (int groupIndex = 0; groupIndex < tracks.getGroups().size(); ++groupIndex) {
            Tracks.Group group = (Tracks.Group)tracks.getGroups().get(groupIndex);
            if (group.getType() != 1) continue;
            for (int trackIndex = 0; trackIndex < group.length; ++trackIndex) {
                Format format = group.getTrackFormat(trackIndex);
                boolean isSelected = group.isTrackSelected(trackIndex);
                ExoPlayerAudioTrackData audioTrack = new ExoPlayerAudioTrackData(groupIndex, trackIndex, format.label, format.language, isSelected, format.bitrate != -1 ? Long.valueOf(format.bitrate) : null, format.sampleRate != -1 ? Long.valueOf(format.sampleRate) : null, format.channelCount != -1 ? Long.valueOf(format.channelCount) : null, format.codecs != null ? format.codecs : null);
                audioTracks.add(audioTrack);
            }
        }
        return new NativeAudioTrackData(audioTracks);
    }

    @Override
    @UnstableApi
    public void selectAudioTrack(long groupIndex, long trackIndex) {
        if (this.trackSelector == null) {
            throw new IllegalStateException("Cannot select audio track: track selector is null");
        }
        Tracks tracks = this.exoPlayer.getCurrentTracks();
        if (groupIndex < 0L || groupIndex >= (long)tracks.getGroups().size()) {
            throw new IllegalArgumentException("Cannot select audio track: groupIndex " + groupIndex + " is out of bounds (available groups: " + tracks.getGroups().size() + ")");
        }
        Tracks.Group group = (Tracks.Group)tracks.getGroups().get((int)groupIndex);
        if (group.getType() != 1) {
            throw new IllegalArgumentException("Cannot select audio track: group at index " + groupIndex + " is not an audio track (type: " + group.getType() + ")");
        }
        if (trackIndex < 0L || (int)trackIndex >= group.length) {
            throw new IllegalArgumentException("Cannot select audio track: trackIndex " + trackIndex + " is out of bounds (available tracks in group: " + group.length + ")");
        }
        TrackGroup trackGroup = group.getMediaTrackGroup();
        TrackSelectionOverride override = new TrackSelectionOverride(trackGroup, (int)trackIndex);
        this.trackSelector.setParameters((TrackSelectionParameters)this.trackSelector.buildUponParameters().setOverrideForType(override).build());
    }

    public void dispose() {
        if (this.disposeHandler != null) {
            this.disposeHandler.onDispose();
        }
        this.exoPlayer.release();
    }

    public static interface ExoPlayerProvider {
        @NonNull
        public ExoPlayer get();
    }

    public static interface DisposeHandler {
        public void onDispose();
    }
}

