/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.videoplayer.texture;

import android.content.Context;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.trackselection.DefaultTrackSelector;
import androidx.media3.exoplayer.trackselection.TrackSelector;
import io.flutter.plugins.videoplayer.ExoPlayerEventListener;
import io.flutter.plugins.videoplayer.VideoAsset;
import io.flutter.plugins.videoplayer.VideoPlayer;
import io.flutter.plugins.videoplayer.VideoPlayerCallbacks;
import io.flutter.plugins.videoplayer.VideoPlayerOptions;
import io.flutter.plugins.videoplayer.texture.TextureExoPlayerEventListener;
import io.flutter.view.TextureRegistry;

public final class TextureVideoPlayer
extends VideoPlayer
implements TextureRegistry.SurfaceProducer.Callback {
    private boolean needsSurface = true;

    @UnstableApi
    @NonNull
    public static TextureVideoPlayer create(@NonNull Context context, @NonNull VideoPlayerCallbacks events, @NonNull TextureRegistry.SurfaceProducer surfaceProducer, @NonNull VideoAsset asset, @NonNull VideoPlayerOptions options) {
        return new TextureVideoPlayer(events, surfaceProducer, asset.getMediaItem(), options, () -> {
            DefaultTrackSelector trackSelector = new DefaultTrackSelector(context);
            ExoPlayer.Builder builder = new ExoPlayer.Builder(context).setTrackSelector((TrackSelector)trackSelector).setMediaSourceFactory(asset.getMediaSourceFactory(context));
            return builder.build();
        });
    }

    @UnstableApi
    @VisibleForTesting
    public TextureVideoPlayer(@NonNull VideoPlayerCallbacks events, @NonNull TextureRegistry.SurfaceProducer surfaceProducer, @NonNull MediaItem mediaItem, @NonNull VideoPlayerOptions options, @NonNull VideoPlayer.ExoPlayerProvider exoPlayerProvider) {
        super(events, mediaItem, options, surfaceProducer, exoPlayerProvider);
        surfaceProducer.setCallback((TextureRegistry.SurfaceProducer.Callback)this);
        Surface surface = surfaceProducer.getSurface();
        this.exoPlayer.setVideoSurface(surface);
        this.needsSurface = surface == null;
    }

    @Override
    @NonNull
    protected ExoPlayerEventListener createExoPlayerEventListener(@NonNull ExoPlayer exoPlayer, @Nullable TextureRegistry.SurfaceProducer surfaceProducer) {
        if (surfaceProducer == null) {
            throw new IllegalArgumentException("surfaceProducer cannot be null to create an ExoPlayerEventListener for TextureVideoPlayer.");
        }
        boolean surfaceProducerHandlesCropAndRotation = surfaceProducer.handlesCropAndRotation();
        return new TextureExoPlayerEventListener(exoPlayer, this.videoPlayerEvents, surfaceProducerHandlesCropAndRotation);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void onSurfaceAvailable() {
        if (this.needsSurface) {
            assert (this.surfaceProducer != null);
            this.exoPlayer.setVideoSurface(this.surfaceProducer.getSurface());
            this.needsSurface = false;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void onSurfaceCleanup() {
        this.exoPlayer.setVideoSurface(null);
        this.needsSurface = true;
    }

    @Override
    public void dispose() {
        super.dispose();
        assert (this.surfaceProducer != null);
        this.surfaceProducer.release();
    }
}

