/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.videoplayer.platformview;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.media3.exoplayer.ExoPlayer;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugin.platform.PlatformViewFactory;
import io.flutter.plugins.videoplayer.AndroidVideoPlayerApi;
import io.flutter.plugins.videoplayer.PlatformVideoViewCreationParams;
import io.flutter.plugins.videoplayer.VideoPlayer;
import io.flutter.plugins.videoplayer.platformview.PlatformVideoView;
import java.util.Objects;

public class PlatformVideoViewFactory
extends PlatformViewFactory {
    private final VideoPlayerProvider videoPlayerProvider;

    public PlatformVideoViewFactory(@NonNull VideoPlayerProvider videoPlayerProvider) {
        super(AndroidVideoPlayerApi.Companion.getCodec());
        this.videoPlayerProvider = videoPlayerProvider;
    }

    @NonNull
    public PlatformView create(@NonNull Context context, int id, @Nullable Object args) {
        PlatformVideoViewCreationParams params = Objects.requireNonNull((PlatformVideoViewCreationParams)args);
        Long playerId = params.getPlayerId();
        VideoPlayer player = this.videoPlayerProvider.getVideoPlayer(playerId);
        ExoPlayer exoPlayer = player.getExoPlayer();
        return new PlatformVideoView(context, exoPlayer);
    }

    @FunctionalInterface
    public static interface VideoPlayerProvider {
        @NonNull
        public VideoPlayer getVideoPlayer(@NonNull Long var1);
    }
}

