/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.videoplayer;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaItem;
import androidx.media3.exoplayer.source.MediaSource;
import io.flutter.plugins.videoplayer.HttpVideoAsset;
import io.flutter.plugins.videoplayer.LocalVideoAsset;
import io.flutter.plugins.videoplayer.RtspVideoAsset;
import java.util.HashMap;
import java.util.Map;

public abstract class VideoAsset {
    @Nullable
    protected final String assetUrl;

    @NonNull
    static VideoAsset fromAssetUrl(@NonNull String assetUrl) {
        if (!assetUrl.startsWith("asset:///")) {
            throw new IllegalArgumentException("assetUrl must start with 'asset:///'");
        }
        return new LocalVideoAsset(assetUrl);
    }

    @NonNull
    static VideoAsset fromRemoteUrl(@Nullable String remoteUrl, @NonNull StreamingFormat streamingFormat, @NonNull Map<String, String> httpHeaders, @Nullable String userAgent) {
        return new HttpVideoAsset(remoteUrl, streamingFormat, new HashMap<String, String>(httpHeaders), userAgent);
    }

    @NonNull
    static VideoAsset fromRtspUrl(@NonNull String rtspUrl) {
        if (!rtspUrl.startsWith("rtsp://")) {
            throw new IllegalArgumentException("rtspUrl must start with 'rtsp://'");
        }
        return new RtspVideoAsset(rtspUrl);
    }

    protected VideoAsset(@Nullable String assetUrl) {
        this.assetUrl = assetUrl;
    }

    @NonNull
    public abstract MediaItem getMediaItem();

    @NonNull
    public abstract MediaSource.Factory getMediaSourceFactory(@NonNull Context var1);

    static enum StreamingFormat {
        UNKNOWN,
        SMOOTH,
        DYNAMIC_ADAPTIVE,
        HTTP_LIVE;

    }
}

