/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.videoplayer.texture;

import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.media3.common.Format;
import androidx.media3.common.VideoSize;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.ExoPlayer;
import io.flutter.plugins.videoplayer.ExoPlayerEventListener;
import io.flutter.plugins.videoplayer.VideoPlayerCallbacks;
import java.util.Objects;

public final class TextureExoPlayerEventListener
extends ExoPlayerEventListener {
    private final boolean surfaceProducerHandlesCropAndRotation;

    public TextureExoPlayerEventListener(@NonNull ExoPlayer exoPlayer, @NonNull VideoPlayerCallbacks events, boolean surfaceProducerHandlesCropAndRotation) {
        super(exoPlayer, events);
        this.surfaceProducerHandlesCropAndRotation = surfaceProducerHandlesCropAndRotation;
    }

    @Override
    protected void sendInitialized() {
        VideoSize videoSize = this.exoPlayer.getVideoSize();
        ExoPlayerEventListener.RotationDegrees rotationCorrection = ExoPlayerEventListener.RotationDegrees.ROTATE_0;
        int width = videoSize.width;
        int height = videoSize.height;
        if (width != 0 && height != 0 && !this.surfaceProducerHandlesCropAndRotation) {
            int rawVideoFormatRotation = this.getRotationCorrectionFromFormat(this.exoPlayer);
            try {
                rotationCorrection = ExoPlayerEventListener.RotationDegrees.fromDegrees(rawVideoFormatRotation);
            }
            catch (IllegalArgumentException e) {
                rotationCorrection = ExoPlayerEventListener.RotationDegrees.ROTATE_0;
            }
        }
        this.events.onInitialized(width, height, this.exoPlayer.getDuration(), rotationCorrection.getDegrees());
    }

    @OptIn(markerClass={UnstableApi.class})
    private int getRotationCorrectionFromFormat(ExoPlayer exoPlayer) {
        Format videoFormat = Objects.requireNonNull(exoPlayer.getVideoFormat());
        return videoFormat.rotationDegrees;
    }
}

